/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.lang;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.teavm.classlib.PlatformDetector;
import org.teavm.classlib.java.lang.TStackTraceElement;
import org.teavm.classlib.java.util.TArrays;
import org.teavm.interop.Import;
import org.teavm.interop.Remove;
import org.teavm.interop.Rename;
import org.teavm.interop.Superclass;
import org.teavm.jso.JSBody;
import org.teavm.jso.JSIndexer;
import org.teavm.jso.JSObject;
import org.teavm.jso.JSProperty;
import org.teavm.jso.impl.JSWrapper;
import org.teavm.runtime.ExceptionHandling;

@Superclass(value="java.lang.Object")
public class TThrowable
extends RuntimeException {
    private static final long serialVersionUID = 2026791432677149320L;
    private String message;
    private TThrowable cause;
    private boolean suppressionEnabled;
    private boolean writableStackTrace;
    private TThrowable[] suppressed = new TThrowable[0];
    private TStackTraceElement[] stackTrace;
    private LazyStackSupplier lazyStackTrace;

    @Rename(value="fakeInit")
    protected TThrowable(String message, TThrowable cause, boolean enableSuppression, boolean writableStackTrace) {
    }

    @Rename(value="<init>")
    public void init(String message, TThrowable cause, boolean enableSuppression, boolean writableStackTrace) {
        this.initNativeException();
        if (writableStackTrace) {
            this.fillInStackTrace();
        }
        this.suppressionEnabled = enableSuppression;
        this.writableStackTrace = writableStackTrace;
        this.message = message;
        this.cause = cause;
    }

    @Rename(value="fakeInit")
    public TThrowable() {
    }

    @Rename(value="<init>")
    private void init() {
        this.initNativeException();
        this.suppressionEnabled = true;
        this.writableStackTrace = true;
        this.fillInStackTrace();
    }

    @Rename(value="fakeInit")
    public TThrowable(String message) {
    }

    @Rename(value="<init>")
    private void init(String message) {
        this.initNativeException();
        this.suppressionEnabled = true;
        this.writableStackTrace = true;
        this.fillInStackTrace();
        this.message = message;
    }

    @Rename(value="fakeInit")
    public TThrowable(String message, TThrowable cause) {
    }

    @Rename(value="<init>")
    private void init(String message, TThrowable cause) {
        this.initNativeException();
        this.suppressionEnabled = true;
        this.writableStackTrace = true;
        this.fillInStackTrace();
        this.message = message;
        this.cause = cause;
    }

    @Rename(value="fakeInit")
    public TThrowable(TThrowable cause) {
    }

    @Rename(value="<init>")
    private void init(TThrowable cause) {
        this.initNativeException();
        this.suppressionEnabled = true;
        this.writableStackTrace = true;
        this.fillInStackTrace();
        this.cause = cause;
    }

    @Override
    public Throwable fillInStackTrace() {
        if (PlatformDetector.isLowLevel()) {
            this.stackTrace = (TStackTraceElement[])ExceptionHandling.fillStackTrace();
        } else if (PlatformDetector.isWebAssemblyGC()) {
            this.lazyStackTrace = this.takeWasmGCStack();
            TThrowable.decorateException(this);
        }
        return this;
    }

    private void initNativeException() {
        if (PlatformDetector.isJavaScript()) {
            TThrowable.initNativeExceptionJS(JSWrapper.directJavaToJs(this));
        }
    }

    @JSBody(params={"o"}, script="$rt_fillNativeException(o);")
    private static native void initNativeExceptionJS(JSObject var0);

    @Import(name="decorateException")
    private static native void decorateException(Object var0);

    private void ensureStackTrace() {
        if (PlatformDetector.isWebAssemblyGC() && this.lazyStackTrace != null) {
            LazyStackSupplier supplier = this.lazyStackTrace;
            this.lazyStackTrace = null;
            StackFrames nativeStack = supplier.getStack();
            if (nativeStack == null) {
                return;
            }
            TStackTraceElement[] stack = new TStackTraceElement[nativeStack.getLength()];
            for (int i = 0; i < nativeStack.getLength(); ++i) {
                StackFrame frame = nativeStack.get(i);
                stack[i] = new TStackTraceElement(frame.getClassName(), frame.getMethod(), frame.getFile(), frame.getLine());
            }
            this.stackTrace = stack;
        }
    }

    @Import(name="takeStackTrace")
    private native LazyStackSupplier takeWasmGCStack();

    @Rename(value="getMessage")
    public String getMessage0() {
        return this.message;
    }

    @Rename(value="getLocalizedMessage")
    public String getLocalizedMessage0() {
        return this.getMessage();
    }

    @Override
    @Remove
    public native TThrowable getCause();

    @Rename(value="getCause")
    public TThrowable getCause0() {
        return this.cause != this ? this.cause : null;
    }

    @Remove
    public native Class<?> getClass0();

    @Rename(value="toString")
    public String toString0() {
        String message = this.getLocalizedMessage();
        return this.getClass().getName() + (String)(message != null ? ": " + message : "");
    }

    public TThrowable initCause(TThrowable cause) {
        if (this.cause != this && this.cause != null) {
            throw new IllegalStateException("Cause already set");
        }
        if (cause == this) {
            throw new IllegalArgumentException("Circular causation relation");
        }
        this.cause = cause;
        return this;
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    @Override
    public void printStackTrace(PrintStream stream) {
        stream.print(this.getClass().getName());
        String message = this.getLocalizedMessage();
        if (message != null) {
            stream.print(": " + message);
        }
        stream.println();
        this.ensureStackTrace();
        if (this.stackTrace != null) {
            for (TStackTraceElement element : this.stackTrace) {
                stream.print("\tat ");
                stream.println(element);
            }
        }
        if (this.cause != null && this.cause != this) {
            stream.print("Caused by: ");
            this.cause.printStackTrace(stream);
        }
    }

    @Override
    public void printStackTrace(PrintWriter stream) {
        stream.print(this.getClass().getName());
        String message = this.getLocalizedMessage();
        if (message != null) {
            stream.print(": " + message);
        }
        stream.println();
        this.ensureStackTrace();
        if (this.stackTrace != null) {
            for (TStackTraceElement element : this.stackTrace) {
                stream.print("\tat ");
                stream.println(element);
            }
        }
        if (this.cause != null && this.cause != this) {
            stream.print("Caused by: ");
            this.cause.printStackTrace(stream);
        }
    }

    @Rename(value="getStackTrace")
    public TStackTraceElement[] getStackTrace0() {
        this.ensureStackTrace();
        return this.stackTrace != null ? (TStackTraceElement[])this.stackTrace.clone() : new TStackTraceElement[]{};
    }

    public void setStackTrace(TStackTraceElement[] stackTrace) {
        if (PlatformDetector.isWebAssemblyGC()) {
            this.lazyStackTrace = null;
        }
        this.stackTrace = (TStackTraceElement[])stackTrace.clone();
    }

    @Rename(value="getSuppressed")
    public final TThrowable[] getSuppressed0() {
        return TArrays.copyOf(this.suppressed, this.suppressed.length);
    }

    public final void addSuppressed(TThrowable exception) {
        if (!this.suppressionEnabled) {
            return;
        }
        this.suppressed = TArrays.copyOf(this.suppressed, this.suppressed.length + 1);
        this.suppressed[this.suppressed.length - 1] = exception;
    }

    static interface LazyStackSupplier
    extends JSObject {
        public StackFrames getStack();
    }

    static interface StackFrames
    extends JSObject {
        @JSProperty
        public int getLength();

        @JSIndexer
        public StackFrame get(int var1);
    }

    static interface StackFrame
    extends JSObject {
        @JSProperty
        public String getClassName();

        @JSProperty
        public String getMethod();

        @JSProperty
        public String getFile();

        @JSProperty
        public int getLine();
    }
}

