/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.lang.reflect;

import java.lang.annotation.Retention;
import java.util.ArrayList;
import org.teavm.dependency.DependencyAgent;
import org.teavm.dependency.DependencyNode;
import org.teavm.dependency.FieldDependency;
import org.teavm.model.AccessLevel;
import org.teavm.model.AnnotationReader;
import org.teavm.model.AnnotationValue;
import org.teavm.model.BasicBlock;
import org.teavm.model.ClassHierarchy;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassReader;
import org.teavm.model.ElementModifier;
import org.teavm.model.FieldHolder;
import org.teavm.model.FieldReader;
import org.teavm.model.FieldReference;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;
import org.teavm.model.emit.PhiEmitter;
import org.teavm.model.emit.ProgramEmitter;
import org.teavm.model.emit.ValueEmitter;

public class AnnotationGenerationHelper {
    public static final String ANNOTATION_IMPLEMENTOR_SUFFIX = "$$_impl";
    private boolean enumsAsInts;
    private boolean needAnnotImplCtor;

    public AnnotationGenerationHelper(boolean enumsAsInts, boolean needAnnotImplCtor) {
        this.enumsAsInts = enumsAsInts;
        this.needAnnotImplCtor = needAnnotImplCtor;
    }

    public final String getAnnotationImplementor(DependencyAgent agent, String annotationType) {
        String implementorName = annotationType + ANNOTATION_IMPLEMENTOR_SUFFIX;
        if (agent.getClassSource().get(implementorName) == null) {
            ClassHolder implementor = this.createImplementor(agent.getClassHierarchy(), annotationType, implementorName);
            agent.submitClass(implementor);
        }
        return implementorName;
    }

    private ClassHolder createImplementor(ClassHierarchy hierarchy, String annotationType, String implementorName) {
        ClassHolder implementor = new ClassHolder(implementorName);
        implementor.setParent("java.lang.Object");
        implementor.getInterfaces().add(annotationType);
        implementor.getModifiers().add(ElementModifier.FINAL);
        implementor.setLevel(AccessLevel.PUBLIC);
        ClassReader annotation = hierarchy.getClassSource().get(annotationType);
        if (annotation == null) {
            return implementor;
        }
        ArrayList<ValueType> ctorSignature = new ArrayList<ValueType>();
        for (MethodReader methodReader : annotation.getMethods()) {
            if (methodReader.hasModifier(ElementModifier.STATIC)) continue;
            FieldHolder field = new FieldHolder("$" + methodReader.getName());
            ValueType type = methodReader.getResultType();
            boolean isEnum = false;
            int n = 0;
            String enumCacheType = null;
            if (this.enumsAsInts) {
                while (type instanceof ValueType.Array) {
                    type = ((ValueType.Array)type).getItemType();
                    ++n;
                }
                if (type instanceof ValueType.Object) {
                    String typeName = ((ValueType.Object)type).getClassName();
                    ClassReader cls = hierarchy.getClassSource().get(typeName);
                    if (cls != null && cls.hasModifier(ElementModifier.ENUM)) {
                        enumCacheType = typeName;
                        type = ValueType.INTEGER;
                        isEnum = true;
                    }
                }
                for (int i = 0; i < n; ++i) {
                    type = ValueType.arrayOf(type);
                }
            }
            field.setType(type);
            field.setLevel(AccessLevel.PRIVATE);
            implementor.addField(field);
            MethodHolder accessor = new MethodHolder(methodReader.getDescriptor());
            ProgramEmitter pe = ProgramEmitter.create(accessor, hierarchy);
            ValueEmitter thisVal = pe.var(0, (ClassReader)implementor);
            if (isEnum) {
                FieldHolder cacheField = new FieldHolder("enumCache$" + field.getName());
                cacheField.setLevel(AccessLevel.PRIVATE);
                cacheField.getModifiers().add(ElementModifier.STATIC);
                implementor.addField(cacheField);
                cacheField.setType(ValueType.arrayOf(ValueType.object(enumCacheType)));
                this.decodeEnumOrEnumArray(pe, thisVal, cacheField, enumCacheType, field, accessor.getResultType());
            } else {
                ValueEmitter result = thisVal.getField(field.getName(), field.getType());
                if (field.getType() instanceof ValueType.Array) {
                    result = result.cloneArray();
                    result = result.cast(field.getType());
                }
                result.returnValue();
            }
            implementor.addMethod(accessor);
            ctorSignature.add(field.getType());
        }
        ctorSignature.add(ValueType.VOID);
        MethodHolder ctor = new MethodHolder("<init>", ctorSignature.toArray(new ValueType[0]));
        ProgramEmitter programEmitter = ProgramEmitter.create(ctor, hierarchy);
        ValueEmitter thisVar = programEmitter.var(0, (ClassReader)implementor);
        thisVar.invokeSpecial(Object.class, "<init>", new ValueEmitter[0]);
        int index = 1;
        for (MethodReader methodReader : annotation.getMethods()) {
            if (methodReader.hasModifier(ElementModifier.STATIC)) continue;
            ValueEmitter param = programEmitter.var(index++, methodReader.getResultType());
            thisVar.setField("$" + methodReader.getName(), param);
        }
        programEmitter.exit();
        implementor.addMethod(ctor);
        MethodHolder annotTypeMethod = new MethodHolder("annotationType", ValueType.parse(Class.class));
        ProgramEmitter programEmitter2 = ProgramEmitter.create(annotTypeMethod, hierarchy);
        programEmitter2.constant(ValueType.object(annotationType)).returnValue();
        implementor.addMethod(annotTypeMethod);
        return implementor;
    }

    private void decodeEnumOrEnumArray(ProgramEmitter pe, ValueEmitter thisVal, FieldReader cacheField, String enumCacheType, FieldReader field, ValueType type) {
        pe.when(pe.getField(cacheField.getReference(), cacheField.getType()).isNull()).thenDo(() -> pe.setField(cacheField.getReference(), pe.invoke(enumCacheType, "values", cacheField.getType(), new ValueEmitter[0])));
        ValueEmitter source = thisVal.getField(field.getName(), field.getType());
        this.decodeEnumArrayRec(pe, source, cacheField, type).returnValue();
    }

    private ValueEmitter decodeEnumArrayRec(ProgramEmitter pe, ValueEmitter source, FieldReader cacheField, ValueType type) {
        if (type instanceof ValueType.Array) {
            BasicBlock header = pe.prepareBlock();
            BasicBlock body = pe.prepareBlock();
            BasicBlock exit = pe.prepareBlock();
            ValueType itemType = ((ValueType.Array)type).getItemType();
            ValueEmitter targetArray = pe.constructArray(itemType, source.arrayLength());
            ValueEmitter initialIndex = pe.constant(0);
            PhiEmitter index = pe.phi(ValueType.INTEGER, header);
            initialIndex.propagateTo(index);
            pe.jump(header);
            pe.enter(header);
            pe.when(index.getValue().isLessThan(source.arrayLength())).thenDo(() -> pe.jump(body)).elseDo(() -> pe.jump(exit));
            pe.enter(body);
            ValueEmitter mappedValue = this.decodeEnumArrayRec(pe, source.getElement(index.getValue()), cacheField, itemType);
            targetArray.setElement(index.getValue(), mappedValue);
            index.getValue().add(1).propagateTo(index);
            pe.jump(header);
            pe.enter(exit);
            return targetArray;
        }
        return pe.getField(cacheField.getReference(), cacheField.getType()).getElement(source);
    }

    public void propagateAnnotationImplementations(DependencyAgent agent, Iterable<? extends AnnotationReader> inputAnnotations, DependencyNode outputNode) {
        for (AnnotationReader annotationReader : inputAnnotations) {
            agent.linkClass(annotationReader.getType());
        }
        ArrayList<AnnotationReader> annotations = new ArrayList<AnnotationReader>();
        for (AnnotationReader annotationReader : inputAnnotations) {
            String retentionPolicy;
            AnnotationReader retention;
            ClassReader annotType = agent.getClassSource().get(annotationReader.getType());
            if (annotType == null || (retention = annotType.getAnnotations().get(Retention.class.getName())) == null || !(retentionPolicy = retention.getValue("value").getEnumValue().getFieldName()).equals("RUNTIME")) continue;
            annotations.add(annotationReader);
        }
        for (AnnotationReader annotationReader : annotations) {
            this.propagateAnnotationInstance(agent, annotationReader, outputNode);
        }
    }

    private void propagateAnnotationInstance(DependencyAgent agent, AnnotationReader annotation, DependencyNode outputNode) {
        ClassReader annotationClass = agent.getClassSource().get(annotation.getType());
        if (annotationClass == null) {
            return;
        }
        String implementor = this.getAnnotationImplementor(agent, annotation.getType());
        if (implementor != null) {
            agent.linkClass(implementor).initClass(null);
            outputNode.propagate(agent.getType(ValueType.object(implementor)));
            ArrayList<ValueType> signature = new ArrayList<ValueType>();
            for (MethodReader methodReader : annotationClass.getMethods()) {
                if (methodReader.hasModifier(ElementModifier.STATIC)) continue;
                AnnotationValue value = annotation.getValue(methodReader.getName());
                if (value == null) {
                    value = methodReader.getAnnotationDefault();
                }
                FieldDependency field = agent.linkField(new FieldReference(implementor, "$" + methodReader.getName()));
                this.propagateAnnotationValue(agent, value, methodReader.getResultType(), field.getValue());
                signature.add(methodReader.getResultType());
            }
            if (this.needAnnotImplCtor) {
                signature.add(ValueType.VOID);
                agent.linkMethod(new MethodReference(implementor, "<init>", signature.toArray(new ValueType[0]))).use();
            }
        }
    }

    private void propagateAnnotationValue(DependencyAgent agent, AnnotationValue value, ValueType type, DependencyNode outputNode) {
        switch (value.getType()) {
            case 9: {
                outputNode.propagate(agent.getType(type));
                ValueType itemType = ((ValueType.Array)type).getItemType();
                for (AnnotationValue annotationValue : value.getList()) {
                    this.propagateAnnotationValue(agent, annotationValue, itemType, outputNode.getArrayItem());
                }
                break;
            }
            case 10: {
                break;
            }
            case 8: {
                ValueType cls = value.getJavaClass();
                while (cls instanceof ValueType.Array) {
                    cls = ((ValueType.Array)cls).getItemType();
                }
                if (cls instanceof ValueType.Object) {
                    String className = ((ValueType.Object)cls).getClassName();
                    agent.linkClass(className).initClass(null);
                }
                outputNode.getClassValueNode().propagate(agent.getType(value.getJavaClass()));
                outputNode.propagate(agent.getType(ValueType.object("java.lang.Class")));
                break;
            }
            case 11: {
                this.propagateAnnotationInstance(agent, value.getAnnotation(), outputNode);
            }
        }
    }
}

