/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.lang.reflect;

import java.lang.annotation.Annotation;
import org.teavm.classlib.impl.reflection.MethodCaller;
import org.teavm.classlib.java.lang.TClass;
import org.teavm.classlib.java.lang.TIllegalAccessException;
import org.teavm.classlib.java.lang.TIllegalArgumentException;
import org.teavm.classlib.java.lang.TInstantiationException;
import org.teavm.classlib.java.lang.TObject;
import org.teavm.classlib.java.lang.reflect.TExecutable;
import org.teavm.classlib.java.lang.reflect.TInvocationTargetException;
import org.teavm.classlib.java.lang.reflect.TMember;
import org.teavm.classlib.java.lang.reflect.TModifier;

public class TConstructor<T>
extends TExecutable
implements TMember {
    private String name;
    private MethodCaller caller;

    public TConstructor(TClass<T> declaringClass, String name, int modifiers, int accessLevel, TClass<?>[] parameterTypes, Object[] genericParameterTypes, MethodCaller caller, Annotation[] declaredAnnotations) {
        super(declaringClass, modifiers, accessLevel, parameterTypes, genericParameterTypes, declaredAnnotations, null);
        this.name = name;
        this.caller = caller;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TModifier.toString(this.getModifiers()));
        if (sb.length() > 0) {
            sb.append(' ');
        }
        sb.append(this.declaringClass.getName().toString()).append('(');
        TClass<?>[] parameterTypes = this.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(parameterTypes[i].getName());
        }
        return sb.append(')').toString();
    }

    public T newInstance(Object ... initargs) throws TInstantiationException, TIllegalAccessException, TIllegalArgumentException, TInvocationTargetException {
        if ((this.flags & 1) != 0) {
            throw new TInstantiationException();
        }
        if (this.caller == null) {
            throw new TIllegalAccessException();
        }
        if (initargs.length != this.parameterTypes.length) {
            throw new TIllegalArgumentException();
        }
        for (int i = 0; i < initargs.length; ++i) {
            if (!this.parameterTypes[i].isPrimitive() && initargs[i] != null && !this.parameterTypes[i].isInstance((TObject)initargs[i])) {
                throw new TIllegalArgumentException();
            }
            if (!this.parameterTypes[i].isPrimitive() || initargs[i] != null) continue;
            throw new TIllegalArgumentException();
        }
        return (T)this.caller.call(null, initargs);
    }
}

