/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.lang.reflect;

import java.lang.annotation.Annotation;
import org.teavm.classlib.PlatformDetector;
import org.teavm.classlib.impl.reflection.MethodCaller;
import org.teavm.classlib.java.lang.TClass;
import org.teavm.classlib.java.lang.TIllegalAccessException;
import org.teavm.classlib.java.lang.TIllegalArgumentException;
import org.teavm.classlib.java.lang.TObject;
import org.teavm.classlib.java.lang.reflect.TExecutable;
import org.teavm.classlib.java.lang.reflect.TInvocationTargetException;
import org.teavm.classlib.java.lang.reflect.TMember;
import org.teavm.classlib.java.lang.reflect.TModifier;
import org.teavm.classlib.java.lang.reflect.TType;
import org.teavm.classlib.java.lang.reflect.TTypeVariableImpl;
import org.teavm.classlib.java.lang.reflect.TTypeVariableStub;
import org.teavm.platform.Platform;

public class TMethod
extends TExecutable
implements TMember {
    private String name;
    private TClass<?> returnType;
    private TType genericReturnType;
    private boolean genericReturnTypeResolved;
    private MethodCaller caller;

    public TMethod(TClass<?> declaringClass, String name, int flags, int accessLevel, TClass<?> returnType, Object genericReturnType, TClass<?>[] parameterTypes, Object[] genericParameterTypes, MethodCaller caller, Annotation[] declaredAnnotations, TTypeVariableImpl[] typeParameters) {
        super(declaringClass, flags, accessLevel, parameterTypes, genericParameterTypes, declaredAnnotations, typeParameters);
        this.name = name;
        this.returnType = returnType;
        this.genericReturnType = (TType)genericReturnType;
        this.caller = caller;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public TClass<?> getReturnType() {
        return this.returnType;
    }

    public TType getGenericReturnType() {
        if (!this.genericReturnTypeResolved) {
            this.genericReturnTypeResolved = true;
            this.genericReturnType = this.genericReturnType == null ? this.returnType : TTypeVariableStub.resolve(this.genericReturnType, this);
        }
        return this.genericReturnType;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TModifier.toString(this.getModifiers(), (this.getDeclaringClass().getModifiers() & 0x200) != 0));
        if (sb.length() > 0) {
            sb.append(' ');
        }
        sb.append(this.getReturnType().getName()).append(' ').append(this.getDeclaringClass().getName()).append('.').append(this.name).append('(');
        TClass<?>[] parameterTypes = this.getParameterTypes();
        if (parameterTypes.length > 0) {
            sb.append(parameterTypes[0].getName());
            for (int i = 1; i < parameterTypes.length; ++i) {
                sb.append(',').append(parameterTypes[i].getName());
            }
        }
        sb.append(')');
        return sb.toString();
    }

    public Object invoke(Object obj, Object ... args) throws TIllegalAccessException, TIllegalArgumentException, TInvocationTargetException {
        if (this.caller == null) {
            throw new TIllegalAccessException();
        }
        if (args.length != this.parameterTypes.length) {
            throw new TIllegalArgumentException();
        }
        if ((this.flags & 0x200) == 0) {
            if (!this.declaringClass.isInstance((TObject)obj)) {
                throw new TIllegalArgumentException();
            }
        } else if (PlatformDetector.isJavaScript()) {
            Platform.initClass(this.declaringClass.getPlatformClass());
        }
        for (int i = 0; i < args.length; ++i) {
            if (!this.parameterTypes[i].isPrimitive() && args[i] != null && !this.parameterTypes[i].isInstance((TObject)args[i])) {
                throw new TIllegalArgumentException();
            }
            if (!this.parameterTypes[i].isPrimitive() || args[i] != null) continue;
            throw new TIllegalArgumentException();
        }
        return this.caller.call(obj, args);
    }

    public boolean isBridge() {
        return (this.flags & 0x40) != 0;
    }
}

