/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.lang.reflect;

import java.util.Arrays;
import java.util.Objects;
import org.teavm.classlib.impl.reflection.ObjectList;
import org.teavm.classlib.java.lang.TClass;
import org.teavm.classlib.java.lang.reflect.TGenericDeclaration;
import org.teavm.classlib.java.lang.reflect.TLazyResolvedType;
import org.teavm.classlib.java.lang.reflect.TParameterizedType;
import org.teavm.classlib.java.lang.reflect.TType;
import org.teavm.classlib.java.lang.reflect.TTypeVariableStub;

class TParameterizedTypeImpl
extends TLazyResolvedType
implements TParameterizedType {
    private TClass<?> rawType;
    private ObjectList actualTypeArguments;
    private TType[] actualTypeArgumentsArray;
    private TType ownerType;

    TParameterizedTypeImpl(TClass<?> rawType, ObjectList actualTypeArguments, TType ownerType) {
        this.rawType = rawType;
        this.actualTypeArguments = actualTypeArguments;
        this.ownerType = ownerType;
    }

    static TParameterizedTypeImpl create(TClass<?> rawType, ObjectList actualTypeArguments) {
        return new TParameterizedTypeImpl(rawType, actualTypeArguments, null);
    }

    static TParameterizedTypeImpl create(TClass<?> rawType, ObjectList actualTypeArguments, TType ownerType) {
        return new TParameterizedTypeImpl(rawType, actualTypeArguments, ownerType);
    }

    @Override
    public TType[] getActualTypeArguments() {
        if (this.actualTypeArgumentsArray == null) {
            if (this.actualTypeArguments == null) {
                this.actualTypeArgumentsArray = new TType[0];
            } else {
                Object[] array = this.actualTypeArguments.asArray();
                this.actualTypeArgumentsArray = new TType[array.length];
                System.arraycopy(array, 0, this.actualTypeArgumentsArray, 0, array.length);
            }
        }
        return (TType[])this.actualTypeArgumentsArray.clone();
    }

    @Override
    public TType getRawType() {
        return this.rawType;
    }

    @Override
    public TType getOwnerType() {
        return this.ownerType;
    }

    @Override
    void resolve(TGenericDeclaration declaration) {
        if (this.actualTypeArguments == null) {
            this.actualTypeArgumentsArray = new TType[0];
        } else {
            Object[] array = this.actualTypeArguments.asArray();
            this.actualTypeArgumentsArray = new TType[array.length];
            for (int i = 0; i < array.length; ++i) {
                this.actualTypeArgumentsArray[i] = TTypeVariableStub.resolve((TType)array[i], declaration);
            }
        }
        if (this.ownerType != null) {
            this.ownerType = TTypeVariableStub.resolve(this.ownerType, declaration);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TParameterizedTypeImpl)) {
            return false;
        }
        TParameterizedTypeImpl that = (TParameterizedTypeImpl)obj;
        return this.rawType == that.rawType && Objects.equals(this.ownerType, that.ownerType) && Arrays.equals(this.getActualTypeArguments(), that.getActualTypeArguments());
    }

    public int hashCode() {
        return Objects.hash(this.rawType, this.ownerType, Arrays.hashCode(this.getActualTypeArguments()));
    }

    public String toString() {
        TType[] args = this.getActualTypeArguments();
        StringBuilder sb = new StringBuilder();
        if (this.ownerType != null) {
            sb.append(this.ownerType.getTypeName()).append("$").append(this.rawType.getSimpleName());
        } else {
            sb.append(this.rawType.getName());
        }
        sb.append('<').append(args[0].getTypeName());
        for (int i = 1; i < args.length; ++i) {
            sb.append(',').append(args[i].getTypeName());
        }
        return sb.append(">").toString();
    }
}

