/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.lang.reflect;

import java.util.Arrays;
import java.util.Objects;
import org.teavm.classlib.java.lang.reflect.TGenericDeclaration;
import org.teavm.classlib.java.lang.reflect.TLazyResolvedType;
import org.teavm.classlib.java.lang.reflect.TType;
import org.teavm.classlib.java.lang.reflect.TTypeVariableStub;
import org.teavm.classlib.java.lang.reflect.TWildcardType;

class TWildcardTypeImpl
extends TLazyResolvedType
implements TWildcardType {
    private TType[] upperBounds;
    private TType[] lowerBounds;

    private TWildcardTypeImpl(TType[] upperBounds, TType[] lowerBounds) {
        this.upperBounds = upperBounds;
        this.lowerBounds = lowerBounds;
    }

    static TWildcardTypeImpl upper(TType upperBound) {
        if (upperBound == null) {
            upperBound = (TType)((Object)Object.class);
        }
        return new TWildcardTypeImpl(new TType[]{upperBound}, new TType[0]);
    }

    static TWildcardTypeImpl lower(TType lowerBound) {
        return new TWildcardTypeImpl(new TType[]{(TType)((Object)Object.class)}, new TType[]{lowerBound});
    }

    @Override
    public TType[] getUpperBounds() {
        return (TType[])this.upperBounds.clone();
    }

    @Override
    public TType[] getLowerBounds() {
        return (TType[])this.lowerBounds.clone();
    }

    @Override
    void resolve(TGenericDeclaration declaration) {
        int i;
        if (this.upperBounds != null) {
            for (i = 0; i < this.upperBounds.length; ++i) {
                this.upperBounds[i] = TTypeVariableStub.resolve(this.upperBounds[i], declaration);
            }
        }
        if (this.lowerBounds != null) {
            for (i = 0; i < this.lowerBounds.length; ++i) {
                this.lowerBounds[i] = TTypeVariableStub.resolve(this.lowerBounds[i], declaration);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TWildcardTypeImpl)) {
            return false;
        }
        TWildcardTypeImpl that = (TWildcardTypeImpl)o;
        return Objects.deepEquals(this.upperBounds, that.upperBounds) && Objects.deepEquals(this.lowerBounds, that.lowerBounds);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.upperBounds), Arrays.hashCode(this.lowerBounds));
    }

    public String toString() {
        if (this.lowerBounds.length == 0) {
            if (this.upperBounds[0].equals(Object.class)) {
                return "?";
            }
            return "? extends " + this.upperBounds[0].getTypeName();
        }
        return "? super " + this.lowerBounds[0].getTypeName();
    }
}

