/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.nio;

import java.io.IOException;
import java.util.Objects;
import org.teavm.classlib.PlatformDetector;
import org.teavm.classlib.java.lang.TReadable;
import org.teavm.classlib.java.nio.TBuffer;
import org.teavm.classlib.java.nio.TBufferOverflowException;
import org.teavm.classlib.java.nio.TBufferUnderflowException;
import org.teavm.classlib.java.nio.TByteOrder;
import org.teavm.classlib.java.nio.TCharBufferNative;
import org.teavm.classlib.java.nio.TCharBufferOverArray;
import org.teavm.classlib.java.nio.TCharBufferOverTypedArray;
import org.teavm.classlib.java.nio.TReadOnlyBufferException;
import org.teavm.interop.Address;
import org.teavm.jso.typedarrays.Uint16Array;

public abstract class TCharBuffer
extends TBuffer
implements Comparable<TCharBuffer>,
Appendable,
CharSequence,
TReadable {
    TCharBuffer(int position, int limit) {
        this.position = position;
        this.limit = limit;
    }

    abstract char getChar(int var1);

    abstract void putChar(int var1, char var2);

    public static TCharBuffer allocate(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Capacity is negative: " + capacity);
        }
        if (PlatformDetector.isJavaScript()) {
            char[] array = new char[capacity];
            return new TCharBufferOverTypedArray(0, capacity, false, Uint16Array.fromJavaArray(array), array);
        }
        if (PlatformDetector.isC() || PlatformDetector.isWebAssembly()) {
            char[] array = new char[capacity];
            return new TCharBufferNative(null, array, 0, capacity, false, array, Address.ofData(array), capacity, false);
        }
        return new TCharBufferOverArray(capacity);
    }

    public static TCharBuffer wrap(char[] array, int offset, int length) {
        if (length < 0 || offset < 0 || length + offset > array.length) {
            throw new IndexOutOfBoundsException();
        }
        if (PlatformDetector.isJavaScript()) {
            TCharBufferOverTypedArray result = new TCharBufferOverTypedArray(0, array.length, false, Uint16Array.fromJavaArray(array), array);
            result.position = offset;
            result.limit = offset + length;
            return result;
        }
        if (PlatformDetector.isC() || PlatformDetector.isWebAssembly()) {
            TCharBufferNative result = new TCharBufferNative(null, array, 0, array.length, false, array, Address.ofData(array), array.length, false);
            result.position = offset;
            result.limit = offset + length;
            return result;
        }
        return new TCharBufferOverArray(0, array.length, array, offset, offset + length, false);
    }

    public static TCharBuffer wrap(char[] array) {
        return TCharBuffer.wrap(array, 0, array.length);
    }

    @Override
    public int read(TCharBuffer target) throws IOException {
        Objects.requireNonNull(target);
        if (!this.hasRemaining()) {
            return -1;
        }
        int sz = Math.min(this.remaining(), target.remaining());
        int srcPos = this.position;
        int dstPos = target.position;
        for (int i = 0; i < sz; ++i) {
            target.putChar(dstPos++, this.getChar(srcPos++));
        }
        target.position += sz;
        return sz;
    }

    public static TCharBuffer wrap(CharSequence csq, int start, int end) {
        return TCharBuffer.wrap(csq.toString().toCharArray(), start, end - start);
    }

    public static TCharBuffer wrap(CharSequence csq) {
        return TCharBuffer.wrap(csq.toString().toCharArray());
    }

    public abstract TCharBuffer slice();

    public abstract TCharBuffer duplicate();

    public abstract TCharBuffer asReadOnlyBuffer();

    public abstract char get();

    public abstract TCharBuffer put(char var1);

    public abstract char get(int var1);

    public abstract TCharBuffer put(int var1, char var2);

    public TCharBuffer get(char[] dst, int offset, int length) {
        if (length < 0 || offset < 0 || offset + length > dst.length) {
            throw new IndexOutOfBoundsException();
        }
        if (length > this.remaining()) {
            throw new TBufferUnderflowException();
        }
        this.getImpl(this.position, dst, offset, length);
        this.position += length;
        return this;
    }

    public TCharBuffer get(int index, char[] dst, int offset, int length) {
        if (length < 0 || offset < 0 || offset + length > dst.length || index < 0 || index + length > this.capacity()) {
            throw new IndexOutOfBoundsException();
        }
        this.getImpl(index, dst, offset, length);
        return this;
    }

    public TCharBuffer get(int index, char[] dst) {
        return this.get(index, dst, 0, dst.length);
    }

    abstract void getImpl(int var1, char[] var2, int var3, int var4);

    public TCharBuffer get(char[] dst) {
        return this.get(dst, 0, dst.length);
    }

    public TCharBuffer put(TCharBuffer src) {
        if (this.isReadOnly()) {
            throw new TReadOnlyBufferException();
        }
        int elementsToTransfer = src.remaining();
        if (this.remaining() < elementsToTransfer) {
            throw new TBufferOverflowException();
        }
        this.putImpl(this.position, src, src.position, elementsToTransfer);
        this.position += elementsToTransfer;
        src.position += elementsToTransfer;
        return this;
    }

    public TCharBuffer put(int index, TCharBuffer src, int offset, int length) {
        if (this.isReadOnly()) {
            throw new TReadOnlyBufferException();
        }
        if (index < 0 || index > this.limit() || offset < 0 || offset + length > this.capacity()) {
            throw new IndexOutOfBoundsException();
        }
        this.putImpl(index, src, offset, length);
        return this;
    }

    abstract void putImpl(int var1, TCharBuffer var2, int var3, int var4);

    public TCharBuffer put(char[] src, int offset, int length) {
        if (this.isReadOnly()) {
            throw new TReadOnlyBufferException();
        }
        if (this.remaining() < length) {
            throw new TBufferOverflowException();
        }
        if (length < 0 || offset < 0 || offset + length > src.length) {
            throw new IndexOutOfBoundsException();
        }
        this.putImpl(this.position, src, offset, length);
        this.position += length;
        return this;
    }

    public TCharBuffer put(int index, char[] src, int offset, int length) {
        if (this.isReadOnly()) {
            throw new TReadOnlyBufferException();
        }
        if (length < 0 || offset < 0 || offset + length > src.length || index < 0 || index + length > this.capacity()) {
            throw new IndexOutOfBoundsException();
        }
        this.putImpl(index, src, offset, length);
        return this;
    }

    public TCharBuffer put(int index, char[] src) {
        return this.put(index, src, 0, src.length);
    }

    public final TCharBuffer put(char[] src) {
        return this.put(src, 0, src.length);
    }

    abstract void putImpl(int var1, char[] var2, int var3, int var4);

    public TCharBuffer put(String src, int start, int end) {
        if (this.isReadOnly()) {
            throw new TReadOnlyBufferException();
        }
        if (end < start || start < 0 || end > src.length()) {
            throw new IndexOutOfBoundsException();
        }
        int sz = end - start;
        if (this.remaining() < sz) {
            throw new TBufferOverflowException();
        }
        int pos = this.position;
        this.putImpl(pos, src, start, end);
        this.position += sz;
        return this;
    }

    public final TCharBuffer put(String src) {
        return this.put(src, 0, src.length());
    }

    abstract void putImpl(int var1, String var2, int var3, int var4);

    @Override
    public final boolean hasArray() {
        return this.isArrayPresent();
    }

    public final char[] array() {
        return this.getArray();
    }

    @Override
    public final int arrayOffset() {
        return this.getArrayOffset();
    }

    abstract boolean isArrayPresent();

    abstract char[] getArray();

    abstract int getArrayOffset();

    public abstract TCharBuffer compact();

    @Override
    public abstract boolean isDirect();

    public int hashCode() {
        int hashCode = 0;
        int pos = this.position;
        for (int i = this.position; i < this.limit; ++i) {
            hashCode = 31 * hashCode + this.getChar(pos++);
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TCharBuffer)) {
            return false;
        }
        TCharBuffer other = (TCharBuffer)obj;
        int sz = this.remaining();
        if (sz != other.remaining()) {
            return false;
        }
        int a = this.position;
        int b = other.position;
        for (int i = 0; i < sz; ++i) {
            if (this.getChar(a++) == other.getChar(b++)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(TCharBuffer other) {
        if (this == other) {
            return 0;
        }
        int sz = Math.min(this.remaining(), other.remaining());
        int a = this.position;
        int b = other.position;
        for (int i = 0; i < sz; ++i) {
            int r;
            if ((r = Character.compare(this.getChar(a++), other.getChar(b++))) == 0) continue;
            return r;
        }
        return Integer.compare(this.remaining(), other.remaining());
    }

    @Override
    public String toString() {
        char[] chars = new char[this.limit - this.position];
        int pos = this.position;
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = this.getChar(pos++);
        }
        return new String(chars);
    }

    @Override
    public final int length() {
        return this.remaining();
    }

    @Override
    public final char charAt(int index) {
        return this.get(index);
    }

    @Override
    public abstract TCharBuffer subSequence(int var1, int var2);

    @Override
    public TCharBuffer append(CharSequence csq) {
        return this.put(csq.toString());
    }

    @Override
    public TCharBuffer append(CharSequence csq, int start, int end) {
        return this.put(csq.subSequence(start, end).toString());
    }

    @Override
    public TCharBuffer append(char c) {
        return this.put(c);
    }

    public abstract TByteOrder order();

    @Override
    public final TCharBuffer mark() {
        super.mark();
        return this;
    }

    @Override
    public final TCharBuffer reset() {
        super.reset();
        return this;
    }

    @Override
    public final TCharBuffer clear() {
        super.clear();
        return this;
    }

    @Override
    public final TCharBuffer flip() {
        super.flip();
        return this;
    }

    @Override
    public final TCharBuffer rewind() {
        super.rewind();
        return this;
    }

    @Override
    public TCharBuffer limit(int newLimit) {
        super.limit(newLimit);
        return this;
    }

    @Override
    public TCharBuffer position(int newPosition) {
        super.position(newPosition);
        return this;
    }
}

