/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.nio;

import org.teavm.classlib.java.nio.TArrayBufferViewProvider;
import org.teavm.classlib.java.nio.TByteOrder;
import org.teavm.classlib.java.nio.TDoubleBuffer;
import org.teavm.classlib.java.nio.TDoubleBufferImpl;
import org.teavm.jso.typedarrays.ArrayBufferView;
import org.teavm.jso.typedarrays.Float64Array;

class TDoubleBufferOverTypedArray
extends TDoubleBufferImpl
implements TArrayBufferViewProvider {
    private boolean readOnly;
    private Float64Array data;
    private double[] array;

    TDoubleBufferOverTypedArray(int position, int limit, boolean readOnly, Float64Array data, double[] array) {
        super(position, limit);
        this.readOnly = readOnly;
        this.data = data;
        this.array = array;
    }

    @Override
    TDoubleBuffer duplicate(int start, int capacity, int position, int limit, boolean readOnly) {
        Float64Array slice = new Float64Array(this.data.getBuffer(), this.data.getByteOffset() + start * 8, capacity);
        return new TDoubleBufferOverTypedArray(position, limit, readOnly, slice, this.array);
    }

    @Override
    boolean readOnly() {
        return this.readOnly;
    }

    @Override
    double getElement(int index) {
        return this.data.get(index);
    }

    @Override
    void putElement(int index, double value) {
        this.data.set(index, value);
    }

    @Override
    boolean isArrayPresent() {
        return this.array != null;
    }

    @Override
    double[] getArray() {
        if (this.array == null) {
            throw new UnsupportedOperationException();
        }
        return this.array;
    }

    @Override
    int getArrayOffset() {
        if (this.array == null) {
            throw new UnsupportedOperationException();
        }
        return this.data.getByteOffset() / 8;
    }

    @Override
    public TByteOrder order() {
        return TByteOrder.nativeOrder();
    }

    @Override
    int capacityImpl() {
        return this.data.getLength();
    }

    @Override
    void getImpl(int index, double[] dst, int offset, int length) {
        Float64Array slice = new Float64Array(this.data.getBuffer(), this.data.getByteOffset() + index * 8, length);
        Float64Array.fromJavaArray(dst).set(slice, offset);
    }

    @Override
    void putImpl(int index, double[] src, int offset, int length) {
        Float64Array slice = new Float64Array(Float64Array.fromJavaArray(src).getBuffer(), offset * 8, length);
        this.data.set(slice, index);
    }

    @Override
    void putImpl(int index, TDoubleBuffer src, int offset, int length) {
        if (src instanceof TDoubleBufferOverTypedArray) {
            TDoubleBufferOverTypedArray srcImpl = (TDoubleBufferOverTypedArray)src;
            Float64Array slice = new Float64Array(srcImpl.data.getBuffer(), srcImpl.data.getByteOffset() + index * 8, length);
            this.data.set(slice, index);
        } else {
            while (length-- > 0) {
                this.data.set(index++, src.get(offset++));
            }
        }
    }

    @Override
    public ArrayBufferView getArrayBufferView() {
        return this.data;
    }

    @Override
    public int elementSize() {
        return 8;
    }
}

