/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.nio;

import org.teavm.classlib.java.nio.TArrayBufferViewProvider;
import org.teavm.classlib.java.nio.TByteOrder;
import org.teavm.classlib.java.nio.TLongBuffer;
import org.teavm.classlib.java.nio.TLongBufferImpl;
import org.teavm.jso.typedarrays.ArrayBufferView;
import org.teavm.jso.typedarrays.DataView;
import org.teavm.jso.typedarrays.Int8Array;

class TLongBufferOverDataView
extends TLongBufferImpl
implements TArrayBufferViewProvider {
    private boolean readOnly;
    private DataView data;
    private boolean littleEndian;

    TLongBufferOverDataView(int position, int limit, boolean readOnly, DataView data, boolean littleEndian) {
        super(position, limit);
        this.readOnly = readOnly;
        this.data = data;
        this.littleEndian = littleEndian;
    }

    @Override
    TLongBuffer duplicate(int start, int capacity, int position, int limit, boolean readOnly) {
        DataView slice = new DataView(this.data.getBuffer(), this.data.getByteOffset() + start * 8, capacity * 8);
        return new TLongBufferOverDataView(position, limit, readOnly, slice, this.littleEndian);
    }

    @Override
    boolean readOnly() {
        return this.readOnly;
    }

    @Override
    long getElement(int index) {
        return this.data.getBigInt64(index * 8, this.littleEndian);
    }

    @Override
    void putElement(int index, long value) {
        this.data.setBigInt64(index * 8, value, this.littleEndian);
    }

    @Override
    void getImpl(int index, long[] dst, int offset, int length) {
        index *= 8;
        while (length-- > 0) {
            dst[offset++] = this.data.getBigInt64(index, this.littleEndian);
            index += 8;
        }
    }

    @Override
    void putImpl(int index, TLongBuffer src, int offset, int length) {
        if (src instanceof TLongBufferOverDataView) {
            TLongBufferOverDataView srcImpl = (TLongBufferOverDataView)src;
            Int8Array srcArray = new Int8Array(srcImpl.data.getBuffer(), srcImpl.data.getByteOffset() + offset * 8, length *= 8);
            Int8Array destArray = new Int8Array(this.data.getBuffer(), this.data.getByteOffset() + index * 8, length);
            destArray.set(srcArray, 0);
        } else {
            index *= 8;
            while (length-- > 0) {
                this.data.setBigInt64(index, src.get(offset++), this.littleEndian);
                index += 8;
            }
        }
    }

    @Override
    void putImpl(int index, long[] src, int offset, int length) {
        index *= 8;
        while (length-- > 0) {
            this.data.setBigInt64(index, src[offset++], this.littleEndian);
            index += 8;
        }
    }

    @Override
    boolean isArrayPresent() {
        return false;
    }

    @Override
    long[] getArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    int getArrayOffset() {
        throw new UnsupportedOperationException();
    }

    @Override
    public TByteOrder order() {
        return this.littleEndian ? TByteOrder.LITTLE_ENDIAN : TByteOrder.BIG_ENDIAN;
    }

    @Override
    int capacityImpl() {
        return this.data.getByteLength() / 8;
    }

    @Override
    public ArrayBufferView getArrayBufferView() {
        return this.data;
    }

    @Override
    public int elementSize() {
        return 8;
    }
}

