/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.nio.file;

import java.io.File;
import java.io.IOException;
import org.teavm.classlib.java.net.TURI;
import org.teavm.classlib.java.nio.file.TFileSystem;
import org.teavm.classlib.java.nio.file.TFileSystems;
import org.teavm.classlib.java.nio.file.TLinkOption;

public interface TPath
extends Comparable<TPath>,
Iterable<TPath> {
    public static TPath of(String first, String ... more) {
        return TFileSystems.getDefault().getPath(first, more);
    }

    public static TPath of(TURI uri) {
        return TFileSystems.getFileSystem(uri).provider().getPath(uri);
    }

    public TFileSystem getFileSystem();

    public boolean isAbsolute();

    public TPath getRoot();

    public TPath getFileName();

    public TPath getParent();

    public int getNameCount();

    public TPath getName(int var1);

    public TPath subpath(int var1, int var2);

    public boolean startsWith(TPath var1);

    default public boolean startsWith(String other) {
        return this.startsWith(this.getFileSystem().getPath(other, new String[0]));
    }

    public boolean endsWith(TPath var1);

    default public boolean endsWith(String other) {
        return this.endsWith(this.getFileSystem().getPath(other, new String[0]));
    }

    public TPath normalize();

    public TPath resolve(TPath var1);

    default public TPath resolve(String other) {
        return this.resolve(this.getFileSystem().getPath(other, new String[0]));
    }

    default public TPath resolveSibling(TPath other) {
        return this.getParent() == null ? other : this.getParent().resolve(other);
    }

    default public TPath resolveSibling(String other) {
        return this.resolveSibling(this.getFileSystem().getPath(other, new String[0]));
    }

    public TPath relativize(TPath var1);

    public TURI toUri();

    public TPath toAbsolutePath();

    public TPath toRealPath(TLinkOption ... var1) throws IOException;

    @Override
    public int compareTo(TPath var1);

    default public File toFile() {
        if (this.getFileSystem() != TFileSystems.getDefault()) {
            throw new UnsupportedOperationException();
        }
        return new File(this.toString());
    }
}

