/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.nio.file.impl;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.teavm.classlib.java.nio.file.TFileSystem;
import org.teavm.classlib.java.nio.file.TPath;
import org.teavm.classlib.java.nio.file.impl.TDefaultFileSystemProvider;
import org.teavm.classlib.java.nio.file.impl.TDefaultPath;
import org.teavm.classlib.java.nio.file.spi.TFileSystemProvider;
import org.teavm.runtime.fs.VirtualFileSystem;
import org.teavm.runtime.fs.VirtualFileSystemProvider;

public class TDefaultFileSystem
extends TFileSystem {
    public final VirtualFileSystem vfs = VirtualFileSystemProvider.getInstance();
    public static final TDefaultFileSystem INSTANCE = new TDefaultFileSystem();

    private TDefaultFileSystem() {
    }

    @Override
    public TDefaultPath getPath(String first, String ... more) {
        StringBuilder sb = new StringBuilder();
        char separator = this.getSeparatorChar();
        this.appendSegment(sb, separator, first);
        for (String part : more) {
            if (part.isEmpty()) continue;
            this.appendSegment(sb, separator, part);
        }
        return new TDefaultPath(this, sb.toString());
    }

    private void appendSegment(StringBuilder sb, char separator, String part) {
        int index;
        if (part.isEmpty()) {
            return;
        }
        int last = 0;
        if (part.charAt(0) == separator && sb.length() == 0) {
            sb.append(separator);
        }
        while ((index = part.indexOf(separator, last)) >= 0) {
            if (index > last) {
                if (sb.length() > 0 && sb.charAt(sb.length() - 1) != separator) {
                    sb.append(separator);
                }
                sb.append(part, last, index);
            }
            while (part.charAt(index) == separator) {
                if (++index < part.length()) continue;
                return;
            }
            last = index;
        }
        if (sb.length() > 0 && sb.charAt(sb.length() - 1) != separator) {
            sb.append(separator);
        }
        sb.append(part, last, part.length());
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public String getSeparator() {
        return this.vfs.isWindows() ? "\\" : "/";
    }

    char getSeparatorChar() {
        return this.vfs.isWindows() ? (char)'\\' : '/';
    }

    @Override
    public Iterable<TPath> getRootDirectories() {
        return List.of(new TDefaultPath(this, "/"));
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        return Set.of();
    }

    @Override
    public TFileSystemProvider provider() {
        return TDefaultFileSystemProvider.INSTANCE;
    }

    @Override
    public void close() throws IOException {
        throw new UnsupportedOperationException();
    }
}

