/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.nio.file.spi;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.teavm.classlib.java.net.TURI;
import org.teavm.classlib.java.nio.file.TAccessMode;
import org.teavm.classlib.java.nio.file.TCopyOption;
import org.teavm.classlib.java.nio.file.TDirectoryStream;
import org.teavm.classlib.java.nio.file.TFileSystem;
import org.teavm.classlib.java.nio.file.TLinkOption;
import org.teavm.classlib.java.nio.file.TNoSuchFileException;
import org.teavm.classlib.java.nio.file.TOpenOption;
import org.teavm.classlib.java.nio.file.TPath;
import org.teavm.classlib.java.nio.file.attribute.TBasicFileAttributes;
import org.teavm.classlib.java.nio.file.attribute.TFileAttribute;
import org.teavm.classlib.java.nio.file.impl.TDefaultFileSystemProvider;

public abstract class TFileSystemProvider {
    private static List<TFileSystemProvider> installedProviders;

    protected TFileSystemProvider() {
    }

    public abstract String getScheme();

    public abstract TFileSystem newFileSystem(TURI var1, Map<String, ?> var2) throws IOException;

    public abstract TFileSystem getFileSystem(TURI var1);

    public abstract TPath getPath(TURI var1);

    public abstract TFileSystem newFileSystem(TPath var1, Map<String, ?> var2) throws IOException;

    public InputStream newInputStream(TPath path, TOpenOption ... options) throws IOException {
        throw new UnsupportedOperationException();
    }

    public OutputStream newOutputStream(TPath path, TOpenOption ... options) throws IOException {
        throw new UnsupportedOperationException();
    }

    public abstract TDirectoryStream<TPath> newDirectoryStream(TPath var1, TDirectoryStream.Filter<? super TPath> var2) throws IOException;

    public abstract void createDirectory(TPath var1, TFileAttribute<?> ... var2) throws IOException;

    public abstract void delete(TPath var1) throws IOException;

    public boolean deleteIfExists(TPath path) throws IOException {
        try {
            this.delete(path);
            return true;
        }
        catch (TNoSuchFileException e) {
            return false;
        }
    }

    public TPath readSymbolicLink(TPath link) throws IOException {
        throw new UnsupportedOperationException();
    }

    public abstract void copy(TPath var1, TPath var2, TCopyOption ... var3) throws IOException;

    public abstract void move(TPath var1, TPath var2, TCopyOption ... var3) throws IOException;

    public abstract boolean isSameFile(TPath var1, TPath var2) throws IOException;

    public abstract boolean isHidden(TPath var1) throws IOException;

    public abstract void checkAccess(TPath var1, TAccessMode ... var2) throws IOException;

    public abstract <A extends TBasicFileAttributes> A readAttributes(TPath var1, Class<A> var2, TLinkOption ... var3) throws IOException;

    public boolean exists(TPath path, TLinkOption ... options) {
        try {
            if (Arrays.asList(options).contains(TLinkOption.NOFOLLOW_LINKS)) {
                this.checkAccess(path, new TAccessMode[0]);
            } else {
                this.readAttributes(path, TBasicFileAttributes.class, new TLinkOption[0]);
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public <A extends TBasicFileAttributes> A readAttributesIfExists(TPath path, Class<A> type, TLinkOption ... options) throws IOException {
        try {
            return this.readAttributes(path, type, options);
        }
        catch (TNoSuchFileException e) {
            return null;
        }
    }

    public static List<TFileSystemProvider> installedProviders() {
        if (installedProviders == null) {
            ArrayList<TFileSystemProvider> providers = new ArrayList<TFileSystemProvider>();
            providers.add(TDefaultFileSystemProvider.INSTANCE);
            for (TFileSystemProvider provider : ServiceLoader.load(TFileSystemProvider.class)) {
                providers.add(provider);
            }
            installedProviders = List.copyOf(providers);
        }
        return installedProviders;
    }
}

