/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.stream.intimpl;

import java.util.function.IntPredicate;
import org.teavm.classlib.java.util.stream.intimpl.TSimpleIntStreamImpl;

public class TDropWhileIntStream
extends TSimpleIntStreamImpl {
    private TSimpleIntStreamImpl sourceStream;
    private IntPredicate predicate;
    private boolean isStarted;

    TDropWhileIntStream(TSimpleIntStreamImpl sourceStream, IntPredicate predicate) {
        this.sourceStream = sourceStream;
        this.predicate = predicate;
    }

    @Override
    public boolean next(final IntPredicate consumer) {
        if (!this.isStarted) {
            var skippingPredicate = new IntPredicate(){
                boolean consumerCanTakeMore;

                @Override
                public boolean test(int t) {
                    if (TDropWhileIntStream.this.predicate.test(t)) {
                        return true;
                    }
                    TDropWhileIntStream.this.isStarted = true;
                    this.consumerCanTakeMore = consumer.test(t);
                    return false;
                }
            };
            boolean result = this.sourceStream.next(skippingPredicate);
            if (!result) {
                return false;
            }
            if (!skippingPredicate.consumerCanTakeMore) {
                return true;
            }
        }
        return this.sourceStream.next(consumer);
    }

    @Override
    public void close() {
        this.sourceStream.close();
    }
}

