/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.stream.longimpl;

import java.util.function.LongPredicate;
import org.teavm.classlib.java.util.stream.longimpl.TSimpleLongStreamImpl;

public class TTakeWhileLongStream
extends TSimpleLongStreamImpl {
    private TSimpleLongStreamImpl sourceStream;
    private LongPredicate predicate;
    private boolean isStopped;

    TTakeWhileLongStream(TSimpleLongStreamImpl innerStream, LongPredicate predicate) {
        this.sourceStream = innerStream;
        this.predicate = predicate;
    }

    @Override
    public boolean next(LongPredicate consumer) {
        if (this.isStopped) {
            return false;
        }
        boolean result = this.sourceStream.next(e -> {
            if (!this.predicate.test(e)) {
                this.isStopped = true;
                return false;
            }
            return consumer.test(e);
        });
        if (!result) {
            this.isStopped = true;
        }
        return result;
    }

    @Override
    public void close() {
        this.sourceStream.close();
    }
}

