/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.hppc;

import java.util.Arrays;
import java.util.Iterator;
import org.teavm.hppc.AbstractIterator;
import org.teavm.hppc.Accountable;
import org.teavm.hppc.DoubleArrayList;
import org.teavm.hppc.IntArrayList;
import org.teavm.hppc.PgmIndexUtil;
import org.teavm.hppc.PlaModel;
import org.teavm.hppc.RamUsageEstimator;
import org.teavm.hppc.cursors.DoubleCursor;
import org.teavm.hppc.procedures.DoubleProcedure;

public class DoublePgmIndex
implements Accountable {
    public static final DoublePgmIndex EMPTY = new DoubleEmptyPgmIndex();
    public static final int EPSILON = 64;
    public static final int EPSILON_RECURSIVE = 32;
    public static final int KEY_SIZE = RamUsageEstimator.primitiveSizes.get(Double.TYPE) / 4;
    public static final int DOUBLE_KEY_SIZE = KEY_SIZE * 2;
    public static final int SEGMENT_DATA_SIZE = KEY_SIZE * 3;
    public static final int BEYOND_EPSILON_JUMP = 16;
    public final DoubleArrayList keys;
    public final int size;
    public final double firstKey;
    public final double lastKey;
    public final int epsilon;
    public final int epsilonRecursive;
    public final int[] levelOffsets;
    public final int[] segmentData;

    private DoublePgmIndex(DoubleArrayList keys, int size, int epsilon, int epsilonRecursive, int[] levelOffsets, int[] segmentData) {
        assert (keys.size() > 0);
        assert (size > 0 && size <= keys.size());
        assert (epsilon > 0);
        assert (epsilonRecursive > 0);
        this.keys = keys;
        this.size = size;
        this.firstKey = keys.get(0);
        this.lastKey = keys.get(keys.size() - 1);
        this.epsilon = epsilon;
        this.epsilonRecursive = epsilonRecursive;
        this.levelOffsets = levelOffsets;
        this.segmentData = segmentData;
    }

    private DoublePgmIndex() {
        this.keys = new DoubleArrayList(0);
        this.size = 0;
        this.firstKey = 0.0;
        this.lastKey = 0.0;
        this.epsilon = 0;
        this.epsilonRecursive = 0;
        this.levelOffsets = new int[0];
        this.segmentData = this.levelOffsets;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean contains(double key) {
        return this.indexOf(key) >= 0;
    }

    public int indexOf(double key) {
        if (key < this.firstKey) {
            return -1;
        }
        if (key > this.lastKey) {
            return -this.keys.size() - 1;
        }
        int[] segmentData = this.segmentData;
        int segmentDataIndex = this.findSegment(key);
        int nextIntercept = (int)DoublePgmIndex.getIntercept(segmentDataIndex + SEGMENT_DATA_SIZE, segmentData);
        int index = Math.min(this.approximateIndex(key, segmentDataIndex, segmentData), Math.min(nextIntercept, this.keys.size() - 1));
        assert (index >= 0 && index < this.keys.size());
        double k = this.keys.get(index);
        if (key < k) {
            int fromIndex = Math.max(index - this.epsilon - 1, 0);
            while (--index >= fromIndex) {
                k = this.keys.get(index);
                if (key > k) {
                    return -index - 2;
                }
                if (Double.doubleToLongBits(key) != Double.doubleToLongBits(k)) continue;
                return index;
            }
            ++index;
            int jump = 16;
            do {
                int loIndex;
                if (key >= this.keys.get(loIndex = Math.max(index - jump, 0))) {
                    return Arrays.binarySearch(this.keys.buffer, loIndex, index, key);
                }
                index = loIndex;
                jump <<= 1;
            } while (index > 0);
            return -1;
        }
        if (Double.doubleToLongBits(key) == Double.doubleToLongBits(k)) {
            return index;
        }
        int toIndex = Math.min(index + this.epsilon + 3, this.keys.size());
        while (++index < toIndex) {
            k = this.keys.get(index);
            if (key < k) {
                return -index - 1;
            }
            if (Double.doubleToLongBits(key) != Double.doubleToLongBits(k)) continue;
            return index;
        }
        int jump = 16;
        do {
            int hiIndex;
            if (key <= this.keys.get(hiIndex = Math.min(index + jump, this.keys.size()))) {
                return Arrays.binarySearch(this.keys.buffer, index, hiIndex, key);
            }
            index = hiIndex;
            jump <<= 1;
        } while (index < this.keys.size());
        return -this.keys.size() - 1;
    }

    public int rank(double x) {
        int index = this.indexOf(x);
        return index >= 0 ? index : -index - 1;
    }

    public int rangeCardinality(double minKey, double maxKey) {
        int fromIndex = this.rank(minKey);
        int maxIndex = this.indexOf(maxKey);
        int toIndex = maxIndex >= 0 ? maxIndex + 1 : -maxIndex - 1;
        return Math.max(toIndex - fromIndex, 0);
    }

    public Iterator<DoubleCursor> rangeIterator(double minKey, double maxKey) {
        int fromIndex = this.rank(minKey);
        return new RangeIterator(this.keys, fromIndex, maxKey);
    }

    public <T extends DoubleProcedure> T forEachInRange(T procedure, double minKey, double maxKey) {
        double[] buffer = this.keys.buffer;
        int size = this.keys.size();
        for (int i = this.rank(minKey); i < size; ++i) {
            double d;
            double k = buffer[i];
            if (!(d <= maxKey)) break;
            procedure.apply(k);
        }
        return procedure;
    }

    @Override
    public long ramBytesAllocated() {
        return (long)(RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 12) + 2L * (long)KEY_SIZE * 4L + RamUsageEstimator.shallowSizeOfArray(this.levelOffsets) + RamUsageEstimator.shallowSizeOfArray(this.segmentData);
    }

    @Override
    public long ramBytesUsed() {
        return (long)(RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 12) + 2L * (long)KEY_SIZE * 4L + RamUsageEstimator.shallowSizeOfArray(this.levelOffsets) + RamUsageEstimator.shallowSizeOfArray(this.segmentData);
    }

    private int findSegment(double key) {
        assert (key >= this.firstKey && key <= this.lastKey);
        int epsilonRecursive = this.epsilonRecursive;
        int[] levelOffsets = this.levelOffsets;
        int[] segmentData = this.segmentData;
        int level = levelOffsets.length - 1;
        int segmentDataIndex = levelOffsets[level] * SEGMENT_DATA_SIZE;
        while (--level >= 0) {
            int nextIntercept = (int)DoublePgmIndex.getIntercept(segmentDataIndex + SEGMENT_DATA_SIZE, segmentData);
            int index = Math.min(this.approximateIndex(key, segmentDataIndex, segmentData), nextIntercept);
            assert (index >= 0 && index <= levelOffsets[level + 1] - levelOffsets[level] - 1);
            int sdIndex = (levelOffsets[level] + index) * SEGMENT_DATA_SIZE;
            if (this.getKey(sdIndex, segmentData) <= key) {
                int levelNumSegments = levelOffsets[level + 1] - levelOffsets[level] - 1;
                int toIndex = Math.min(index + epsilonRecursive + 3, levelNumSegments);
                while (index++ < toIndex && this.getKey(sdIndex + SEGMENT_DATA_SIZE, segmentData) <= key) {
                    sdIndex += SEGMENT_DATA_SIZE;
                }
            } else {
                int fromIndex = Math.max(index - epsilonRecursive - 1, 0);
                while (index-- > fromIndex && !(this.getKey(sdIndex -= SEGMENT_DATA_SIZE, segmentData) <= key)) {
                }
            }
            segmentDataIndex = sdIndex;
        }
        assert (segmentDataIndex >= 0);
        return segmentDataIndex;
    }

    private int approximateIndex(double key, int segmentDataIndex, int[] segmentData) {
        long intercept = DoublePgmIndex.getIntercept(segmentDataIndex, segmentData);
        double sKey = this.getKey(segmentDataIndex, segmentData);
        double slope = DoublePgmIndex.getSlope(segmentDataIndex, segmentData);
        int index = (int)(slope * (key - sKey) + (double)intercept);
        return Math.max(index, 0);
    }

    private static long getIntercept(int segmentDataIndex, int[] segmentData) {
        return PgmIndexUtil.getIntercept(segmentDataIndex, segmentData, KEY_SIZE);
    }

    private double getKey(int segmentDataIndex, int[] segmentData) {
        return PgmIndexUtil.getKey(segmentDataIndex + KEY_SIZE, segmentData, 0.0);
    }

    private static double getSlope(int segmentDataIndex, int[] segmentData) {
        return PgmIndexUtil.getSlope(segmentDataIndex + DOUBLE_KEY_SIZE, segmentData, KEY_SIZE);
    }

    protected static class RangeIterator
    extends AbstractIterator<DoubleCursor> {
        private final double[] buffer;
        private final int size;
        private final DoubleCursor cursor;
        private final double maxKey;

        protected RangeIterator(DoubleArrayList keys, int fromIndex, double maxKey) {
            this.buffer = keys.buffer;
            this.size = keys.size();
            this.cursor = new DoubleCursor();
            this.cursor.index = fromIndex;
            this.maxKey = maxKey;
        }

        @Override
        protected DoubleCursor fetch() {
            if (this.cursor.index >= this.size) {
                return (DoubleCursor)this.done();
            }
            this.cursor.value = this.buffer[this.cursor.index++];
            if (this.cursor.value > this.maxKey) {
                this.cursor.index = this.size;
                return (DoubleCursor)this.done();
            }
            return this.cursor;
        }
    }

    private static class DoubleEmptyPgmIndex
    extends DoublePgmIndex {
        private final Iterator<DoubleCursor> emptyIterator = new DoubleEmptyIterator();

        private DoubleEmptyPgmIndex() {
        }

        @Override
        public int indexOf(double key) {
            return -1;
        }

        @Override
        public Iterator<DoubleCursor> rangeIterator(double minKey, double maxKey) {
            return this.emptyIterator;
        }

        @Override
        public <T extends DoubleProcedure> T forEachInRange(T procedure, double minKey, double maxKey) {
            return procedure;
        }

        private static class DoubleEmptyIterator
        extends AbstractIterator<DoubleCursor> {
            private DoubleEmptyIterator() {
            }

            @Override
            protected DoubleCursor fetch() {
                return (DoubleCursor)this.done();
            }
        }
    }

    public static class DoubleBuilder
    implements PlaModel.SegmentConsumer,
    Accountable {
        protected DoubleArrayList keys;
        protected int epsilon = 64;
        protected int epsilonRecursive = 32;
        protected PlaModel plam;
        protected int size;
        protected IntArrayList segmentData;
        protected int numSegments;

        public DoubleBuilder setSortedKeys(DoubleArrayList keys) {
            this.keys = keys;
            return this;
        }

        public DoubleBuilder setSortedKeys(double[] keys, int length) {
            DoubleArrayList keyList = new DoubleArrayList(0);
            keyList.buffer = keys;
            keyList.elementsCount = length;
            return this.setSortedKeys(keyList);
        }

        public DoubleBuilder setEpsilon(int epsilon) {
            if (epsilon <= 0) {
                throw new IllegalArgumentException("epsilon must be > 0");
            }
            this.epsilon = epsilon;
            return this;
        }

        public DoubleBuilder setEpsilonRecursive(int epsilonRecursive) {
            if (epsilonRecursive <= 0) {
                throw new IllegalArgumentException("epsilonRecursive must be > 0");
            }
            this.epsilonRecursive = epsilonRecursive;
            return this;
        }

        public DoublePgmIndex build() {
            if (this.keys == null || this.keys.size() == 0) {
                return EMPTY;
            }
            this.plam = new PlaModel(this.epsilon);
            int segmentsInitialCapacity = Math.min(Math.max(this.keys.size() / (2 * this.epsilon * this.epsilon) * SEGMENT_DATA_SIZE, 16), 524288);
            this.segmentData = new IntArrayList(segmentsInitialCapacity);
            IntArrayList levelOffsets = new IntArrayList(16);
            int levelOffset = 0;
            levelOffsets.add(levelOffset);
            int levelNumSegments = this.buildFirstLevel();
            while (levelNumSegments > 1) {
                int nextLevelOffset = this.numSegments;
                levelOffsets.add(nextLevelOffset);
                levelNumSegments = this.buildUpperLevel(levelOffset, levelNumSegments);
                levelOffset = nextLevelOffset;
            }
            int[] segmentDataFinal = this.segmentData.toArray();
            int[] levelOffsetsFinal = levelOffsets.toArray();
            return new DoublePgmIndex(this.keys, this.size, this.epsilon, this.epsilonRecursive, levelOffsetsFinal, segmentDataFinal);
        }

        private int buildFirstLevel() {
            assert (this.numSegments == 0);
            int numKeys = this.keys.size();
            int size = 0;
            double key = this.keys.get(0);
            ++size;
            this.plam.addKey(key, 0, this);
            for (int i = 1; i < numKeys; ++i) {
                double nextKey = this.keys.get(i);
                if (Double.doubleToLongBits(nextKey) == Double.doubleToLongBits(key)) continue;
                key = nextKey;
                this.plam.addKey(key, i, this);
                ++size;
            }
            this.plam.finish(this);
            this.addSentinelSegment(numKeys);
            this.size = size;
            return this.numSegments - 1;
        }

        private int buildUpperLevel(int levelOffset, int levelNumSegments) {
            this.plam.setEpsilon(this.epsilonRecursive);
            assert (this.numSegments > 0);
            int initialNumSegments = this.numSegments;
            int segmentDataIndex = levelOffset * SEGMENT_DATA_SIZE;
            double key = this.getKey(segmentDataIndex, this.segmentData.buffer);
            this.plam.addKey(key, 0, this);
            for (int i = 1; i < levelNumSegments; ++i) {
                double nextKey = this.getKey(segmentDataIndex += SEGMENT_DATA_SIZE, this.segmentData.buffer);
                if (Double.doubleToLongBits(nextKey) == Double.doubleToLongBits(key)) continue;
                key = nextKey;
                this.plam.addKey(key, i, this);
            }
            this.plam.finish(this);
            this.addSentinelSegment(levelNumSegments);
            return this.numSegments - initialNumSegments - 1;
        }

        private double getKey(int segmentDataIndex, int[] segmentData) {
            return PgmIndexUtil.getKey(segmentDataIndex + KEY_SIZE, segmentData, 0.0);
        }

        private void addSentinelSegment(int endIndex) {
            this.accept(Double.MAX_VALUE, 0.0, endIndex);
        }

        @Override
        public void accept(double firstKey, double slope, long intercept) {
            PgmIndexUtil.addIntercept(intercept, this.segmentData, KEY_SIZE);
            PgmIndexUtil.addKey(firstKey, this.segmentData);
            PgmIndexUtil.addSlope(slope, this.segmentData, KEY_SIZE);
            ++this.numSegments;
            assert (this.segmentData.size() == this.numSegments * SEGMENT_DATA_SIZE);
        }

        @Override
        public long ramBytesAllocated() {
            return (long)(RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 16) + this.plam.ramBytesAllocated() + this.segmentData.ramBytesAllocated();
        }

        @Override
        public long ramBytesUsed() {
            return (long)(RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 16) + this.plam.ramBytesUsed() + this.segmentData.ramBytesUsed();
        }
    }
}

