/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.hppc;

import java.util.Iterator;
import java.util.Objects;
import java.util.function.IntBinaryOperator;
import org.teavm.hppc.AbstractCharCollection;
import org.teavm.hppc.AbstractIterator;
import org.teavm.hppc.AbstractObjectCollection;
import org.teavm.hppc.CharCollection;
import org.teavm.hppc.CharContainer;
import org.teavm.hppc.CharLookupContainer;
import org.teavm.hppc.CharObjectAssociativeContainer;
import org.teavm.hppc.CharObjectHashMap;
import org.teavm.hppc.CharObjectMap;
import org.teavm.hppc.ObjectContainer;
import org.teavm.hppc.comparators.CharComparator;
import org.teavm.hppc.comparators.CharObjectComparator;
import org.teavm.hppc.cursors.CharCursor;
import org.teavm.hppc.cursors.CharObjectCursor;
import org.teavm.hppc.cursors.ObjectCursor;
import org.teavm.hppc.predicates.CharObjectPredicate;
import org.teavm.hppc.predicates.CharPredicate;
import org.teavm.hppc.predicates.ObjectPredicate;
import org.teavm.hppc.procedures.CharObjectProcedure;
import org.teavm.hppc.procedures.CharProcedure;
import org.teavm.hppc.procedures.ObjectProcedure;
import org.teavm.hppc.sorting.QuickSort;

public class SortedIterationCharObjectHashMap<VType>
implements CharObjectMap<VType> {
    public final CharObjectHashMap<VType> delegate;
    public final int[] iterationOrder;

    public SortedIterationCharObjectHashMap(CharObjectHashMap<VType> delegate, CharComparator comparator) {
        this.delegate = delegate;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    public SortedIterationCharObjectHashMap(CharObjectHashMap<VType> delegate, CharObjectComparator<VType> comparator) {
        this.delegate = delegate;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    private int[] createEntryIndexes() {
        char[] keys = this.delegate.keys;
        int size = this.delegate.size();
        int[] entryIndexes = new int[size];
        int entry = 0;
        if (this.delegate.hasEmptyKey) {
            entryIndexes[entry++] = this.delegate.mask + 1;
        }
        int keyIndex = 0;
        while (entry < size) {
            if (keys[keyIndex] != '\u0000') {
                entryIndexes[entry++] = keyIndex;
            }
            ++keyIndex;
        }
        return entryIndexes;
    }

    protected int[] sortIterationOrder(int[] entryIndexes, CharComparator comparator) {
        QuickSort.sort(entryIndexes, (i, j) -> {
            char[] keys = this.delegate.keys;
            return comparator.compare(keys[entryIndexes[i]], keys[entryIndexes[j]]);
        });
        return entryIndexes;
    }

    protected int[] sortIterationOrder(final int[] entryIndexes, final CharObjectComparator<VType> comparator) {
        QuickSort.sort(entryIndexes, new IntBinaryOperator(){
            final char[] keys;
            final VType[] values;
            {
                this.keys = SortedIterationCharObjectHashMap.this.delegate.keys;
                this.values = SortedIterationCharObjectHashMap.this.delegate.values;
            }

            @Override
            public int applyAsInt(int i, int j) {
                int index1 = entryIndexes[i];
                int index2 = entryIndexes[j];
                return comparator.compare(this.keys[index1], this.values[index1], this.keys[index2], this.values[index2]);
            }
        });
        return entryIndexes;
    }

    @Override
    public Iterator<CharObjectCursor<VType>> iterator() {
        assert (this.checkUnmodified());
        return new EntryIterator();
    }

    @Override
    public boolean containsKey(char key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public int size() {
        assert (this.checkUnmodified());
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public int removeAll(CharContainer container) {
        throw SortedIterationCharObjectHashMap.readOnlyException();
    }

    @Override
    public int removeAll(CharPredicate predicate) {
        throw SortedIterationCharObjectHashMap.readOnlyException();
    }

    @Override
    public int removeAll(CharObjectPredicate<? super VType> predicate) {
        throw SortedIterationCharObjectHashMap.readOnlyException();
    }

    @Override
    public <T extends CharObjectProcedure<? super VType>> T forEach(T procedure) {
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        char[] keys = this.delegate.keys;
        Object[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            int slot = iterationOrder[i];
            procedure.apply(keys[slot], (Object)values[slot]);
        }
        return procedure;
    }

    @Override
    public <T extends CharObjectPredicate<? super VType>> T forEach(T predicate) {
        int slot;
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        char[] keys = this.delegate.keys;
        Object[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size && predicate.apply(keys[slot = iterationOrder[i]], (Object)values[slot]); ++i) {
        }
        return predicate;
    }

    @Override
    public CharCollection keys() {
        assert (this.checkUnmodified());
        return new KeysContainer();
    }

    @Override
    public ObjectContainer<VType> values() {
        assert (this.checkUnmodified());
        return new ValuesContainer();
    }

    @Override
    public VType get(char key) {
        return this.delegate.get(key);
    }

    @Override
    public VType getOrDefault(char key, VType defaultValue) {
        return this.delegate.getOrDefault(key, defaultValue);
    }

    @Override
    public VType put(char key, VType value) {
        throw SortedIterationCharObjectHashMap.readOnlyException();
    }

    @Override
    public int putAll(CharObjectAssociativeContainer<? extends VType> container) {
        throw SortedIterationCharObjectHashMap.readOnlyException();
    }

    @Override
    public int putAll(Iterable<? extends CharObjectCursor<? extends VType>> iterable) {
        throw SortedIterationCharObjectHashMap.readOnlyException();
    }

    @Override
    public VType remove(char key) {
        throw SortedIterationCharObjectHashMap.readOnlyException();
    }

    @Override
    public int indexOf(char key) {
        return this.delegate.indexOf(key);
    }

    @Override
    public boolean indexExists(int index) {
        return this.delegate.indexExists(index);
    }

    @Override
    public VType indexGet(int index) {
        return this.delegate.indexGet(index);
    }

    @Override
    public VType indexReplace(int index, VType newValue) {
        throw SortedIterationCharObjectHashMap.readOnlyException();
    }

    @Override
    public void indexInsert(int index, char key, VType value) {
        throw SortedIterationCharObjectHashMap.readOnlyException();
    }

    @Override
    public VType indexRemove(int index) {
        throw SortedIterationCharObjectHashMap.readOnlyException();
    }

    @Override
    public void clear() {
        throw SortedIterationCharObjectHashMap.readOnlyException();
    }

    @Override
    public void release() {
        throw SortedIterationCharObjectHashMap.readOnlyException();
    }

    @Override
    public String visualizeKeyDistribution(int characters) {
        return this.delegate.visualizeKeyDistribution(characters);
    }

    private static RuntimeException readOnlyException() {
        throw new UnsupportedOperationException("Read-only view cannot be modified");
    }

    private boolean checkUnmodified() {
        assert (this.delegate.size() == this.iterationOrder.length) : "The delegate map changed; this is not supported by this read-only view";
        return true;
    }

    private final class EntryIterator
    extends AbstractIterator<CharObjectCursor<VType>> {
        private final CharObjectCursor<VType> cursor = new CharObjectCursor();
        private int index;

        private EntryIterator() {
        }

        @Override
        protected CharObjectCursor<VType> fetch() {
            if (this.index < SortedIterationCharObjectHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationCharObjectHashMap.this.iterationOrder[this.index++];
                this.cursor.key = SortedIterationCharObjectHashMap.this.delegate.keys[slot];
                this.cursor.value = SortedIterationCharObjectHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (CharObjectCursor)this.done();
        }
    }

    private final class KeysContainer
    extends AbstractCharCollection
    implements CharLookupContainer {
        private final SortedIterationCharObjectHashMap<VType> owner;

        private KeysContainer() {
            this.owner = SortedIterationCharObjectHashMap.this;
        }

        @Override
        public boolean contains(char e) {
            return this.owner.containsKey(e);
        }

        @Override
        public <T extends CharProcedure> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(k));
            return procedure;
        }

        @Override
        public <T extends CharPredicate> T forEach(T predicate) {
            this.owner.forEach((key, value) -> predicate.apply(key));
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<CharCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            throw SortedIterationCharObjectHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationCharObjectHashMap.readOnlyException();
        }

        @Override
        public int removeAll(CharPredicate predicate) {
            throw SortedIterationCharObjectHashMap.readOnlyException();
        }

        @Override
        public int removeAll(char e) {
            throw SortedIterationCharObjectHashMap.readOnlyException();
        }
    }

    private final class ValuesContainer
    extends AbstractObjectCollection<VType> {
        private final SortedIterationCharObjectHashMap<VType> owner;

        private ValuesContainer() {
            this.owner = SortedIterationCharObjectHashMap.this;
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public boolean contains(VType value) {
            for (CharObjectCursor c : this.owner) {
                if (!Objects.equals(value, c.value)) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends ObjectProcedure<? super VType>> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(v));
            return procedure;
        }

        @Override
        public <T extends ObjectPredicate<? super VType>> T forEach(T predicate) {
            this.owner.forEach((k, v) -> predicate.apply(v));
            return predicate;
        }

        @Override
        public Iterator<ObjectCursor<VType>> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAll(VType e) {
            throw SortedIterationCharObjectHashMap.readOnlyException();
        }

        @Override
        public int removeAll(ObjectPredicate<? super VType> predicate) {
            throw SortedIterationCharObjectHashMap.readOnlyException();
        }

        @Override
        public void clear() {
            throw SortedIterationCharObjectHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationCharObjectHashMap.readOnlyException();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<ObjectCursor<VType>> {
        private final ObjectCursor<VType> cursor = new ObjectCursor();
        private int index;

        private ValuesIterator() {
        }

        @Override
        protected ObjectCursor<VType> fetch() {
            if (this.index < SortedIterationCharObjectHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationCharObjectHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationCharObjectHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (ObjectCursor)this.done();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<CharCursor> {
        private final CharCursor cursor = new CharCursor();
        private int index;

        private KeysIterator() {
        }

        @Override
        protected CharCursor fetch() {
            if (this.index < SortedIterationCharObjectHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationCharObjectHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationCharObjectHashMap.this.delegate.keys[slot];
                return this.cursor;
            }
            return (CharCursor)this.done();
        }
    }
}

