/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jso.impl;

import org.teavm.classlib.PlatformDetector;
import org.teavm.interop.Import;
import org.teavm.interop.NoSideEffects;
import org.teavm.jso.JSBody;
import org.teavm.jso.JSClass;
import org.teavm.jso.JSFunctor;
import org.teavm.jso.JSObject;
import org.teavm.jso.core.JSBoolean;
import org.teavm.jso.core.JSMap;
import org.teavm.jso.core.JSNumber;
import org.teavm.jso.core.JSObjects;
import org.teavm.jso.core.JSString;
import org.teavm.jso.core.JSUndefined;
import org.teavm.jso.core.JSWeakMap;
import org.teavm.jso.core.JSWeakRef;
import org.teavm.jso.impl.JS;
import org.teavm.jso.impl.JSMarshallable;

public final class JSWrapper {
    public final JSObject js;

    private JSWrapper(JSObject js) {
        this.js = js;
    }

    public static Object wrap(JSObject o) {
        if (o == null) {
            return null;
        }
        String type = JSObjects.typeOf(o);
        boolean isObject = type.equals("object") || type.equals("function");
        JSWeakMap<JSObject, JSWeakRef<JSObject>> wrappers = Helper.wrappers;
        if (wrappers != null) {
            if (isObject) {
                JSObject existing;
                JSWeakRef<JSObject> existingRef = JSWrapper.get(wrappers, o);
                JSObject jSObject = existing = !JSWrapper.isUndefined(existingRef) ? JSWrapper.deref(existingRef) : JSUndefined.instance();
                if (JSWrapper.isUndefined(existing)) {
                    JSWrapper wrapper = new JSWrapper(o);
                    JSWrapper.set(wrappers, o, JSWrapper.createWeakRef(JSWrapper.wrapperToJs(wrapper)));
                    return wrapper;
                }
                return JSWrapper.jsToWrapper(existing);
            }
            if (type.equals("string")) {
                JSObject existing;
                JSString jsString = (JSString)o;
                JSMap<JSString, JSWeakRef<JSObject>> stringWrappers = Helper.stringWrappers;
                Helper.FinalizationRegistry stringFinalizationRegistry = Helper.stringFinalizationRegistry;
                JSWeakRef<JSObject> existingRef = JSWrapper.get(stringWrappers, (JSObject)jsString);
                JSObject jSObject = existing = !JSWrapper.isUndefined(existingRef) ? JSWrapper.deref(existingRef) : JSUndefined.instance();
                if (JSWrapper.isUndefined(existing)) {
                    JSWrapper wrapper = new JSWrapper(o);
                    JSObject wrapperAsJs = JSWrapper.wrapperToJs(wrapper);
                    JSWrapper.set(stringWrappers, (JSObject)jsString, JSWrapper.createWeakRef(wrapperAsJs));
                    stringFinalizationRegistry.register(wrapperAsJs, jsString);
                    return wrapper;
                }
                return JSWrapper.jsToWrapper(existing);
            }
            if (type.equals("number")) {
                JSObject existing;
                JSNumber jsNumber = (JSNumber)o;
                JSMap<JSNumber, JSWeakRef<JSObject>> numberWrappers = Helper.numberWrappers;
                Helper.FinalizationRegistry numberFinalizationRegistry = Helper.numberFinalizationRegistry;
                JSWeakRef<JSObject> existingRef = JSWrapper.get(numberWrappers, (JSObject)jsNumber);
                JSObject jSObject = existing = !JSWrapper.isUndefined(existingRef) ? JSWrapper.deref(existingRef) : JSUndefined.instance();
                if (JSWrapper.isUndefined(existing)) {
                    JSWrapper wrapper = new JSWrapper(o);
                    JSObject wrapperAsJs = JSWrapper.wrapperToJs(wrapper);
                    JSWrapper.set(numberWrappers, (JSObject)jsNumber, JSWrapper.createWeakRef(wrapperAsJs));
                    numberFinalizationRegistry.register(wrapperAsJs, jsNumber);
                    return wrapper;
                }
                return JSWrapper.jsToWrapper(existing);
            }
            if (type.equals("undefined")) {
                JSObject existing;
                JSWeakRef<JSObject> existingRef = Helper.undefinedWrapper;
                JSObject jSObject = existing = existingRef != null ? JSWrapper.deref(existingRef) : JSUndefined.instance();
                if (JSWrapper.isUndefined(existing)) {
                    JSWrapper wrapper = new JSWrapper(o);
                    JSObject wrapperAsJs = JSWrapper.wrapperToJs(wrapper);
                    Helper.undefinedWrapper = JSWrapper.createWeakRef(wrapperAsJs);
                    return wrapper;
                }
                return JSWrapper.jsToWrapper(existing);
            }
        }
        return new JSWrapper(o);
    }

    @JSBody(params={"target"}, script="return new WeakRef(target);")
    @NoSideEffects
    private static native JSWeakRef<JSObject> createWeakRef(JSObject var0);

    @JSBody(params={"target"}, script="return target.deref();")
    @NoSideEffects
    private static native JSObject deref(JSWeakRef<JSObject> var0);

    @JSBody(params={"map", "key"}, script="return map.get(key);")
    @NoSideEffects
    private static native JSWeakRef<JSObject> get(JSMap<? extends JSObject, JSWeakRef<JSObject>> var0, JSObject var1);

    @JSBody(params={"map", "key", "value"}, script="map.set(key, value);")
    @NoSideEffects
    private static native void set(JSMap<? extends JSObject, JSWeakRef<JSObject>> var0, JSObject var1, JSObject var2);

    @JSBody(params={"map", "key"}, script="return map.get(key);")
    @NoSideEffects
    private static native JSWeakRef<JSObject> get(JSWeakMap<? extends JSObject, JSWeakRef<JSObject>> var0, JSObject var1);

    @JSBody(params={"map", "key", "value"}, script="map.set(key, value);")
    @NoSideEffects
    private static native void set(JSWeakMap<? extends JSObject, JSWeakRef<JSObject>> var0, JSObject var1, JSObject var2);

    @NoSideEffects
    public static Object maybeWrap(Object o) {
        return o == null || JSWrapper.isJava(o) ? o : JSWrapper.wrap(JSWrapper.directJavaToJs(o));
    }

    @NoSideEffects
    public static native JSObject directJavaToJs(Object var0);

    @NoSideEffects
    public static native JSObject marshallJavaToJs(Object var0);

    @NoSideEffects
    @Import(name="unwrapJavaObject", module="teavmJso")
    public static native Object unmarshallJavaFromJs(JSObject var0);

    @NoSideEffects
    public static native JSObject dependencyJavaToJs(Object var0);

    @NoSideEffects
    public static native Object dependencyJsToJava(JSObject var0);

    @NoSideEffects
    private static native JSObject wrapperToJs(JSWrapper var0);

    @NoSideEffects
    private static native JSWrapper jsToWrapper(JSObject var0);

    @NoSideEffects
    public static native boolean isJava(Object var0);

    @NoSideEffects
    public static native boolean isJava(JSObject var0);

    public static JSObject unwrap(Object o) {
        if (o == null) {
            return null;
        }
        return !(o instanceof JSWrapper) ? JSWrapper.marshallJavaToJs(o) : ((JSWrapper)o).js;
    }

    public static JSObject maybeUnwrap(Object o) {
        if (o == null) {
            return null;
        }
        return JSWrapper.isJava(o) ? JSWrapper.unwrap(o) : JSWrapper.marshallJavaToJs(o);
    }

    public static JSObject javaToJs(Object o) {
        if (o == null) {
            return null;
        }
        return JSWrapper.isJava(o) && o instanceof JSWrapper ? JSWrapper.unwrap(o) : JSWrapper.dependencyJavaToJs(o);
    }

    public static Object jsToJava(JSObject o) {
        if (o == null) {
            return null;
        }
        return !JSWrapper.isJava(o) ? JSWrapper.wrap(o) : JSWrapper.dependencyJsToJava(o);
    }

    public static boolean isJs(Object o) {
        if (o == null) {
            return false;
        }
        return !JSWrapper.isJava(o) || o instanceof JSWrapper;
    }

    public static boolean isPrimitive(Object o, JSObject primitive) {
        if (PlatformDetector.isWebAssemblyGC()) {
            JSObject js;
            if (o instanceof JSWrapper) {
                js = ((JSWrapper)o).js;
            } else if (o instanceof JSMarshallable) {
                js = ((JSMarshallable)o).marshallToJs();
            } else {
                return false;
            }
            return JS.isPrimitive(js, primitive);
        }
        return JSWrapper.isJs(o) && JS.isPrimitive(JSWrapper.maybeUnwrap(o), primitive);
    }

    public static boolean instanceOf(Object o, JSObject type) {
        if (PlatformDetector.isWebAssemblyGC()) {
            JSObject js;
            if (o instanceof JSWrapper) {
                js = ((JSWrapper)o).js;
            } else if (o instanceof JSMarshallable) {
                js = ((JSMarshallable)o).marshallToJs();
            } else {
                return false;
            }
            return JS.instanceOf(js, type);
        }
        return JSWrapper.isJs(o) && JS.instanceOf(JSWrapper.maybeUnwrap(o), type);
    }

    public int hashCode() {
        if (PlatformDetector.isWebAssemblyGC()) {
            return JSWrapper.wasmGcHashCode(this.js);
        }
        String type = JSObjects.typeOf(this.js);
        if (type.equals("object") || type.equals("symbol") || type.equals("function")) {
            JSTransparentInt code = Helper.hashCodes.get(this.js);
            if (JSWrapper.isUndefined(code)) {
                code = JSTransparentInt.valueOf(++Helper.hashCodeGen);
                Helper.hashCodes.set(this.js, code);
            }
            return code.intValue();
        }
        if (type.equals("number")) {
            return ((JSNumber)this.js).intValue();
        }
        if (type.equals("bigint")) {
            return JSWrapper.bigintTruncate(this.js);
        }
        if (type.equals("string")) {
            JSString s = (JSString)this.js;
            int hashCode = 0;
            for (int i = 0; i < s.getLength(); ++i) {
                hashCode = 31 * hashCode + s.charCodeAt(i);
            }
            return hashCode;
        }
        if (type.equals("boolean")) {
            return this.js == JSBoolean.valueOf(true) ? 1 : 0;
        }
        return 0;
    }

    @Import(name="hashCode", module="teavmJso")
    private static native int wasmGcHashCode(JSObject var0);

    @JSBody(params={"bigint"}, script="return BigInt.asIntN(bigint, 32);")
    @NoSideEffects
    private static native int bigintTruncate(JSObject var0);

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JSWrapper)) {
            return false;
        }
        return this.js == ((JSWrapper)obj).js;
    }

    public String toString() {
        return JSWrapper.isUndefined(this.js) ? "undefined" : JSObjects.toString(this.js);
    }

    @JSBody(params={"obj"}, script="return typeof obj == 'undefined'")
    private static native boolean isUndefined(JSObject var0);

    private static class Helper {
        private static final JSWeakMap<JSObject, JSTransparentInt> hashCodes = new JSWeakMap();
        private static final JSWeakMap<JSObject, JSWeakRef<JSObject>> wrappers = JSWeakRef.isSupported() ? new JSWeakMap() : null;
        private static final JSMap<JSString, JSWeakRef<JSObject>> stringWrappers = JSWeakRef.isSupported() ? new JSMap() : null;
        private static final JSMap<JSNumber, JSWeakRef<JSObject>> numberWrappers = JSWeakRef.isSupported() ? new JSMap() : null;
        private static JSWeakRef<JSObject> undefinedWrapper;
        private static FinalizationRegistry stringFinalizationRegistry;
        private static FinalizationRegistry numberFinalizationRegistry;
        private static int hashCodeGen;

        private Helper() {
        }

        static {
            stringFinalizationRegistry = stringWrappers != null ? new FinalizationRegistry(token -> stringWrappers.delete((JSString)token)) : null;
            numberFinalizationRegistry = numberWrappers != null ? new FinalizationRegistry(token -> numberWrappers.delete((JSNumber)token)) : null;
        }

        @JSClass(name="FinalizationRegistry")
        static class FinalizationRegistry
        implements JSObject {
            FinalizationRegistry(FinalizationRegistryConsumer consumer) {
            }

            native void register(Object var1, JSObject var2);

            native void register(Object var1, JSObject var2, Object var3);
        }

        @JSFunctor
        static interface FinalizationRegistryConsumer
        extends JSObject {
            public void accept(JSObject var1);
        }
    }

    @JSClass(transparent=true)
    static abstract class JSTransparentInt
    implements JSObject {
        JSTransparentInt() {
        }

        @JSBody(script="return this;")
        native int intValue();

        @JSBody(params={"value"}, script="return value;")
        static native JSTransparentInt valueOf(int var0);
    }
}

