/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.teavm.common.OptionalPredicate;
import org.teavm.hppc.ObjectByteHashMap;
import org.teavm.hppc.ObjectByteMap;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.FieldReader;
import org.teavm.model.FieldReference;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;

public class ClassHierarchy {
    private final ClassReaderSource classSource;
    private final Map<String, OptionalPredicate<ValueType>> superclassPredicateCache = new HashMap<String, OptionalPredicate<ValueType>>();
    private final Map<String, Map<MethodDescriptor, Optional<MethodReader>>> resolveMethodCache = new HashMap<String, Map<MethodDescriptor, Optional<MethodReader>>>();
    private final Map<String, Map<String, Optional<FieldReader>>> resolveFieldCache = new HashMap<String, Map<String, Optional<FieldReader>>>();
    OptionalPredicate<ValueType> objectPredicate = (value, defaultResult) -> !(value instanceof ValueType.Primitive);

    public ClassHierarchy(ClassReaderSource classSource) {
        this.classSource = classSource;
        this.superclassPredicateCache.put("java.lang.Object", (c, d) -> true);
    }

    public ClassReaderSource getClassSource() {
        return this.classSource;
    }

    public boolean isSuperType(ValueType superType, ValueType subType, boolean defaultValue) {
        if (superType.equals(subType)) {
            return true;
        }
        if (superType instanceof ValueType.Primitive || subType instanceof ValueType.Primitive) {
            return false;
        }
        if (superType.isObject("java.lang.Object")) {
            return true;
        }
        if (superType instanceof ValueType.Object && subType instanceof ValueType.Object) {
            return this.isSuperType(((ValueType.Object)superType).getClassName(), ((ValueType.Object)subType).getClassName(), defaultValue);
        }
        if (superType instanceof ValueType.Array & subType instanceof ValueType.Array) {
            return this.isSuperType(((ValueType.Array)superType).getItemType(), ((ValueType.Array)subType).getItemType(), defaultValue);
        }
        return false;
    }

    public boolean isSuperType(String superType, String subType, boolean defaultValue) {
        if (subType.equals(superType)) {
            return true;
        }
        return this.getSuperclassPredicate(superType).test(ValueType.object(subType), defaultValue);
    }

    public MethodReader resolve(MethodReference method) {
        return this.resolve(method.getClassName(), method.getDescriptor());
    }

    public MethodReader resolve(String className, MethodDescriptor method) {
        Map cache = this.resolveMethodCache.computeIfAbsent(className, k -> new HashMap());
        Optional<Object> opt = (Optional<Object>)cache.get(method);
        if (opt == null) {
            MethodReader reader = null;
            ClassReader cls = this.classSource.get(className);
            if (cls != null) {
                reader = cls.getMethod(method);
                if (reader == null && cls.getParent() != null) {
                    reader = this.resolve(cls.getParent(), method);
                }
                if (reader == null) {
                    String itf;
                    Iterator<String> iterator = cls.getInterfaces().iterator();
                    while (iterator.hasNext() && (reader = this.resolve(itf = iterator.next(), method)) == null) {
                    }
                }
            }
            opt = Optional.ofNullable(reader);
            cache.put(method, opt);
        }
        return opt.orElse(null);
    }

    public FieldReader resolve(FieldReference field) {
        return this.resolve(field.getClassName(), field.getFieldName());
    }

    public FieldReader resolve(String className, String fieldName) {
        Map cache = this.resolveFieldCache.computeIfAbsent(className, k -> new HashMap());
        Optional<Object> opt = (Optional<Object>)cache.get(fieldName);
        if (opt == null) {
            FieldReader reader = null;
            ClassReader cls = this.classSource.get(className);
            if (cls != null) {
                if (cls.getParent() != null) {
                    reader = this.resolve(cls.getParent(), fieldName);
                }
                if (reader == null) {
                    String itf;
                    Iterator<String> iterator = cls.getInterfaces().iterator();
                    while (iterator.hasNext() && (reader = this.resolve(itf = iterator.next(), fieldName)) == null) {
                    }
                }
            }
            opt = Optional.ofNullable(reader);
            cache.put(fieldName, opt);
        }
        return opt.orElse(null);
    }

    public OptionalPredicate<ValueType> getSuperclassPredicate(String superclass) {
        if (superclass.equals("java.lang.Object")) {
            return this.objectPredicate;
        }
        return this.superclassPredicateCache.computeIfAbsent(superclass, x$0 -> new SuperclassPredicate((String)x$0));
    }

    public OptionalPredicate<ValueType> getSupertypePredicate(ValueType supertype) {
        if (supertype instanceof ValueType.Object) {
            return this.getSuperclassPredicate(((ValueType.Object)supertype).getClassName());
        }
        if (supertype instanceof ValueType.Array) {
            return new SuperArrayPredicate(this.getSupertypePredicate(((ValueType.Array)supertype).getItemType()));
        }
        return (value, defaultResult) -> value == supertype;
    }

    private static class SuperArrayPredicate
    implements OptionalPredicate<ValueType> {
        private OptionalPredicate<ValueType> itemPredicate;

        SuperArrayPredicate(OptionalPredicate<ValueType> itemPredicate) {
            this.itemPredicate = itemPredicate;
        }

        @Override
        public boolean test(ValueType value, boolean defaultResult) {
            if (value instanceof ValueType.Array) {
                return this.itemPredicate.test(((ValueType.Array)value).getItemType(), defaultResult);
            }
            return false;
        }
    }

    private class SuperclassPredicate
    implements OptionalPredicate<ValueType> {
        private final String superclass;
        private final ObjectByteMap<String> cache = new ObjectByteHashMap<String>(100, 0.5);

        SuperclassPredicate(String superclass) {
            this.superclass = superclass;
        }

        @Override
        public boolean test(ValueType value, boolean defaultResult) {
            if (!(value instanceof ValueType.Object)) {
                return false;
            }
            String className = ((ValueType.Object)value).getClassName();
            switch (this.test(className)) {
                case 1: {
                    return true;
                }
                case 2: {
                    return false;
                }
            }
            return defaultResult;
        }

        byte test(String value) {
            if (value.equals(this.superclass)) {
                return 1;
            }
            byte result = this.cache.get(value);
            if (result == 0) {
                result = this.testCacheMiss(value);
                this.cache.put(value, result);
            }
            return result;
        }

        byte testCacheMiss(String value) {
            if (value.equals(this.superclass)) {
                return 1;
            }
            ClassReader cls = ClassHierarchy.this.classSource.get(value);
            if (cls == null) {
                return 2;
            }
            if (cls.getParent() != null && this.test(cls.getParent()) == 1) {
                return 1;
            }
            for (String itf : cls.getInterfaces()) {
                if (this.test(itf) != 1) continue;
                return 1;
            }
            return 2;
        }
    }
}

