/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.platform.plugin;

import org.teavm.dependency.AbstractDependencyListener;
import org.teavm.dependency.DependencyAgent;
import org.teavm.dependency.DependencyNode;
import org.teavm.dependency.MethodDependency;
import org.teavm.model.ClassReader;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;
import org.teavm.platform.Platform;

public class ClassLookupDependencySupport
extends AbstractDependencyListener {
    private DependencyNode allClasses;

    @Override
    public void started(DependencyAgent agent) {
        this.allClasses = agent.createNode();
    }

    @Override
    public void classReached(DependencyAgent agent, String className) {
        this.allClasses.propagate(agent.getType(ValueType.object(className)));
    }

    @Override
    public void methodReached(DependencyAgent agent, MethodDependency method) {
        MethodReference ref = method.getReference();
        if (ref.getClassName().equals(Platform.class.getName()) && ref.getName().equals("lookupClass")) {
            this.allClasses.addConsumer(type -> {
                if (!(type.getValueType() instanceof ValueType.Object)) {
                    return;
                }
                String className = ((ValueType.Object)type.getValueType()).getClassName();
                ClassReader cls = agent.getClassSource().get(className);
                if (cls == null) {
                    return;
                }
                MethodReader initMethod = cls.getMethod(new MethodDescriptor("<clinit>", Void.TYPE));
                if (initMethod != null) {
                    MethodDependency initDep = agent.linkMethod(initMethod.getReference());
                    method.addLocationListener(initDep::addLocation);
                    initDep.use();
                }
            });
        }
    }
}

