/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.platform.plugin.wasmgc;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.teavm.ast.InvocationExpr;
import org.teavm.backend.wasm.generate.gc.strings.WasmGCStringConstant;
import org.teavm.backend.wasm.intrinsics.gc.WasmGCIntrinsic;
import org.teavm.backend.wasm.intrinsics.gc.WasmGCIntrinsicContext;
import org.teavm.backend.wasm.model.WasmArray;
import org.teavm.backend.wasm.model.WasmGlobal;
import org.teavm.backend.wasm.model.WasmStructure;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.model.expression.WasmArrayNewFixed;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmFloat32Constant;
import org.teavm.backend.wasm.model.expression.WasmFloat64Constant;
import org.teavm.backend.wasm.model.expression.WasmGetGlobal;
import org.teavm.backend.wasm.model.expression.WasmInt32Constant;
import org.teavm.backend.wasm.model.expression.WasmInt64Constant;
import org.teavm.backend.wasm.model.expression.WasmNullConstant;
import org.teavm.backend.wasm.model.expression.WasmStructNew;
import org.teavm.common.HashUtils;
import org.teavm.common.ServiceRepository;
import org.teavm.hppc.ObjectIntHashMap;
import org.teavm.hppc.ObjectIntMap;
import org.teavm.model.AnnotationReader;
import org.teavm.model.ClassHierarchy;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;
import org.teavm.platform.metadata.MetadataGenerator;
import org.teavm.platform.metadata.Resource;
import org.teavm.platform.metadata.ResourceArray;
import org.teavm.platform.metadata.ResourceMap;
import org.teavm.platform.metadata.builders.ObjectResourceBuilder;
import org.teavm.platform.metadata.builders.ResourceArrayBuilder;
import org.teavm.platform.metadata.builders.ResourceBuilder;
import org.teavm.platform.metadata.builders.ResourceMapBuilder;
import org.teavm.platform.plugin.DefaultMetadataGeneratorContext;
import org.teavm.platform.plugin.ResourceTypeDescriptor;
import org.teavm.platform.plugin.wasmgc.FieldMarker;
import org.teavm.platform.plugin.wasmgc.ResourceMapEntry;

class MetadataIntrinsic
implements WasmGCIntrinsic {
    private Properties properties;
    private ServiceRepository services;
    private MetadataGenerator generator;
    private WasmGlobal global;
    private Map<Class<?>, ResourceTypeDescriptor> descriptors = new HashMap();
    private Map<Class<?>, ObjectIntMap<String>> fieldIndexMap = new HashMap();

    MetadataIntrinsic(Properties properties, ServiceRepository services, MetadataGenerator generator) {
        this.properties = properties;
        this.services = services;
        this.generator = generator;
    }

    @Override
    public WasmExpression apply(InvocationExpr invocation, WasmGCIntrinsicContext context) {
        WasmGlobal global = this.getGlobal(invocation.getMethod(), context);
        return new WasmGetGlobal(global);
    }

    private WasmGlobal getGlobal(MethodReference method, WasmGCIntrinsicContext context) {
        if (this.global == null) {
            DefaultMetadataGeneratorContext genContext = new DefaultMetadataGeneratorContext(context.hierarchy().getClassSource(), context.resources(), context.classLoader(), this.properties, this.services);
            ResourceBuilder metadata = this.generator.generateMetadata(genContext, method);
            WasmType type = context.typeMapper().mapType(method.getReturnType());
            String name = context.names().topLevel(context.names().suggestForMethod(method));
            WasmExpression initialValue = this.generateMetadata(context, metadata, type);
            this.global = new WasmGlobal(name, type, initialValue);
            context.module().globals.add(this.global);
        }
        return this.global;
    }

    private WasmExpression generateMetadata(WasmGCIntrinsicContext context, Object value, WasmType expectedType) {
        if (value == null) {
            return new WasmNullConstant((WasmType.Reference)expectedType);
        }
        if (value instanceof String) {
            return new WasmGetGlobal(context.strings().getStringConstant((String)((String)value)).global);
        }
        if (value instanceof Boolean) {
            return new WasmInt32Constant((Boolean)value != false ? 1 : 0);
        }
        if (value instanceof Integer) {
            return new WasmInt32Constant((Integer)value);
        }
        if (value instanceof Long) {
            return new WasmInt64Constant((Long)value);
        }
        if (value instanceof Byte) {
            return new WasmInt32Constant(((Byte)value).byteValue());
        }
        if (value instanceof Short) {
            return new WasmInt32Constant(((Short)value).shortValue());
        }
        if (value instanceof Character) {
            return new WasmInt32Constant(((Character)value).charValue());
        }
        if (value instanceof Float) {
            return new WasmFloat32Constant(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return new WasmFloat64Constant((Double)value);
        }
        if (value instanceof ResourceArrayBuilder) {
            ResourceArrayBuilder array = (ResourceArrayBuilder)value;
            WasmType.CompositeReference type = (WasmType.CompositeReference)context.typeMapper().mapType(ValueType.object(ResourceArray.class.getName()));
            WasmArray arrayType = (WasmArray)type.composite;
            WasmArrayNewFixed result = new WasmArrayNewFixed(arrayType);
            for (int i = 0; i < array.values.size(); ++i) {
                result.getElements().add(this.generateMetadata(context, array.values.get(i), arrayType.getElementType().asUnpackedType()));
            }
            return result;
        }
        if (value instanceof ResourceMapBuilder) {
            return this.generateMapResource(context, (ResourceMapBuilder)value);
        }
        if (value instanceof ObjectResourceBuilder) {
            ObjectResourceBuilder objBuilder = (ObjectResourceBuilder)value;
            ResourceTypeDescriptor descriptor = this.getDescriptor(context.hierarchy(), objBuilder);
            return this.generateObjectResource(context, objBuilder, descriptor);
        }
        throw new IllegalArgumentException("Don't know how to write resource: " + String.valueOf(value));
    }

    private ResourceTypeDescriptor getDescriptor(ClassHierarchy hierarchy, ObjectResourceBuilder builder) {
        return this.descriptors.computeIfAbsent(builder.getOutputClass(), key -> new ResourceTypeDescriptor(hierarchy, hierarchy.getClassSource().get(key.getName())));
    }

    private WasmExpression generateMapResource(WasmGCIntrinsicContext context, ResourceMapBuilder<?> map) {
        String[] hashTable = HashUtils.createHashTable(map.values.keySet().toArray(new String[0]));
        WasmType.CompositeReference type = (WasmType.CompositeReference)context.typeMapper().mapType(ValueType.object(ResourceMap.class.getName()));
        WasmArray arrayType = (WasmArray)type.composite;
        WasmType.CompositeReference entryType = (WasmType.CompositeReference)context.typeMapper().mapType(ValueType.object(ResourceMapEntry.class.getName()));
        WasmStructure entryStruct = (WasmStructure)entryType.composite;
        WasmArrayNewFixed expr = new WasmArrayNewFixed(arrayType);
        for (String key : hashTable) {
            if (key == null) {
                expr.getElements().add(new WasmNullConstant(entryType));
                continue;
            }
            ResourceBuilder value = (ResourceBuilder)map.values.get(key);
            WasmExpression wasmValue = this.generateMetadata(context, value, WasmType.Reference.EQ);
            WasmStructNew entryExpr = new WasmStructNew(entryStruct);
            WasmGCStringConstant keyConstant = context.strings().getStringConstant(key);
            entryExpr.getInitializers().add(new WasmGetGlobal(keyConstant.global));
            entryExpr.getInitializers().add(wasmValue);
            expr.getElements().add(entryExpr);
        }
        return expr;
    }

    private WasmExpression generateObjectResource(WasmGCIntrinsicContext context, ObjectResourceBuilder value, ResourceTypeDescriptor descriptor) {
        ClassReader javaItf = descriptor.getRootInterface();
        ClassReader cls = context.hierarchy().getClassSource().get(javaItf.getName());
        WasmType.CompositeReference wasmType = (WasmType.CompositeReference)context.typeMapper().mapType(ValueType.object(cls.getName()));
        WasmStructure wasmStruct = (WasmStructure)wasmType.composite;
        WasmStructNew expr = new WasmStructNew(wasmStruct);
        ObjectIntMap map = this.fieldIndexMap.computeIfAbsent(value.getOutputClass(), key -> {
            ObjectIntHashMap<String> result = new ObjectIntHashMap<String>();
            String[] names = value.fieldNames();
            for (int i = 0; i < names.length; ++i) {
                result.put(names[i], i);
            }
            return result;
        });
        for (FieldDescriptor field : this.collectFields(context.hierarchy().getClassSource(), cls)) {
            int index = map.getOrDefault(field.name, -1);
            Object fieldValue = value.getValue(index);
            expr.getInitializers().add(this.generateMetadata(context, fieldValue, context.typeMapper().mapType(field.type)));
        }
        return expr;
    }

    private List<FieldDescriptor> collectFields(ClassReaderSource classes, ClassReader cls) {
        ArrayList<FieldDescriptor> fields = new ArrayList<FieldDescriptor>();
        while (cls != null) {
            for (MethodReader methodReader : cls.getMethods()) {
                AnnotationReader annot = methodReader.getAnnotations().get(FieldMarker.class.getName());
                if (annot == null) continue;
                fields.add(new FieldDescriptor(annot.getValue("index").getInt(), annot.getValue("value").getString(), methodReader.getResultType()));
            }
            if (!(cls = classes.get(cls.getParent())).getName().equals(Resource.class.getName())) continue;
        }
        fields.sort(Comparator.comparingInt(f -> f.index));
        return fields;
    }

    private static class FieldDescriptor {
        final int index;
        final String name;
        final ValueType type;

        FieldDescriptor(int index, String name, ValueType type) {
            this.index = index;
            this.name = name;
            this.type = type;
        }
    }
}

