/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.tooling.c.incremental;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.teavm.backend.c.CTarget;
import org.teavm.backend.c.generate.CNameProvider;
import org.teavm.cache.InMemoryMethodNodeCache;
import org.teavm.cache.InMemoryProgramCache;
import org.teavm.cache.InMemorySymbolTable;
import org.teavm.cache.MemoryCachedClassReaderSource;
import org.teavm.dependency.FastDependencyAnalyzer;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.PreOptimizingClassHolderSource;
import org.teavm.model.ReferenceCache;
import org.teavm.parsing.RenamingResourceMapper;
import org.teavm.parsing.resource.ResourceClassHolderMapper;
import org.teavm.parsing.resource.ResourceProvider;
import org.teavm.tooling.EmptyTeaVMToolLog;
import org.teavm.tooling.TeaVMProblemRenderer;
import org.teavm.tooling.TeaVMToolLog;
import org.teavm.tooling.builder.SimpleBuildResult;
import org.teavm.tooling.c.incremental.BuilderListener;
import org.teavm.tooling.c.incremental.ProgressHandler;
import org.teavm.tooling.util.FileSystemWatcher;
import org.teavm.vm.IncrementalDirectoryBuildTarget;
import org.teavm.vm.TeaVM;
import org.teavm.vm.TeaVMBuilder;
import org.teavm.vm.TeaVMOptimizationLevel;
import org.teavm.vm.TeaVMPhase;
import org.teavm.vm.TeaVMProgressFeedback;
import org.teavm.vm.TeaVMProgressListener;

public class IncrementalCBuilder {
    private String mainClass;
    private String[] classPath;
    private int minHeapSize = 4;
    private int maxHeapSize = 128;
    private boolean lineNumbersGenerated;
    private String targetPath;
    private String externalTool;
    private String externalToolWorkingDir;
    private String mainFunctionName;
    private IncrementalDirectoryBuildTarget buildTarget;
    private FileSystemWatcher watcher;
    private TeaVMToolLog log = new EmptyTeaVMToolLog();
    private MemoryCachedClassReaderSource classSource;
    private ReferenceCache referenceCache = new ReferenceCache();
    private InMemorySymbolTable symbolTable = new InMemorySymbolTable();
    private InMemorySymbolTable fileSymbolTable = new InMemorySymbolTable();
    private InMemorySymbolTable variableSymbolTable = new InMemorySymbolTable();
    private InMemoryProgramCache programCache;
    private InMemoryMethodNodeCache astCache;
    private List<BuilderListener> listeners = new ArrayList<BuilderListener>();
    private final Set<ProgressHandler> progressHandlers = new LinkedHashSet<ProgressHandler>();
    private final CNameProvider nameProvider = new CNameProvider();
    private int lastReachedClasses;
    private final Object statusLock = new Object();
    private volatile boolean cancelRequested;
    private volatile boolean stopped;
    private boolean compiling;
    private double progress;
    private boolean waiting;
    private Thread buildThread;
    private boolean needsExternalTool;
    private final ProgressListenerImpl progressListener = new ProgressListenerImpl();

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public void setClassPath(String[] classPath) {
        this.classPath = classPath;
    }

    public void setMinHeapSize(int minHeapSize) {
        this.minHeapSize = minHeapSize;
    }

    public void setMaxHeapSize(int maxHeapSize) {
        this.maxHeapSize = maxHeapSize;
    }

    public void setLineNumbersGenerated(boolean lineNumbersGenerated) {
        this.lineNumbersGenerated = lineNumbersGenerated;
    }

    public void setTargetPath(String targetPath) {
        this.targetPath = targetPath;
    }

    public void setLog(TeaVMToolLog log) {
        this.log = log;
    }

    public void setExternalTool(String externalTool) {
        this.externalTool = externalTool;
    }

    public void setExternalToolWorkingDir(String externalToolWorkingDir) {
        this.externalToolWorkingDir = externalToolWorkingDir;
    }

    public void setMainFunctionName(String mainFunctionName) {
        this.mainFunctionName = mainFunctionName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProgressHandler(ProgressHandler handler) {
        double progress;
        Set<ProgressHandler> set = this.progressHandlers;
        synchronized (set) {
            this.progressHandlers.add(handler);
        }
        Object object = this.statusLock;
        synchronized (object) {
            if (!this.compiling) {
                return;
            }
            progress = this.progress;
        }
        handler.progress(progress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProgressHandler(ProgressHandler handler) {
        Set<ProgressHandler> set = this.progressHandlers;
        synchronized (set) {
            this.progressHandlers.remove(handler);
        }
    }

    public void addListener(BuilderListener listener) {
        this.listeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateCache() {
        Object object = this.statusLock;
        synchronized (object) {
            if (this.compiling) {
                return;
            }
            this.astCache.invalidate();
            this.programCache.invalidate();
            this.classSource.invalidate();
            this.symbolTable.invalidate();
            this.fileSymbolTable.invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildProject() {
        Object object = this.statusLock;
        synchronized (object) {
            if (this.waiting) {
                this.buildThread.interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelBuild() {
        Object object = this.statusLock;
        synchronized (object) {
            if (this.compiling) {
                this.cancelRequested = true;
            }
        }
    }

    public void start() {
        this.buildThread = new Thread(this::run);
        this.buildThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.stopped = true;
        Object object = this.statusLock;
        synchronized (object) {
            if (this.waiting) {
                this.buildThread.interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() {
        try {
            this.initBuilder();
            while (!this.stopped) {
                this.buildOnce();
                if (this.stopped) break;
                try {
                    Object object = this.statusLock;
                    synchronized (object) {
                        this.waiting = true;
                    }
                    this.watcher.waitForChange(750);
                    object = this.statusLock;
                    synchronized (object) {
                        this.waiting = false;
                    }
                    this.log.info("Changes detected. Recompiling.");
                }
                catch (InterruptedException e) {
                    if (this.stopped) break;
                    this.log.info("Build triggered by user");
                }
                List<String> staleClasses = this.getChangedClasses(this.watcher.grabChangedFiles());
                if (staleClasses.size() > 15) {
                    List<String> displayedStaleClasses = staleClasses.subList(0, 10);
                    this.log.debug("Following classes changed (" + staleClasses.size() + "): " + String.join((CharSequence)", ", displayedStaleClasses) + " and more...");
                } else {
                    this.log.debug("Following classes changed (" + staleClasses.size() + "): " + String.join((CharSequence)", ", staleClasses));
                }
                this.classSource.evict(staleClasses);
            }
            this.log.info("Build process stopped");
        }
        catch (Throwable e) {
            this.log.error("Compile server crashed", e);
        }
        finally {
            this.shutdownBuilder();
        }
    }

    private List<String> getChangedClasses(Collection<File> changedFiles) {
        ArrayList<String> result = new ArrayList<String>();
        String[] prefixes = (String[])Arrays.stream(this.classPath).map(s -> s.replace('\\', '/')).toArray(String[]::new);
        for (File file : changedFiles) {
            String path = file.getPath().replace('\\', '/');
            if (!path.endsWith(".class")) continue;
            String prefix = Arrays.stream(prefixes).filter(path::startsWith).findFirst().orElse("");
            int start = prefix.length();
            if (start < path.length() && path.charAt(start) == '/') {
                ++start;
            }
            path = path.substring(start, path.length() - ".class".length()).replace('/', '.');
            result.add(path);
        }
        return result;
    }

    private void initBuilder() throws IOException {
        this.buildTarget = new IncrementalDirectoryBuildTarget(new File(this.targetPath));
        this.watcher = new FileSystemWatcher(this.classPath);
        this.classSource = this.createCachedSource();
        this.astCache = new InMemoryMethodNodeCache(this.referenceCache, this.symbolTable, this.fileSymbolTable, this.variableSymbolTable);
        this.programCache = new InMemoryProgramCache(this.referenceCache, this.symbolTable, this.fileSymbolTable, this.variableSymbolTable);
    }

    private void shutdownBuilder() {
        try {
            this.watcher.dispose();
        }
        catch (IOException e) {
            this.log.debug("Exception caught", e);
        }
        this.classSource = null;
        this.watcher = null;
        this.astCache = null;
        this.programCache = null;
        this.log.info("Build thread complete");
    }

    private MemoryCachedClassReaderSource createCachedSource() {
        return new MemoryCachedClassReaderSource(this.referenceCache, this.symbolTable, this.fileSymbolTable, this.variableSymbolTable);
    }

    private void buildOnce() {
        this.fireBuildStarted();
        this.reportProgress(0.0);
        ClassLoader classLoader = this.initClassLoader();
        ResourceProvider reader = ResourceProvider.ofClassPath(Stream.of(this.classPath).map(File::new).collect(Collectors.toList()));
        ResourceClassHolderMapper rawMapper = new ResourceClassHolderMapper(reader, this.referenceCache);
        RenamingResourceMapper classPathMapper = new RenamingResourceMapper(reader, this.referenceCache, (Function<String, ClassHolder>)rawMapper);
        this.classSource.setProvider(name -> PreOptimizingClassHolderSource.optimize(classPathMapper, name));
        long startTime = System.currentTimeMillis();
        CTarget cTarget = new CTarget(this.nameProvider);
        cTarget.setAstCache(this.astCache);
        TeaVM vm = new TeaVMBuilder(cTarget).setReferenceCache(this.referenceCache).setClassLoader(classLoader).setClassSource(this.classSource).setResourceProvider(reader).setDependencyAnalyzerFactory(FastDependencyAnalyzer::new).setClassSourcePacker(this::packClasses).setStrict(true).setObfuscated(false).build();
        cTarget.setIncremental(true);
        cTarget.setMinHeapSize(this.minHeapSize * 1024 * 1024);
        cTarget.setMaxHeapSize(this.maxHeapSize * 1024 * 1024);
        cTarget.setLineNumbersGenerated(this.lineNumbersGenerated);
        cTarget.setHeapDump(true);
        vm.setOptimizationLevel(TeaVMOptimizationLevel.SIMPLE);
        vm.setCacheStatus(this.classSource);
        vm.addVirtualMethods(m -> true);
        vm.setProgressListener(this.progressListener);
        vm.setProgramCache(this.programCache);
        vm.installPlugins();
        vm.setLastKnownClasses(this.lastReachedClasses);
        vm.setEntryPoint(this.mainClass);
        if (this.mainFunctionName != null) {
            vm.setEntryPointName(this.mainFunctionName);
        }
        this.log.info("Starting build");
        this.progressListener.last = 0;
        this.progressListener.lastTime = System.currentTimeMillis();
        vm.build(this.buildTarget, "");
        this.postBuild(vm, startTime);
        reader.close();
        this.runExternalTool();
    }

    private void postBuild(TeaVM vm, long startTime) {
        this.needsExternalTool = false;
        boolean hasErrors = false;
        if (!vm.wasCancelled()) {
            this.log.info("Recompiled stale methods: " + this.programCache.getPendingItemsCount());
            this.fireBuildComplete(vm);
            if (vm.getProblemProvider().getSevereProblems().isEmpty()) {
                this.log.info("Build complete successfully");
                this.lastReachedClasses = vm.getDependencyInfo().getReachableClasses().size();
                this.classSource.commit();
                this.programCache.commit();
                this.astCache.commit();
                this.reportCompilationComplete(true);
                this.needsExternalTool = true;
            } else {
                hasErrors = true;
                this.log.info("Build complete with errors");
                this.reportCompilationComplete(false);
            }
            this.printStats(vm, startTime);
            TeaVMProblemRenderer.describeProblems(vm, this.log);
        } else {
            this.log.info("Build cancelled");
            this.fireBuildCancelled();
        }
        this.astCache.discard();
        this.programCache.discard();
        if (!vm.wasCancelled() && !hasErrors) {
            this.buildTarget.reset();
        }
        this.cancelRequested = false;
    }

    private void printStats(TeaVM vm, long startTime) {
        if (vm.getWrittenClasses() != null) {
            int classCount = vm.getWrittenClasses().getClassNames().size();
            int methodCount = 0;
            for (String className : vm.getWrittenClasses().getClassNames()) {
                ClassReader cls = vm.getWrittenClasses().get(className);
                methodCount += cls.getMethods().size();
            }
            this.log.info("Classes compiled: " + classCount);
            this.log.info("Methods compiled: " + methodCount);
        }
        this.log.info("Compilation took " + (System.currentTimeMillis() - startTime) + " ms");
    }

    private void runExternalTool() {
        if (this.externalTool == null || !this.needsExternalTool) {
            return;
        }
        try {
            this.log.info("Running external tool");
            long start = System.currentTimeMillis();
            ProcessBuilder pb = new ProcessBuilder(this.externalTool);
            if (this.externalToolWorkingDir != null) {
                pb.directory(new File(this.externalToolWorkingDir));
            }
            Process process = pb.start();
            BufferedReader stdoutReader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));
            BufferedReader stderrReader = new BufferedReader(new InputStreamReader(process.getErrorStream(), StandardCharsets.UTF_8));
            IncrementalCBuilder.daemon("external tool stdout watcher", new ExternalOutputWatcher(stdoutReader, s -> this.log.info("[external tool] " + s)));
            IncrementalCBuilder.daemon("external tool stderr watcher", new ExternalOutputWatcher(stderrReader, s -> this.log.error("[external tool] " + s)));
            int code = process.waitFor();
            if (code != 0) {
                this.log.error("External tool returned non-zero code: " + code);
            } else {
                this.log.info("External tool took " + (System.currentTimeMillis() - start) + " ms");
            }
        }
        catch (IOException e) {
            this.log.error("Could not start external tool", e);
        }
        catch (InterruptedException e) {
            this.log.info("Interrupted while running external tool");
        }
    }

    private static Thread daemon(String name, Runnable runnable) {
        Thread thread = new Thread(runnable);
        thread.setDaemon(true);
        thread.setName(name);
        thread.start();
        return thread;
    }

    private ClassReaderSource packClasses(ClassReaderSource source, Collection<? extends String> classNames) {
        MemoryCachedClassReaderSource packedSource = this.createCachedSource();
        packedSource.setProvider(source::get);
        for (String string : classNames) {
            packedSource.populate(string);
        }
        packedSource.setProvider(null);
        return packedSource;
    }

    private ClassLoader initClassLoader() {
        URL[] urls = new URL[this.classPath.length];
        try {
            for (int i = 0; i < this.classPath.length; ++i) {
                urls[i] = new File(this.classPath[i]).toURI().toURL();
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        return new URLClassLoader(urls, IncrementalCBuilder.class.getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportProgress(double progress) {
        Object object = this.statusLock;
        synchronized (object) {
            if (this.compiling && this.progress == progress) {
                return;
            }
            this.compiling = true;
            this.progress = progress;
        }
        ProgressHandler[] progressHandlerArray = this.progressHandlers;
        synchronized (this.progressHandlers) {
            ProgressHandler[] handlers = this.progressHandlers.toArray(new ProgressHandler[0]);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            for (ProgressHandler handler : handlers) {
                handler.progress(progress);
            }
            for (BuilderListener listener : this.listeners) {
                listener.compilationProgress(progress);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportCompilationComplete(boolean success) {
        Object object = this.statusLock;
        synchronized (object) {
            if (!this.compiling) {
                return;
            }
            this.compiling = false;
        }
        ProgressHandler[] progressHandlerArray = this.progressHandlers;
        synchronized (this.progressHandlers) {
            ProgressHandler[] handlers = this.progressHandlers.toArray(new ProgressHandler[0]);
            // ** MonitorExit[var3_4] (shouldn't be in output)
            for (ProgressHandler handler : handlers) {
                handler.complete(success);
            }
            return;
        }
    }

    private void fireBuildStarted() {
        for (BuilderListener listener : this.listeners) {
            listener.compilationStarted();
        }
    }

    private void fireBuildCancelled() {
        for (BuilderListener listener : this.listeners) {
            listener.compilationCancelled();
        }
    }

    private void fireBuildComplete(TeaVM vm) {
        SimpleBuildResult result = new SimpleBuildResult(vm);
        for (BuilderListener listener : this.listeners) {
            listener.compilationComplete(result);
        }
    }

    class ProgressListenerImpl
    implements TeaVMProgressListener {
        private int start;
        private int end;
        private int phaseLimit;
        private int last;
        private long lastTime;

        ProgressListenerImpl() {
        }

        @Override
        public TeaVMProgressFeedback phaseStarted(TeaVMPhase phase, int count) {
            switch (phase) {
                case DEPENDENCY_ANALYSIS: {
                    this.start = 0;
                    this.end = 500;
                    break;
                }
                case COMPILING: {
                    this.start = 500;
                    this.end = 1000;
                }
            }
            this.phaseLimit = count;
            return this.progressReached(0);
        }

        @Override
        public TeaVMProgressFeedback progressReached(int progress) {
            int current = this.start + Math.min(progress, this.phaseLimit) * (this.end - this.start) / this.phaseLimit;
            if (current != this.last && (current - this.last > 10 || System.currentTimeMillis() - this.lastTime > 100L)) {
                this.lastTime = System.currentTimeMillis();
                this.last = current;
                IncrementalCBuilder.this.reportProgress((double)current / 10.0);
            }
            return this.getResult();
        }

        private TeaVMProgressFeedback getResult() {
            if (IncrementalCBuilder.this.cancelRequested) {
                IncrementalCBuilder.this.log.info("Trying to cancel compilation due to user request");
                return TeaVMProgressFeedback.CANCEL;
            }
            if (IncrementalCBuilder.this.stopped) {
                IncrementalCBuilder.this.log.info("Trying to cancel compilation due to server stopping");
                return TeaVMProgressFeedback.CANCEL;
            }
            try {
                if (IncrementalCBuilder.this.watcher.hasChanges()) {
                    IncrementalCBuilder.this.log.info("Changes detected, cancelling build");
                    return TeaVMProgressFeedback.CANCEL;
                }
            }
            catch (IOException e) {
                IncrementalCBuilder.this.log.info("IO error occurred", e);
                return TeaVMProgressFeedback.CANCEL;
            }
            return TeaVMProgressFeedback.CONTINUE;
        }
    }

    class ExternalOutputWatcher
    implements Runnable {
        private BufferedReader reader;
        private Consumer<String> consumer;

        ExternalOutputWatcher(BufferedReader reader, Consumer<String> consumer) {
            this.reader = reader;
            this.consumer = consumer;
        }

        @Override
        public void run() {
            try {
                String line;
                while ((line = this.reader.readLine()) != null) {
                    this.consumer.accept(line);
                }
            }
            catch (IOException e) {
                IncrementalCBuilder.this.log.error("Error reading build daemon output", e);
            }
        }
    }
}

