function [IncDec, fitresult, gof, SigFitTrace] = createFit_sigmoid(XVals, fluorescence_trace)
%CREATEFIT(XVals,FLUORESCENCE_TRACE)
%  Create a fit to a sigmoidal curve. Equation is modified from Boltzmann
%  charge-voltage equation
%
%  Data for fit:
%      X Input : XVals (1:length(fluorescence_trace))
%      Y Output: fluorescence_trace (for a single region in a single
%      tseries)
%  Output:
%      IncDec: 1,0 or -1. Categorizing if the trace increased(1), decreased(-1)
%      or didn't change(0). Max change in values from fitted curve must be
%      greater than 3std of baseline to be considered as increasing or
%      decreasing.
%
%      fitresult : a fit object representing the fit.
%            Coefficients: a: max fluorescence - min fluorescence
%                          b: inflection point of curve (frame at which
%                          fluorescence is (max fluorescence - min
%                          fluorescence)/2
%                          c: baseline fluorescence
%                          d: slope factor
%      gof : structure with goodness-of fit info.
%      SigFitTrace: The Y-vals of the fitted curve
%
%  See also FIT, CFIT, SFIT.

%  Auto-generated by MATLAB on 21-Feb-2020 15:03:52


%% Fit: 'untitled fit 1'.
[xData, yData] = prepareCurveData( XVals, fluorescence_trace );

% Set up fittype and options.
ft = fittype( '(a/(1+exp((b-x)/d)))+c', 'independent', 'x', 'dependent', 'y' );
opts = fitoptions( 'Method', 'NonlinearLeastSquares' );
opts.Algorithm = 'Levenberg-Marquardt';
opts.Display = 'Off';
% opts.StartPoint = [0.0154034376515551 0.0430238016578078 0.168990029462704];
% opts.StartPoint = [0.0154034376515551 500 0.168990029462704]; %Estimates
% for pinkFlamindo traces
opts.StartPoint = [100 250 40 100]; %Estmates for Alexa594 traces

% Fit model to data.
[fitresult, gof] = fit( xData, yData, ft, opts );

% Plot fit with data.
figure(1);
h = plot( fitresult, xData, yData );
legend( h, 'filtered fluorescence trace', 'Fit Sigmoid Curve', 'Location', 'NorthWest' );
% Label axes
dim = [.7 .2 .1 .1];
annotation('textbox',dim,'String',sprintf('r^2=%d',gof.adjrsquare), 'FitBoxToText','on');
xlabel('frames')
ylabel('fluorescence')

% %Decide if traces increase, decrease or don't change (Is the change in the
% %fitted data greater than the noise (3std)?)
SigFitTrace = feval(fitresult, xData); %find the y-values for the fitted curve
% % baseline_mean = mean(yData(50:200));
% baseline_std = std(yData(50:200));
% if (max(SigFitTrace(1:800))-min(SigFitTrace(1:800))) < (baseline_std*3)
%     IncDec = 0; %if the max change in the fitted curve is less than 3std of the baseline -> Categorize as no change
% elseif SigFitTrace(1) > SigFitTrace(800)
%     IncDec = -1; %if the start of the fitted curve is greater than the end (cutoff at frame 800 to account for filtering artifacts) -> categorize as decrease
% elseif SigFitTrace(1) < SigFitTrace(800)
%     IncDec = 1; %if the start of the fitted curve is less than the end -> categorize as increase
% end
IncDec = nan;



