function [IncDec, fitresult, gof, SigFitTrace] = createFit_sigmoidDefinedStartEnd(XVals, fluorescence_trace, start_frame, end_frame, baseline_period)
%  Create a fit to a sigmoidal curve for the given trace. The portion 
%  of the trace used for the fit is defined by start_frame and end_frame. 
%  Equation for sigmoid is modified from Boltzmann charge-voltage equation
%  Additionally, this function classifies a trace as increasing, decreasing 
%  or not changing from baseline. The baseline period is provided as an 
%  input. A change between the start and end frame > 3std above or below 
%  the baseline mean will be classified as changing
%
%  Data for fit:
%      X Input : XVals (1:length(fluorescence_trace))
%      Y Input: fluorescence_trace (for a single region in a single
%      tseries)
%      start_frame: frame to record for starting value to evalutate
%      increase, decrease or no change
%      end_frame: frame to record end value to evalutate
%      increase, decrease or no change
%      baseline_period: [a,b] the range of baseline frames to use for
%      evaluating a change from baseline
%  Output:
%      IncDec: 1,0 or -1. Categorizing if the trace increased(1), decreased(-1)
%      or didn't change(0). Max change in values from fitted curve must be
%      greater than 3std of baseline to be considered as increasing or
%      decreasing.
%
%      fitresult : a fit object representing the fit.
%            Coefficients: a: max fluorescence - min fluorescence
%                          b: inflection point of curve (frame at which
%                          fluorescence is (max fluorescence - min
%                          fluorescence)/2
%                          c: baseline fluorescence
%      gof : structure with goodness-of fit info.
%      SigFitTrace: The Y-vals of the fitted curve
%
%  See also FIT, CFIT, SFIT.

%  Auto-generated by MATLAB on 21-Feb-2020 15:03:52


%% Fit: 'untitled fit 1'.
[xData, yData] = prepareCurveData(XVals(start_frame:end_frame), fluorescence_trace(start_frame:end_frame));
% [xData, yData] = prepareCurveData(XVals, fluorescence_trace);

% Set up fittype and options.
ft = fittype( '(a/(1+exp((b-x)/c)))+d', 'independent', 'x', 'dependent', 'y' );
opts = fitoptions( 'Method', 'NonlinearLeastSquares' );
opts.Algorithm = 'Levenberg-Marquardt';
opts.Display = 'Off';
% opts.StartPoint = [0.0154034376515551 0.0430238016578078 0.168990029462704];
% opts.StartPoint = [0.0154034376515551 500 0.168990029462704];
% opts.StartPoint = [0.15 100 0.168990029462704 0.01];
% opts.StartPoint = [200 200 0.168990029462704 0.01];
opts.StartPoint = [200 350 0.168990029462704 0.01];

% Fit model to data.
[fitresult, gof] = fit( xData, yData, ft, opts );

% Plot fit with data.
figure(1);
h = plot( fitresult, xData, yData );
legend( h, '% Act Px Active', 'Fit Sigmoid Curve', 'Location', 'NorthWest' );
% Label axes
dim = [.7 .2 .1 .1];
annotation('textbox',dim,'String',sprintf('r^2=%d',gof.adjrsquare), 'FitBoxToText','on');
xlabel('frames')
ylabel('act px per frame')

% % Use this section if fitting curve to designated portion of the trace
% %Decide if traces increase, decrease or don't change (Is the change in the
% %fitted data greater than the noise (3std)?)
% SigFitTrace = feval(fitresult, xData); %find the y-values for the fitted curve
% % baseline_mean = mean(yData(50:200));
% baseline_std = std(fluorescence_trace(baseline_period(1):baseline_period(2)));
% if (max(SigFitTrace)-min(SigFitTrace)) < (baseline_std*3)
%     IncDec = 0; %if the max change in the fitted curve is less than 3std of the baseline -> Categorize as no change
% elseif SigFitTrace(1) > SigFitTrace(end)
%     IncDec = -1; %if the start of the fitted curve is greater than the end (cutoff at frame 800 to account for filtering artifacts) -> categorize as decrease
% elseif SigFitTrace(1) < SigFitTrace(end)
%     IncDec = 1; %if the start of the fitted curve is less than the end -> categorize as increase
% else
%     IncDec = NaN;
% end

% Uncomment this section if fitting curve to entire trace
%Decide if traces increase, decrease or don't change (Is the change in the
%fitted data greater than the noise (3std)?)
SigFitTrace = feval(fitresult, xData); %find the y-values for the fitted curve
% baseline_mean = mean(yData(50:200));
baseline_std = std(yData(baseline_period(1):baseline_period(2)));
if (max(SigFitTrace(start_frame:end_frame))-min(SigFitTrace(start_frame:end_frame))) < (baseline_std*3)
    IncDec = 0; %if the max change in the fitted curve is less than 3std of the baseline -> Categorize as no change
elseif SigFitTrace(start_frame) > SigFitTrace(end_frame)
    IncDec = -1; %if the start of the fitted curve is greater than the end (cutoff at frame 800 to account for filtering artifacts) -> categorize as decrease
elseif SigFitTrace(start_frame) < SigFitTrace(end_frame)
    IncDec = 1; %if the start of the fitted curve is less than the end -> categorize as increase
end

% %Decide if traces increase, decrease or don't change (Is the change in the
% %fitted data greater than the noise (3std)?)
% SigFitTrace = feval(fitresult, xData); %find the y-values for the fitted curve
% % baseline_mean = mean(yData(50:200));
% baseline_std = std(yData(1:50));
% if (max(SigFitTrace(1:end))-min(SigFitTrace(1:end))) < (baseline_std*3)
%     IncDec = 0; %if the max change in the fitted curve is less than 3std of the baseline -> Categorize as no change
% elseif SigFitTrace(1) > SigFitTrace(end)
%     IncDec = -1; %if the start of the fitted curve is greater than the end (cutoff at frame 800 to account for filtering artifacts) -> categorize as decrease
% elseif SigFitTrace(1) < SigFitTrace(end)
%     IncDec = 1; %if the start of the fitted curve is less than the end -> categorize as increase
% end




