package vip.mate.uaa.social;

import lombok.SneakyThrows;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;

import java.util.Collection;

/**
 * 社交验证token生成
 *
 * @author pangu
 */
public class SocialAuthenticationToken extends AbstractAuthenticationToken {
	private static final long serialVersionUID = -3629824093049247125L;

	// ~ Instance fields
	// ================================================================================================

	private final Object principal;
	private Object credentials;

	// ~ Constructors
	// ===================================================================================================

	/**
	 * justauth 使用
	 */
	public SocialAuthenticationToken(Object authUser) {
		super(null);
		this.principal = authUser;
		setAuthenticated(false);
	}

	public SocialAuthenticationToken(Object principal, Collection<? extends GrantedAuthority> authorities) {
		super(authorities);
		this.principal = principal;
		super.setAuthenticated(true);
	}

	// ~ Methods
	// ========================================================================================================


	@Override
	public Object getCredentials() {
		return this.principal;
	}

	@Override
	public Object getPrincipal() {
		return this.principal;
	}

	@Override
	@SneakyThrows
	public void setAuthenticated(boolean isAuthenticated) {
		if (isAuthenticated) {
			throw new IllegalArgumentException(
					"Cannot set this token to trusted - use constructor which takes a GrantedAuthority list instead");
		}

		super.setAuthenticated(false);
	}

	@Override
	public void eraseCredentials() {
		super.eraseCredentials();
	}
}
