// Originally by Unknown Author, Public Domain
// https://github.com/Zensey/sqlite3_unicode

// Modified by Anton Zhiyanov, MIT License
// https://github.com/nalgeon/sqlean

/*
 * Implements case-insensitive string comparison for Unicode strings.
 * Provides the following Unicode features:
 *
 *   - upper(), lower() and casefold() functions to normalize case.
 *   - like() function and LIKE operator with case-independent matching.
 *   - unaccent() function to normalize strings by removing accents.
 *
 * Tries to override the default NOCASE case-insensitive collation sequence
 * to support UTF-8 characters (available in SQLite CLI and C API only).
 *
 * Compile the project with the SQLITE_ENABLE_UNICODE preprocessor definition
 * in order to enable the code below.
 */

#pragma warning(disable : 4305 13 90)

/*
** Un|Comment to provide additional unicode support to SQLite3 or adjust size for unused features
*/
#define SQLITE3_UNICODE_FOLD   // ~ 10KB increase
#define SQLITE3_UNICODE_LOWER  // ~ 10KB increase
#define SQLITE3_UNICODE_UPPER  // ~ 10KB increase
// #define SQLITE3_UNICODE_TITLE  // ~ 10KB increase
#define SQLITE3_UNICODE_UNACC  // ~ 30KB increase \
                               // _______________ \
                               // ~ 70KB increase

/*
** SQLITE3_UNICODE_COLLATE will register and use the custom nocase collation instead of the standard
** one, which supports case folding and unaccenting.
*/
#define SQLITE3_UNICODE_COLLATE  // requires SQLITE3_UNICODE_FOLD to be defined as well.

/*
** SQLITE3_UNICODE_UNACC_AUTOMATIC will automatically try to unaccent any characters that
** are over the 0x80 character in the LIKE comparison operation and in the NOCASE collation
*sequence.
*/
#define SQLITE3_UNICODE_UNACC_AUTOMATIC  // requires SQLITE3_UNICODE_UNACC to be defined as well.

/*************************************************************************************************
** DO NOT MODIFY BELOW THIS LINE
**************************************************************************************************/

/* Generated by builder. Do not modify. Start unicode_version_defines */
/*
File was generated by : sqlite3_unicode.in
File was generated on : Fri Jun  5 01:10:23 2009
Using unicode data db : UnicodeData.txt
Using unicode fold db : CaseFolding.txt
*/
#define SQLITE3_UNICODE_VERSION_MAJOR 5
#define SQLITE3_UNICODE_VERSION_MINOR 1
#define SQLITE3_UNICODE_VERSION_MICRO 0
#define SQLITE3_UNICODE_VERSION_BUILD 12

#define __SQLITE3_UNICODE_VERSION_STRING(a, b, c, d) #a "." #b "." #c "." #d
#define _SQLITE3_UNICODE_VERSION_STRING(a, b, c, d) __SQLITE3_UNICODE_VERSION_STRING(a, b, c, d)
#define SQLITE3_UNICODE_VERSION_STRING                                                            \
    _SQLITE3_UNICODE_VERSION_STRING(SQLITE3_UNICODE_VERSION_MAJOR, SQLITE3_UNICODE_VERSION_MINOR, \
                                    SQLITE3_UNICODE_VERSION_MICRO, SQLITE3_UNICODE_VERSION_BUILD)

/* Generated by builder. Do not modify. End unicode_version_defines */

#if !defined(SQLITE_CORE) || defined(SQLITE_ENABLE_UNICODE)

#ifndef SQLITE_CORE
#include "sqlite3ext.h"
SQLITE_EXTENSION_INIT1
#else
#include "sqlite3.h"
#endif

#include <assert.h>
#include <string.h>

#ifndef _SQLITE3_UNICODE_H
#define _SQLITE3_UNICODE_H

#ifdef __cplusplus
extern "C" {
#endif

/*
** Add the ability to override 'extern'
*/
/*
** <sqlite3_unicode>
** The define of SQLITE_EXPORT is necessary to add the ability of exporting
** functions for both Microsoft Windows and Linux systems without the need
** of a .def file containing the names of the functions being exported.
*/
#ifndef SQLITE_EXPORT
#if ((defined(_WIN32) || defined(WIN32) || defined(__CYGWIN__) || defined(__MINGW32__) || \
      defined(__BORLANDC__)) &&                                                           \
     (!defined(SQLITE_CORE)))
#define SQLITE_EXPORT __declspec(dllexport)
#else
#define SQLITE_EXPORT SQLITE_EXTERN
#endif
#endif

#ifndef SQLITE_PRIVATE
#define SQLITE_PRIVATE static
#endif
#ifndef SQLITE_API
#define SQLITE_API
#endif

/*
** Integers of known sizes.  These typedefs might change for architectures
** where the sizes very.  Preprocessor macros are available so that the
** types can be conveniently redefined at compile-type.  Like this:
**
**         cc '-DUINTPTR_TYPE=long long int' ...
*/
#ifndef UINT32_TYPE
#ifdef HAVE_UINT32_T
#define UINT32_TYPE uint32_t
#else
#define UINT32_TYPE unsigned int
#endif
#endif
#ifndef UINT16_TYPE
#ifdef HAVE_UINT16_T
#define UINT16_TYPE uint16_t
#else
#define UINT16_TYPE unsigned short int
#endif
#endif
#ifndef INT16_TYPE
#ifdef HAVE_INT16_T
#define INT16_TYPE int16_t
#else
#define INT16_TYPE short int
#endif
#endif
#ifndef UINT8_TYPE
#ifdef HAVE_UINT8_T
#define UINT8_TYPE uint8_t
#else
#define UINT8_TYPE unsigned char
#endif
#endif
#ifndef INT8_TYPE
#ifdef HAVE_INT8_T
#define INT8_TYPE int8_t
#else
#define INT8_TYPE signed char
#endif
#endif
#ifndef LONGDOUBLE_TYPE
#define LONGDOUBLE_TYPE long double
#endif
typedef sqlite_int64 i64;  /* 8-byte signed integer */
typedef sqlite_uint64 u64; /* 8-byte unsigned integer */
typedef UINT32_TYPE u32;   /* 4-byte unsigned integer */
typedef UINT16_TYPE u16;   /* 2-byte unsigned integer */
typedef INT16_TYPE i16;    /* 2-byte signed integer */
typedef UINT8_TYPE u8;     /* 1-byte unsigned integer */
typedef INT8_TYPE i8;      /* 1-byte signed integer */

/*
** <sqlite3_unicode>
** These functions are intended for case conversion of single characters
** and return a single character containing the case converted character
** based on the unicode mapping tables.
*/
SQLITE_EXPORT u16 sqlite3_unicode_fold(u16 c);
SQLITE_EXPORT u16 sqlite3_unicode_lower(u16 c);
SQLITE_EXPORT u16 sqlite3_unicode_upper(u16 c);
SQLITE_EXPORT u16 sqlite3_unicode_title(u16 c);

/*
** <sqlite3_unicode>
** This function is intended for decomposing of single characters
** and return a pointer of characters (u16 **)p containing the decomposed
** character or string of characters. (int *)l will contain the length
** of characters contained in (u16 **)p based on the unicode mapping tables.
*/
SQLITE_EXPORT u16 sqlite3_unicode_unacc(u16 c, u16** p, int* l);

/*
** Another built-in collating sequence: NOCASE.
**
** This collating sequence is intended to be used for "case independant
** comparison". SQLite's knowledge of upper and lower case equivalents
** extends only to the 26 characters used in the English language.
**
** At the moment there is only a UTF-8 implementation.
*/
/*
** <sqlite3_unicode>
** The built-in collating sequence: NOCASE is extended to accomodate the
** unicode case folding mapping tables to normalize characters to their
** fold equivalents and test them for equality.
**
** Both UTF-8 and UTF-16 implementations are supported.
**
** (void *)encoding takes the following values
**   * SQLITE_UTF8  for UTF-8  encoded string comparison
**   * SQLITE_UFT16 for UTF-16 encoded string comparison
*/
SQLITE_EXPORT int sqlite3_unicode_collate(void* encoding,
                                          int nKey1,
                                          const void* pKey1,
                                          int nKey2,
                                          const void* pKey2);

/*
** <sqlite3_unicode>
** The following function needs to be called at application startup to load the extension.
*/
SQLITE_EXPORT int sqlite3_unicode_load();

/*
** <sqlite3_unicode>
** The following function needs to be called before application exit to unload the extension.
*/
SQLITE_EXPORT void sqlite3_unicode_free();

#ifdef __cplusplus
}
#endif

#endif /* _SQLITE3_UNICODE_H */
/*************************************************************************************************
 *************************************************************************************************
 *************************************************************************************************/

#ifdef SQLITE3_UNICODE_FOLD
/* Generated by builder. Do not modify. Start unicode_fold_defines */
#define UNICODE_FOLD_BLOCK_SHIFT 5
#define UNICODE_FOLD_BLOCK_MASK ((1 << UNICODE_FOLD_BLOCK_SHIFT) - 1)
#define UNICODE_FOLD_BLOCK_SIZE (1 << UNICODE_FOLD_BLOCK_SHIFT)
#define UNICODE_FOLD_BLOCK_COUNT 69
#define UNICODE_FOLD_INDEXES_SIZE (0x10000 >> UNICODE_FOLD_BLOCK_SHIFT)
/* Generated by builder. Do not modify. End unicode_fold_defines */

/* Generated by builder. Do not modify. Start unicode_fold_tables */

static unsigned short unicode_fold_indexes[UNICODE_FOLD_INDEXES_SIZE] = {
    0,  0,  1,  0,  0,  2,  3,  0,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 0,  0,  0,  0,  0,
    0,  0,  15, 16, 17, 18, 19, 20, 21, 22, 0,  23, 24, 25, 26, 27, 28, 29, 30, 0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  31, 32, 0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 0,  0,  0,  0,  0,  0,  0,  0,
    0,  49, 0,  50, 51, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  52, 53, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  54, 55, 0,  56, 57, 58, 59, 60,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  61, 62, 63, 0,  0,  0,  0,  64, 65, 66, 67, 0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  68, 0,  0,  0,  0,  0,  0};

static unsigned char unicode_fold_positions[UNICODE_FOLD_BLOCK_COUNT][UNICODE_FOLD_BLOCK_SIZE + 1] =
    {
        /* 0 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 1 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 2 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 3 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 4 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 5 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 6 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 7 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 8 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 9 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 10 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 11 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 12 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 13 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 14 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 15 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 16 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 17 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 18 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 19 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 20 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 21 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 22 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 23 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 24 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 25 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 26 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 27 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 28 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 29 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 30 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 31 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 32 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 33 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 34 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 35 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 36 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 37 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 38 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 39 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 40 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 41 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 42 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 43 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 44 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 45 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 46 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 47 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 48 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 49 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 50 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 51 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 52 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 53 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 54 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 55 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 56 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 57 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 58 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 59 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 60 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 61 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 62 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 63 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 64 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 65 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 66 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 67 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 68 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32}};

static unsigned short unicode_fold_data0[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_fold_data1[] = {
    0xFFFF, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 0x0068, 0x0069, 0x006A,
    0x006B, 0x006C, 0x006D, 0x006E, 0x006F, 0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075,
    0x0076, 0x0077, 0x0078, 0x0079, 0x007A, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_fold_data2[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x03BC,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_fold_data3[] = {
    0x00E0, 0x00E1, 0x00E2, 0x00E3, 0x00E4, 0x00E5, 0x00E6, 0x00E7, 0x00E8, 0x00E9, 0x00EA,
    0x00EB, 0x00EC, 0x00ED, 0x00EE, 0x00EF, 0x00F0, 0x00F1, 0x00F2, 0x00F3, 0x00F4, 0x00F5,
    0x00F6, 0xFFFF, 0x00F8, 0x00F9, 0x00FA, 0x00FB, 0x00FC, 0x00FD, 0x00FE, 0xFFFF};
static unsigned short unicode_fold_data4[] = {
    0x0101, 0xFFFF, 0x0103, 0xFFFF, 0x0105, 0xFFFF, 0x0107, 0xFFFF, 0x0109, 0xFFFF, 0x010B,
    0xFFFF, 0x010D, 0xFFFF, 0x010F, 0xFFFF, 0x0111, 0xFFFF, 0x0113, 0xFFFF, 0x0115, 0xFFFF,
    0x0117, 0xFFFF, 0x0119, 0xFFFF, 0x011B, 0xFFFF, 0x011D, 0xFFFF, 0x011F, 0xFFFF};
static unsigned short unicode_fold_data5[] = {
    0x0121, 0xFFFF, 0x0123, 0xFFFF, 0x0125, 0xFFFF, 0x0127, 0xFFFF, 0x0129, 0xFFFF, 0x012B,
    0xFFFF, 0x012D, 0xFFFF, 0x012F, 0xFFFF, 0xFFFF, 0xFFFF, 0x0133, 0xFFFF, 0x0135, 0xFFFF,
    0x0137, 0xFFFF, 0xFFFF, 0x013A, 0xFFFF, 0x013C, 0xFFFF, 0x013E, 0xFFFF, 0x0140};
static unsigned short unicode_fold_data6[] = {
    0xFFFF, 0x0142, 0xFFFF, 0x0144, 0xFFFF, 0x0146, 0xFFFF, 0x0148, 0xFFFF, 0xFFFF, 0x014B,
    0xFFFF, 0x014D, 0xFFFF, 0x014F, 0xFFFF, 0x0151, 0xFFFF, 0x0153, 0xFFFF, 0x0155, 0xFFFF,
    0x0157, 0xFFFF, 0x0159, 0xFFFF, 0x015B, 0xFFFF, 0x015D, 0xFFFF, 0x015F, 0xFFFF};
static unsigned short unicode_fold_data7[] = {
    0x0161, 0xFFFF, 0x0163, 0xFFFF, 0x0165, 0xFFFF, 0x0167, 0xFFFF, 0x0169, 0xFFFF, 0x016B,
    0xFFFF, 0x016D, 0xFFFF, 0x016F, 0xFFFF, 0x0171, 0xFFFF, 0x0173, 0xFFFF, 0x0175, 0xFFFF,
    0x0177, 0xFFFF, 0x00FF, 0x017A, 0xFFFF, 0x017C, 0xFFFF, 0x017E, 0xFFFF, 0x0073};
static unsigned short unicode_fold_data8[] = {
    0xFFFF, 0x0253, 0x0183, 0xFFFF, 0x0185, 0xFFFF, 0x0254, 0x0188, 0xFFFF, 0x0256, 0x0257,
    0x018C, 0xFFFF, 0xFFFF, 0x01DD, 0x0259, 0x025B, 0x0192, 0xFFFF, 0x0260, 0x0263, 0xFFFF,
    0x0269, 0x0268, 0x0199, 0xFFFF, 0xFFFF, 0xFFFF, 0x026F, 0x0272, 0xFFFF, 0x0275};
static unsigned short unicode_fold_data9[] = {
    0x01A1, 0xFFFF, 0x01A3, 0xFFFF, 0x01A5, 0xFFFF, 0x0280, 0x01A8, 0xFFFF, 0x0283, 0xFFFF,
    0xFFFF, 0x01AD, 0xFFFF, 0x0288, 0x01B0, 0xFFFF, 0x028A, 0x028B, 0x01B4, 0xFFFF, 0x01B6,
    0xFFFF, 0x0292, 0x01B9, 0xFFFF, 0xFFFF, 0xFFFF, 0x01BD, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_fold_data10[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x01C6, 0x01C6, 0xFFFF, 0x01C9, 0x01C9, 0xFFFF, 0x01CC,
    0x01CC, 0xFFFF, 0x01CE, 0xFFFF, 0x01D0, 0xFFFF, 0x01D2, 0xFFFF, 0x01D4, 0xFFFF, 0x01D6,
    0xFFFF, 0x01D8, 0xFFFF, 0x01DA, 0xFFFF, 0x01DC, 0xFFFF, 0xFFFF, 0x01DF, 0xFFFF};
static unsigned short unicode_fold_data11[] = {
    0x01E1, 0xFFFF, 0x01E3, 0xFFFF, 0x01E5, 0xFFFF, 0x01E7, 0xFFFF, 0x01E9, 0xFFFF, 0x01EB,
    0xFFFF, 0x01ED, 0xFFFF, 0x01EF, 0xFFFF, 0xFFFF, 0x01F3, 0x01F3, 0xFFFF, 0x01F5, 0xFFFF,
    0x0195, 0x01BF, 0x01F9, 0xFFFF, 0x01FB, 0xFFFF, 0x01FD, 0xFFFF, 0x01FF, 0xFFFF};
static unsigned short unicode_fold_data12[] = {
    0x0201, 0xFFFF, 0x0203, 0xFFFF, 0x0205, 0xFFFF, 0x0207, 0xFFFF, 0x0209, 0xFFFF, 0x020B,
    0xFFFF, 0x020D, 0xFFFF, 0x020F, 0xFFFF, 0x0211, 0xFFFF, 0x0213, 0xFFFF, 0x0215, 0xFFFF,
    0x0217, 0xFFFF, 0x0219, 0xFFFF, 0x021B, 0xFFFF, 0x021D, 0xFFFF, 0x021F, 0xFFFF};
static unsigned short unicode_fold_data13[] = {
    0x019E, 0xFFFF, 0x0223, 0xFFFF, 0x0225, 0xFFFF, 0x0227, 0xFFFF, 0x0229, 0xFFFF, 0x022B,
    0xFFFF, 0x022D, 0xFFFF, 0x022F, 0xFFFF, 0x0231, 0xFFFF, 0x0233, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x2C65, 0x023C, 0xFFFF, 0x019A, 0x2C66, 0xFFFF};
static unsigned short unicode_fold_data14[] = {
    0xFFFF, 0x0242, 0xFFFF, 0x0180, 0x0289, 0x028C, 0x0247, 0xFFFF, 0x0249, 0xFFFF, 0x024B,
    0xFFFF, 0x024D, 0xFFFF, 0x024F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_fold_data15[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x03B9, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_fold_data16[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0371, 0xFFFF, 0x0373, 0xFFFF, 0xFFFF, 0xFFFF,
    0x0377, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_fold_data17[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x03AC, 0xFFFF, 0x03AD, 0x03AE, 0x03AF,
    0xFFFF, 0x03CC, 0xFFFF, 0x03CD, 0x03CE, 0xFFFF, 0x03B1, 0x03B2, 0x03B3, 0x03B4, 0x03B5,
    0x03B6, 0x03B7, 0x03B8, 0x03B9, 0x03BA, 0x03BB, 0x03BC, 0x03BD, 0x03BE, 0x03BF};
static unsigned short unicode_fold_data18[] = {
    0x03C0, 0x03C1, 0xFFFF, 0x03C3, 0x03C4, 0x03C5, 0x03C6, 0x03C7, 0x03C8, 0x03C9, 0x03CA,
    0x03CB, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_fold_data19[] = {
    0xFFFF, 0xFFFF, 0x03C3, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x03D7, 0x03B2, 0x03B8, 0xFFFF, 0xFFFF, 0xFFFF, 0x03C6,
    0x03C0, 0xFFFF, 0x03D9, 0xFFFF, 0x03DB, 0xFFFF, 0x03DD, 0xFFFF, 0x03DF, 0xFFFF};
static unsigned short unicode_fold_data20[] = {
    0x03E1, 0xFFFF, 0x03E3, 0xFFFF, 0x03E5, 0xFFFF, 0x03E7, 0xFFFF, 0x03E9, 0xFFFF, 0x03EB,
    0xFFFF, 0x03ED, 0xFFFF, 0x03EF, 0xFFFF, 0x03BA, 0x03C1, 0xFFFF, 0xFFFF, 0x03B8, 0x03B5,
    0xFFFF, 0x03F8, 0xFFFF, 0x03F2, 0x03FB, 0xFFFF, 0xFFFF, 0x037B, 0x037C, 0x037D};
static unsigned short unicode_fold_data21[] = {
    0x0450, 0x0451, 0x0452, 0x0453, 0x0454, 0x0455, 0x0456, 0x0457, 0x0458, 0x0459, 0x045A,
    0x045B, 0x045C, 0x045D, 0x045E, 0x045F, 0x0430, 0x0431, 0x0432, 0x0433, 0x0434, 0x0435,
    0x0436, 0x0437, 0x0438, 0x0439, 0x043A, 0x043B, 0x043C, 0x043D, 0x043E, 0x043F};
static unsigned short unicode_fold_data22[] = {
    0x0440, 0x0441, 0x0442, 0x0443, 0x0444, 0x0445, 0x0446, 0x0447, 0x0448, 0x0449, 0x044A,
    0x044B, 0x044C, 0x044D, 0x044E, 0x044F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_fold_data23[] = {
    0x0461, 0xFFFF, 0x0463, 0xFFFF, 0x0465, 0xFFFF, 0x0467, 0xFFFF, 0x0469, 0xFFFF, 0x046B,
    0xFFFF, 0x046D, 0xFFFF, 0x046F, 0xFFFF, 0x0471, 0xFFFF, 0x0473, 0xFFFF, 0x0475, 0xFFFF,
    0x0477, 0xFFFF, 0x0479, 0xFFFF, 0x047B, 0xFFFF, 0x047D, 0xFFFF, 0x047F, 0xFFFF};
static unsigned short unicode_fold_data24[] = {
    0x0481, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x048B,
    0xFFFF, 0x048D, 0xFFFF, 0x048F, 0xFFFF, 0x0491, 0xFFFF, 0x0493, 0xFFFF, 0x0495, 0xFFFF,
    0x0497, 0xFFFF, 0x0499, 0xFFFF, 0x049B, 0xFFFF, 0x049D, 0xFFFF, 0x049F, 0xFFFF};
static unsigned short unicode_fold_data25[] = {
    0x04A1, 0xFFFF, 0x04A3, 0xFFFF, 0x04A5, 0xFFFF, 0x04A7, 0xFFFF, 0x04A9, 0xFFFF, 0x04AB,
    0xFFFF, 0x04AD, 0xFFFF, 0x04AF, 0xFFFF, 0x04B1, 0xFFFF, 0x04B3, 0xFFFF, 0x04B5, 0xFFFF,
    0x04B7, 0xFFFF, 0x04B9, 0xFFFF, 0x04BB, 0xFFFF, 0x04BD, 0xFFFF, 0x04BF, 0xFFFF};
static unsigned short unicode_fold_data26[] = {
    0x04CF, 0x04C2, 0xFFFF, 0x04C4, 0xFFFF, 0x04C6, 0xFFFF, 0x04C8, 0xFFFF, 0x04CA, 0xFFFF,
    0x04CC, 0xFFFF, 0x04CE, 0xFFFF, 0xFFFF, 0x04D1, 0xFFFF, 0x04D3, 0xFFFF, 0x04D5, 0xFFFF,
    0x04D7, 0xFFFF, 0x04D9, 0xFFFF, 0x04DB, 0xFFFF, 0x04DD, 0xFFFF, 0x04DF, 0xFFFF};
static unsigned short unicode_fold_data27[] = {
    0x04E1, 0xFFFF, 0x04E3, 0xFFFF, 0x04E5, 0xFFFF, 0x04E7, 0xFFFF, 0x04E9, 0xFFFF, 0x04EB,
    0xFFFF, 0x04ED, 0xFFFF, 0x04EF, 0xFFFF, 0x04F1, 0xFFFF, 0x04F3, 0xFFFF, 0x04F5, 0xFFFF,
    0x04F7, 0xFFFF, 0x04F9, 0xFFFF, 0x04FB, 0xFFFF, 0x04FD, 0xFFFF, 0x04FF, 0xFFFF};
static unsigned short unicode_fold_data28[] = {
    0x0501, 0xFFFF, 0x0503, 0xFFFF, 0x0505, 0xFFFF, 0x0507, 0xFFFF, 0x0509, 0xFFFF, 0x050B,
    0xFFFF, 0x050D, 0xFFFF, 0x050F, 0xFFFF, 0x0511, 0xFFFF, 0x0513, 0xFFFF, 0x0515, 0xFFFF,
    0x0517, 0xFFFF, 0x0519, 0xFFFF, 0x051B, 0xFFFF, 0x051D, 0xFFFF, 0x051F, 0xFFFF};
static unsigned short unicode_fold_data29[] = {
    0x0521, 0xFFFF, 0x0523, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0561, 0x0562, 0x0563, 0x0564, 0x0565,
    0x0566, 0x0567, 0x0568, 0x0569, 0x056A, 0x056B, 0x056C, 0x056D, 0x056E, 0x056F};
static unsigned short unicode_fold_data30[] = {
    0x0570, 0x0571, 0x0572, 0x0573, 0x0574, 0x0575, 0x0576, 0x0577, 0x0578, 0x0579, 0x057A,
    0x057B, 0x057C, 0x057D, 0x057E, 0x057F, 0x0580, 0x0581, 0x0582, 0x0583, 0x0584, 0x0585,
    0x0586, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_fold_data31[] = {
    0x2D00, 0x2D01, 0x2D02, 0x2D03, 0x2D04, 0x2D05, 0x2D06, 0x2D07, 0x2D08, 0x2D09, 0x2D0A,
    0x2D0B, 0x2D0C, 0x2D0D, 0x2D0E, 0x2D0F, 0x2D10, 0x2D11, 0x2D12, 0x2D13, 0x2D14, 0x2D15,
    0x2D16, 0x2D17, 0x2D18, 0x2D19, 0x2D1A, 0x2D1B, 0x2D1C, 0x2D1D, 0x2D1E, 0x2D1F};
static unsigned short unicode_fold_data32[] = {
    0x2D20, 0x2D21, 0x2D22, 0x2D23, 0x2D24, 0x2D25, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_fold_data33[] = {
    0x1E01, 0xFFFF, 0x1E03, 0xFFFF, 0x1E05, 0xFFFF, 0x1E07, 0xFFFF, 0x1E09, 0xFFFF, 0x1E0B,
    0xFFFF, 0x1E0D, 0xFFFF, 0x1E0F, 0xFFFF, 0x1E11, 0xFFFF, 0x1E13, 0xFFFF, 0x1E15, 0xFFFF,
    0x1E17, 0xFFFF, 0x1E19, 0xFFFF, 0x1E1B, 0xFFFF, 0x1E1D, 0xFFFF, 0x1E1F, 0xFFFF};
static unsigned short unicode_fold_data34[] = {
    0x1E21, 0xFFFF, 0x1E23, 0xFFFF, 0x1E25, 0xFFFF, 0x1E27, 0xFFFF, 0x1E29, 0xFFFF, 0x1E2B,
    0xFFFF, 0x1E2D, 0xFFFF, 0x1E2F, 0xFFFF, 0x1E31, 0xFFFF, 0x1E33, 0xFFFF, 0x1E35, 0xFFFF,
    0x1E37, 0xFFFF, 0x1E39, 0xFFFF, 0x1E3B, 0xFFFF, 0x1E3D, 0xFFFF, 0x1E3F, 0xFFFF};
static unsigned short unicode_fold_data35[] = {
    0x1E41, 0xFFFF, 0x1E43, 0xFFFF, 0x1E45, 0xFFFF, 0x1E47, 0xFFFF, 0x1E49, 0xFFFF, 0x1E4B,
    0xFFFF, 0x1E4D, 0xFFFF, 0x1E4F, 0xFFFF, 0x1E51, 0xFFFF, 0x1E53, 0xFFFF, 0x1E55, 0xFFFF,
    0x1E57, 0xFFFF, 0x1E59, 0xFFFF, 0x1E5B, 0xFFFF, 0x1E5D, 0xFFFF, 0x1E5F, 0xFFFF};
static unsigned short unicode_fold_data36[] = {
    0x1E61, 0xFFFF, 0x1E63, 0xFFFF, 0x1E65, 0xFFFF, 0x1E67, 0xFFFF, 0x1E69, 0xFFFF, 0x1E6B,
    0xFFFF, 0x1E6D, 0xFFFF, 0x1E6F, 0xFFFF, 0x1E71, 0xFFFF, 0x1E73, 0xFFFF, 0x1E75, 0xFFFF,
    0x1E77, 0xFFFF, 0x1E79, 0xFFFF, 0x1E7B, 0xFFFF, 0x1E7D, 0xFFFF, 0x1E7F, 0xFFFF};
static unsigned short unicode_fold_data37[] = {
    0x1E81, 0xFFFF, 0x1E83, 0xFFFF, 0x1E85, 0xFFFF, 0x1E87, 0xFFFF, 0x1E89, 0xFFFF, 0x1E8B,
    0xFFFF, 0x1E8D, 0xFFFF, 0x1E8F, 0xFFFF, 0x1E91, 0xFFFF, 0x1E93, 0xFFFF, 0x1E95, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x1E61, 0xFFFF, 0xFFFF, 0x00DF, 0xFFFF};
static unsigned short unicode_fold_data38[] = {
    0x1EA1, 0xFFFF, 0x1EA3, 0xFFFF, 0x1EA5, 0xFFFF, 0x1EA7, 0xFFFF, 0x1EA9, 0xFFFF, 0x1EAB,
    0xFFFF, 0x1EAD, 0xFFFF, 0x1EAF, 0xFFFF, 0x1EB1, 0xFFFF, 0x1EB3, 0xFFFF, 0x1EB5, 0xFFFF,
    0x1EB7, 0xFFFF, 0x1EB9, 0xFFFF, 0x1EBB, 0xFFFF, 0x1EBD, 0xFFFF, 0x1EBF, 0xFFFF};
static unsigned short unicode_fold_data39[] = {
    0x1EC1, 0xFFFF, 0x1EC3, 0xFFFF, 0x1EC5, 0xFFFF, 0x1EC7, 0xFFFF, 0x1EC9, 0xFFFF, 0x1ECB,
    0xFFFF, 0x1ECD, 0xFFFF, 0x1ECF, 0xFFFF, 0x1ED1, 0xFFFF, 0x1ED3, 0xFFFF, 0x1ED5, 0xFFFF,
    0x1ED7, 0xFFFF, 0x1ED9, 0xFFFF, 0x1EDB, 0xFFFF, 0x1EDD, 0xFFFF, 0x1EDF, 0xFFFF};
static unsigned short unicode_fold_data40[] = {
    0x1EE1, 0xFFFF, 0x1EE3, 0xFFFF, 0x1EE5, 0xFFFF, 0x1EE7, 0xFFFF, 0x1EE9, 0xFFFF, 0x1EEB,
    0xFFFF, 0x1EED, 0xFFFF, 0x1EEF, 0xFFFF, 0x1EF1, 0xFFFF, 0x1EF3, 0xFFFF, 0x1EF5, 0xFFFF,
    0x1EF7, 0xFFFF, 0x1EF9, 0xFFFF, 0x1EFB, 0xFFFF, 0x1EFD, 0xFFFF, 0x1EFF, 0xFFFF};
static unsigned short unicode_fold_data41[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x1F00, 0x1F01, 0x1F02,
    0x1F03, 0x1F04, 0x1F05, 0x1F06, 0x1F07, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0x1F10, 0x1F11, 0x1F12, 0x1F13, 0x1F14, 0x1F15, 0xFFFF, 0xFFFF};
static unsigned short unicode_fold_data42[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x1F20, 0x1F21, 0x1F22,
    0x1F23, 0x1F24, 0x1F25, 0x1F26, 0x1F27, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0x1F30, 0x1F31, 0x1F32, 0x1F33, 0x1F34, 0x1F35, 0x1F36, 0x1F37};
static unsigned short unicode_fold_data43[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x1F40, 0x1F41, 0x1F42,
    0x1F43, 0x1F44, 0x1F45, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0x1F51, 0xFFFF, 0x1F53, 0xFFFF, 0x1F55, 0xFFFF, 0x1F57};
static unsigned short unicode_fold_data44[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x1F60, 0x1F61, 0x1F62,
    0x1F63, 0x1F64, 0x1F65, 0x1F66, 0x1F67, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_fold_data45[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x1F80, 0x1F81, 0x1F82,
    0x1F83, 0x1F84, 0x1F85, 0x1F86, 0x1F87, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0x1F90, 0x1F91, 0x1F92, 0x1F93, 0x1F94, 0x1F95, 0x1F96, 0x1F97};
static unsigned short unicode_fold_data46[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x1FA0, 0x1FA1, 0x1FA2,
    0x1FA3, 0x1FA4, 0x1FA5, 0x1FA6, 0x1FA7, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0x1FB0, 0x1FB1, 0x1F70, 0x1F71, 0x1FB3, 0xFFFF, 0x03B9, 0xFFFF};
static unsigned short unicode_fold_data47[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x1F72, 0x1F73, 0x1F74,
    0x1F75, 0x1FC3, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0x1FD0, 0x1FD1, 0x1F76, 0x1F77, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_fold_data48[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x1FE0, 0x1FE1, 0x1F7A,
    0x1F7B, 0x1FE5, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0x1F78, 0x1F79, 0x1F7C, 0x1F7D, 0x1FF3, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_fold_data49[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x03C9, 0xFFFF, 0xFFFF, 0xFFFF, 0x006B,
    0x00E5, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x214E, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_fold_data50[] = {
    0x2170, 0x2171, 0x2172, 0x2173, 0x2174, 0x2175, 0x2176, 0x2177, 0x2178, 0x2179, 0x217A,
    0x217B, 0x217C, 0x217D, 0x217E, 0x217F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_fold_data51[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0x2184, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_fold_data52[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0x24D0, 0x24D1, 0x24D2, 0x24D3, 0x24D4, 0x24D5, 0x24D6, 0x24D7, 0x24D8, 0x24D9};
static unsigned short unicode_fold_data53[] = {
    0x24DA, 0x24DB, 0x24DC, 0x24DD, 0x24DE, 0x24DF, 0x24E0, 0x24E1, 0x24E2, 0x24E3, 0x24E4,
    0x24E5, 0x24E6, 0x24E7, 0x24E8, 0x24E9, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_fold_data54[] = {
    0x2C30, 0x2C31, 0x2C32, 0x2C33, 0x2C34, 0x2C35, 0x2C36, 0x2C37, 0x2C38, 0x2C39, 0x2C3A,
    0x2C3B, 0x2C3C, 0x2C3D, 0x2C3E, 0x2C3F, 0x2C40, 0x2C41, 0x2C42, 0x2C43, 0x2C44, 0x2C45,
    0x2C46, 0x2C47, 0x2C48, 0x2C49, 0x2C4A, 0x2C4B, 0x2C4C, 0x2C4D, 0x2C4E, 0x2C4F};
static unsigned short unicode_fold_data55[] = {
    0x2C50, 0x2C51, 0x2C52, 0x2C53, 0x2C54, 0x2C55, 0x2C56, 0x2C57, 0x2C58, 0x2C59, 0x2C5A,
    0x2C5B, 0x2C5C, 0x2C5D, 0x2C5E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_fold_data56[] = {
    0x2C61, 0xFFFF, 0x026B, 0x1D7D, 0x027D, 0xFFFF, 0xFFFF, 0x2C68, 0xFFFF, 0x2C6A, 0xFFFF,
    0x2C6C, 0xFFFF, 0x0251, 0x0271, 0x0250, 0xFFFF, 0xFFFF, 0x2C73, 0xFFFF, 0xFFFF, 0x2C76,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_fold_data57[] = {
    0x2C81, 0xFFFF, 0x2C83, 0xFFFF, 0x2C85, 0xFFFF, 0x2C87, 0xFFFF, 0x2C89, 0xFFFF, 0x2C8B,
    0xFFFF, 0x2C8D, 0xFFFF, 0x2C8F, 0xFFFF, 0x2C91, 0xFFFF, 0x2C93, 0xFFFF, 0x2C95, 0xFFFF,
    0x2C97, 0xFFFF, 0x2C99, 0xFFFF, 0x2C9B, 0xFFFF, 0x2C9D, 0xFFFF, 0x2C9F, 0xFFFF};
static unsigned short unicode_fold_data58[] = {
    0x2CA1, 0xFFFF, 0x2CA3, 0xFFFF, 0x2CA5, 0xFFFF, 0x2CA7, 0xFFFF, 0x2CA9, 0xFFFF, 0x2CAB,
    0xFFFF, 0x2CAD, 0xFFFF, 0x2CAF, 0xFFFF, 0x2CB1, 0xFFFF, 0x2CB3, 0xFFFF, 0x2CB5, 0xFFFF,
    0x2CB7, 0xFFFF, 0x2CB9, 0xFFFF, 0x2CBB, 0xFFFF, 0x2CBD, 0xFFFF, 0x2CBF, 0xFFFF};
static unsigned short unicode_fold_data59[] = {
    0x2CC1, 0xFFFF, 0x2CC3, 0xFFFF, 0x2CC5, 0xFFFF, 0x2CC7, 0xFFFF, 0x2CC9, 0xFFFF, 0x2CCB,
    0xFFFF, 0x2CCD, 0xFFFF, 0x2CCF, 0xFFFF, 0x2CD1, 0xFFFF, 0x2CD3, 0xFFFF, 0x2CD5, 0xFFFF,
    0x2CD7, 0xFFFF, 0x2CD9, 0xFFFF, 0x2CDB, 0xFFFF, 0x2CDD, 0xFFFF, 0x2CDF, 0xFFFF};
static unsigned short unicode_fold_data60[] = {
    0x2CE1, 0xFFFF, 0x2CE3, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_fold_data61[] = {
    0xA641, 0xFFFF, 0xA643, 0xFFFF, 0xA645, 0xFFFF, 0xA647, 0xFFFF, 0xA649, 0xFFFF, 0xA64B,
    0xFFFF, 0xA64D, 0xFFFF, 0xA64F, 0xFFFF, 0xA651, 0xFFFF, 0xA653, 0xFFFF, 0xA655, 0xFFFF,
    0xA657, 0xFFFF, 0xA659, 0xFFFF, 0xA65B, 0xFFFF, 0xA65D, 0xFFFF, 0xA65F, 0xFFFF};
static unsigned short unicode_fold_data62[] = {
    0xFFFF, 0xFFFF, 0xA663, 0xFFFF, 0xA665, 0xFFFF, 0xA667, 0xFFFF, 0xA669, 0xFFFF, 0xA66B,
    0xFFFF, 0xA66D, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_fold_data63[] = {
    0xA681, 0xFFFF, 0xA683, 0xFFFF, 0xA685, 0xFFFF, 0xA687, 0xFFFF, 0xA689, 0xFFFF, 0xA68B,
    0xFFFF, 0xA68D, 0xFFFF, 0xA68F, 0xFFFF, 0xA691, 0xFFFF, 0xA693, 0xFFFF, 0xA695, 0xFFFF,
    0xA697, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_fold_data64[] = {
    0xFFFF, 0xFFFF, 0xA723, 0xFFFF, 0xA725, 0xFFFF, 0xA727, 0xFFFF, 0xA729, 0xFFFF, 0xA72B,
    0xFFFF, 0xA72D, 0xFFFF, 0xA72F, 0xFFFF, 0xFFFF, 0xFFFF, 0xA733, 0xFFFF, 0xA735, 0xFFFF,
    0xA737, 0xFFFF, 0xA739, 0xFFFF, 0xA73B, 0xFFFF, 0xA73D, 0xFFFF, 0xA73F, 0xFFFF};
static unsigned short unicode_fold_data65[] = {
    0xA741, 0xFFFF, 0xA743, 0xFFFF, 0xA745, 0xFFFF, 0xA747, 0xFFFF, 0xA749, 0xFFFF, 0xA74B,
    0xFFFF, 0xA74D, 0xFFFF, 0xA74F, 0xFFFF, 0xA751, 0xFFFF, 0xA753, 0xFFFF, 0xA755, 0xFFFF,
    0xA757, 0xFFFF, 0xA759, 0xFFFF, 0xA75B, 0xFFFF, 0xA75D, 0xFFFF, 0xA75F, 0xFFFF};
static unsigned short unicode_fold_data66[] = {
    0xA761, 0xFFFF, 0xA763, 0xFFFF, 0xA765, 0xFFFF, 0xA767, 0xFFFF, 0xA769, 0xFFFF, 0xA76B,
    0xFFFF, 0xA76D, 0xFFFF, 0xA76F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xA77A, 0xFFFF, 0xA77C, 0xFFFF, 0x1D79, 0xA77F, 0xFFFF};
static unsigned short unicode_fold_data67[] = {
    0xA781, 0xFFFF, 0xA783, 0xFFFF, 0xA785, 0xFFFF, 0xA787, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xA78C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_fold_data68[] = {
    0xFFFF, 0xFF41, 0xFF42, 0xFF43, 0xFF44, 0xFF45, 0xFF46, 0xFF47, 0xFF48, 0xFF49, 0xFF4A,
    0xFF4B, 0xFF4C, 0xFF4D, 0xFF4E, 0xFF4F, 0xFF50, 0xFF51, 0xFF52, 0xFF53, 0xFF54, 0xFF55,
    0xFF56, 0xFF57, 0xFF58, 0xFF59, 0xFF5A, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};

static unsigned short* unicode_fold_data_table[UNICODE_FOLD_BLOCK_COUNT] = {
    unicode_fold_data0,  unicode_fold_data1,  unicode_fold_data2,  unicode_fold_data3,
    unicode_fold_data4,  unicode_fold_data5,  unicode_fold_data6,  unicode_fold_data7,
    unicode_fold_data8,  unicode_fold_data9,  unicode_fold_data10, unicode_fold_data11,
    unicode_fold_data12, unicode_fold_data13, unicode_fold_data14, unicode_fold_data15,
    unicode_fold_data16, unicode_fold_data17, unicode_fold_data18, unicode_fold_data19,
    unicode_fold_data20, unicode_fold_data21, unicode_fold_data22, unicode_fold_data23,
    unicode_fold_data24, unicode_fold_data25, unicode_fold_data26, unicode_fold_data27,
    unicode_fold_data28, unicode_fold_data29, unicode_fold_data30, unicode_fold_data31,
    unicode_fold_data32, unicode_fold_data33, unicode_fold_data34, unicode_fold_data35,
    unicode_fold_data36, unicode_fold_data37, unicode_fold_data38, unicode_fold_data39,
    unicode_fold_data40, unicode_fold_data41, unicode_fold_data42, unicode_fold_data43,
    unicode_fold_data44, unicode_fold_data45, unicode_fold_data46, unicode_fold_data47,
    unicode_fold_data48, unicode_fold_data49, unicode_fold_data50, unicode_fold_data51,
    unicode_fold_data52, unicode_fold_data53, unicode_fold_data54, unicode_fold_data55,
    unicode_fold_data56, unicode_fold_data57, unicode_fold_data58, unicode_fold_data59,
    unicode_fold_data60, unicode_fold_data61, unicode_fold_data62, unicode_fold_data63,
    unicode_fold_data64, unicode_fold_data65, unicode_fold_data66, unicode_fold_data67,
    unicode_fold_data68};
/* Generated by builder. Do not modify. End unicode_fold_tables */

SQLITE_EXPORT u16 sqlite3_unicode_fold(u16 c) {
    u16 index = unicode_fold_indexes[(c) >> UNICODE_FOLD_BLOCK_SHIFT];
    u8 position = (c)&UNICODE_FOLD_BLOCK_MASK;
    u16(p) = (unicode_fold_data_table[index][unicode_fold_positions[index][position]]);
    int l = unicode_fold_positions[index][position + 1] - unicode_fold_positions[index][position];

    return ((l == 1) && ((p) == 0xFFFF)) ? c : p;
}
#endif

#ifdef SQLITE3_UNICODE_LOWER
/* Generated by builder. Do not modify. Start unicode_lower_defines */
#define UNICODE_LOWER_BLOCK_SHIFT 5
#define UNICODE_LOWER_BLOCK_MASK ((1 << UNICODE_LOWER_BLOCK_SHIFT) - 1)
#define UNICODE_LOWER_BLOCK_SIZE (1 << UNICODE_LOWER_BLOCK_SHIFT)
#define UNICODE_LOWER_BLOCK_COUNT 67
#define UNICODE_LOWER_INDEXES_SIZE (0x10000 >> UNICODE_LOWER_BLOCK_SHIFT)
/* Generated by builder. Do not modify. End unicode_lower_defines */

/* Generated by builder. Do not modify. Start unicode_lower_tables */

static unsigned short unicode_lower_indexes[UNICODE_LOWER_INDEXES_SIZE] = {
    0,  0,  1,  0,  0,  0,  2,  0,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 0,  0,  0,  0,  0,
    0,  0,  0,  14, 15, 16, 17, 18, 19, 20, 0,  21, 22, 23, 24, 25, 26, 27, 28, 0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  29, 30, 0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 0,  0,  0,  0,  0,  0,  0,  0,
    0,  47, 0,  48, 49, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  50, 51, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  52, 53, 0,  54, 55, 56, 57, 58,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  59, 60, 61, 0,  0,  0,  0,  62, 63, 64, 65, 0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  66, 0,  0,  0,  0,  0,  0};

static unsigned char
    unicode_lower_positions[UNICODE_LOWER_BLOCK_COUNT][UNICODE_LOWER_BLOCK_SIZE + 1] = {
        /* 0 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 1 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 2 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 3 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 4 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 5 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 6 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 7 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 8 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 9 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 10 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 11 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 12 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 13 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 14 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 15 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 16 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 17 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 18 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 19 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 20 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 21 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 22 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 23 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 24 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 25 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 26 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 27 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 28 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 29 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 30 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 31 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 32 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 33 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 34 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 35 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 36 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 37 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 38 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 39 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 40 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 41 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 42 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 43 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 44 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 45 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 46 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 47 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 48 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 49 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 50 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 51 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 52 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 53 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 54 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 55 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 56 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 57 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 58 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 59 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 60 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 61 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 62 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 63 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 64 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 65 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 66 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32}};

static unsigned short unicode_lower_data0[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_lower_data1[] = {
    0xFFFF, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 0x0068, 0x0069, 0x006A,
    0x006B, 0x006C, 0x006D, 0x006E, 0x006F, 0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075,
    0x0076, 0x0077, 0x0078, 0x0079, 0x007A, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_lower_data2[] = {
    0x00E0, 0x00E1, 0x00E2, 0x00E3, 0x00E4, 0x00E5, 0x00E6, 0x00E7, 0x00E8, 0x00E9, 0x00EA,
    0x00EB, 0x00EC, 0x00ED, 0x00EE, 0x00EF, 0x00F0, 0x00F1, 0x00F2, 0x00F3, 0x00F4, 0x00F5,
    0x00F6, 0xFFFF, 0x00F8, 0x00F9, 0x00FA, 0x00FB, 0x00FC, 0x00FD, 0x00FE, 0xFFFF};
static unsigned short unicode_lower_data3[] = {
    0x0101, 0xFFFF, 0x0103, 0xFFFF, 0x0105, 0xFFFF, 0x0107, 0xFFFF, 0x0109, 0xFFFF, 0x010B,
    0xFFFF, 0x010D, 0xFFFF, 0x010F, 0xFFFF, 0x0111, 0xFFFF, 0x0113, 0xFFFF, 0x0115, 0xFFFF,
    0x0117, 0xFFFF, 0x0119, 0xFFFF, 0x011B, 0xFFFF, 0x011D, 0xFFFF, 0x011F, 0xFFFF};
static unsigned short unicode_lower_data4[] = {
    0x0121, 0xFFFF, 0x0123, 0xFFFF, 0x0125, 0xFFFF, 0x0127, 0xFFFF, 0x0129, 0xFFFF, 0x012B,
    0xFFFF, 0x012D, 0xFFFF, 0x012F, 0xFFFF, 0x0069, 0xFFFF, 0x0133, 0xFFFF, 0x0135, 0xFFFF,
    0x0137, 0xFFFF, 0xFFFF, 0x013A, 0xFFFF, 0x013C, 0xFFFF, 0x013E, 0xFFFF, 0x0140};
static unsigned short unicode_lower_data5[] = {
    0xFFFF, 0x0142, 0xFFFF, 0x0144, 0xFFFF, 0x0146, 0xFFFF, 0x0148, 0xFFFF, 0xFFFF, 0x014B,
    0xFFFF, 0x014D, 0xFFFF, 0x014F, 0xFFFF, 0x0151, 0xFFFF, 0x0153, 0xFFFF, 0x0155, 0xFFFF,
    0x0157, 0xFFFF, 0x0159, 0xFFFF, 0x015B, 0xFFFF, 0x015D, 0xFFFF, 0x015F, 0xFFFF};
static unsigned short unicode_lower_data6[] = {
    0x0161, 0xFFFF, 0x0163, 0xFFFF, 0x0165, 0xFFFF, 0x0167, 0xFFFF, 0x0169, 0xFFFF, 0x016B,
    0xFFFF, 0x016D, 0xFFFF, 0x016F, 0xFFFF, 0x0171, 0xFFFF, 0x0173, 0xFFFF, 0x0175, 0xFFFF,
    0x0177, 0xFFFF, 0x00FF, 0x017A, 0xFFFF, 0x017C, 0xFFFF, 0x017E, 0xFFFF, 0xFFFF};
static unsigned short unicode_lower_data7[] = {
    0xFFFF, 0x0253, 0x0183, 0xFFFF, 0x0185, 0xFFFF, 0x0254, 0x0188, 0xFFFF, 0x0256, 0x0257,
    0x018C, 0xFFFF, 0xFFFF, 0x01DD, 0x0259, 0x025B, 0x0192, 0xFFFF, 0x0260, 0x0263, 0xFFFF,
    0x0269, 0x0268, 0x0199, 0xFFFF, 0xFFFF, 0xFFFF, 0x026F, 0x0272, 0xFFFF, 0x0275};
static unsigned short unicode_lower_data8[] = {
    0x01A1, 0xFFFF, 0x01A3, 0xFFFF, 0x01A5, 0xFFFF, 0x0280, 0x01A8, 0xFFFF, 0x0283, 0xFFFF,
    0xFFFF, 0x01AD, 0xFFFF, 0x0288, 0x01B0, 0xFFFF, 0x028A, 0x028B, 0x01B4, 0xFFFF, 0x01B6,
    0xFFFF, 0x0292, 0x01B9, 0xFFFF, 0xFFFF, 0xFFFF, 0x01BD, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_lower_data9[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x01C6, 0x01C6, 0xFFFF, 0x01C9, 0x01C9, 0xFFFF, 0x01CC,
    0x01CC, 0xFFFF, 0x01CE, 0xFFFF, 0x01D0, 0xFFFF, 0x01D2, 0xFFFF, 0x01D4, 0xFFFF, 0x01D6,
    0xFFFF, 0x01D8, 0xFFFF, 0x01DA, 0xFFFF, 0x01DC, 0xFFFF, 0xFFFF, 0x01DF, 0xFFFF};
static unsigned short unicode_lower_data10[] = {
    0x01E1, 0xFFFF, 0x01E3, 0xFFFF, 0x01E5, 0xFFFF, 0x01E7, 0xFFFF, 0x01E9, 0xFFFF, 0x01EB,
    0xFFFF, 0x01ED, 0xFFFF, 0x01EF, 0xFFFF, 0xFFFF, 0x01F3, 0x01F3, 0xFFFF, 0x01F5, 0xFFFF,
    0x0195, 0x01BF, 0x01F9, 0xFFFF, 0x01FB, 0xFFFF, 0x01FD, 0xFFFF, 0x01FF, 0xFFFF};
static unsigned short unicode_lower_data11[] = {
    0x0201, 0xFFFF, 0x0203, 0xFFFF, 0x0205, 0xFFFF, 0x0207, 0xFFFF, 0x0209, 0xFFFF, 0x020B,
    0xFFFF, 0x020D, 0xFFFF, 0x020F, 0xFFFF, 0x0211, 0xFFFF, 0x0213, 0xFFFF, 0x0215, 0xFFFF,
    0x0217, 0xFFFF, 0x0219, 0xFFFF, 0x021B, 0xFFFF, 0x021D, 0xFFFF, 0x021F, 0xFFFF};
static unsigned short unicode_lower_data12[] = {
    0x019E, 0xFFFF, 0x0223, 0xFFFF, 0x0225, 0xFFFF, 0x0227, 0xFFFF, 0x0229, 0xFFFF, 0x022B,
    0xFFFF, 0x022D, 0xFFFF, 0x022F, 0xFFFF, 0x0231, 0xFFFF, 0x0233, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x2C65, 0x023C, 0xFFFF, 0x019A, 0x2C66, 0xFFFF};
static unsigned short unicode_lower_data13[] = {
    0xFFFF, 0x0242, 0xFFFF, 0x0180, 0x0289, 0x028C, 0x0247, 0xFFFF, 0x0249, 0xFFFF, 0x024B,
    0xFFFF, 0x024D, 0xFFFF, 0x024F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_lower_data14[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0371, 0xFFFF, 0x0373, 0xFFFF, 0xFFFF, 0xFFFF,
    0x0377, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_lower_data15[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x03AC, 0xFFFF, 0x03AD, 0x03AE, 0x03AF,
    0xFFFF, 0x03CC, 0xFFFF, 0x03CD, 0x03CE, 0xFFFF, 0x03B1, 0x03B2, 0x03B3, 0x03B4, 0x03B5,
    0x03B6, 0x03B7, 0x03B8, 0x03B9, 0x03BA, 0x03BB, 0x03BC, 0x03BD, 0x03BE, 0x03BF};
static unsigned short unicode_lower_data16[] = {
    0x03C0, 0x03C1, 0xFFFF, 0x03C3, 0x03C4, 0x03C5, 0x03C6, 0x03C7, 0x03C8, 0x03C9, 0x03CA,
    0x03CB, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_lower_data17[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x03D7, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0x03D9, 0xFFFF, 0x03DB, 0xFFFF, 0x03DD, 0xFFFF, 0x03DF, 0xFFFF};
static unsigned short unicode_lower_data18[] = {
    0x03E1, 0xFFFF, 0x03E3, 0xFFFF, 0x03E5, 0xFFFF, 0x03E7, 0xFFFF, 0x03E9, 0xFFFF, 0x03EB,
    0xFFFF, 0x03ED, 0xFFFF, 0x03EF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x03B8, 0xFFFF,
    0xFFFF, 0x03F8, 0xFFFF, 0x03F2, 0x03FB, 0xFFFF, 0xFFFF, 0x037B, 0x037C, 0x037D};
static unsigned short unicode_lower_data19[] = {
    0x0450, 0x0451, 0x0452, 0x0453, 0x0454, 0x0455, 0x0456, 0x0457, 0x0458, 0x0459, 0x045A,
    0x045B, 0x045C, 0x045D, 0x045E, 0x045F, 0x0430, 0x0431, 0x0432, 0x0433, 0x0434, 0x0435,
    0x0436, 0x0437, 0x0438, 0x0439, 0x043A, 0x043B, 0x043C, 0x043D, 0x043E, 0x043F};
static unsigned short unicode_lower_data20[] = {
    0x0440, 0x0441, 0x0442, 0x0443, 0x0444, 0x0445, 0x0446, 0x0447, 0x0448, 0x0449, 0x044A,
    0x044B, 0x044C, 0x044D, 0x044E, 0x044F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_lower_data21[] = {
    0x0461, 0xFFFF, 0x0463, 0xFFFF, 0x0465, 0xFFFF, 0x0467, 0xFFFF, 0x0469, 0xFFFF, 0x046B,
    0xFFFF, 0x046D, 0xFFFF, 0x046F, 0xFFFF, 0x0471, 0xFFFF, 0x0473, 0xFFFF, 0x0475, 0xFFFF,
    0x0477, 0xFFFF, 0x0479, 0xFFFF, 0x047B, 0xFFFF, 0x047D, 0xFFFF, 0x047F, 0xFFFF};
static unsigned short unicode_lower_data22[] = {
    0x0481, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x048B,
    0xFFFF, 0x048D, 0xFFFF, 0x048F, 0xFFFF, 0x0491, 0xFFFF, 0x0493, 0xFFFF, 0x0495, 0xFFFF,
    0x0497, 0xFFFF, 0x0499, 0xFFFF, 0x049B, 0xFFFF, 0x049D, 0xFFFF, 0x049F, 0xFFFF};
static unsigned short unicode_lower_data23[] = {
    0x04A1, 0xFFFF, 0x04A3, 0xFFFF, 0x04A5, 0xFFFF, 0x04A7, 0xFFFF, 0x04A9, 0xFFFF, 0x04AB,
    0xFFFF, 0x04AD, 0xFFFF, 0x04AF, 0xFFFF, 0x04B1, 0xFFFF, 0x04B3, 0xFFFF, 0x04B5, 0xFFFF,
    0x04B7, 0xFFFF, 0x04B9, 0xFFFF, 0x04BB, 0xFFFF, 0x04BD, 0xFFFF, 0x04BF, 0xFFFF};
static unsigned short unicode_lower_data24[] = {
    0x04CF, 0x04C2, 0xFFFF, 0x04C4, 0xFFFF, 0x04C6, 0xFFFF, 0x04C8, 0xFFFF, 0x04CA, 0xFFFF,
    0x04CC, 0xFFFF, 0x04CE, 0xFFFF, 0xFFFF, 0x04D1, 0xFFFF, 0x04D3, 0xFFFF, 0x04D5, 0xFFFF,
    0x04D7, 0xFFFF, 0x04D9, 0xFFFF, 0x04DB, 0xFFFF, 0x04DD, 0xFFFF, 0x04DF, 0xFFFF};
static unsigned short unicode_lower_data25[] = {
    0x04E1, 0xFFFF, 0x04E3, 0xFFFF, 0x04E5, 0xFFFF, 0x04E7, 0xFFFF, 0x04E9, 0xFFFF, 0x04EB,
    0xFFFF, 0x04ED, 0xFFFF, 0x04EF, 0xFFFF, 0x04F1, 0xFFFF, 0x04F3, 0xFFFF, 0x04F5, 0xFFFF,
    0x04F7, 0xFFFF, 0x04F9, 0xFFFF, 0x04FB, 0xFFFF, 0x04FD, 0xFFFF, 0x04FF, 0xFFFF};
static unsigned short unicode_lower_data26[] = {
    0x0501, 0xFFFF, 0x0503, 0xFFFF, 0x0505, 0xFFFF, 0x0507, 0xFFFF, 0x0509, 0xFFFF, 0x050B,
    0xFFFF, 0x050D, 0xFFFF, 0x050F, 0xFFFF, 0x0511, 0xFFFF, 0x0513, 0xFFFF, 0x0515, 0xFFFF,
    0x0517, 0xFFFF, 0x0519, 0xFFFF, 0x051B, 0xFFFF, 0x051D, 0xFFFF, 0x051F, 0xFFFF};
static unsigned short unicode_lower_data27[] = {
    0x0521, 0xFFFF, 0x0523, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0561, 0x0562, 0x0563, 0x0564, 0x0565,
    0x0566, 0x0567, 0x0568, 0x0569, 0x056A, 0x056B, 0x056C, 0x056D, 0x056E, 0x056F};
static unsigned short unicode_lower_data28[] = {
    0x0570, 0x0571, 0x0572, 0x0573, 0x0574, 0x0575, 0x0576, 0x0577, 0x0578, 0x0579, 0x057A,
    0x057B, 0x057C, 0x057D, 0x057E, 0x057F, 0x0580, 0x0581, 0x0582, 0x0583, 0x0584, 0x0585,
    0x0586, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_lower_data29[] = {
    0x2D00, 0x2D01, 0x2D02, 0x2D03, 0x2D04, 0x2D05, 0x2D06, 0x2D07, 0x2D08, 0x2D09, 0x2D0A,
    0x2D0B, 0x2D0C, 0x2D0D, 0x2D0E, 0x2D0F, 0x2D10, 0x2D11, 0x2D12, 0x2D13, 0x2D14, 0x2D15,
    0x2D16, 0x2D17, 0x2D18, 0x2D19, 0x2D1A, 0x2D1B, 0x2D1C, 0x2D1D, 0x2D1E, 0x2D1F};
static unsigned short unicode_lower_data30[] = {
    0x2D20, 0x2D21, 0x2D22, 0x2D23, 0x2D24, 0x2D25, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_lower_data31[] = {
    0x1E01, 0xFFFF, 0x1E03, 0xFFFF, 0x1E05, 0xFFFF, 0x1E07, 0xFFFF, 0x1E09, 0xFFFF, 0x1E0B,
    0xFFFF, 0x1E0D, 0xFFFF, 0x1E0F, 0xFFFF, 0x1E11, 0xFFFF, 0x1E13, 0xFFFF, 0x1E15, 0xFFFF,
    0x1E17, 0xFFFF, 0x1E19, 0xFFFF, 0x1E1B, 0xFFFF, 0x1E1D, 0xFFFF, 0x1E1F, 0xFFFF};
static unsigned short unicode_lower_data32[] = {
    0x1E21, 0xFFFF, 0x1E23, 0xFFFF, 0x1E25, 0xFFFF, 0x1E27, 0xFFFF, 0x1E29, 0xFFFF, 0x1E2B,
    0xFFFF, 0x1E2D, 0xFFFF, 0x1E2F, 0xFFFF, 0x1E31, 0xFFFF, 0x1E33, 0xFFFF, 0x1E35, 0xFFFF,
    0x1E37, 0xFFFF, 0x1E39, 0xFFFF, 0x1E3B, 0xFFFF, 0x1E3D, 0xFFFF, 0x1E3F, 0xFFFF};
static unsigned short unicode_lower_data33[] = {
    0x1E41, 0xFFFF, 0x1E43, 0xFFFF, 0x1E45, 0xFFFF, 0x1E47, 0xFFFF, 0x1E49, 0xFFFF, 0x1E4B,
    0xFFFF, 0x1E4D, 0xFFFF, 0x1E4F, 0xFFFF, 0x1E51, 0xFFFF, 0x1E53, 0xFFFF, 0x1E55, 0xFFFF,
    0x1E57, 0xFFFF, 0x1E59, 0xFFFF, 0x1E5B, 0xFFFF, 0x1E5D, 0xFFFF, 0x1E5F, 0xFFFF};
static unsigned short unicode_lower_data34[] = {
    0x1E61, 0xFFFF, 0x1E63, 0xFFFF, 0x1E65, 0xFFFF, 0x1E67, 0xFFFF, 0x1E69, 0xFFFF, 0x1E6B,
    0xFFFF, 0x1E6D, 0xFFFF, 0x1E6F, 0xFFFF, 0x1E71, 0xFFFF, 0x1E73, 0xFFFF, 0x1E75, 0xFFFF,
    0x1E77, 0xFFFF, 0x1E79, 0xFFFF, 0x1E7B, 0xFFFF, 0x1E7D, 0xFFFF, 0x1E7F, 0xFFFF};
static unsigned short unicode_lower_data35[] = {
    0x1E81, 0xFFFF, 0x1E83, 0xFFFF, 0x1E85, 0xFFFF, 0x1E87, 0xFFFF, 0x1E89, 0xFFFF, 0x1E8B,
    0xFFFF, 0x1E8D, 0xFFFF, 0x1E8F, 0xFFFF, 0x1E91, 0xFFFF, 0x1E93, 0xFFFF, 0x1E95, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x00DF, 0xFFFF};
static unsigned short unicode_lower_data36[] = {
    0x1EA1, 0xFFFF, 0x1EA3, 0xFFFF, 0x1EA5, 0xFFFF, 0x1EA7, 0xFFFF, 0x1EA9, 0xFFFF, 0x1EAB,
    0xFFFF, 0x1EAD, 0xFFFF, 0x1EAF, 0xFFFF, 0x1EB1, 0xFFFF, 0x1EB3, 0xFFFF, 0x1EB5, 0xFFFF,
    0x1EB7, 0xFFFF, 0x1EB9, 0xFFFF, 0x1EBB, 0xFFFF, 0x1EBD, 0xFFFF, 0x1EBF, 0xFFFF};
static unsigned short unicode_lower_data37[] = {
    0x1EC1, 0xFFFF, 0x1EC3, 0xFFFF, 0x1EC5, 0xFFFF, 0x1EC7, 0xFFFF, 0x1EC9, 0xFFFF, 0x1ECB,
    0xFFFF, 0x1ECD, 0xFFFF, 0x1ECF, 0xFFFF, 0x1ED1, 0xFFFF, 0x1ED3, 0xFFFF, 0x1ED5, 0xFFFF,
    0x1ED7, 0xFFFF, 0x1ED9, 0xFFFF, 0x1EDB, 0xFFFF, 0x1EDD, 0xFFFF, 0x1EDF, 0xFFFF};
static unsigned short unicode_lower_data38[] = {
    0x1EE1, 0xFFFF, 0x1EE3, 0xFFFF, 0x1EE5, 0xFFFF, 0x1EE7, 0xFFFF, 0x1EE9, 0xFFFF, 0x1EEB,
    0xFFFF, 0x1EED, 0xFFFF, 0x1EEF, 0xFFFF, 0x1EF1, 0xFFFF, 0x1EF3, 0xFFFF, 0x1EF5, 0xFFFF,
    0x1EF7, 0xFFFF, 0x1EF9, 0xFFFF, 0x1EFB, 0xFFFF, 0x1EFD, 0xFFFF, 0x1EFF, 0xFFFF};
static unsigned short unicode_lower_data39[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x1F00, 0x1F01, 0x1F02,
    0x1F03, 0x1F04, 0x1F05, 0x1F06, 0x1F07, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0x1F10, 0x1F11, 0x1F12, 0x1F13, 0x1F14, 0x1F15, 0xFFFF, 0xFFFF};
static unsigned short unicode_lower_data40[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x1F20, 0x1F21, 0x1F22,
    0x1F23, 0x1F24, 0x1F25, 0x1F26, 0x1F27, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0x1F30, 0x1F31, 0x1F32, 0x1F33, 0x1F34, 0x1F35, 0x1F36, 0x1F37};
static unsigned short unicode_lower_data41[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x1F40, 0x1F41, 0x1F42,
    0x1F43, 0x1F44, 0x1F45, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0x1F51, 0xFFFF, 0x1F53, 0xFFFF, 0x1F55, 0xFFFF, 0x1F57};
static unsigned short unicode_lower_data42[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x1F60, 0x1F61, 0x1F62,
    0x1F63, 0x1F64, 0x1F65, 0x1F66, 0x1F67, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_lower_data43[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x1F80, 0x1F81, 0x1F82,
    0x1F83, 0x1F84, 0x1F85, 0x1F86, 0x1F87, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0x1F90, 0x1F91, 0x1F92, 0x1F93, 0x1F94, 0x1F95, 0x1F96, 0x1F97};
static unsigned short unicode_lower_data44[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x1FA0, 0x1FA1, 0x1FA2,
    0x1FA3, 0x1FA4, 0x1FA5, 0x1FA6, 0x1FA7, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0x1FB0, 0x1FB1, 0x1F70, 0x1F71, 0x1FB3, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_lower_data45[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x1F72, 0x1F73, 0x1F74,
    0x1F75, 0x1FC3, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0x1FD0, 0x1FD1, 0x1F76, 0x1F77, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_lower_data46[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x1FE0, 0x1FE1, 0x1F7A,
    0x1F7B, 0x1FE5, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0x1F78, 0x1F79, 0x1F7C, 0x1F7D, 0x1FF3, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_lower_data47[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x03C9, 0xFFFF, 0xFFFF, 0xFFFF, 0x006B,
    0x00E5, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x214E, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_lower_data48[] = {
    0x2170, 0x2171, 0x2172, 0x2173, 0x2174, 0x2175, 0x2176, 0x2177, 0x2178, 0x2179, 0x217A,
    0x217B, 0x217C, 0x217D, 0x217E, 0x217F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_lower_data49[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0x2184, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_lower_data50[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0x24D0, 0x24D1, 0x24D2, 0x24D3, 0x24D4, 0x24D5, 0x24D6, 0x24D7, 0x24D8, 0x24D9};
static unsigned short unicode_lower_data51[] = {
    0x24DA, 0x24DB, 0x24DC, 0x24DD, 0x24DE, 0x24DF, 0x24E0, 0x24E1, 0x24E2, 0x24E3, 0x24E4,
    0x24E5, 0x24E6, 0x24E7, 0x24E8, 0x24E9, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_lower_data52[] = {
    0x2C30, 0x2C31, 0x2C32, 0x2C33, 0x2C34, 0x2C35, 0x2C36, 0x2C37, 0x2C38, 0x2C39, 0x2C3A,
    0x2C3B, 0x2C3C, 0x2C3D, 0x2C3E, 0x2C3F, 0x2C40, 0x2C41, 0x2C42, 0x2C43, 0x2C44, 0x2C45,
    0x2C46, 0x2C47, 0x2C48, 0x2C49, 0x2C4A, 0x2C4B, 0x2C4C, 0x2C4D, 0x2C4E, 0x2C4F};
static unsigned short unicode_lower_data53[] = {
    0x2C50, 0x2C51, 0x2C52, 0x2C53, 0x2C54, 0x2C55, 0x2C56, 0x2C57, 0x2C58, 0x2C59, 0x2C5A,
    0x2C5B, 0x2C5C, 0x2C5D, 0x2C5E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_lower_data54[] = {
    0x2C61, 0xFFFF, 0x026B, 0x1D7D, 0x027D, 0xFFFF, 0xFFFF, 0x2C68, 0xFFFF, 0x2C6A, 0xFFFF,
    0x2C6C, 0xFFFF, 0x0251, 0x0271, 0x0250, 0xFFFF, 0xFFFF, 0x2C73, 0xFFFF, 0xFFFF, 0x2C76,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_lower_data55[] = {
    0x2C81, 0xFFFF, 0x2C83, 0xFFFF, 0x2C85, 0xFFFF, 0x2C87, 0xFFFF, 0x2C89, 0xFFFF, 0x2C8B,
    0xFFFF, 0x2C8D, 0xFFFF, 0x2C8F, 0xFFFF, 0x2C91, 0xFFFF, 0x2C93, 0xFFFF, 0x2C95, 0xFFFF,
    0x2C97, 0xFFFF, 0x2C99, 0xFFFF, 0x2C9B, 0xFFFF, 0x2C9D, 0xFFFF, 0x2C9F, 0xFFFF};
static unsigned short unicode_lower_data56[] = {
    0x2CA1, 0xFFFF, 0x2CA3, 0xFFFF, 0x2CA5, 0xFFFF, 0x2CA7, 0xFFFF, 0x2CA9, 0xFFFF, 0x2CAB,
    0xFFFF, 0x2CAD, 0xFFFF, 0x2CAF, 0xFFFF, 0x2CB1, 0xFFFF, 0x2CB3, 0xFFFF, 0x2CB5, 0xFFFF,
    0x2CB7, 0xFFFF, 0x2CB9, 0xFFFF, 0x2CBB, 0xFFFF, 0x2CBD, 0xFFFF, 0x2CBF, 0xFFFF};
static unsigned short unicode_lower_data57[] = {
    0x2CC1, 0xFFFF, 0x2CC3, 0xFFFF, 0x2CC5, 0xFFFF, 0x2CC7, 0xFFFF, 0x2CC9, 0xFFFF, 0x2CCB,
    0xFFFF, 0x2CCD, 0xFFFF, 0x2CCF, 0xFFFF, 0x2CD1, 0xFFFF, 0x2CD3, 0xFFFF, 0x2CD5, 0xFFFF,
    0x2CD7, 0xFFFF, 0x2CD9, 0xFFFF, 0x2CDB, 0xFFFF, 0x2CDD, 0xFFFF, 0x2CDF, 0xFFFF};
static unsigned short unicode_lower_data58[] = {
    0x2CE1, 0xFFFF, 0x2CE3, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_lower_data59[] = {
    0xA641, 0xFFFF, 0xA643, 0xFFFF, 0xA645, 0xFFFF, 0xA647, 0xFFFF, 0xA649, 0xFFFF, 0xA64B,
    0xFFFF, 0xA64D, 0xFFFF, 0xA64F, 0xFFFF, 0xA651, 0xFFFF, 0xA653, 0xFFFF, 0xA655, 0xFFFF,
    0xA657, 0xFFFF, 0xA659, 0xFFFF, 0xA65B, 0xFFFF, 0xA65D, 0xFFFF, 0xA65F, 0xFFFF};
static unsigned short unicode_lower_data60[] = {
    0xFFFF, 0xFFFF, 0xA663, 0xFFFF, 0xA665, 0xFFFF, 0xA667, 0xFFFF, 0xA669, 0xFFFF, 0xA66B,
    0xFFFF, 0xA66D, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_lower_data61[] = {
    0xA681, 0xFFFF, 0xA683, 0xFFFF, 0xA685, 0xFFFF, 0xA687, 0xFFFF, 0xA689, 0xFFFF, 0xA68B,
    0xFFFF, 0xA68D, 0xFFFF, 0xA68F, 0xFFFF, 0xA691, 0xFFFF, 0xA693, 0xFFFF, 0xA695, 0xFFFF,
    0xA697, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_lower_data62[] = {
    0xFFFF, 0xFFFF, 0xA723, 0xFFFF, 0xA725, 0xFFFF, 0xA727, 0xFFFF, 0xA729, 0xFFFF, 0xA72B,
    0xFFFF, 0xA72D, 0xFFFF, 0xA72F, 0xFFFF, 0xFFFF, 0xFFFF, 0xA733, 0xFFFF, 0xA735, 0xFFFF,
    0xA737, 0xFFFF, 0xA739, 0xFFFF, 0xA73B, 0xFFFF, 0xA73D, 0xFFFF, 0xA73F, 0xFFFF};
static unsigned short unicode_lower_data63[] = {
    0xA741, 0xFFFF, 0xA743, 0xFFFF, 0xA745, 0xFFFF, 0xA747, 0xFFFF, 0xA749, 0xFFFF, 0xA74B,
    0xFFFF, 0xA74D, 0xFFFF, 0xA74F, 0xFFFF, 0xA751, 0xFFFF, 0xA753, 0xFFFF, 0xA755, 0xFFFF,
    0xA757, 0xFFFF, 0xA759, 0xFFFF, 0xA75B, 0xFFFF, 0xA75D, 0xFFFF, 0xA75F, 0xFFFF};
static unsigned short unicode_lower_data64[] = {
    0xA761, 0xFFFF, 0xA763, 0xFFFF, 0xA765, 0xFFFF, 0xA767, 0xFFFF, 0xA769, 0xFFFF, 0xA76B,
    0xFFFF, 0xA76D, 0xFFFF, 0xA76F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xA77A, 0xFFFF, 0xA77C, 0xFFFF, 0x1D79, 0xA77F, 0xFFFF};
static unsigned short unicode_lower_data65[] = {
    0xA781, 0xFFFF, 0xA783, 0xFFFF, 0xA785, 0xFFFF, 0xA787, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xA78C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_lower_data66[] = {
    0xFFFF, 0xFF41, 0xFF42, 0xFF43, 0xFF44, 0xFF45, 0xFF46, 0xFF47, 0xFF48, 0xFF49, 0xFF4A,
    0xFF4B, 0xFF4C, 0xFF4D, 0xFF4E, 0xFF4F, 0xFF50, 0xFF51, 0xFF52, 0xFF53, 0xFF54, 0xFF55,
    0xFF56, 0xFF57, 0xFF58, 0xFF59, 0xFF5A, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};

static unsigned short* unicode_lower_data_table[UNICODE_LOWER_BLOCK_COUNT] = {
    unicode_lower_data0,  unicode_lower_data1,  unicode_lower_data2,  unicode_lower_data3,
    unicode_lower_data4,  unicode_lower_data5,  unicode_lower_data6,  unicode_lower_data7,
    unicode_lower_data8,  unicode_lower_data9,  unicode_lower_data10, unicode_lower_data11,
    unicode_lower_data12, unicode_lower_data13, unicode_lower_data14, unicode_lower_data15,
    unicode_lower_data16, unicode_lower_data17, unicode_lower_data18, unicode_lower_data19,
    unicode_lower_data20, unicode_lower_data21, unicode_lower_data22, unicode_lower_data23,
    unicode_lower_data24, unicode_lower_data25, unicode_lower_data26, unicode_lower_data27,
    unicode_lower_data28, unicode_lower_data29, unicode_lower_data30, unicode_lower_data31,
    unicode_lower_data32, unicode_lower_data33, unicode_lower_data34, unicode_lower_data35,
    unicode_lower_data36, unicode_lower_data37, unicode_lower_data38, unicode_lower_data39,
    unicode_lower_data40, unicode_lower_data41, unicode_lower_data42, unicode_lower_data43,
    unicode_lower_data44, unicode_lower_data45, unicode_lower_data46, unicode_lower_data47,
    unicode_lower_data48, unicode_lower_data49, unicode_lower_data50, unicode_lower_data51,
    unicode_lower_data52, unicode_lower_data53, unicode_lower_data54, unicode_lower_data55,
    unicode_lower_data56, unicode_lower_data57, unicode_lower_data58, unicode_lower_data59,
    unicode_lower_data60, unicode_lower_data61, unicode_lower_data62, unicode_lower_data63,
    unicode_lower_data64, unicode_lower_data65, unicode_lower_data66};
/* Generated by builder. Do not modify. End unicode_lower_tables */

SQLITE_EXPORT u16 sqlite3_unicode_lower(u16 c) {
    u16 index = unicode_lower_indexes[(c) >> UNICODE_LOWER_BLOCK_SHIFT];
    u8 position = (c)&UNICODE_LOWER_BLOCK_MASK;
    u16(p) = (unicode_lower_data_table[index][unicode_lower_positions[index][position]]);
    int l = unicode_lower_positions[index][position + 1] - unicode_lower_positions[index][position];

    return ((l == 1) && ((p) == 0xFFFF)) ? c : p;
}
#endif

#ifdef SQLITE3_UNICODE_UPPER
/* Generated by builder. Do not modify. Start unicode_upper_defines */
#define UNICODE_UPPER_BLOCK_SHIFT 6
#define UNICODE_UPPER_BLOCK_MASK ((1 << UNICODE_UPPER_BLOCK_SHIFT) - 1)
#define UNICODE_UPPER_BLOCK_SIZE (1 << UNICODE_UPPER_BLOCK_SHIFT)
#define UNICODE_UPPER_BLOCK_COUNT 44
#define UNICODE_UPPER_INDEXES_SIZE (0x10000 >> UNICODE_UPPER_BLOCK_SHIFT)
/* Generated by builder. Do not modify. End unicode_upper_defines */

/* Generated by builder. Do not modify. Start unicode_upper_tables */

static unsigned short unicode_upper_indexes[UNICODE_UPPER_INDEXES_SIZE] = {
    0, 1, 2, 3, 4, 5, 6, 7, 8, 9,  10, 0, 0,  11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 0, 0, 0,  0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0, 0,  0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0, 0,  0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0, 0,  0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 21, 0,  0, 22, 23, 24, 25, 26, 27, 28, 29, 0,  0,  0,  0, 0, 30, 31,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 32, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0, 0,  0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 0,  0,  33, 34, 35, 36, 37, 0,  0,  0,  0,  0, 0, 0,  0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0, 0,  0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0, 0,  0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0, 0,  0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0, 0,  0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0, 0,  0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0, 0,  0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0, 0,  0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0, 0,  0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0, 0,  0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0, 0,  0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0, 0,  0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0, 0,  0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0, 0,  0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0, 0,  0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0, 0,  0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0, 0,  0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0, 0,  0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 0,  0,  0,  0,  0,  38, 39, 0,  40, 41, 42, 0, 0, 0,  0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0, 0,  0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0, 0,  0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0, 0,  0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0, 0,  0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0, 0,  0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0, 0,  0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0, 0,  0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0, 0,  0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0, 0,  0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0, 0,  0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0, 0,  0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0, 0,  0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  43, 0, 0};

static unsigned char unicode_upper_positions[UNICODE_UPPER_BLOCK_COUNT][UNICODE_UPPER_BLOCK_SIZE +
                                                                        1] = {
    /* 0 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
             22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43,
             44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 1 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
             22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43,
             44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 2 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
             22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43,
             44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 3 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
             22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43,
             44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 4 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
             22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43,
             44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 5 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
             22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43,
             44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 6 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
             22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43,
             44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 7 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
             22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43,
             44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 8 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
             22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43,
             44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 9 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
             22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43,
             44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 10 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
              17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
              34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
              51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 11 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
              17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
              34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
              51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 12 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
              17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
              34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
              51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 13 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
              17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
              34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
              51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 14 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
              17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
              34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
              51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 15 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
              17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
              34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
              51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 16 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
              17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
              34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
              51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 17 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
              17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
              34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
              51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 18 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
              17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
              34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
              51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 19 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
              17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
              34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
              51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 20 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
              17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
              34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
              51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 21 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
              17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
              34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
              51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 22 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
              17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
              34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
              51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 23 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
              17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
              34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
              51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 24 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
              17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
              34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
              51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 25 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
              17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
              34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
              51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 26 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
              17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
              34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
              51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 27 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
              17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
              34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
              51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 28 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
              17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
              34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
              51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 29 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
              17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
              34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
              51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 30 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
              17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
              34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
              51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 31 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
              17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
              34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
              51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 32 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
              17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
              34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
              51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 33 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
              17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
              34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
              51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 34 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
              17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
              34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
              51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 35 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
              17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
              34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
              51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 36 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
              17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
              34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
              51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 37 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
              17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
              34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
              51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 38 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
              17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
              34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
              51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 39 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
              17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
              34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
              51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 40 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
              17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
              34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
              51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 41 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
              17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
              34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
              51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 42 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
              17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
              34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
              51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 43 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
              17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
              34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
              51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64}};

static unsigned short unicode_upper_data0[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_upper_data1[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 0x0048, 0x0049, 0x004A, 0x004B,
    0x004C, 0x004D, 0x004E, 0x004F, 0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056,
    0x0057, 0x0058, 0x0059, 0x005A, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_upper_data2[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x039C, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_upper_data3[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x00C0,
    0x00C1, 0x00C2, 0x00C3, 0x00C4, 0x00C5, 0x00C6, 0x00C7, 0x00C8, 0x00C9, 0x00CA, 0x00CB,
    0x00CC, 0x00CD, 0x00CE, 0x00CF, 0x00D0, 0x00D1, 0x00D2, 0x00D3, 0x00D4, 0x00D5, 0x00D6,
    0xFFFF, 0x00D8, 0x00D9, 0x00DA, 0x00DB, 0x00DC, 0x00DD, 0x00DE, 0x0178};
static unsigned short unicode_upper_data4[] = {
    0xFFFF, 0x0100, 0xFFFF, 0x0102, 0xFFFF, 0x0104, 0xFFFF, 0x0106, 0xFFFF, 0x0108, 0xFFFF,
    0x010A, 0xFFFF, 0x010C, 0xFFFF, 0x010E, 0xFFFF, 0x0110, 0xFFFF, 0x0112, 0xFFFF, 0x0114,
    0xFFFF, 0x0116, 0xFFFF, 0x0118, 0xFFFF, 0x011A, 0xFFFF, 0x011C, 0xFFFF, 0x011E, 0xFFFF,
    0x0120, 0xFFFF, 0x0122, 0xFFFF, 0x0124, 0xFFFF, 0x0126, 0xFFFF, 0x0128, 0xFFFF, 0x012A,
    0xFFFF, 0x012C, 0xFFFF, 0x012E, 0xFFFF, 0x0049, 0xFFFF, 0x0132, 0xFFFF, 0x0134, 0xFFFF,
    0x0136, 0xFFFF, 0xFFFF, 0x0139, 0xFFFF, 0x013B, 0xFFFF, 0x013D, 0xFFFF};
static unsigned short unicode_upper_data5[] = {
    0x013F, 0xFFFF, 0x0141, 0xFFFF, 0x0143, 0xFFFF, 0x0145, 0xFFFF, 0x0147, 0xFFFF, 0xFFFF,
    0x014A, 0xFFFF, 0x014C, 0xFFFF, 0x014E, 0xFFFF, 0x0150, 0xFFFF, 0x0152, 0xFFFF, 0x0154,
    0xFFFF, 0x0156, 0xFFFF, 0x0158, 0xFFFF, 0x015A, 0xFFFF, 0x015C, 0xFFFF, 0x015E, 0xFFFF,
    0x0160, 0xFFFF, 0x0162, 0xFFFF, 0x0164, 0xFFFF, 0x0166, 0xFFFF, 0x0168, 0xFFFF, 0x016A,
    0xFFFF, 0x016C, 0xFFFF, 0x016E, 0xFFFF, 0x0170, 0xFFFF, 0x0172, 0xFFFF, 0x0174, 0xFFFF,
    0x0176, 0xFFFF, 0xFFFF, 0x0179, 0xFFFF, 0x017B, 0xFFFF, 0x017D, 0x0053};
static unsigned short unicode_upper_data6[] = {
    0x0243, 0xFFFF, 0xFFFF, 0x0182, 0xFFFF, 0x0184, 0xFFFF, 0xFFFF, 0x0187, 0xFFFF, 0xFFFF,
    0xFFFF, 0x018B, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0191, 0xFFFF, 0xFFFF, 0x01F6,
    0xFFFF, 0xFFFF, 0xFFFF, 0x0198, 0x023D, 0xFFFF, 0xFFFF, 0xFFFF, 0x0220, 0xFFFF, 0xFFFF,
    0x01A0, 0xFFFF, 0x01A2, 0xFFFF, 0x01A4, 0xFFFF, 0xFFFF, 0x01A7, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0x01AC, 0xFFFF, 0xFFFF, 0x01AF, 0xFFFF, 0xFFFF, 0xFFFF, 0x01B3, 0xFFFF, 0x01B5,
    0xFFFF, 0xFFFF, 0x01B8, 0xFFFF, 0xFFFF, 0xFFFF, 0x01BC, 0xFFFF, 0x01F7};
static unsigned short unicode_upper_data7[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x01C4, 0x01C4, 0xFFFF, 0x01C7, 0x01C7, 0xFFFF,
    0x01CA, 0x01CA, 0xFFFF, 0x01CD, 0xFFFF, 0x01CF, 0xFFFF, 0x01D1, 0xFFFF, 0x01D3, 0xFFFF,
    0x01D5, 0xFFFF, 0x01D7, 0xFFFF, 0x01D9, 0xFFFF, 0x01DB, 0x018E, 0xFFFF, 0x01DE, 0xFFFF,
    0x01E0, 0xFFFF, 0x01E2, 0xFFFF, 0x01E4, 0xFFFF, 0x01E6, 0xFFFF, 0x01E8, 0xFFFF, 0x01EA,
    0xFFFF, 0x01EC, 0xFFFF, 0x01EE, 0xFFFF, 0xFFFF, 0x01F1, 0x01F1, 0xFFFF, 0x01F4, 0xFFFF,
    0xFFFF, 0xFFFF, 0x01F8, 0xFFFF, 0x01FA, 0xFFFF, 0x01FC, 0xFFFF, 0x01FE};
static unsigned short unicode_upper_data8[] = {
    0xFFFF, 0x0200, 0xFFFF, 0x0202, 0xFFFF, 0x0204, 0xFFFF, 0x0206, 0xFFFF, 0x0208, 0xFFFF,
    0x020A, 0xFFFF, 0x020C, 0xFFFF, 0x020E, 0xFFFF, 0x0210, 0xFFFF, 0x0212, 0xFFFF, 0x0214,
    0xFFFF, 0x0216, 0xFFFF, 0x0218, 0xFFFF, 0x021A, 0xFFFF, 0x021C, 0xFFFF, 0x021E, 0xFFFF,
    0xFFFF, 0xFFFF, 0x0222, 0xFFFF, 0x0224, 0xFFFF, 0x0226, 0xFFFF, 0x0228, 0xFFFF, 0x022A,
    0xFFFF, 0x022C, 0xFFFF, 0x022E, 0xFFFF, 0x0230, 0xFFFF, 0x0232, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x023B, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_upper_data9[] = {
    0xFFFF, 0xFFFF, 0x0241, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0246, 0xFFFF, 0x0248, 0xFFFF,
    0x024A, 0xFFFF, 0x024C, 0xFFFF, 0x024E, 0x2C6F, 0x2C6D, 0xFFFF, 0x0181, 0x0186, 0xFFFF,
    0x0189, 0x018A, 0xFFFF, 0x018F, 0xFFFF, 0x0190, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0193,
    0xFFFF, 0xFFFF, 0x0194, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0197, 0x0196, 0xFFFF, 0x2C62,
    0xFFFF, 0xFFFF, 0xFFFF, 0x019C, 0xFFFF, 0x2C6E, 0x019D, 0xFFFF, 0xFFFF, 0x019F, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x2C64, 0xFFFF, 0xFFFF};
static unsigned short unicode_upper_data10[] = {
    0x01A6, 0xFFFF, 0xFFFF, 0x01A9, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x01AE, 0x0244, 0x01B1,
    0x01B2, 0x0245, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x01B7, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_upper_data11[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0399, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0370, 0xFFFF, 0x0372, 0xFFFF, 0xFFFF, 0xFFFF,
    0x0376, 0xFFFF, 0xFFFF, 0xFFFF, 0x03FD, 0x03FE, 0x03FF, 0xFFFF, 0xFFFF};
static unsigned short unicode_upper_data12[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0x0386, 0x0388, 0x0389, 0x038A, 0xFFFF, 0x0391, 0x0392, 0x0393, 0x0394, 0x0395, 0x0396,
    0x0397, 0x0398, 0x0399, 0x039A, 0x039B, 0x039C, 0x039D, 0x039E, 0x039F};
static unsigned short unicode_upper_data13[] = {
    0x03A0, 0x03A1, 0x03A3, 0x03A3, 0x03A4, 0x03A5, 0x03A6, 0x03A7, 0x03A8, 0x03A9, 0x03AA,
    0x03AB, 0x038C, 0x038E, 0x038F, 0xFFFF, 0x0392, 0x0398, 0xFFFF, 0xFFFF, 0xFFFF, 0x03A6,
    0x03A0, 0x03CF, 0xFFFF, 0x03D8, 0xFFFF, 0x03DA, 0xFFFF, 0x03DC, 0xFFFF, 0x03DE, 0xFFFF,
    0x03E0, 0xFFFF, 0x03E2, 0xFFFF, 0x03E4, 0xFFFF, 0x03E6, 0xFFFF, 0x03E8, 0xFFFF, 0x03EA,
    0xFFFF, 0x03EC, 0xFFFF, 0x03EE, 0x039A, 0x03A1, 0x03F9, 0xFFFF, 0xFFFF, 0x0395, 0xFFFF,
    0xFFFF, 0x03F7, 0xFFFF, 0xFFFF, 0x03FA, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_upper_data14[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0410, 0x0411, 0x0412, 0x0413, 0x0414, 0x0415, 0x0416,
    0x0417, 0x0418, 0x0419, 0x041A, 0x041B, 0x041C, 0x041D, 0x041E, 0x041F};
static unsigned short unicode_upper_data15[] = {
    0x0420, 0x0421, 0x0422, 0x0423, 0x0424, 0x0425, 0x0426, 0x0427, 0x0428, 0x0429, 0x042A,
    0x042B, 0x042C, 0x042D, 0x042E, 0x042F, 0x0400, 0x0401, 0x0402, 0x0403, 0x0404, 0x0405,
    0x0406, 0x0407, 0x0408, 0x0409, 0x040A, 0x040B, 0x040C, 0x040D, 0x040E, 0x040F, 0xFFFF,
    0x0460, 0xFFFF, 0x0462, 0xFFFF, 0x0464, 0xFFFF, 0x0466, 0xFFFF, 0x0468, 0xFFFF, 0x046A,
    0xFFFF, 0x046C, 0xFFFF, 0x046E, 0xFFFF, 0x0470, 0xFFFF, 0x0472, 0xFFFF, 0x0474, 0xFFFF,
    0x0476, 0xFFFF, 0x0478, 0xFFFF, 0x047A, 0xFFFF, 0x047C, 0xFFFF, 0x047E};
static unsigned short unicode_upper_data16[] = {
    0xFFFF, 0x0480, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0x048A, 0xFFFF, 0x048C, 0xFFFF, 0x048E, 0xFFFF, 0x0490, 0xFFFF, 0x0492, 0xFFFF, 0x0494,
    0xFFFF, 0x0496, 0xFFFF, 0x0498, 0xFFFF, 0x049A, 0xFFFF, 0x049C, 0xFFFF, 0x049E, 0xFFFF,
    0x04A0, 0xFFFF, 0x04A2, 0xFFFF, 0x04A4, 0xFFFF, 0x04A6, 0xFFFF, 0x04A8, 0xFFFF, 0x04AA,
    0xFFFF, 0x04AC, 0xFFFF, 0x04AE, 0xFFFF, 0x04B0, 0xFFFF, 0x04B2, 0xFFFF, 0x04B4, 0xFFFF,
    0x04B6, 0xFFFF, 0x04B8, 0xFFFF, 0x04BA, 0xFFFF, 0x04BC, 0xFFFF, 0x04BE};
static unsigned short unicode_upper_data17[] = {
    0xFFFF, 0xFFFF, 0x04C1, 0xFFFF, 0x04C3, 0xFFFF, 0x04C5, 0xFFFF, 0x04C7, 0xFFFF, 0x04C9,
    0xFFFF, 0x04CB, 0xFFFF, 0x04CD, 0x04C0, 0xFFFF, 0x04D0, 0xFFFF, 0x04D2, 0xFFFF, 0x04D4,
    0xFFFF, 0x04D6, 0xFFFF, 0x04D8, 0xFFFF, 0x04DA, 0xFFFF, 0x04DC, 0xFFFF, 0x04DE, 0xFFFF,
    0x04E0, 0xFFFF, 0x04E2, 0xFFFF, 0x04E4, 0xFFFF, 0x04E6, 0xFFFF, 0x04E8, 0xFFFF, 0x04EA,
    0xFFFF, 0x04EC, 0xFFFF, 0x04EE, 0xFFFF, 0x04F0, 0xFFFF, 0x04F2, 0xFFFF, 0x04F4, 0xFFFF,
    0x04F6, 0xFFFF, 0x04F8, 0xFFFF, 0x04FA, 0xFFFF, 0x04FC, 0xFFFF, 0x04FE};
static unsigned short unicode_upper_data18[] = {
    0xFFFF, 0x0500, 0xFFFF, 0x0502, 0xFFFF, 0x0504, 0xFFFF, 0x0506, 0xFFFF, 0x0508, 0xFFFF,
    0x050A, 0xFFFF, 0x050C, 0xFFFF, 0x050E, 0xFFFF, 0x0510, 0xFFFF, 0x0512, 0xFFFF, 0x0514,
    0xFFFF, 0x0516, 0xFFFF, 0x0518, 0xFFFF, 0x051A, 0xFFFF, 0x051C, 0xFFFF, 0x051E, 0xFFFF,
    0x0520, 0xFFFF, 0x0522, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_upper_data19[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0x0531, 0x0532, 0x0533, 0x0534, 0x0535, 0x0536, 0x0537, 0x0538, 0x0539, 0x053A, 0x053B,
    0x053C, 0x053D, 0x053E, 0x053F, 0x0540, 0x0541, 0x0542, 0x0543, 0x0544, 0x0545, 0x0546,
    0x0547, 0x0548, 0x0549, 0x054A, 0x054B, 0x054C, 0x054D, 0x054E, 0x054F};
static unsigned short unicode_upper_data20[] = {
    0x0550, 0x0551, 0x0552, 0x0553, 0x0554, 0x0555, 0x0556, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_upper_data21[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xA77D, 0xFFFF, 0xFFFF, 0xFFFF, 0x2C63, 0xFFFF, 0xFFFF};
static unsigned short unicode_upper_data22[] = {
    0xFFFF, 0x1E00, 0xFFFF, 0x1E02, 0xFFFF, 0x1E04, 0xFFFF, 0x1E06, 0xFFFF, 0x1E08, 0xFFFF,
    0x1E0A, 0xFFFF, 0x1E0C, 0xFFFF, 0x1E0E, 0xFFFF, 0x1E10, 0xFFFF, 0x1E12, 0xFFFF, 0x1E14,
    0xFFFF, 0x1E16, 0xFFFF, 0x1E18, 0xFFFF, 0x1E1A, 0xFFFF, 0x1E1C, 0xFFFF, 0x1E1E, 0xFFFF,
    0x1E20, 0xFFFF, 0x1E22, 0xFFFF, 0x1E24, 0xFFFF, 0x1E26, 0xFFFF, 0x1E28, 0xFFFF, 0x1E2A,
    0xFFFF, 0x1E2C, 0xFFFF, 0x1E2E, 0xFFFF, 0x1E30, 0xFFFF, 0x1E32, 0xFFFF, 0x1E34, 0xFFFF,
    0x1E36, 0xFFFF, 0x1E38, 0xFFFF, 0x1E3A, 0xFFFF, 0x1E3C, 0xFFFF, 0x1E3E};
static unsigned short unicode_upper_data23[] = {
    0xFFFF, 0x1E40, 0xFFFF, 0x1E42, 0xFFFF, 0x1E44, 0xFFFF, 0x1E46, 0xFFFF, 0x1E48, 0xFFFF,
    0x1E4A, 0xFFFF, 0x1E4C, 0xFFFF, 0x1E4E, 0xFFFF, 0x1E50, 0xFFFF, 0x1E52, 0xFFFF, 0x1E54,
    0xFFFF, 0x1E56, 0xFFFF, 0x1E58, 0xFFFF, 0x1E5A, 0xFFFF, 0x1E5C, 0xFFFF, 0x1E5E, 0xFFFF,
    0x1E60, 0xFFFF, 0x1E62, 0xFFFF, 0x1E64, 0xFFFF, 0x1E66, 0xFFFF, 0x1E68, 0xFFFF, 0x1E6A,
    0xFFFF, 0x1E6C, 0xFFFF, 0x1E6E, 0xFFFF, 0x1E70, 0xFFFF, 0x1E72, 0xFFFF, 0x1E74, 0xFFFF,
    0x1E76, 0xFFFF, 0x1E78, 0xFFFF, 0x1E7A, 0xFFFF, 0x1E7C, 0xFFFF, 0x1E7E};
static unsigned short unicode_upper_data24[] = {
    0xFFFF, 0x1E80, 0xFFFF, 0x1E82, 0xFFFF, 0x1E84, 0xFFFF, 0x1E86, 0xFFFF, 0x1E88, 0xFFFF,
    0x1E8A, 0xFFFF, 0x1E8C, 0xFFFF, 0x1E8E, 0xFFFF, 0x1E90, 0xFFFF, 0x1E92, 0xFFFF, 0x1E94,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x1E60, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0x1EA0, 0xFFFF, 0x1EA2, 0xFFFF, 0x1EA4, 0xFFFF, 0x1EA6, 0xFFFF, 0x1EA8, 0xFFFF, 0x1EAA,
    0xFFFF, 0x1EAC, 0xFFFF, 0x1EAE, 0xFFFF, 0x1EB0, 0xFFFF, 0x1EB2, 0xFFFF, 0x1EB4, 0xFFFF,
    0x1EB6, 0xFFFF, 0x1EB8, 0xFFFF, 0x1EBA, 0xFFFF, 0x1EBC, 0xFFFF, 0x1EBE};
static unsigned short unicode_upper_data25[] = {
    0xFFFF, 0x1EC0, 0xFFFF, 0x1EC2, 0xFFFF, 0x1EC4, 0xFFFF, 0x1EC6, 0xFFFF, 0x1EC8, 0xFFFF,
    0x1ECA, 0xFFFF, 0x1ECC, 0xFFFF, 0x1ECE, 0xFFFF, 0x1ED0, 0xFFFF, 0x1ED2, 0xFFFF, 0x1ED4,
    0xFFFF, 0x1ED6, 0xFFFF, 0x1ED8, 0xFFFF, 0x1EDA, 0xFFFF, 0x1EDC, 0xFFFF, 0x1EDE, 0xFFFF,
    0x1EE0, 0xFFFF, 0x1EE2, 0xFFFF, 0x1EE4, 0xFFFF, 0x1EE6, 0xFFFF, 0x1EE8, 0xFFFF, 0x1EEA,
    0xFFFF, 0x1EEC, 0xFFFF, 0x1EEE, 0xFFFF, 0x1EF0, 0xFFFF, 0x1EF2, 0xFFFF, 0x1EF4, 0xFFFF,
    0x1EF6, 0xFFFF, 0x1EF8, 0xFFFF, 0x1EFA, 0xFFFF, 0x1EFC, 0xFFFF, 0x1EFE};
static unsigned short unicode_upper_data26[] = {
    0x1F08, 0x1F09, 0x1F0A, 0x1F0B, 0x1F0C, 0x1F0D, 0x1F0E, 0x1F0F, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x1F18, 0x1F19, 0x1F1A, 0x1F1B, 0x1F1C, 0x1F1D,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x1F28,
    0x1F29, 0x1F2A, 0x1F2B, 0x1F2C, 0x1F2D, 0x1F2E, 0x1F2F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x1F38, 0x1F39, 0x1F3A, 0x1F3B, 0x1F3C, 0x1F3D, 0x1F3E,
    0x1F3F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_upper_data27[] = {
    0x1F48, 0x1F49, 0x1F4A, 0x1F4B, 0x1F4C, 0x1F4D, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x1F59, 0xFFFF, 0x1F5B, 0xFFFF, 0x1F5D,
    0xFFFF, 0x1F5F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x1F68,
    0x1F69, 0x1F6A, 0x1F6B, 0x1F6C, 0x1F6D, 0x1F6E, 0x1F6F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x1FBA, 0x1FBB, 0x1FC8, 0x1FC9, 0x1FCA, 0x1FCB, 0x1FDA,
    0x1FDB, 0x1FF8, 0x1FF9, 0x1FEA, 0x1FEB, 0x1FFA, 0x1FFB, 0xFFFF, 0xFFFF};
static unsigned short unicode_upper_data28[] = {
    0x1F88, 0x1F89, 0x1F8A, 0x1F8B, 0x1F8C, 0x1F8D, 0x1F8E, 0x1F8F, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x1F98, 0x1F99, 0x1F9A, 0x1F9B, 0x1F9C, 0x1F9D,
    0x1F9E, 0x1F9F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x1FA8,
    0x1FA9, 0x1FAA, 0x1FAB, 0x1FAC, 0x1FAD, 0x1FAE, 0x1FAF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x1FB8, 0x1FB9, 0xFFFF, 0x1FBC, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0399, 0xFFFF};
static unsigned short unicode_upper_data29[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0x1FCC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x1FD8, 0x1FD9, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x1FE8,
    0x1FE9, 0xFFFF, 0xFFFF, 0xFFFF, 0x1FEC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x1FFC, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_upper_data30[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0x2132, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x2160, 0x2161, 0x2162, 0x2163, 0x2164, 0x2165, 0x2166,
    0x2167, 0x2168, 0x2169, 0x216A, 0x216B, 0x216C, 0x216D, 0x216E, 0x216F};
static unsigned short unicode_upper_data31[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x2183, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_upper_data32[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x24B6, 0x24B7, 0x24B8, 0x24B9, 0x24BA, 0x24BB,
    0x24BC, 0x24BD, 0x24BE, 0x24BF, 0x24C0, 0x24C1, 0x24C2, 0x24C3, 0x24C4, 0x24C5, 0x24C6,
    0x24C7, 0x24C8, 0x24C9, 0x24CA, 0x24CB, 0x24CC, 0x24CD, 0x24CE, 0x24CF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_upper_data33[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x2C00, 0x2C01, 0x2C02, 0x2C03, 0x2C04, 0x2C05, 0x2C06,
    0x2C07, 0x2C08, 0x2C09, 0x2C0A, 0x2C0B, 0x2C0C, 0x2C0D, 0x2C0E, 0x2C0F};
static unsigned short unicode_upper_data34[] = {
    0x2C10, 0x2C11, 0x2C12, 0x2C13, 0x2C14, 0x2C15, 0x2C16, 0x2C17, 0x2C18, 0x2C19, 0x2C1A,
    0x2C1B, 0x2C1C, 0x2C1D, 0x2C1E, 0x2C1F, 0x2C20, 0x2C21, 0x2C22, 0x2C23, 0x2C24, 0x2C25,
    0x2C26, 0x2C27, 0x2C28, 0x2C29, 0x2C2A, 0x2C2B, 0x2C2C, 0x2C2D, 0x2C2E, 0xFFFF, 0xFFFF,
    0x2C60, 0xFFFF, 0xFFFF, 0xFFFF, 0x023A, 0x023E, 0xFFFF, 0x2C67, 0xFFFF, 0x2C69, 0xFFFF,
    0x2C6B, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x2C72, 0xFFFF, 0xFFFF, 0x2C75,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_upper_data35[] = {
    0xFFFF, 0x2C80, 0xFFFF, 0x2C82, 0xFFFF, 0x2C84, 0xFFFF, 0x2C86, 0xFFFF, 0x2C88, 0xFFFF,
    0x2C8A, 0xFFFF, 0x2C8C, 0xFFFF, 0x2C8E, 0xFFFF, 0x2C90, 0xFFFF, 0x2C92, 0xFFFF, 0x2C94,
    0xFFFF, 0x2C96, 0xFFFF, 0x2C98, 0xFFFF, 0x2C9A, 0xFFFF, 0x2C9C, 0xFFFF, 0x2C9E, 0xFFFF,
    0x2CA0, 0xFFFF, 0x2CA2, 0xFFFF, 0x2CA4, 0xFFFF, 0x2CA6, 0xFFFF, 0x2CA8, 0xFFFF, 0x2CAA,
    0xFFFF, 0x2CAC, 0xFFFF, 0x2CAE, 0xFFFF, 0x2CB0, 0xFFFF, 0x2CB2, 0xFFFF, 0x2CB4, 0xFFFF,
    0x2CB6, 0xFFFF, 0x2CB8, 0xFFFF, 0x2CBA, 0xFFFF, 0x2CBC, 0xFFFF, 0x2CBE};
static unsigned short unicode_upper_data36[] = {
    0xFFFF, 0x2CC0, 0xFFFF, 0x2CC2, 0xFFFF, 0x2CC4, 0xFFFF, 0x2CC6, 0xFFFF, 0x2CC8, 0xFFFF,
    0x2CCA, 0xFFFF, 0x2CCC, 0xFFFF, 0x2CCE, 0xFFFF, 0x2CD0, 0xFFFF, 0x2CD2, 0xFFFF, 0x2CD4,
    0xFFFF, 0x2CD6, 0xFFFF, 0x2CD8, 0xFFFF, 0x2CDA, 0xFFFF, 0x2CDC, 0xFFFF, 0x2CDE, 0xFFFF,
    0x2CE0, 0xFFFF, 0x2CE2, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_upper_data37[] = {
    0x10A0, 0x10A1, 0x10A2, 0x10A3, 0x10A4, 0x10A5, 0x10A6, 0x10A7, 0x10A8, 0x10A9, 0x10AA,
    0x10AB, 0x10AC, 0x10AD, 0x10AE, 0x10AF, 0x10B0, 0x10B1, 0x10B2, 0x10B3, 0x10B4, 0x10B5,
    0x10B6, 0x10B7, 0x10B8, 0x10B9, 0x10BA, 0x10BB, 0x10BC, 0x10BD, 0x10BE, 0x10BF, 0x10C0,
    0x10C1, 0x10C2, 0x10C3, 0x10C4, 0x10C5, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_upper_data38[] = {
    0xFFFF, 0xA640, 0xFFFF, 0xA642, 0xFFFF, 0xA644, 0xFFFF, 0xA646, 0xFFFF, 0xA648, 0xFFFF,
    0xA64A, 0xFFFF, 0xA64C, 0xFFFF, 0xA64E, 0xFFFF, 0xA650, 0xFFFF, 0xA652, 0xFFFF, 0xA654,
    0xFFFF, 0xA656, 0xFFFF, 0xA658, 0xFFFF, 0xA65A, 0xFFFF, 0xA65C, 0xFFFF, 0xA65E, 0xFFFF,
    0xFFFF, 0xFFFF, 0xA662, 0xFFFF, 0xA664, 0xFFFF, 0xA666, 0xFFFF, 0xA668, 0xFFFF, 0xA66A,
    0xFFFF, 0xA66C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_upper_data39[] = {
    0xFFFF, 0xA680, 0xFFFF, 0xA682, 0xFFFF, 0xA684, 0xFFFF, 0xA686, 0xFFFF, 0xA688, 0xFFFF,
    0xA68A, 0xFFFF, 0xA68C, 0xFFFF, 0xA68E, 0xFFFF, 0xA690, 0xFFFF, 0xA692, 0xFFFF, 0xA694,
    0xFFFF, 0xA696, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_upper_data40[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xA722, 0xFFFF, 0xA724, 0xFFFF, 0xA726, 0xFFFF, 0xA728, 0xFFFF, 0xA72A,
    0xFFFF, 0xA72C, 0xFFFF, 0xA72E, 0xFFFF, 0xFFFF, 0xFFFF, 0xA732, 0xFFFF, 0xA734, 0xFFFF,
    0xA736, 0xFFFF, 0xA738, 0xFFFF, 0xA73A, 0xFFFF, 0xA73C, 0xFFFF, 0xA73E};
static unsigned short unicode_upper_data41[] = {
    0xFFFF, 0xA740, 0xFFFF, 0xA742, 0xFFFF, 0xA744, 0xFFFF, 0xA746, 0xFFFF, 0xA748, 0xFFFF,
    0xA74A, 0xFFFF, 0xA74C, 0xFFFF, 0xA74E, 0xFFFF, 0xA750, 0xFFFF, 0xA752, 0xFFFF, 0xA754,
    0xFFFF, 0xA756, 0xFFFF, 0xA758, 0xFFFF, 0xA75A, 0xFFFF, 0xA75C, 0xFFFF, 0xA75E, 0xFFFF,
    0xA760, 0xFFFF, 0xA762, 0xFFFF, 0xA764, 0xFFFF, 0xA766, 0xFFFF, 0xA768, 0xFFFF, 0xA76A,
    0xFFFF, 0xA76C, 0xFFFF, 0xA76E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xA779, 0xFFFF, 0xA77B, 0xFFFF, 0xFFFF, 0xA77E};
static unsigned short unicode_upper_data42[] = {
    0xFFFF, 0xA780, 0xFFFF, 0xA782, 0xFFFF, 0xA784, 0xFFFF, 0xA786, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xA78B, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_upper_data43[] = {
    0xFFFF, 0xFF21, 0xFF22, 0xFF23, 0xFF24, 0xFF25, 0xFF26, 0xFF27, 0xFF28, 0xFF29, 0xFF2A,
    0xFF2B, 0xFF2C, 0xFF2D, 0xFF2E, 0xFF2F, 0xFF30, 0xFF31, 0xFF32, 0xFF33, 0xFF34, 0xFF35,
    0xFF36, 0xFF37, 0xFF38, 0xFF39, 0xFF3A, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};

static unsigned short* unicode_upper_data_table[UNICODE_UPPER_BLOCK_COUNT] = {
    unicode_upper_data0,  unicode_upper_data1,  unicode_upper_data2,  unicode_upper_data3,
    unicode_upper_data4,  unicode_upper_data5,  unicode_upper_data6,  unicode_upper_data7,
    unicode_upper_data8,  unicode_upper_data9,  unicode_upper_data10, unicode_upper_data11,
    unicode_upper_data12, unicode_upper_data13, unicode_upper_data14, unicode_upper_data15,
    unicode_upper_data16, unicode_upper_data17, unicode_upper_data18, unicode_upper_data19,
    unicode_upper_data20, unicode_upper_data21, unicode_upper_data22, unicode_upper_data23,
    unicode_upper_data24, unicode_upper_data25, unicode_upper_data26, unicode_upper_data27,
    unicode_upper_data28, unicode_upper_data29, unicode_upper_data30, unicode_upper_data31,
    unicode_upper_data32, unicode_upper_data33, unicode_upper_data34, unicode_upper_data35,
    unicode_upper_data36, unicode_upper_data37, unicode_upper_data38, unicode_upper_data39,
    unicode_upper_data40, unicode_upper_data41, unicode_upper_data42, unicode_upper_data43};
/* Generated by builder. Do not modify. End unicode_upper_tables */

SQLITE_EXPORT u16 sqlite3_unicode_upper(u16 c) {
    u16 index = unicode_upper_indexes[(c) >> UNICODE_UPPER_BLOCK_SHIFT];
    u8 position = (c)&UNICODE_UPPER_BLOCK_MASK;
    u16(p) = (unicode_upper_data_table[index][unicode_upper_positions[index][position]]);
    int l = unicode_upper_positions[index][position + 1] - unicode_upper_positions[index][position];

    return ((l == 1) && ((p) == 0xFFFF)) ? c : p;
}
#endif

#ifdef SQLITE3_UNICODE_TITLE
/* Generated by builder. Do not modify. Start unicode_title_defines */
#define UNICODE_TITLE_BLOCK_SHIFT 6
#define UNICODE_TITLE_BLOCK_MASK ((1 << UNICODE_TITLE_BLOCK_SHIFT) - 1)
#define UNICODE_TITLE_BLOCK_SIZE (1 << UNICODE_TITLE_BLOCK_SHIFT)
#define UNICODE_TITLE_BLOCK_COUNT 44
#define UNICODE_TITLE_INDEXES_SIZE (0x10000 >> UNICODE_TITLE_BLOCK_SHIFT)
/* Generated by builder. Do not modify. End unicode_title_defines */

/* Generated by builder. Do not modify. Start unicode_title_tables */

static unsigned short unicode_title_indexes[UNICODE_TITLE_INDEXES_SIZE] = {
    0, 1, 2, 3, 4, 5, 6, 7, 8, 9,  10, 0, 0,  11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 0, 0, 0,  0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0, 0,  0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0, 0,  0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0, 0,  0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 21, 0,  0, 22, 23, 24, 25, 26, 27, 28, 29, 0,  0,  0,  0, 0, 30, 31,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 32, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0, 0,  0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 0,  0,  33, 34, 35, 36, 37, 0,  0,  0,  0,  0, 0, 0,  0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0, 0,  0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0, 0,  0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0, 0,  0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0, 0,  0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0, 0,  0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0, 0,  0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0, 0,  0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0, 0,  0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0, 0,  0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0, 0,  0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0, 0,  0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0, 0,  0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0, 0,  0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0, 0,  0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0, 0,  0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0, 0,  0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0, 0,  0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 0,  0,  0,  0,  0,  38, 39, 0,  40, 41, 42, 0, 0, 0,  0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0, 0,  0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0, 0,  0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0, 0,  0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0, 0,  0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0, 0,  0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0, 0,  0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0, 0,  0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0, 0,  0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0, 0,  0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0, 0,  0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0, 0,  0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0, 0,  0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  43, 0, 0};

static unsigned char unicode_title_positions[UNICODE_TITLE_BLOCK_COUNT][UNICODE_TITLE_BLOCK_SIZE +
                                                                        1] = {
    /* 0 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
             22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43,
             44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 1 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
             22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43,
             44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 2 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
             22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43,
             44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 3 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
             22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43,
             44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 4 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
             22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43,
             44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 5 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
             22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43,
             44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 6 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
             22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43,
             44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 7 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
             22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43,
             44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 8 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
             22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43,
             44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 9 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
             22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43,
             44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 10 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
              17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
              34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
              51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 11 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
              17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
              34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
              51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 12 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
              17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
              34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
              51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 13 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
              17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
              34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
              51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 14 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
              17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
              34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
              51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 15 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
              17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
              34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
              51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 16 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
              17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
              34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
              51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 17 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
              17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
              34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
              51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 18 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
              17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
              34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
              51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 19 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
              17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
              34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
              51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 20 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
              17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
              34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
              51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 21 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
              17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
              34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
              51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 22 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
              17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
              34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
              51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 23 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
              17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
              34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
              51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 24 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
              17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
              34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
              51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 25 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
              17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
              34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
              51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 26 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
              17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
              34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
              51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 27 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
              17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
              34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
              51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 28 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
              17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
              34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
              51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 29 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
              17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
              34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
              51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 30 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
              17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
              34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
              51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 31 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
              17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
              34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
              51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 32 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
              17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
              34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
              51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 33 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
              17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
              34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
              51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 34 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
              17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
              34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
              51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 35 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
              17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
              34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
              51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 36 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
              17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
              34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
              51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 37 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
              17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
              34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
              51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 38 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
              17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
              34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
              51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 39 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
              17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
              34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
              51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 40 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
              17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
              34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
              51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 41 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
              17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
              34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
              51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 42 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
              17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
              34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
              51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64},
    /* 43 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
              17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
              34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
              51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64}};

static unsigned short unicode_title_data0[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_title_data1[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 0x0048, 0x0049, 0x004A, 0x004B,
    0x004C, 0x004D, 0x004E, 0x004F, 0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056,
    0x0057, 0x0058, 0x0059, 0x005A, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_title_data2[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x039C, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_title_data3[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x00C0,
    0x00C1, 0x00C2, 0x00C3, 0x00C4, 0x00C5, 0x00C6, 0x00C7, 0x00C8, 0x00C9, 0x00CA, 0x00CB,
    0x00CC, 0x00CD, 0x00CE, 0x00CF, 0x00D0, 0x00D1, 0x00D2, 0x00D3, 0x00D4, 0x00D5, 0x00D6,
    0xFFFF, 0x00D8, 0x00D9, 0x00DA, 0x00DB, 0x00DC, 0x00DD, 0x00DE, 0x0178};
static unsigned short unicode_title_data4[] = {
    0xFFFF, 0x0100, 0xFFFF, 0x0102, 0xFFFF, 0x0104, 0xFFFF, 0x0106, 0xFFFF, 0x0108, 0xFFFF,
    0x010A, 0xFFFF, 0x010C, 0xFFFF, 0x010E, 0xFFFF, 0x0110, 0xFFFF, 0x0112, 0xFFFF, 0x0114,
    0xFFFF, 0x0116, 0xFFFF, 0x0118, 0xFFFF, 0x011A, 0xFFFF, 0x011C, 0xFFFF, 0x011E, 0xFFFF,
    0x0120, 0xFFFF, 0x0122, 0xFFFF, 0x0124, 0xFFFF, 0x0126, 0xFFFF, 0x0128, 0xFFFF, 0x012A,
    0xFFFF, 0x012C, 0xFFFF, 0x012E, 0xFFFF, 0x0049, 0xFFFF, 0x0132, 0xFFFF, 0x0134, 0xFFFF,
    0x0136, 0xFFFF, 0xFFFF, 0x0139, 0xFFFF, 0x013B, 0xFFFF, 0x013D, 0xFFFF};
static unsigned short unicode_title_data5[] = {
    0x013F, 0xFFFF, 0x0141, 0xFFFF, 0x0143, 0xFFFF, 0x0145, 0xFFFF, 0x0147, 0xFFFF, 0xFFFF,
    0x014A, 0xFFFF, 0x014C, 0xFFFF, 0x014E, 0xFFFF, 0x0150, 0xFFFF, 0x0152, 0xFFFF, 0x0154,
    0xFFFF, 0x0156, 0xFFFF, 0x0158, 0xFFFF, 0x015A, 0xFFFF, 0x015C, 0xFFFF, 0x015E, 0xFFFF,
    0x0160, 0xFFFF, 0x0162, 0xFFFF, 0x0164, 0xFFFF, 0x0166, 0xFFFF, 0x0168, 0xFFFF, 0x016A,
    0xFFFF, 0x016C, 0xFFFF, 0x016E, 0xFFFF, 0x0170, 0xFFFF, 0x0172, 0xFFFF, 0x0174, 0xFFFF,
    0x0176, 0xFFFF, 0xFFFF, 0x0179, 0xFFFF, 0x017B, 0xFFFF, 0x017D, 0x0053};
static unsigned short unicode_title_data6[] = {
    0x0243, 0xFFFF, 0xFFFF, 0x0182, 0xFFFF, 0x0184, 0xFFFF, 0xFFFF, 0x0187, 0xFFFF, 0xFFFF,
    0xFFFF, 0x018B, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0191, 0xFFFF, 0xFFFF, 0x01F6,
    0xFFFF, 0xFFFF, 0xFFFF, 0x0198, 0x023D, 0xFFFF, 0xFFFF, 0xFFFF, 0x0220, 0xFFFF, 0xFFFF,
    0x01A0, 0xFFFF, 0x01A2, 0xFFFF, 0x01A4, 0xFFFF, 0xFFFF, 0x01A7, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0x01AC, 0xFFFF, 0xFFFF, 0x01AF, 0xFFFF, 0xFFFF, 0xFFFF, 0x01B3, 0xFFFF, 0x01B5,
    0xFFFF, 0xFFFF, 0x01B8, 0xFFFF, 0xFFFF, 0xFFFF, 0x01BC, 0xFFFF, 0x01F7};
static unsigned short unicode_title_data7[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x01C5, 0x01C5, 0x01C5, 0x01C8, 0x01C8, 0x01C8, 0x01CB,
    0x01CB, 0x01CB, 0xFFFF, 0x01CD, 0xFFFF, 0x01CF, 0xFFFF, 0x01D1, 0xFFFF, 0x01D3, 0xFFFF,
    0x01D5, 0xFFFF, 0x01D7, 0xFFFF, 0x01D9, 0xFFFF, 0x01DB, 0x018E, 0xFFFF, 0x01DE, 0xFFFF,
    0x01E0, 0xFFFF, 0x01E2, 0xFFFF, 0x01E4, 0xFFFF, 0x01E6, 0xFFFF, 0x01E8, 0xFFFF, 0x01EA,
    0xFFFF, 0x01EC, 0xFFFF, 0x01EE, 0xFFFF, 0x01F2, 0x01F2, 0x01F2, 0xFFFF, 0x01F4, 0xFFFF,
    0xFFFF, 0xFFFF, 0x01F8, 0xFFFF, 0x01FA, 0xFFFF, 0x01FC, 0xFFFF, 0x01FE};
static unsigned short unicode_title_data8[] = {
    0xFFFF, 0x0200, 0xFFFF, 0x0202, 0xFFFF, 0x0204, 0xFFFF, 0x0206, 0xFFFF, 0x0208, 0xFFFF,
    0x020A, 0xFFFF, 0x020C, 0xFFFF, 0x020E, 0xFFFF, 0x0210, 0xFFFF, 0x0212, 0xFFFF, 0x0214,
    0xFFFF, 0x0216, 0xFFFF, 0x0218, 0xFFFF, 0x021A, 0xFFFF, 0x021C, 0xFFFF, 0x021E, 0xFFFF,
    0xFFFF, 0xFFFF, 0x0222, 0xFFFF, 0x0224, 0xFFFF, 0x0226, 0xFFFF, 0x0228, 0xFFFF, 0x022A,
    0xFFFF, 0x022C, 0xFFFF, 0x022E, 0xFFFF, 0x0230, 0xFFFF, 0x0232, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x023B, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_title_data9[] = {
    0xFFFF, 0xFFFF, 0x0241, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0246, 0xFFFF, 0x0248, 0xFFFF,
    0x024A, 0xFFFF, 0x024C, 0xFFFF, 0x024E, 0x2C6F, 0x2C6D, 0xFFFF, 0x0181, 0x0186, 0xFFFF,
    0x0189, 0x018A, 0xFFFF, 0x018F, 0xFFFF, 0x0190, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0193,
    0xFFFF, 0xFFFF, 0x0194, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0197, 0x0196, 0xFFFF, 0x2C62,
    0xFFFF, 0xFFFF, 0xFFFF, 0x019C, 0xFFFF, 0x2C6E, 0x019D, 0xFFFF, 0xFFFF, 0x019F, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x2C64, 0xFFFF, 0xFFFF};
static unsigned short unicode_title_data10[] = {
    0x01A6, 0xFFFF, 0xFFFF, 0x01A9, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x01AE, 0x0244, 0x01B1,
    0x01B2, 0x0245, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x01B7, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_title_data11[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0399, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0370, 0xFFFF, 0x0372, 0xFFFF, 0xFFFF, 0xFFFF,
    0x0376, 0xFFFF, 0xFFFF, 0xFFFF, 0x03FD, 0x03FE, 0x03FF, 0xFFFF, 0xFFFF};
static unsigned short unicode_title_data12[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0x0386, 0x0388, 0x0389, 0x038A, 0xFFFF, 0x0391, 0x0392, 0x0393, 0x0394, 0x0395, 0x0396,
    0x0397, 0x0398, 0x0399, 0x039A, 0x039B, 0x039C, 0x039D, 0x039E, 0x039F};
static unsigned short unicode_title_data13[] = {
    0x03A0, 0x03A1, 0x03A3, 0x03A3, 0x03A4, 0x03A5, 0x03A6, 0x03A7, 0x03A8, 0x03A9, 0x03AA,
    0x03AB, 0x038C, 0x038E, 0x038F, 0xFFFF, 0x0392, 0x0398, 0xFFFF, 0xFFFF, 0xFFFF, 0x03A6,
    0x03A0, 0x03CF, 0xFFFF, 0x03D8, 0xFFFF, 0x03DA, 0xFFFF, 0x03DC, 0xFFFF, 0x03DE, 0xFFFF,
    0x03E0, 0xFFFF, 0x03E2, 0xFFFF, 0x03E4, 0xFFFF, 0x03E6, 0xFFFF, 0x03E8, 0xFFFF, 0x03EA,
    0xFFFF, 0x03EC, 0xFFFF, 0x03EE, 0x039A, 0x03A1, 0x03F9, 0xFFFF, 0xFFFF, 0x0395, 0xFFFF,
    0xFFFF, 0x03F7, 0xFFFF, 0xFFFF, 0x03FA, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_title_data14[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0410, 0x0411, 0x0412, 0x0413, 0x0414, 0x0415, 0x0416,
    0x0417, 0x0418, 0x0419, 0x041A, 0x041B, 0x041C, 0x041D, 0x041E, 0x041F};
static unsigned short unicode_title_data15[] = {
    0x0420, 0x0421, 0x0422, 0x0423, 0x0424, 0x0425, 0x0426, 0x0427, 0x0428, 0x0429, 0x042A,
    0x042B, 0x042C, 0x042D, 0x042E, 0x042F, 0x0400, 0x0401, 0x0402, 0x0403, 0x0404, 0x0405,
    0x0406, 0x0407, 0x0408, 0x0409, 0x040A, 0x040B, 0x040C, 0x040D, 0x040E, 0x040F, 0xFFFF,
    0x0460, 0xFFFF, 0x0462, 0xFFFF, 0x0464, 0xFFFF, 0x0466, 0xFFFF, 0x0468, 0xFFFF, 0x046A,
    0xFFFF, 0x046C, 0xFFFF, 0x046E, 0xFFFF, 0x0470, 0xFFFF, 0x0472, 0xFFFF, 0x0474, 0xFFFF,
    0x0476, 0xFFFF, 0x0478, 0xFFFF, 0x047A, 0xFFFF, 0x047C, 0xFFFF, 0x047E};
static unsigned short unicode_title_data16[] = {
    0xFFFF, 0x0480, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0x048A, 0xFFFF, 0x048C, 0xFFFF, 0x048E, 0xFFFF, 0x0490, 0xFFFF, 0x0492, 0xFFFF, 0x0494,
    0xFFFF, 0x0496, 0xFFFF, 0x0498, 0xFFFF, 0x049A, 0xFFFF, 0x049C, 0xFFFF, 0x049E, 0xFFFF,
    0x04A0, 0xFFFF, 0x04A2, 0xFFFF, 0x04A4, 0xFFFF, 0x04A6, 0xFFFF, 0x04A8, 0xFFFF, 0x04AA,
    0xFFFF, 0x04AC, 0xFFFF, 0x04AE, 0xFFFF, 0x04B0, 0xFFFF, 0x04B2, 0xFFFF, 0x04B4, 0xFFFF,
    0x04B6, 0xFFFF, 0x04B8, 0xFFFF, 0x04BA, 0xFFFF, 0x04BC, 0xFFFF, 0x04BE};
static unsigned short unicode_title_data17[] = {
    0xFFFF, 0xFFFF, 0x04C1, 0xFFFF, 0x04C3, 0xFFFF, 0x04C5, 0xFFFF, 0x04C7, 0xFFFF, 0x04C9,
    0xFFFF, 0x04CB, 0xFFFF, 0x04CD, 0x04C0, 0xFFFF, 0x04D0, 0xFFFF, 0x04D2, 0xFFFF, 0x04D4,
    0xFFFF, 0x04D6, 0xFFFF, 0x04D8, 0xFFFF, 0x04DA, 0xFFFF, 0x04DC, 0xFFFF, 0x04DE, 0xFFFF,
    0x04E0, 0xFFFF, 0x04E2, 0xFFFF, 0x04E4, 0xFFFF, 0x04E6, 0xFFFF, 0x04E8, 0xFFFF, 0x04EA,
    0xFFFF, 0x04EC, 0xFFFF, 0x04EE, 0xFFFF, 0x04F0, 0xFFFF, 0x04F2, 0xFFFF, 0x04F4, 0xFFFF,
    0x04F6, 0xFFFF, 0x04F8, 0xFFFF, 0x04FA, 0xFFFF, 0x04FC, 0xFFFF, 0x04FE};
static unsigned short unicode_title_data18[] = {
    0xFFFF, 0x0500, 0xFFFF, 0x0502, 0xFFFF, 0x0504, 0xFFFF, 0x0506, 0xFFFF, 0x0508, 0xFFFF,
    0x050A, 0xFFFF, 0x050C, 0xFFFF, 0x050E, 0xFFFF, 0x0510, 0xFFFF, 0x0512, 0xFFFF, 0x0514,
    0xFFFF, 0x0516, 0xFFFF, 0x0518, 0xFFFF, 0x051A, 0xFFFF, 0x051C, 0xFFFF, 0x051E, 0xFFFF,
    0x0520, 0xFFFF, 0x0522, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_title_data19[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0x0531, 0x0532, 0x0533, 0x0534, 0x0535, 0x0536, 0x0537, 0x0538, 0x0539, 0x053A, 0x053B,
    0x053C, 0x053D, 0x053E, 0x053F, 0x0540, 0x0541, 0x0542, 0x0543, 0x0544, 0x0545, 0x0546,
    0x0547, 0x0548, 0x0549, 0x054A, 0x054B, 0x054C, 0x054D, 0x054E, 0x054F};
static unsigned short unicode_title_data20[] = {
    0x0550, 0x0551, 0x0552, 0x0553, 0x0554, 0x0555, 0x0556, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_title_data21[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xA77D, 0xFFFF, 0xFFFF, 0xFFFF, 0x2C63, 0xFFFF, 0xFFFF};
static unsigned short unicode_title_data22[] = {
    0xFFFF, 0x1E00, 0xFFFF, 0x1E02, 0xFFFF, 0x1E04, 0xFFFF, 0x1E06, 0xFFFF, 0x1E08, 0xFFFF,
    0x1E0A, 0xFFFF, 0x1E0C, 0xFFFF, 0x1E0E, 0xFFFF, 0x1E10, 0xFFFF, 0x1E12, 0xFFFF, 0x1E14,
    0xFFFF, 0x1E16, 0xFFFF, 0x1E18, 0xFFFF, 0x1E1A, 0xFFFF, 0x1E1C, 0xFFFF, 0x1E1E, 0xFFFF,
    0x1E20, 0xFFFF, 0x1E22, 0xFFFF, 0x1E24, 0xFFFF, 0x1E26, 0xFFFF, 0x1E28, 0xFFFF, 0x1E2A,
    0xFFFF, 0x1E2C, 0xFFFF, 0x1E2E, 0xFFFF, 0x1E30, 0xFFFF, 0x1E32, 0xFFFF, 0x1E34, 0xFFFF,
    0x1E36, 0xFFFF, 0x1E38, 0xFFFF, 0x1E3A, 0xFFFF, 0x1E3C, 0xFFFF, 0x1E3E};
static unsigned short unicode_title_data23[] = {
    0xFFFF, 0x1E40, 0xFFFF, 0x1E42, 0xFFFF, 0x1E44, 0xFFFF, 0x1E46, 0xFFFF, 0x1E48, 0xFFFF,
    0x1E4A, 0xFFFF, 0x1E4C, 0xFFFF, 0x1E4E, 0xFFFF, 0x1E50, 0xFFFF, 0x1E52, 0xFFFF, 0x1E54,
    0xFFFF, 0x1E56, 0xFFFF, 0x1E58, 0xFFFF, 0x1E5A, 0xFFFF, 0x1E5C, 0xFFFF, 0x1E5E, 0xFFFF,
    0x1E60, 0xFFFF, 0x1E62, 0xFFFF, 0x1E64, 0xFFFF, 0x1E66, 0xFFFF, 0x1E68, 0xFFFF, 0x1E6A,
    0xFFFF, 0x1E6C, 0xFFFF, 0x1E6E, 0xFFFF, 0x1E70, 0xFFFF, 0x1E72, 0xFFFF, 0x1E74, 0xFFFF,
    0x1E76, 0xFFFF, 0x1E78, 0xFFFF, 0x1E7A, 0xFFFF, 0x1E7C, 0xFFFF, 0x1E7E};
static unsigned short unicode_title_data24[] = {
    0xFFFF, 0x1E80, 0xFFFF, 0x1E82, 0xFFFF, 0x1E84, 0xFFFF, 0x1E86, 0xFFFF, 0x1E88, 0xFFFF,
    0x1E8A, 0xFFFF, 0x1E8C, 0xFFFF, 0x1E8E, 0xFFFF, 0x1E90, 0xFFFF, 0x1E92, 0xFFFF, 0x1E94,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x1E60, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0x1EA0, 0xFFFF, 0x1EA2, 0xFFFF, 0x1EA4, 0xFFFF, 0x1EA6, 0xFFFF, 0x1EA8, 0xFFFF, 0x1EAA,
    0xFFFF, 0x1EAC, 0xFFFF, 0x1EAE, 0xFFFF, 0x1EB0, 0xFFFF, 0x1EB2, 0xFFFF, 0x1EB4, 0xFFFF,
    0x1EB6, 0xFFFF, 0x1EB8, 0xFFFF, 0x1EBA, 0xFFFF, 0x1EBC, 0xFFFF, 0x1EBE};
static unsigned short unicode_title_data25[] = {
    0xFFFF, 0x1EC0, 0xFFFF, 0x1EC2, 0xFFFF, 0x1EC4, 0xFFFF, 0x1EC6, 0xFFFF, 0x1EC8, 0xFFFF,
    0x1ECA, 0xFFFF, 0x1ECC, 0xFFFF, 0x1ECE, 0xFFFF, 0x1ED0, 0xFFFF, 0x1ED2, 0xFFFF, 0x1ED4,
    0xFFFF, 0x1ED6, 0xFFFF, 0x1ED8, 0xFFFF, 0x1EDA, 0xFFFF, 0x1EDC, 0xFFFF, 0x1EDE, 0xFFFF,
    0x1EE0, 0xFFFF, 0x1EE2, 0xFFFF, 0x1EE4, 0xFFFF, 0x1EE6, 0xFFFF, 0x1EE8, 0xFFFF, 0x1EEA,
    0xFFFF, 0x1EEC, 0xFFFF, 0x1EEE, 0xFFFF, 0x1EF0, 0xFFFF, 0x1EF2, 0xFFFF, 0x1EF4, 0xFFFF,
    0x1EF6, 0xFFFF, 0x1EF8, 0xFFFF, 0x1EFA, 0xFFFF, 0x1EFC, 0xFFFF, 0x1EFE};
static unsigned short unicode_title_data26[] = {
    0x1F08, 0x1F09, 0x1F0A, 0x1F0B, 0x1F0C, 0x1F0D, 0x1F0E, 0x1F0F, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x1F18, 0x1F19, 0x1F1A, 0x1F1B, 0x1F1C, 0x1F1D,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x1F28,
    0x1F29, 0x1F2A, 0x1F2B, 0x1F2C, 0x1F2D, 0x1F2E, 0x1F2F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x1F38, 0x1F39, 0x1F3A, 0x1F3B, 0x1F3C, 0x1F3D, 0x1F3E,
    0x1F3F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_title_data27[] = {
    0x1F48, 0x1F49, 0x1F4A, 0x1F4B, 0x1F4C, 0x1F4D, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x1F59, 0xFFFF, 0x1F5B, 0xFFFF, 0x1F5D,
    0xFFFF, 0x1F5F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x1F68,
    0x1F69, 0x1F6A, 0x1F6B, 0x1F6C, 0x1F6D, 0x1F6E, 0x1F6F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x1FBA, 0x1FBB, 0x1FC8, 0x1FC9, 0x1FCA, 0x1FCB, 0x1FDA,
    0x1FDB, 0x1FF8, 0x1FF9, 0x1FEA, 0x1FEB, 0x1FFA, 0x1FFB, 0xFFFF, 0xFFFF};
static unsigned short unicode_title_data28[] = {
    0x1F88, 0x1F89, 0x1F8A, 0x1F8B, 0x1F8C, 0x1F8D, 0x1F8E, 0x1F8F, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x1F98, 0x1F99, 0x1F9A, 0x1F9B, 0x1F9C, 0x1F9D,
    0x1F9E, 0x1F9F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x1FA8,
    0x1FA9, 0x1FAA, 0x1FAB, 0x1FAC, 0x1FAD, 0x1FAE, 0x1FAF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x1FB8, 0x1FB9, 0xFFFF, 0x1FBC, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0399, 0xFFFF};
static unsigned short unicode_title_data29[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0x1FCC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x1FD8, 0x1FD9, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x1FE8,
    0x1FE9, 0xFFFF, 0xFFFF, 0xFFFF, 0x1FEC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x1FFC, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_title_data30[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0x2132, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x2160, 0x2161, 0x2162, 0x2163, 0x2164, 0x2165, 0x2166,
    0x2167, 0x2168, 0x2169, 0x216A, 0x216B, 0x216C, 0x216D, 0x216E, 0x216F};
static unsigned short unicode_title_data31[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x2183, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_title_data32[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x24B6, 0x24B7, 0x24B8, 0x24B9, 0x24BA, 0x24BB,
    0x24BC, 0x24BD, 0x24BE, 0x24BF, 0x24C0, 0x24C1, 0x24C2, 0x24C3, 0x24C4, 0x24C5, 0x24C6,
    0x24C7, 0x24C8, 0x24C9, 0x24CA, 0x24CB, 0x24CC, 0x24CD, 0x24CE, 0x24CF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_title_data33[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x2C00, 0x2C01, 0x2C02, 0x2C03, 0x2C04, 0x2C05, 0x2C06,
    0x2C07, 0x2C08, 0x2C09, 0x2C0A, 0x2C0B, 0x2C0C, 0x2C0D, 0x2C0E, 0x2C0F};
static unsigned short unicode_title_data34[] = {
    0x2C10, 0x2C11, 0x2C12, 0x2C13, 0x2C14, 0x2C15, 0x2C16, 0x2C17, 0x2C18, 0x2C19, 0x2C1A,
    0x2C1B, 0x2C1C, 0x2C1D, 0x2C1E, 0x2C1F, 0x2C20, 0x2C21, 0x2C22, 0x2C23, 0x2C24, 0x2C25,
    0x2C26, 0x2C27, 0x2C28, 0x2C29, 0x2C2A, 0x2C2B, 0x2C2C, 0x2C2D, 0x2C2E, 0xFFFF, 0xFFFF,
    0x2C60, 0xFFFF, 0xFFFF, 0xFFFF, 0x023A, 0x023E, 0xFFFF, 0x2C67, 0xFFFF, 0x2C69, 0xFFFF,
    0x2C6B, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x2C72, 0xFFFF, 0xFFFF, 0x2C75,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_title_data35[] = {
    0xFFFF, 0x2C80, 0xFFFF, 0x2C82, 0xFFFF, 0x2C84, 0xFFFF, 0x2C86, 0xFFFF, 0x2C88, 0xFFFF,
    0x2C8A, 0xFFFF, 0x2C8C, 0xFFFF, 0x2C8E, 0xFFFF, 0x2C90, 0xFFFF, 0x2C92, 0xFFFF, 0x2C94,
    0xFFFF, 0x2C96, 0xFFFF, 0x2C98, 0xFFFF, 0x2C9A, 0xFFFF, 0x2C9C, 0xFFFF, 0x2C9E, 0xFFFF,
    0x2CA0, 0xFFFF, 0x2CA2, 0xFFFF, 0x2CA4, 0xFFFF, 0x2CA6, 0xFFFF, 0x2CA8, 0xFFFF, 0x2CAA,
    0xFFFF, 0x2CAC, 0xFFFF, 0x2CAE, 0xFFFF, 0x2CB0, 0xFFFF, 0x2CB2, 0xFFFF, 0x2CB4, 0xFFFF,
    0x2CB6, 0xFFFF, 0x2CB8, 0xFFFF, 0x2CBA, 0xFFFF, 0x2CBC, 0xFFFF, 0x2CBE};
static unsigned short unicode_title_data36[] = {
    0xFFFF, 0x2CC0, 0xFFFF, 0x2CC2, 0xFFFF, 0x2CC4, 0xFFFF, 0x2CC6, 0xFFFF, 0x2CC8, 0xFFFF,
    0x2CCA, 0xFFFF, 0x2CCC, 0xFFFF, 0x2CCE, 0xFFFF, 0x2CD0, 0xFFFF, 0x2CD2, 0xFFFF, 0x2CD4,
    0xFFFF, 0x2CD6, 0xFFFF, 0x2CD8, 0xFFFF, 0x2CDA, 0xFFFF, 0x2CDC, 0xFFFF, 0x2CDE, 0xFFFF,
    0x2CE0, 0xFFFF, 0x2CE2, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_title_data37[] = {
    0x10A0, 0x10A1, 0x10A2, 0x10A3, 0x10A4, 0x10A5, 0x10A6, 0x10A7, 0x10A8, 0x10A9, 0x10AA,
    0x10AB, 0x10AC, 0x10AD, 0x10AE, 0x10AF, 0x10B0, 0x10B1, 0x10B2, 0x10B3, 0x10B4, 0x10B5,
    0x10B6, 0x10B7, 0x10B8, 0x10B9, 0x10BA, 0x10BB, 0x10BC, 0x10BD, 0x10BE, 0x10BF, 0x10C0,
    0x10C1, 0x10C2, 0x10C3, 0x10C4, 0x10C5, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_title_data38[] = {
    0xFFFF, 0xA640, 0xFFFF, 0xA642, 0xFFFF, 0xA644, 0xFFFF, 0xA646, 0xFFFF, 0xA648, 0xFFFF,
    0xA64A, 0xFFFF, 0xA64C, 0xFFFF, 0xA64E, 0xFFFF, 0xA650, 0xFFFF, 0xA652, 0xFFFF, 0xA654,
    0xFFFF, 0xA656, 0xFFFF, 0xA658, 0xFFFF, 0xA65A, 0xFFFF, 0xA65C, 0xFFFF, 0xA65E, 0xFFFF,
    0xFFFF, 0xFFFF, 0xA662, 0xFFFF, 0xA664, 0xFFFF, 0xA666, 0xFFFF, 0xA668, 0xFFFF, 0xA66A,
    0xFFFF, 0xA66C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_title_data39[] = {
    0xFFFF, 0xA680, 0xFFFF, 0xA682, 0xFFFF, 0xA684, 0xFFFF, 0xA686, 0xFFFF, 0xA688, 0xFFFF,
    0xA68A, 0xFFFF, 0xA68C, 0xFFFF, 0xA68E, 0xFFFF, 0xA690, 0xFFFF, 0xA692, 0xFFFF, 0xA694,
    0xFFFF, 0xA696, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_title_data40[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xA722, 0xFFFF, 0xA724, 0xFFFF, 0xA726, 0xFFFF, 0xA728, 0xFFFF, 0xA72A,
    0xFFFF, 0xA72C, 0xFFFF, 0xA72E, 0xFFFF, 0xFFFF, 0xFFFF, 0xA732, 0xFFFF, 0xA734, 0xFFFF,
    0xA736, 0xFFFF, 0xA738, 0xFFFF, 0xA73A, 0xFFFF, 0xA73C, 0xFFFF, 0xA73E};
static unsigned short unicode_title_data41[] = {
    0xFFFF, 0xA740, 0xFFFF, 0xA742, 0xFFFF, 0xA744, 0xFFFF, 0xA746, 0xFFFF, 0xA748, 0xFFFF,
    0xA74A, 0xFFFF, 0xA74C, 0xFFFF, 0xA74E, 0xFFFF, 0xA750, 0xFFFF, 0xA752, 0xFFFF, 0xA754,
    0xFFFF, 0xA756, 0xFFFF, 0xA758, 0xFFFF, 0xA75A, 0xFFFF, 0xA75C, 0xFFFF, 0xA75E, 0xFFFF,
    0xA760, 0xFFFF, 0xA762, 0xFFFF, 0xA764, 0xFFFF, 0xA766, 0xFFFF, 0xA768, 0xFFFF, 0xA76A,
    0xFFFF, 0xA76C, 0xFFFF, 0xA76E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xA779, 0xFFFF, 0xA77B, 0xFFFF, 0xFFFF, 0xA77E};
static unsigned short unicode_title_data42[] = {
    0xFFFF, 0xA780, 0xFFFF, 0xA782, 0xFFFF, 0xA784, 0xFFFF, 0xA786, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xA78B, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_title_data43[] = {
    0xFFFF, 0xFF21, 0xFF22, 0xFF23, 0xFF24, 0xFF25, 0xFF26, 0xFF27, 0xFF28, 0xFF29, 0xFF2A,
    0xFF2B, 0xFF2C, 0xFF2D, 0xFF2E, 0xFF2F, 0xFF30, 0xFF31, 0xFF32, 0xFF33, 0xFF34, 0xFF35,
    0xFF36, 0xFF37, 0xFF38, 0xFF39, 0xFF3A, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};

static unsigned short* unicode_title_data_table[UNICODE_TITLE_BLOCK_COUNT] = {
    unicode_title_data0,  unicode_title_data1,  unicode_title_data2,  unicode_title_data3,
    unicode_title_data4,  unicode_title_data5,  unicode_title_data6,  unicode_title_data7,
    unicode_title_data8,  unicode_title_data9,  unicode_title_data10, unicode_title_data11,
    unicode_title_data12, unicode_title_data13, unicode_title_data14, unicode_title_data15,
    unicode_title_data16, unicode_title_data17, unicode_title_data18, unicode_title_data19,
    unicode_title_data20, unicode_title_data21, unicode_title_data22, unicode_title_data23,
    unicode_title_data24, unicode_title_data25, unicode_title_data26, unicode_title_data27,
    unicode_title_data28, unicode_title_data29, unicode_title_data30, unicode_title_data31,
    unicode_title_data32, unicode_title_data33, unicode_title_data34, unicode_title_data35,
    unicode_title_data36, unicode_title_data37, unicode_title_data38, unicode_title_data39,
    unicode_title_data40, unicode_title_data41, unicode_title_data42, unicode_title_data43};
/* Generated by builder. Do not modify. End unicode_title_tables */

SQLITE_EXPORT u16 sqlite3_unicode_title(u16 c) {
    u16 index = unicode_title_indexes[(c) >> UNICODE_TITLE_BLOCK_SHIFT];
    u8 position = (c)&UNICODE_TITLE_BLOCK_MASK;
    u16(p) = (unicode_title_data_table[index][unicode_title_positions[index][position]]);
    int l = unicode_title_positions[index][position + 1] - unicode_title_positions[index][position];

    return ((l == 1) && ((p) == 0xFFFF)) ? c : p;
}
#endif

#ifdef SQLITE3_UNICODE_UNACC
/* Generated by builder. Do not modify. Start unicode_unacc_defines */
#define UNICODE_UNACC_BLOCK_SHIFT 5
#define UNICODE_UNACC_BLOCK_MASK ((1 << UNICODE_UNACC_BLOCK_SHIFT) - 1)
#define UNICODE_UNACC_BLOCK_SIZE (1 << UNICODE_UNACC_BLOCK_SHIFT)
#define UNICODE_UNACC_BLOCK_COUNT 239
#define UNICODE_UNACC_INDEXES_SIZE (0x10000 >> UNICODE_UNACC_BLOCK_SHIFT)
/* Generated by builder. Do not modify. End unicode_unacc_defines */

/* Generated by builder. Do not modify. Start unicode_unacc_tables */

static unsigned short unicode_unacc_indexes[UNICODE_UNACC_INDEXES_SIZE] = {
    0,   0,   0,   0,   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,   10,  11,  12,  13,  14,
    15,  16,  17,  18,  19,  0,   0,   0,   20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,
    31,  32,  33,  34,  0,   0,   35,  0,   0,   0,   0,   36,  0,   37,  38,  39,  40,  41,  0,
    0,   42,  43,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   44,  45,  0,
    0,   0,   46,  47,  0,   48,  49,  0,   0,   0,   0,   0,   0,   0,   50,  0,   51,  0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   52,
    0,   0,   0,   53,  54,  0,   55,  0,   56,  57,  0,   0,   0,   0,   0,   58,  0,   0,   0,
    0,   0,   59,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   60,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   61,  62,  63,  64,  65,  66,  0,   0,   67,  68,  69,  70,  71,  72,  73,
    74,  75,  76,  77,  78,  79,  80,  81,  82,  83,  84,  85,  86,  87,  88,  0,   0,   89,  90,
    91,  92,  93,  94,  95,  96,  97,  98,  99,  100, 101, 102, 0,   103, 0,   104, 0,   105, 106,
    0,   107, 108, 0,   0,   0,   109, 110, 111, 112, 113, 0,   0,   0,   0,   0,   114, 0,   115,
    116, 0,   0,   0,   117, 0,   0,   0,   0,   0,   0,   0,   0,   0,   118, 119, 0,   0,   0,
    0,   0,   0,   0,   0,   120, 121, 122, 0,   123, 124, 125, 126, 127, 128, 129, 130, 131, 132,
    133, 134, 135, 136, 0,   0,   0,   0,   0,   0,   0,   137, 138, 139, 0,   0,   0,   0,   0,
    0,   0,   140, 0,   0,   0,   0,   141, 0,   0,   0,   142, 0,   0,   143, 144, 145, 146, 147,
    148, 149, 150, 0,   151, 152, 153, 154, 155, 156, 157, 158, 0,   159, 160, 161, 162, 0,   0,
    0,   163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    179, 0,   180, 0,   0,   0,   0,   181, 182, 183, 0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 185, 186,
    187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 0,   199, 200, 201, 202, 203, 204,
    205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223,
    224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238};

static unsigned char
    unicode_unacc_positions[UNICODE_UNACC_BLOCK_COUNT][UNICODE_UNACC_BLOCK_SIZE + 1] = {
        /* 0 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 1 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 31, 34, 37, 38},
        /* 2 */ {0,  1,  2,  3,  4,  5,  6,  8,  9,  10, 11, 12, 13, 14, 15, 16, 17,
                 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33},
        /* 3 */ {0,  1,  2,  3,  4,  5,  6,  8,  9,  10, 11, 12, 13, 14, 15, 16, 17,
                 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33},
        /* 4 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 5 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                 17, 18, 20, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 35},
        /* 6 */ {0,  2,  3,  4,  5,  6,  7,  8,  9,  10, 12, 13, 14, 15, 16, 17, 18,
                 19, 20, 22, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36},
        /* 7 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 8 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 9 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 10 */ {0,  1,  2,  3,  4,  6,  8,  10, 12, 14, 16, 18, 20, 22, 23, 24, 25,
                  26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41},
        /* 11 */ {0,  1,  2,  4,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16, 17, 18,
                  19, 21, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 35, 37, 38, 39},
        /* 12 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 13 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 14 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 15 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 16 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 17 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 18 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 19 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 20 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 21 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 22 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 23 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 24 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 25 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 26 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 27 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 28 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 29 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 30 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 31 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 32 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 33 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 34 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 35 */ {0,  1,  2,  3,  4,  5,  6,  7,  9,  10, 11, 12, 13, 14, 15, 16, 17,
                  18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33},
        /* 36 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 37 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 23, 25, 27, 29, 30, 31, 32, 33, 34, 35, 36},
        /* 38 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 39 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 40 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 41 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 42 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 43 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 44 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 45 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 46 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 47 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 48 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 49 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 50 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 51 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 52 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 53 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 54 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 30, 32, 33, 34},
        /* 55 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 56 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 57 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 58 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 59 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 60 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 61 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 62 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 15, 16, 17,
                  18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33},
        /* 63 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 64 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 65 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 66 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 67 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 68 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 69 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 70 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 71 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 28, 29, 30, 31, 32, 33},
        /* 72 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 73 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 74 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 75 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 76 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 77 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 78 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 79 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 80 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 81 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 82 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 83 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 84 */ {0,  1,  2,  3,  4,  5,  7,  10, 11, 12, 13, 14, 15, 16, 17, 18, 19,
                  20, 21, 22, 24, 27, 28, 30, 33, 34, 35, 36, 37, 39, 40, 41, 42},
        /* 85 */ {0,  1,  2,  3,  4,  5,  6,  7,  9,  11, 13, 14, 15, 16, 17, 18, 19,
                  20, 21, 22, 23, 24, 25, 26, 30, 31, 32, 33, 34, 35, 36, 37, 38},
        /* 86 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 87 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 88 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  10, 11, 12, 13, 14, 15, 16, 17,
                  18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33},
        /* 89 */ {0,  3,  6,  7,  9,  10, 13, 16, 17, 18, 20, 21, 22, 23, 24, 25, 26,
                  27, 28, 29, 30, 31, 32, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43},
        /* 90 */ {0,  2,  5,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20,
                  21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 34, 35, 36, 37, 38},
        /* 91 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 22, 25, 28, 31, 34, 37, 40, 43, 46, 49, 52, 55, 57},
        /* 92 */ {0,  1,  3,  6,  8,  9,  11, 14, 18, 20, 21, 23, 26, 27, 28, 29, 30,
                  31, 33, 36, 38, 39, 41, 44, 48, 50, 51, 53, 56, 57, 58, 59, 60},
        /* 93 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 94 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 95 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 96 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 97 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 98 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 14, 17, 18, 20,
                  23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38},
        /* 99 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                  17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 100 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 101 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 102 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 103 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 104 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 105 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 106 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 107 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 108 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 109 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  11, 13, 15, 17, 19, 21, 23,
                   25, 27, 29, 31, 34, 37, 40, 43, 46, 49, 52, 55, 58, 62, 66, 70},
        /* 110 */ {0,  4,  8,  12, 16, 20, 24, 28, 32, 34, 36, 38, 40, 42, 44, 46, 48,
                   50, 53, 56, 59, 62, 65, 68, 71, 74, 77, 80, 83, 86, 89, 92, 95},
        /* 111 */ {0,  3,  6,  9,  12, 15, 18, 21, 24, 27, 30, 33, 36, 39, 42, 45, 48,
                   51, 54, 57, 60, 63, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76},
        /* 112 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 113 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 114 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 115 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 116 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 117 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 118 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 119 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 120 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 121 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 122 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 123 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 124 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 125 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 126 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 127 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 16, 17, 18, 19,
                   20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35},
        /* 128 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 129 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 130 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 23, 25, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37},
        /* 131 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 132 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 133 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 134 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 135 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 136 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 137 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 138 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 139 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 140 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 141 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 142 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 143 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 144 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 145 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 146 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 147 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 148 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 149 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 150 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 151 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 152 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 153 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 154 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 155 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 33},
        /* 156 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 157 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 158 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 33},
        /* 159 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 160 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 161 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 162 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 163 */ {0,  3,  6,  9,  12, 15, 18, 21, 24, 27, 30, 33, 36,  39,  42,  46, 50,
                   54, 58, 62, 66, 70, 74, 78, 82, 86, 90, 94, 98, 102, 109, 115, 116},
        /* 164 */ {0,  3,  6,  9,  12, 15, 18, 21, 24, 27, 30, 33, 36, 39, 42, 45, 48,
                   51, 54, 57, 60, 63, 66, 69, 72, 75, 78, 81, 84, 87, 90, 93, 96},
        /* 165 */ {0,  3,  6,  9,  12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24,
                   27, 29, 31, 33, 35, 37, 39, 41, 43, 45, 47, 49, 51, 53, 55, 57},
        /* 166 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 16, 18,
                   20, 22, 24, 26, 28, 30, 32, 34, 36, 38, 40, 42, 47, 51, 53, 54},
        /* 167 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 168 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 19, 21, 23, 25, 27, 29, 31, 33, 35, 37, 39, 41, 43, 45, 47},
        /* 169 */ {0,  2,  4,  6,  8,  10, 12, 14, 16, 18, 21, 24, 27, 29, 32, 34, 37,
                   38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53},
        /* 170 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 171 */ {0,  4,  8,  12, 15, 19, 22, 25, 30, 34, 37,  40,  43,  47,  51,  54, 57,
                   59, 62, 66, 70, 72, 77, 83, 88, 91, 96, 101, 105, 108, 111, 114, 118},
        /* 172 */ {0,  5,  9,  12, 15, 18, 20, 22, 24, 26, 29, 32, 37, 40, 44,  49, 52,
                   54, 56, 61, 65, 70, 73, 78, 80, 83, 86, 89, 92, 95, 99, 102, 104},
        /* 173 */ {0,  3,  6,  9,  13, 16, 19, 22, 27, 31, 33, 38, 40, 44, 48, 51, 54,
                   57, 61, 63, 66, 70, 72, 77, 80, 82, 84, 86, 88, 90, 92, 94, 96},
        /* 174 */ {0,  2,  4,  7,  10, 13, 16, 19, 22, 25, 28, 31, 34, 37, 40, 43, 46,
                   49, 52, 54, 56, 59, 61, 63, 65, 68, 71, 73, 75, 77, 79, 81, 85},
        /* 175 */ {0,  2,  4,  6,  8,  10, 12, 14, 16, 19, 23, 25, 27, 29, 31, 33, 35,
                   37, 40, 43, 46, 49, 51, 53, 55, 57, 59, 61, 63, 65, 67, 69, 72},
        /* 176 */ {0,  3,  5,  8,  11, 14, 16, 19, 22, 26, 28, 31, 34, 37, 40, 45, 51,
                   53, 55, 57, 59, 61, 63, 65, 67, 69, 71, 73, 75, 77, 79, 81, 83},
        /* 177 */ {0,  2,  4,  8,  10, 12, 14, 18, 21, 23, 25, 27, 29, 31, 33, 35, 37,
                   39, 41, 44, 46, 48, 51, 54, 56, 60, 63, 65, 67, 69, 71, 74, 77},
        /* 178 */ {0,  2,  4,  6,  8,  10, 12, 14, 16, 18, 21, 24, 27, 30, 33, 36, 39,
                   42, 45, 48, 51, 54, 57, 60, 63, 66, 69, 72, 75, 78, 81, 84, 87},
        /* 179 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 180 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 181 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 182 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 183 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 184 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 185 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 186 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 187 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 188 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 189 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 190 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 191 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 192 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 193 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 194 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 195 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 196 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 197 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 198 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 199 */ {0,  2,  4,  6,  9,  12, 14, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25,
                   26, 27, 28, 30, 32, 34, 36, 38, 39, 40, 41, 42, 43, 44, 45, 46},
        /* 200 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 201 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 17,
                   18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33},
        /* 202 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 203 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 204 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 205 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 31, 32, 33},
        /* 206 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 12, 14, 16, 18, 20, 22,
                   24, 26, 28, 30, 32, 34, 36, 38, 40, 42, 44, 46, 47, 48, 49, 50},
        /* 207 */ {0,  2,  4,  6,  8,  10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32,
                   34, 36, 38, 40, 42, 44, 46, 48, 50, 52, 54, 56, 58, 60, 62, 64},
        /* 208 */ {0,  2,  4,  6,  8,  10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32,
                   34, 36, 38, 40, 42, 44, 46, 48, 50, 52, 54, 56, 58, 60, 62, 64},
        /* 209 */ {0,  2,  4,  6,  8,  10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32,
                   34, 36, 38, 40, 42, 44, 46, 48, 50, 52, 54, 55, 56, 57, 58, 59},
        /* 210 */ {0,  1,  2,  3,  4,  6,  8,  10, 12, 14, 16, 18, 20, 22, 24, 26, 28,
                   30, 32, 34, 36, 38, 40, 42, 44, 46, 48, 50, 52, 54, 56, 58, 60},
        /* 211 */ {0,  2,  4,  6,  8,  10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32,
                   33, 35, 37, 39, 41, 43, 45, 47, 49, 51, 53, 55, 57, 59, 61, 63},
        /* 212 */ {0,  2,  4,  6,  8,  10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32,
                   34, 36, 38, 40, 42, 44, 46, 48, 50, 52, 54, 56, 58, 60, 62, 64},
        /* 213 */ {0,  2,  4,  6,  8,  10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32,
                   34, 36, 38, 40, 42, 44, 46, 48, 50, 51, 53, 55, 57, 59, 61, 63},
        /* 214 */ {0,  2,  4,  6,  8,  10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32,
                   34, 36, 37, 38, 39, 41, 43, 45, 47, 49, 51, 53, 55, 57, 59, 61},
        /* 215 */ {0,  2,  4,  6,  8,  10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32,
                   34, 36, 38, 40, 42, 44, 46, 48, 50, 52, 54, 56, 58, 60, 62, 64},
        /* 216 */ {0,  2,  4,  6,  8,  10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32,
                   34, 36, 38, 40, 42, 44, 46, 48, 50, 52, 54, 56, 57, 58, 59, 60},
        /* 217 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   19, 22, 25, 28, 31, 34, 37, 40, 43, 46, 49, 52, 55, 58, 61, 64},
        /* 218 */ {0,  3,  6,  9,  12, 15, 18, 21, 24, 27, 30, 33, 36, 39, 42, 45, 48,
                   51, 54, 57, 60, 63, 66, 69, 72, 75, 78, 81, 84, 87, 90, 93, 96},
        /* 219 */ {0,  3,  6,  9,  12, 15, 18, 21, 24, 27, 30, 33, 36, 39, 42, 45, 48,
                   49, 50, 53, 56, 59, 62, 65, 68, 71, 74, 77, 80, 83, 86, 89, 92},
        /* 220 */ {0,  3,  6,  9,  12, 15, 18, 21, 24, 27, 30, 33, 36, 39, 42, 45, 48,
                   51, 54, 57, 60, 63, 66, 69, 72, 75, 78, 81, 84, 87, 90, 93, 96},
        /* 221 */ {0,  3,  6,  9,  12, 15, 18, 21, 24, 25, 26, 27, 28, 29, 30, 31, 32,
                   33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48},
        /* 222 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   19, 22, 26, 30, 34, 38, 42, 46, 50, 53, 71, 79, 83, 84, 85, 86},
        /* 223 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34},
        /* 224 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33},
        /* 225 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 226 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 227 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 228 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 229 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 230 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 23, 25, 27, 29, 31, 33, 35, 37, 38, 39, 40},
        /* 231 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 232 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 233 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 234 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 235 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 236 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 237 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32},
        /* 238 */ {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 16,
                   17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32}};

static unsigned short unicode_unacc_data0[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data1[] = {
    0x0020, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0020, 0xFFFF,
    0x0061, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0020, 0xFFFF, 0xFFFF, 0x0032, 0x0033,
    0x0020, 0x03BC, 0xFFFF, 0xFFFF, 0x0020, 0x0031, 0x006F, 0xFFFF, 0x0031, 0x2044,
    0x0034, 0x0031, 0x2044, 0x0032, 0x0033, 0x2044, 0x0034, 0xFFFF};
static unsigned short unicode_unacc_data2[] = {
    0x0041, 0x0041, 0x0041, 0x0041, 0x0041, 0x0041, 0x0041, 0x0045, 0x0043, 0x0045, 0x0045,
    0x0045, 0x0045, 0x0049, 0x0049, 0x0049, 0x0049, 0xFFFF, 0x004E, 0x004F, 0x004F, 0x004F,
    0x004F, 0x004F, 0xFFFF, 0x004F, 0x0055, 0x0055, 0x0055, 0x0055, 0x0059, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data3[] = {
    0x0061, 0x0061, 0x0061, 0x0061, 0x0061, 0x0061, 0x0061, 0x0065, 0x0063, 0x0065, 0x0065,
    0x0065, 0x0065, 0x0069, 0x0069, 0x0069, 0x0069, 0xFFFF, 0x006E, 0x006F, 0x006F, 0x006F,
    0x006F, 0x006F, 0xFFFF, 0x006F, 0x0075, 0x0075, 0x0075, 0x0075, 0x0079, 0xFFFF, 0x0079};
static unsigned short unicode_unacc_data4[] = {
    0x0041, 0x0061, 0x0041, 0x0061, 0x0041, 0x0061, 0x0043, 0x0063, 0x0043, 0x0063, 0x0043,
    0x0063, 0x0043, 0x0063, 0x0044, 0x0064, 0x0044, 0x0064, 0x0045, 0x0065, 0x0045, 0x0065,
    0x0045, 0x0065, 0x0045, 0x0065, 0x0045, 0x0065, 0x0047, 0x0067, 0x0047, 0x0067};
static unsigned short unicode_unacc_data5[] = {
    0x0047, 0x0067, 0x0047, 0x0067, 0x0048, 0x0068, 0x0048, 0x0068, 0x0049, 0x0069, 0x0049, 0x0069,
    0x0049, 0x0069, 0x0049, 0x0069, 0x0049, 0xFFFF, 0x0049, 0x004A, 0x0069, 0x006A, 0x004A, 0x006A,
    0x004B, 0x006B, 0xFFFF, 0x004C, 0x006C, 0x004C, 0x006C, 0x004C, 0x006C, 0x004C, 0x00B7};
static unsigned short unicode_unacc_data6[] = {
    0x006C, 0x00B7, 0x004C, 0x006C, 0x004E, 0x006E, 0x004E, 0x006E, 0x004E, 0x006E, 0x02BC, 0x006E,
    0xFFFF, 0xFFFF, 0x004F, 0x006F, 0x004F, 0x006F, 0x004F, 0x006F, 0x004F, 0x0045, 0x006F, 0x0065,
    0x0052, 0x0072, 0x0052, 0x0072, 0x0052, 0x0072, 0x0053, 0x0073, 0x0053, 0x0073, 0x0053, 0x0073};
static unsigned short unicode_unacc_data7[] = {
    0x0053, 0x0073, 0x0054, 0x0074, 0x0054, 0x0074, 0x0054, 0x0074, 0x0055, 0x0075, 0x0055,
    0x0075, 0x0055, 0x0075, 0x0055, 0x0075, 0x0055, 0x0075, 0x0055, 0x0075, 0x0057, 0x0077,
    0x0059, 0x0079, 0x0059, 0x005A, 0x007A, 0x005A, 0x007A, 0x005A, 0x007A, 0x0073};
static unsigned short unicode_unacc_data8[] = {
    0x0062, 0x0042, 0x0042, 0x0062, 0xFFFF, 0xFFFF, 0xFFFF, 0x0043, 0x0063, 0xFFFF, 0x0044,
    0x0044, 0x0064, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0046, 0x0066, 0x0047, 0xFFFF, 0xFFFF,
    0xFFFF, 0x0049, 0x004B, 0x006B, 0x006C, 0xFFFF, 0xFFFF, 0x004E, 0x006E, 0x004F};
static unsigned short unicode_unacc_data9[] = {
    0x004F, 0x006F, 0xFFFF, 0xFFFF, 0x0050, 0x0070, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0x0074, 0x0054, 0x0074, 0x0054, 0x0055, 0x0075, 0xFFFF, 0x0056, 0x0059, 0x0079, 0x005A,
    0x007A, 0xFFFF, 0xFFFF, 0xFFFF, 0x0292, 0xFFFF, 0xFFFF, 0xFFFF, 0x0296, 0xFFFF};
static unsigned short unicode_unacc_data10[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0044, 0x005A, 0x0044, 0x007A, 0x0064, 0x007A, 0x004C,
    0x004A, 0x004C, 0x006A, 0x006C, 0x006A, 0x004E, 0x004A, 0x004E, 0x006A, 0x006E, 0x006A,
    0x0041, 0x0061, 0x0049, 0x0069, 0x004F, 0x006F, 0x0055, 0x0075, 0x0055, 0x0075, 0x0055,
    0x0075, 0x0055, 0x0075, 0x0055, 0x0075, 0xFFFF, 0x0041, 0x0061};
static unsigned short unicode_unacc_data11[] = {
    0x0041, 0x0061, 0x0041, 0x0045, 0x0061, 0x0065, 0x0047, 0x0067, 0x0047, 0x0067,
    0x004B, 0x006B, 0x004F, 0x006F, 0x004F, 0x006F, 0x01B7, 0x0292, 0x006A, 0x0044,
    0x005A, 0x0044, 0x007A, 0x0064, 0x007A, 0x0047, 0x0067, 0xFFFF, 0xFFFF, 0x004E,
    0x006E, 0x0041, 0x0061, 0x0041, 0x0045, 0x0061, 0x0065, 0x004F, 0x006F};
static unsigned short unicode_unacc_data12[] = {
    0x0041, 0x0061, 0x0041, 0x0061, 0x0045, 0x0065, 0x0045, 0x0065, 0x0049, 0x0069, 0x0049,
    0x0069, 0x004F, 0x006F, 0x004F, 0x006F, 0x0052, 0x0072, 0x0052, 0x0072, 0x0055, 0x0075,
    0x0055, 0x0075, 0x0053, 0x0073, 0x0054, 0x0074, 0xFFFF, 0xFFFF, 0x0048, 0x0068};
static unsigned short unicode_unacc_data13[] = {
    0x004E, 0x0064, 0xFFFF, 0xFFFF, 0x005A, 0x007A, 0x0041, 0x0061, 0x0045, 0x0065, 0x004F,
    0x006F, 0x004F, 0x006F, 0x004F, 0x006F, 0x004F, 0x006F, 0x0059, 0x0079, 0x006C, 0x006E,
    0x0074, 0xFFFF, 0xFFFF, 0xFFFF, 0x0041, 0x0043, 0x0063, 0x004C, 0x0054, 0x0073};
static unsigned short unicode_unacc_data14[] = {
    0x007A, 0xFFFF, 0xFFFF, 0x0042, 0xFFFF, 0xFFFF, 0x0045, 0x0065, 0x004A, 0x006A, 0xFFFF,
    0x0071, 0x0052, 0x0072, 0x0059, 0x0079, 0xFFFF, 0xFFFF, 0xFFFF, 0x0062, 0xFFFF, 0x0063,
    0x0064, 0x0064, 0xFFFF, 0xFFFF, 0x0259, 0xFFFF, 0xFFFF, 0x025C, 0xFFFF, 0x0237};
static unsigned short unicode_unacc_data15[] = {
    0x0067, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0068, 0xA727, 0x0069, 0xFFFF, 0xFFFF,
    0x006C, 0x006C, 0x006C, 0xFFFF, 0xFFFF, 0x026F, 0x006D, 0x006E, 0x006E, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0279, 0x0279, 0x0072, 0x0072, 0x0072, 0xFFFF};
static unsigned short unicode_unacc_data16[] = {
    0xFFFF, 0xFFFF, 0x0073, 0xFFFF, 0x0237, 0xFFFF, 0x0283, 0xFFFF, 0x0074, 0xFFFF, 0xFFFF,
    0x0076, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x007A, 0x007A, 0xFFFF, 0x0292, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0262, 0xFFFF, 0x006A, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data17[] = {
    0x0071, 0x0294, 0xFFFF, 0xFFFF, 0xFFFF, 0x02A3, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0x0265, 0x0265, 0x0068, 0x0068, 0x006A, 0x0072, 0x0279, 0x0279,
    0x0281, 0x0077, 0x0079, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data18[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data19[] = {
    0x0263, 0x006C, 0x0073, 0x0078, 0x0295, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data20[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x02B9, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0020, 0xFFFF, 0xFFFF, 0xFFFF, 0x003B, 0xFFFF};
static unsigned short unicode_unacc_data21[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0020, 0x0020, 0x0391, 0x00B7, 0x0395, 0x0397, 0x0399,
    0xFFFF, 0x039F, 0xFFFF, 0x03A5, 0x03A9, 0x03B9, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data22[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0399,
    0x03A5, 0x03B1, 0x03B5, 0x03B7, 0x03B9, 0x03C5, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data23[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x03B9,
    0x03C5, 0x03BF, 0x03C5, 0x03C9, 0xFFFF, 0x03B2, 0x03B8, 0x03A5, 0x03A5, 0x03A5, 0x03C6,
    0x03C0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data24[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x03BA, 0x03C1, 0x03C2, 0xFFFF, 0x0398, 0x03B5,
    0xFFFF, 0xFFFF, 0xFFFF, 0x03A3, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data25[] = {
    0x0415, 0x0415, 0xFFFF, 0x0413, 0xFFFF, 0xFFFF, 0xFFFF, 0x0406, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0x041A, 0x0418, 0x0423, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0x0418, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data26[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0x0438, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data27[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0435, 0x0435, 0xFFFF, 0x0433, 0xFFFF, 0xFFFF,
    0xFFFF, 0x0456, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x043A, 0x0438, 0x0443, 0xFFFF};
static unsigned short unicode_unacc_data28[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0x0474, 0x0475, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0460, 0x0461, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data29[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0418,
    0x0438, 0xFFFF, 0xFFFF, 0x0420, 0x0440, 0x0413, 0x0433, 0x0413, 0x0433, 0x0413, 0x0433,
    0x0416, 0x0436, 0x0417, 0x0437, 0x041A, 0x043A, 0x041A, 0x043A, 0x041A, 0x043A};
static unsigned short unicode_unacc_data30[] = {
    0xFFFF, 0xFFFF, 0x041D, 0x043D, 0xFFFF, 0xFFFF, 0x041F, 0x043F, 0xFFFF, 0xFFFF, 0x0421,
    0x0441, 0x0422, 0x0442, 0xFFFF, 0xFFFF, 0x04AE, 0x04AF, 0x0425, 0x0445, 0xFFFF, 0xFFFF,
    0x0427, 0x0447, 0x0427, 0x0447, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x04BC, 0x04BD};
static unsigned short unicode_unacc_data31[] = {
    0xFFFF, 0x0416, 0x0436, 0x041A, 0x043A, 0x041B, 0x043B, 0x041D, 0x043D, 0x041D, 0x043D,
    0xFFFF, 0xFFFF, 0x041C, 0x043C, 0xFFFF, 0x0410, 0x0430, 0x0410, 0x0430, 0xFFFF, 0xFFFF,
    0x0415, 0x0435, 0xFFFF, 0xFFFF, 0x04D8, 0x04D9, 0x0416, 0x0436, 0x0417, 0x0437};
static unsigned short unicode_unacc_data32[] = {
    0xFFFF, 0xFFFF, 0x0418, 0x0438, 0x0418, 0x0438, 0x041E, 0x043E, 0xFFFF, 0xFFFF, 0x04E8,
    0x04E9, 0x042D, 0x044D, 0x0423, 0x0443, 0x0423, 0x0443, 0x0423, 0x0443, 0x0427, 0x0447,
    0x0413, 0x0433, 0x042B, 0x044B, 0x0413, 0x0433, 0x0425, 0x0445, 0x0425, 0x0445};
static unsigned short unicode_unacc_data33[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x041B, 0x043B, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data34[] = {
    0x041B, 0x043B, 0x041D, 0x043D, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data35[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0565, 0x0582, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data36[] = {
    0xFFFF, 0xFFFF, 0x0627, 0x0627, 0x0648, 0x0627, 0x064A, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x06A9, 0x06A9, 0x06CC, 0x06CC, 0x06CC};
static unsigned short unicode_unacc_data37[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0627, 0x0627, 0xFFFF, 0x0627, 0x0674, 0x0648,
    0x0674, 0x06C7, 0x0674, 0x064A, 0x0674, 0xFFFF, 0xFFFF, 0xFFFF, 0x062A, 0x062A, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data38[] = {
    0xFFFF, 0x062D, 0x062D, 0xFFFF, 0xFFFF, 0x062D, 0xFFFF, 0xFFFF, 0xFFFF, 0x062F, 0x062F,
    0x062F, 0xFFFF, 0xFFFF, 0xFFFF, 0x062F, 0x062F, 0xFFFF, 0x0631, 0x0631, 0x0631, 0x0631,
    0x0631, 0x0631, 0xFFFF, 0x0631, 0x0633, 0x0633, 0x0633, 0x0635, 0x0635, 0x0637};
static unsigned short unicode_unacc_data39[] = {
    0x0639, 0xFFFF, 0x0641, 0x0641, 0xFFFF, 0x0641, 0xFFFF, 0x0642, 0x0642, 0xFFFF, 0xFFFF,
    0x0643, 0x0643, 0xFFFF, 0x0643, 0xFFFF, 0x06AF, 0xFFFF, 0x06AF, 0xFFFF, 0x06AF, 0x0644,
    0x0644, 0x0644, 0x0644, 0x0646, 0xFFFF, 0xFFFF, 0x0646, 0x0646, 0xFFFF, 0x0686};
static unsigned short unicode_unacc_data40[] = {
    0x06D5, 0xFFFF, 0x06C1, 0xFFFF, 0x0648, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0648,
    0xFFFF, 0xFFFF, 0x064A, 0x064A, 0x0648, 0xFFFF, 0x064A, 0xFFFF, 0x06D2, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data41[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0x062F, 0x0631, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0634, 0x0636, 0x063A, 0xFFFF, 0xFFFF, 0x0647};
static unsigned short unicode_unacc_data42[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0628, 0x0628, 0x0628, 0x0628, 0x0628, 0x0628,
    0x0628, 0x062D, 0x062D, 0x062F, 0x062F, 0x0631, 0x0633, 0x0639, 0x0639, 0x0639};
static unsigned short unicode_unacc_data43[] = {
    0x0641, 0x0641, 0x06A9, 0x06A9, 0x06A9, 0x0645, 0x0645, 0x0646, 0x0646, 0x0646, 0x0644,
    0x0631, 0x0631, 0x0633, 0x062D, 0x062D, 0x0633, 0x0631, 0x062D, 0x0627, 0x0627, 0x06CC,
    0x06CC, 0x06CC, 0x0648, 0x0648, 0x06D2, 0x06D2, 0x062D, 0x0633, 0x0633, 0x0643};
static unsigned short unicode_unacc_data44[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0928, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0930, 0xFFFF, 0xFFFF, 0x0933, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data45[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0x0915, 0x0916, 0x0917, 0x091C, 0x0921, 0x0922, 0x092B, 0x092F};
static unsigned short unicode_unacc_data46[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x09A1, 0x09A2, 0xFFFF, 0x09AF};
static unsigned short unicode_unacc_data47[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x09B0, 0x09B0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data48[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0A32, 0xFFFF, 0xFFFF,
    0x0A38, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data49[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0x0A16, 0x0A17, 0x0A1C, 0xFFFF, 0xFFFF, 0x0A2B, 0xFFFF};
static unsigned short unicode_unacc_data50[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0B21, 0x0B22, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data51[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0B92, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data52[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0E32, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data53[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0EB2, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data54[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0EAB, 0x0E99, 0x0EAB, 0x0EA1, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data55[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0x0F0B, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data56[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0x0F42, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0x0F4C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0F51, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0x0F56, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0F5B, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data57[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0F40, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data58[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x1025, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data59[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x10DC, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data60[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x1B05, 0xFFFF, 0x1B07, 0xFFFF, 0x1B09,
    0xFFFF, 0x1B0B, 0xFFFF, 0x1B0D, 0xFFFF, 0xFFFF, 0xFFFF, 0x1B11, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data61[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0x029F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x1D11, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data62[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0x0041, 0x0041, 0x0045, 0x0042, 0xFFFF, 0x0044, 0x0045, 0x018E, 0x0047, 0x0048,
    0x0049, 0x004A, 0x004B, 0x004C, 0x004D, 0x004E, 0xFFFF, 0x004F, 0x0222, 0x0050, 0x0052};
static unsigned short unicode_unacc_data63[] = {
    0x0054, 0x0055, 0x0057, 0x0061, 0x0250, 0x0251, 0x1D02, 0x0062, 0x0064, 0x0065, 0x0259,
    0x025B, 0x025C, 0x0067, 0xFFFF, 0x006B, 0x006D, 0x014B, 0x006F, 0x0254, 0x1D16, 0x1D17,
    0x0070, 0x0074, 0x0075, 0x1D1D, 0x026F, 0x0076, 0x1D25, 0x03B2, 0x03B3, 0x03B4};
static unsigned short unicode_unacc_data64[] = {
    0x03C6, 0x03C7, 0x0069, 0x0072, 0x0075, 0x0076, 0x03B2, 0x03B3, 0x03C1, 0x03C6, 0x03C7,
    0xFFFF, 0x0062, 0x0064, 0x0066, 0x006D, 0x006E, 0x0070, 0x0072, 0x0072, 0x0073, 0x0074,
    0x007A, 0xFFFF, 0x043D, 0xFFFF, 0xFFFF, 0xFFFF, 0x0269, 0x0070, 0xFFFF, 0x028A};
static unsigned short unicode_unacc_data65[] = {
    0x0062, 0x0064, 0x0066, 0x0067, 0x006B, 0x006C, 0x006D, 0x006E, 0x0070, 0x0072, 0x0073,
    0x0283, 0x0076, 0x0078, 0x007A, 0x0061, 0x0251, 0x0064, 0x0065, 0x025B, 0x025C, 0x0259,
    0x0069, 0x0254, 0x0283, 0x0075, 0x0292, 0x0252, 0x0063, 0x0063, 0x00F0, 0x025C};
static unsigned short unicode_unacc_data66[] = {
    0x0066, 0x0237, 0x0261, 0x0265, 0x0069, 0x0269, 0x026A, 0x1D7B, 0x006A, 0x006C, 0x006C,
    0x029F, 0x006D, 0x026F, 0x006E, 0x006E, 0x0274, 0x0275, 0x0278, 0x0073, 0x0283, 0x0074,
    0x0289, 0x028A, 0x1D1C, 0x0076, 0x028C, 0x007A, 0x007A, 0x007A, 0x0292, 0x03B8};
static unsigned short unicode_unacc_data67[] = {
    0x0041, 0x0061, 0x0042, 0x0062, 0x0042, 0x0062, 0x0042, 0x0062, 0x0043, 0x0063, 0x0044,
    0x0064, 0x0044, 0x0064, 0x0044, 0x0064, 0x0044, 0x0064, 0x0044, 0x0064, 0x0045, 0x0065,
    0x0045, 0x0065, 0x0045, 0x0065, 0x0045, 0x0065, 0x0045, 0x0065, 0x0046, 0x0066};
static unsigned short unicode_unacc_data68[] = {
    0x0047, 0x0067, 0x0048, 0x0068, 0x0048, 0x0068, 0x0048, 0x0068, 0x0048, 0x0068, 0x0048,
    0x0068, 0x0049, 0x0069, 0x0049, 0x0069, 0x004B, 0x006B, 0x004B, 0x006B, 0x004B, 0x006B,
    0x004C, 0x006C, 0x004C, 0x006C, 0x004C, 0x006C, 0x004C, 0x006C, 0x004D, 0x006D};
static unsigned short unicode_unacc_data69[] = {
    0x004D, 0x006D, 0x004D, 0x006D, 0x004E, 0x006E, 0x004E, 0x006E, 0x004E, 0x006E, 0x004E,
    0x006E, 0x004F, 0x006F, 0x004F, 0x006F, 0x004F, 0x006F, 0x004F, 0x006F, 0x0050, 0x0070,
    0x0050, 0x0070, 0x0052, 0x0072, 0x0052, 0x0072, 0x0052, 0x0072, 0x0052, 0x0072};
static unsigned short unicode_unacc_data70[] = {
    0x0053, 0x0073, 0x0053, 0x0073, 0x0053, 0x0073, 0x0053, 0x0073, 0x0053, 0x0073, 0x0054,
    0x0074, 0x0054, 0x0074, 0x0054, 0x0074, 0x0054, 0x0074, 0x0055, 0x0075, 0x0055, 0x0075,
    0x0055, 0x0075, 0x0055, 0x0075, 0x0055, 0x0075, 0x0056, 0x0076, 0x0056, 0x0076};
static unsigned short unicode_unacc_data71[] = {
    0x0057, 0x0077, 0x0057, 0x0077, 0x0057, 0x0077, 0x0057, 0x0077, 0x0057, 0x0077, 0x0058,
    0x0078, 0x0058, 0x0078, 0x0059, 0x0079, 0x005A, 0x007A, 0x005A, 0x007A, 0x005A, 0x007A,
    0x0068, 0x0074, 0x0077, 0x0079, 0x0061, 0x02BE, 0x0073, 0x0073, 0x0073, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data72[] = {
    0x0041, 0x0061, 0x0041, 0x0061, 0x0041, 0x0061, 0x0041, 0x0061, 0x0041, 0x0061, 0x0041,
    0x0061, 0x0041, 0x0061, 0x0041, 0x0061, 0x0041, 0x0061, 0x0041, 0x0061, 0x0041, 0x0061,
    0x0041, 0x0061, 0x0045, 0x0065, 0x0045, 0x0065, 0x0045, 0x0065, 0x0045, 0x0065};
static unsigned short unicode_unacc_data73[] = {
    0x0045, 0x0065, 0x0045, 0x0065, 0x0045, 0x0065, 0x0045, 0x0065, 0x0049, 0x0069, 0x0049,
    0x0069, 0x004F, 0x006F, 0x004F, 0x006F, 0x004F, 0x006F, 0x004F, 0x006F, 0x004F, 0x006F,
    0x004F, 0x006F, 0x004F, 0x006F, 0x004F, 0x006F, 0x004F, 0x006F, 0x004F, 0x006F};
static unsigned short unicode_unacc_data74[] = {
    0x004F, 0x006F, 0x004F, 0x006F, 0x0055, 0x0075, 0x0055, 0x0075, 0x0055, 0x0075, 0x0055,
    0x0075, 0x0055, 0x0075, 0x0055, 0x0075, 0x0055, 0x0075, 0x0059, 0x0079, 0x0059, 0x0079,
    0x0059, 0x0079, 0x0059, 0x0079, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0059, 0x0079};
static unsigned short unicode_unacc_data75[] = {
    0x03B1, 0x03B1, 0x03B1, 0x03B1, 0x03B1, 0x03B1, 0x03B1, 0x03B1, 0x0391, 0x0391, 0x0391,
    0x0391, 0x0391, 0x0391, 0x0391, 0x0391, 0x03B5, 0x03B5, 0x03B5, 0x03B5, 0x03B5, 0x03B5,
    0xFFFF, 0xFFFF, 0x0395, 0x0395, 0x0395, 0x0395, 0x0395, 0x0395, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data76[] = {
    0x03B7, 0x03B7, 0x03B7, 0x03B7, 0x03B7, 0x03B7, 0x03B7, 0x03B7, 0x0397, 0x0397, 0x0397,
    0x0397, 0x0397, 0x0397, 0x0397, 0x0397, 0x03B9, 0x03B9, 0x03B9, 0x03B9, 0x03B9, 0x03B9,
    0x03B9, 0x03B9, 0x0399, 0x0399, 0x0399, 0x0399, 0x0399, 0x0399, 0x0399, 0x0399};
static unsigned short unicode_unacc_data77[] = {
    0x03BF, 0x03BF, 0x03BF, 0x03BF, 0x03BF, 0x03BF, 0xFFFF, 0xFFFF, 0x039F, 0x039F, 0x039F,
    0x039F, 0x039F, 0x039F, 0xFFFF, 0xFFFF, 0x03C5, 0x03C5, 0x03C5, 0x03C5, 0x03C5, 0x03C5,
    0x03C5, 0x03C5, 0xFFFF, 0x03A5, 0xFFFF, 0x03A5, 0xFFFF, 0x03A5, 0xFFFF, 0x03A5};
static unsigned short unicode_unacc_data78[] = {
    0x03C9, 0x03C9, 0x03C9, 0x03C9, 0x03C9, 0x03C9, 0x03C9, 0x03C9, 0x03A9, 0x03A9, 0x03A9,
    0x03A9, 0x03A9, 0x03A9, 0x03A9, 0x03A9, 0x03B1, 0x03B1, 0x03B5, 0x03B5, 0x03B7, 0x03B7,
    0x03B9, 0x03B9, 0x03BF, 0x03BF, 0x03C5, 0x03C5, 0x03C9, 0x03C9, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data79[] = {
    0x03B1, 0x03B1, 0x03B1, 0x03B1, 0x03B1, 0x03B1, 0x03B1, 0x03B1, 0x0391, 0x0391, 0x0391,
    0x0391, 0x0391, 0x0391, 0x0391, 0x0391, 0x03B7, 0x03B7, 0x03B7, 0x03B7, 0x03B7, 0x03B7,
    0x03B7, 0x03B7, 0x0397, 0x0397, 0x0397, 0x0397, 0x0397, 0x0397, 0x0397, 0x0397};
static unsigned short unicode_unacc_data80[] = {
    0x03C9, 0x03C9, 0x03C9, 0x03C9, 0x03C9, 0x03C9, 0x03C9, 0x03C9, 0x03A9, 0x03A9, 0x03A9,
    0x03A9, 0x03A9, 0x03A9, 0x03A9, 0x03A9, 0x03B1, 0x03B1, 0x03B1, 0x03B1, 0x03B1, 0xFFFF,
    0x03B1, 0x03B1, 0x0391, 0x0391, 0x0391, 0x0391, 0x0391, 0x0020, 0x03B9, 0x0020};
static unsigned short unicode_unacc_data81[] = {
    0x0020, 0x0020, 0x03B7, 0x03B7, 0x03B7, 0xFFFF, 0x03B7, 0x03B7, 0x0395, 0x0395, 0x0397,
    0x0397, 0x0397, 0x0020, 0x0020, 0x0020, 0x03B9, 0x03B9, 0x03B9, 0x03B9, 0xFFFF, 0xFFFF,
    0x03B9, 0x03B9, 0x0399, 0x0399, 0x0399, 0x0399, 0xFFFF, 0x0020, 0x0020, 0x0020};
static unsigned short unicode_unacc_data82[] = {
    0x03C5, 0x03C5, 0x03C5, 0x03C5, 0x03C1, 0x03C1, 0x03C5, 0x03C5, 0x03A5, 0x03A5, 0x03A5,
    0x03A5, 0x03A1, 0x0020, 0x0020, 0x0060, 0xFFFF, 0xFFFF, 0x03C9, 0x03C9, 0x03C9, 0xFFFF,
    0x03C9, 0x03C9, 0x039F, 0x039F, 0x03A9, 0x03A9, 0x03A9, 0x0020, 0x0020, 0xFFFF};
static unsigned short unicode_unacc_data83[] = {
    0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x2010, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0x0020, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data84[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x002E, 0x002E, 0x002E, 0x002E, 0x002E, 0x002E, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0020, 0xFFFF, 0xFFFF, 0xFFFF,
    0x2032, 0x2032, 0x2032, 0x2032, 0x2032, 0xFFFF, 0x2035, 0x2035, 0x2035, 0x2035, 0x2035,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0021, 0x0021, 0xFFFF, 0x0020, 0xFFFF};
static unsigned short unicode_unacc_data85[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x005B, 0x005D, 0x003F, 0x003F, 0x003F,
    0x0021, 0x0021, 0x003F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x2032, 0x2032, 0x2032, 0x2032,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0020};
static unsigned short unicode_unacc_data86[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0030, 0x0069, 0xFFFF, 0xFFFF, 0x0034, 0x0035,
    0x0036, 0x0037, 0x0038, 0x0039, 0x002B, 0x2212, 0x003D, 0x0028, 0x0029, 0x006E};
static unsigned short unicode_unacc_data87[] = {
    0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 0x0038, 0x0039, 0x002B,
    0x2212, 0x003D, 0x0028, 0x0029, 0xFFFF, 0x0061, 0x0065, 0x006F, 0x0078, 0x0259, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data88[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0052, 0x0073, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data89[] = {
    0x0061, 0x002F, 0x0063, 0x0061, 0x002F, 0x0073, 0x0043, 0x00B0, 0x0043, 0xFFFF, 0x0063,
    0x002F, 0x006F, 0x0063, 0x002F, 0x0075, 0x0190, 0xFFFF, 0x00B0, 0x0046, 0x0067, 0x0048,
    0x0048, 0x0048, 0x0068, 0x0068, 0x0049, 0x0049, 0x004C, 0x006C, 0xFFFF, 0x004E, 0x004E,
    0x006F, 0xFFFF, 0xFFFF, 0x0050, 0x0051, 0x0052, 0x0052, 0x0052, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data90[] = {
    0x0053, 0x004D, 0x0054, 0x0045, 0x004C, 0x0054, 0x004D, 0xFFFF, 0x005A, 0xFFFF,
    0x03A9, 0xFFFF, 0x005A, 0xFFFF, 0x004B, 0x0041, 0x0042, 0x0043, 0xFFFF, 0x0065,
    0x0045, 0x0046, 0xFFFF, 0x004D, 0x006F, 0x05D0, 0x05D1, 0x05D2, 0x05D3, 0x0069,
    0xFFFF, 0x0046, 0x0041, 0x0058, 0x03C0, 0x03B3, 0x0393, 0x03A0};
static unsigned short unicode_unacc_data91[] = {
    0x2211, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0044, 0x0064, 0x0065, 0x0069, 0x006A, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0031, 0x2044, 0x0033, 0x0032, 0x2044,
    0x0033, 0x0031, 0x2044, 0x0035, 0x0032, 0x2044, 0x0035, 0x0033, 0x2044, 0x0035, 0x0034, 0x2044,
    0x0035, 0x0031, 0x2044, 0x0036, 0x0035, 0x2044, 0x0036, 0x0031, 0x2044, 0x0038, 0x0033, 0x2044,
    0x0038, 0x0035, 0x2044, 0x0038, 0x0037, 0x2044, 0x0038, 0x0031, 0x2044};
static unsigned short unicode_unacc_data92[] = {
    0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0056, 0x0056, 0x0056, 0x0049, 0x0056,
    0x0049, 0x0049, 0x0056, 0x0049, 0x0049, 0x0049, 0x0049, 0x0058, 0x0058, 0x0058, 0x0049, 0x0058,
    0x0049, 0x0049, 0x004C, 0x0043, 0x0044, 0x004D, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069,
    0x0069, 0x0076, 0x0076, 0x0076, 0x0069, 0x0076, 0x0069, 0x0069, 0x0076, 0x0069, 0x0069, 0x0069,
    0x0069, 0x0078, 0x0078, 0x0078, 0x0069, 0x0078, 0x0069, 0x0069, 0x006C, 0x0063, 0x0064, 0x006D};
static unsigned short unicode_unacc_data93[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x2190, 0x2192, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data94[] = {
    0xFFFF, 0xFFFF, 0x2190, 0x2192, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x2195, 0x2190, 0x2192,
    0x2190, 0x2192, 0xFFFF, 0x2194, 0xFFFF, 0x2191, 0x2191, 0x2193, 0x2193, 0x2192, 0x2193,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data95[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0x21D0, 0x21D4, 0x21D2, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x2191, 0x2193};
static unsigned short unicode_unacc_data96[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0x21EB, 0x21EB, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0x2190, 0x2192, 0x2194, 0x2190, 0x2192, 0x2194, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data97[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x2203, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x2208, 0xFFFF,
    0xFFFF, 0x220B, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data98[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x2223, 0xFFFF, 0x2225, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0x222B, 0x222B, 0x222B, 0x222B, 0x222B, 0xFFFF, 0x222E, 0x222E,
    0x222E, 0x222E, 0x222E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data99[] = {
    0xFFFF, 0x223C, 0xFFFF, 0xFFFF, 0x2243, 0xFFFF, 0xFFFF, 0x2245, 0xFFFF, 0x2248, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data100[] = {
    0x003D, 0xFFFF, 0x2261, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0x224D, 0x003C, 0x003E, 0x2264, 0x2265, 0xFFFF, 0xFFFF, 0x2272, 0x2273,
    0xFFFF, 0xFFFF, 0x2276, 0x2277, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data101[] = {
    0x227A, 0x227B, 0xFFFF, 0xFFFF, 0x2282, 0x2283, 0xFFFF, 0xFFFF, 0x2286, 0x2287, 0x2282,
    0x2283, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data102[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0x22A2, 0x22A8, 0x22A9, 0x22AB, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x221F, 0xFFFF};
static unsigned short unicode_unacc_data103[] = {
    0x227C, 0x227D, 0x2291, 0x2292, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x22B2,
    0x22B3, 0x22B4, 0x22B5, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x2208, 0x2208, 0x220A, 0x2208,
    0x2208, 0x220A, 0x2208, 0x2208, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data104[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x3008, 0x3009,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data105[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x221F, 0xFFFF, 0xFFFF, 0x007C};
static unsigned short unicode_unacc_data106[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x25A1, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data107[] = {
    0xFFFF, 0x23C9, 0x23CA, 0xFFFF, 0x23C9, 0x23CA, 0xFFFF, 0x23C9, 0x23CA, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data108[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0x232C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data109[] = {
    0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 0x0038, 0x0039, 0x0031, 0x0030, 0x0031,
    0x0031, 0x0031, 0x0032, 0x0031, 0x0033, 0x0031, 0x0034, 0x0031, 0x0035, 0x0031, 0x0036, 0x0031,
    0x0037, 0x0031, 0x0038, 0x0031, 0x0039, 0x0032, 0x0030, 0x0028, 0x0031, 0x0029, 0x0028, 0x0032,
    0x0029, 0x0028, 0x0033, 0x0029, 0x0028, 0x0034, 0x0029, 0x0028, 0x0035, 0x0029, 0x0028, 0x0036,
    0x0029, 0x0028, 0x0037, 0x0029, 0x0028, 0x0038, 0x0029, 0x0028, 0x0039, 0x0029, 0x0028, 0x0031,
    0x0030, 0x0029, 0x0028, 0x0031, 0x0031, 0x0029, 0x0028, 0x0031, 0x0032, 0x0029};
static unsigned short unicode_unacc_data110[] = {
    0x0028, 0x0031, 0x0033, 0x0029, 0x0028, 0x0031, 0x0034, 0x0029, 0x0028, 0x0031, 0x0035, 0x0029,
    0x0028, 0x0031, 0x0036, 0x0029, 0x0028, 0x0031, 0x0037, 0x0029, 0x0028, 0x0031, 0x0038, 0x0029,
    0x0028, 0x0031, 0x0039, 0x0029, 0x0028, 0x0032, 0x0030, 0x0029, 0x0031, 0x002E, 0x0032, 0x002E,
    0x0033, 0x002E, 0x0034, 0x002E, 0x0035, 0x002E, 0x0036, 0x002E, 0x0037, 0x002E, 0x0038, 0x002E,
    0x0039, 0x002E, 0x0031, 0x0030, 0x002E, 0x0031, 0x0031, 0x002E, 0x0031, 0x0032, 0x002E, 0x0031,
    0x0033, 0x002E, 0x0031, 0x0034, 0x002E, 0x0031, 0x0035, 0x002E, 0x0031, 0x0036, 0x002E, 0x0031,
    0x0037, 0x002E, 0x0031, 0x0038, 0x002E, 0x0031, 0x0039, 0x002E, 0x0032, 0x0030, 0x002E, 0x0028,
    0x0061, 0x0029, 0x0028, 0x0062, 0x0029, 0x0028, 0x0063, 0x0029, 0x0028, 0x0064, 0x0029};
static unsigned short unicode_unacc_data111[] = {
    0x0028, 0x0065, 0x0029, 0x0028, 0x0066, 0x0029, 0x0028, 0x0067, 0x0029, 0x0028, 0x0068,
    0x0029, 0x0028, 0x0069, 0x0029, 0x0028, 0x006A, 0x0029, 0x0028, 0x006B, 0x0029, 0x0028,
    0x006C, 0x0029, 0x0028, 0x006D, 0x0029, 0x0028, 0x006E, 0x0029, 0x0028, 0x006F, 0x0029,
    0x0028, 0x0070, 0x0029, 0x0028, 0x0071, 0x0029, 0x0028, 0x0072, 0x0029, 0x0028, 0x0073,
    0x0029, 0x0028, 0x0074, 0x0029, 0x0028, 0x0075, 0x0029, 0x0028, 0x0076, 0x0029, 0x0028,
    0x0077, 0x0029, 0x0028, 0x0078, 0x0029, 0x0028, 0x0079, 0x0029, 0x0028, 0x007A, 0x0029,
    0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 0x0048, 0x0049, 0x004A};
static unsigned short unicode_unacc_data112[] = {
    0x004B, 0x004C, 0x004D, 0x004E, 0x004F, 0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055,
    0x0056, 0x0057, 0x0058, 0x0059, 0x005A, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066,
    0x0067, 0x0068, 0x0069, 0x006A, 0x006B, 0x006C, 0x006D, 0x006E, 0x006F, 0x0070};
static unsigned short unicode_unacc_data113[] = {
    0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077, 0x0078, 0x0079, 0x007A, 0x0030,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data114[] = {
    0xFFFF, 0xFFFF, 0x25A1, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data115[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0x25A1, 0x25B3, 0xFFFF, 0xFFFF, 0xFFFF, 0x25A1, 0x25A1, 0x25A1, 0x25A1, 0x25CB, 0x25CB,
    0x25CB, 0x25CB, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data116[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x2610, 0x2610, 0xFFFF, 0x2602, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data117[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x25CB, 0x25CB, 0x25CF, 0x25CF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data118[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x25C7, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x22A5};
static unsigned short unicode_unacc_data119[] = {
    0xFFFF, 0xFFFF, 0x27E1, 0x27E1, 0x25A1, 0x25A1, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data120[] = {
    0xFFFF, 0xFFFF, 0x21D0, 0x21D2, 0x21D4, 0xFFFF, 0xFFFF, 0xFFFF, 0x2193, 0x2191, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x2192, 0xFFFF, 0xFFFF, 0x2192, 0x2192,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data121[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0x2196, 0x2197, 0x2198, 0x2199, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x293A, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data122[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x2192, 0x2190, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data123[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0x005B, 0x005D, 0x005B, 0x005D, 0x005B, 0x005D, 0x3008, 0x3009, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x2220, 0xFFFF};
static unsigned short unicode_unacc_data124[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x2220, 0x29A3, 0xFFFF, 0xFFFF, 0x2221, 0x2221, 0x2221,
    0x2221, 0x2221, 0x2221, 0x2221, 0x2221, 0xFFFF, 0x2205, 0x2205, 0x2205, 0x2205, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data125[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x22C8, 0x22C8, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data126[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x29E3, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x25C6,
    0xFFFF, 0x25CB, 0x25CF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0x002F, 0x005C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data127[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0x222B, 0x222B, 0x222B, 0x222B, 0xFFFF, 0x222B, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0x222B, 0x222B, 0x222B, 0x222B, 0x222B, 0x222B, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data128[] = {
    0xFFFF, 0xFFFF, 0x002B, 0x002B, 0x002B, 0x002B, 0x002B, 0x002B, 0x002B, 0x2212, 0x2212,
    0x2212, 0x2212, 0xFFFF, 0xFFFF, 0xFFFF, 0x00D7, 0x00D7, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data129[] = {
    0x2229, 0x222A, 0x222A, 0x2229, 0x2229, 0x222A, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x2227, 0x2228, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x2227, 0x2228, 0x2227, 0x2228, 0x2227, 0x2227};
static unsigned short unicode_unacc_data130[] = {
    0x2227, 0xFFFF, 0x2228, 0x2228, 0xFFFF, 0xFFFF, 0x003D, 0xFFFF, 0xFFFF, 0xFFFF,
    0x223C, 0x223C, 0xFFFF, 0xFFFF, 0xFFFF, 0x2248, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0x003A, 0x003A, 0x003D, 0x003D, 0x003D, 0x003D, 0x003D, 0x003D, 0x003D, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x2A7D};
static unsigned short unicode_unacc_data131[] = {
    0x2A7E, 0x2A7D, 0x2A7E, 0x2A7D, 0x2A7E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0x2A95, 0x2A96, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data132[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0x2AA1, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0x003D, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data133[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0x2286, 0x2287, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x22D4, 0xFFFF, 0x2ADD, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data134[] = {
    0xFFFF, 0x27C2, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x2ADF, 0x2AE0, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0x2223, 0x007C, 0x007C, 0x22A4, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data135[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0x2192, 0x2192, 0x2190, 0x2190, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data136[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0x2190, 0x2190, 0x2190, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data137[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x2C24, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data138[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x2C54,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data139[] = {
    0x004C, 0x006C, 0x004C, 0x0050, 0x0052, 0x0061, 0x0074, 0x0048, 0x0068, 0x004B, 0x006B,
    0x005A, 0x007A, 0xFFFF, 0x004D, 0xFFFF, 0xFFFF, 0x0076, 0x0057, 0x0077, 0x0076, 0xFFFF,
    0xFFFF, 0xFFFF, 0x0065, 0x0279, 0x006F, 0xFFFF, 0x006A, 0x0056, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data140[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x2D61, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data141[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x2010, 0x007E, 0xFFFF, 0xFFFF, 0x007E, 0x007E};
static unsigned short unicode_unacc_data142[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x6BCD};
static unsigned short unicode_unacc_data143[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x9F9F, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data144[] = {
    0x4E00, 0x4E28, 0x4E36, 0x4E3F, 0x4E59, 0x4E85, 0x4E8C, 0x4EA0, 0x4EBA, 0x513F, 0x5165,
    0x516B, 0x5182, 0x5196, 0x51AB, 0x51E0, 0x51F5, 0x5200, 0x529B, 0x52F9, 0x5315, 0x531A,
    0x5338, 0x5341, 0x535C, 0x5369, 0x5382, 0x53B6, 0x53C8, 0x53E3, 0x56D7, 0x571F};
static unsigned short unicode_unacc_data145[] = {
    0x58EB, 0x5902, 0x590A, 0x5915, 0x5927, 0x5973, 0x5B50, 0x5B80, 0x5BF8, 0x5C0F, 0x5C22,
    0x5C38, 0x5C6E, 0x5C71, 0x5DDB, 0x5DE5, 0x5DF1, 0x5DFE, 0x5E72, 0x5E7A, 0x5E7F, 0x5EF4,
    0x5EFE, 0x5F0B, 0x5F13, 0x5F50, 0x5F61, 0x5F73, 0x5FC3, 0x6208, 0x6236, 0x624B};
static unsigned short unicode_unacc_data146[] = {
    0x652F, 0x6534, 0x6587, 0x6597, 0x65A4, 0x65B9, 0x65E0, 0x65E5, 0x66F0, 0x6708, 0x6728,
    0x6B20, 0x6B62, 0x6B79, 0x6BB3, 0x6BCB, 0x6BD4, 0x6BDB, 0x6C0F, 0x6C14, 0x6C34, 0x706B,
    0x722A, 0x7236, 0x723B, 0x723F, 0x7247, 0x7259, 0x725B, 0x72AC, 0x7384, 0x7389};
static unsigned short unicode_unacc_data147[] = {
    0x74DC, 0x74E6, 0x7518, 0x751F, 0x7528, 0x7530, 0x758B, 0x7592, 0x7676, 0x767D, 0x76AE,
    0x76BF, 0x76EE, 0x77DB, 0x77E2, 0x77F3, 0x793A, 0x79B8, 0x79BE, 0x7A74, 0x7ACB, 0x7AF9,
    0x7C73, 0x7CF8, 0x7F36, 0x7F51, 0x7F8A, 0x7FBD, 0x8001, 0x800C, 0x8012, 0x8033};
static unsigned short unicode_unacc_data148[] = {
    0x807F, 0x8089, 0x81E3, 0x81EA, 0x81F3, 0x81FC, 0x820C, 0x821B, 0x821F, 0x826E, 0x8272,
    0x8278, 0x864D, 0x866B, 0x8840, 0x884C, 0x8863, 0x897E, 0x898B, 0x89D2, 0x8A00, 0x8C37,
    0x8C46, 0x8C55, 0x8C78, 0x8C9D, 0x8D64, 0x8D70, 0x8DB3, 0x8EAB, 0x8ECA, 0x8F9B};
static unsigned short unicode_unacc_data149[] = {
    0x8FB0, 0x8FB5, 0x9091, 0x9149, 0x91C6, 0x91CC, 0x91D1, 0x9577, 0x9580, 0x961C, 0x96B6,
    0x96B9, 0x96E8, 0x9751, 0x975E, 0x9762, 0x9769, 0x97CB, 0x97ED, 0x97F3, 0x9801, 0x98A8,
    0x98DB, 0x98DF, 0x9996, 0x9999, 0x99AC, 0x9AA8, 0x9AD8, 0x9ADF, 0x9B25, 0x9B2F};
static unsigned short unicode_unacc_data150[] = {
    0x9B32, 0x9B3C, 0x9B5A, 0x9CE5, 0x9E75, 0x9E7F, 0x9EA5, 0x9EBB, 0x9EC3, 0x9ECD, 0x9ED1,
    0x9EF9, 0x9EFD, 0x9F0E, 0x9F13, 0x9F20, 0x9F3B, 0x9F4A, 0x9F52, 0x9F8D, 0x9F9C, 0x9FA0,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data151[] = {
    0x0020, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data152[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0x3012, 0xFFFF, 0x5341, 0x5344, 0x5345, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data153[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0x304B, 0xFFFF, 0x304D, 0xFFFF, 0x304F, 0xFFFF, 0x3051, 0xFFFF, 0x3053, 0xFFFF,
    0x3055, 0xFFFF, 0x3057, 0xFFFF, 0x3059, 0xFFFF, 0x305B, 0xFFFF, 0x305D, 0xFFFF};
static unsigned short unicode_unacc_data154[] = {
    0x305F, 0xFFFF, 0x3061, 0xFFFF, 0xFFFF, 0x3064, 0xFFFF, 0x3066, 0xFFFF, 0x3068, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x306F, 0x306F, 0xFFFF, 0x3072, 0x3072, 0xFFFF,
    0x3075, 0x3075, 0xFFFF, 0x3078, 0x3078, 0xFFFF, 0x307B, 0x307B, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data155[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x3046, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0020, 0x0020, 0xFFFF, 0x309D, 0x3088, 0x308A};
static unsigned short unicode_unacc_data156[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0x30AB, 0xFFFF, 0x30AD, 0xFFFF, 0x30AF, 0xFFFF, 0x30B1, 0xFFFF, 0x30B3, 0xFFFF,
    0x30B5, 0xFFFF, 0x30B7, 0xFFFF, 0x30B9, 0xFFFF, 0x30BB, 0xFFFF, 0x30BD, 0xFFFF};
static unsigned short unicode_unacc_data157[] = {
    0x30BF, 0xFFFF, 0x30C1, 0xFFFF, 0xFFFF, 0x30C4, 0xFFFF, 0x30C6, 0xFFFF, 0x30C8, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x30CF, 0x30CF, 0xFFFF, 0x30D2, 0x30D2, 0xFFFF,
    0x30D5, 0x30D5, 0xFFFF, 0x30D8, 0x30D8, 0xFFFF, 0x30DB, 0x30DB, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data158[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x30A6, 0xFFFF,
    0xFFFF, 0x30EF, 0x30F0, 0x30F1, 0x30F2, 0xFFFF, 0xFFFF, 0xFFFF, 0x30FD, 0x30B3, 0x30C8};
static unsigned short unicode_unacc_data159[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x1100, 0x1101, 0x11AA, 0x1102, 0x11AC,
    0x11AD, 0x1103, 0x1104, 0x1105, 0x11B0, 0x11B1, 0x11B2, 0x11B3, 0x11B4, 0x11B5};
static unsigned short unicode_unacc_data160[] = {
    0x111A, 0x1106, 0x1107, 0x1108, 0x1121, 0x1109, 0x110A, 0x110B, 0x110C, 0x110D, 0x110E,
    0x110F, 0x1110, 0x1111, 0x1112, 0x1161, 0x1162, 0x1163, 0x1164, 0x1165, 0x1166, 0x1167,
    0x1168, 0x1169, 0x116A, 0x116B, 0x116C, 0x116D, 0x116E, 0x116F, 0x1170, 0x1171};
static unsigned short unicode_unacc_data161[] = {
    0x1172, 0x1173, 0x1174, 0x1175, 0x1160, 0x1114, 0x1115, 0x11C7, 0x11C8, 0x11CC, 0x11CE,
    0x11D3, 0x11D7, 0x11D9, 0x111C, 0x11DD, 0x11DF, 0x111D, 0x111E, 0x1120, 0x1122, 0x1123,
    0x1127, 0x1129, 0x112B, 0x112C, 0x112D, 0x112E, 0x112F, 0x1132, 0x1136, 0x1140};
static unsigned short unicode_unacc_data162[] = {
    0x1147, 0x114C, 0x11F1, 0x11F2, 0x1157, 0x1158, 0x1159, 0x1184, 0x1185, 0x1188, 0x1191,
    0x1192, 0x1194, 0x119E, 0x11A1, 0xFFFF, 0xFFFF, 0xFFFF, 0x4E00, 0x4E8C, 0x4E09, 0x56DB,
    0x4E0A, 0x4E2D, 0x4E0B, 0x7532, 0x4E59, 0x4E19, 0x4E01, 0x5929, 0x5730, 0x4EBA};
static unsigned short unicode_unacc_data163[] = {
    0x0028, 0x1100, 0x0029, 0x0028, 0x1102, 0x0029, 0x0028, 0x1103, 0x0029, 0x0028, 0x1105, 0x0029,
    0x0028, 0x1106, 0x0029, 0x0028, 0x1107, 0x0029, 0x0028, 0x1109, 0x0029, 0x0028, 0x110B, 0x0029,
    0x0028, 0x110C, 0x0029, 0x0028, 0x110E, 0x0029, 0x0028, 0x110F, 0x0029, 0x0028, 0x1110, 0x0029,
    0x0028, 0x1111, 0x0029, 0x0028, 0x1112, 0x0029, 0x0028, 0x1100, 0x1161, 0x0029, 0x0028, 0x1102,
    0x1161, 0x0029, 0x0028, 0x1103, 0x1161, 0x0029, 0x0028, 0x1105, 0x1161, 0x0029, 0x0028, 0x1106,
    0x1161, 0x0029, 0x0028, 0x1107, 0x1161, 0x0029, 0x0028, 0x1109, 0x1161, 0x0029, 0x0028, 0x110B,
    0x1161, 0x0029, 0x0028, 0x110C, 0x1161, 0x0029, 0x0028, 0x110E, 0x1161, 0x0029, 0x0028, 0x110F,
    0x1161, 0x0029, 0x0028, 0x1110, 0x1161, 0x0029, 0x0028, 0x1111, 0x1161, 0x0029, 0x0028, 0x1112,
    0x1161, 0x0029, 0x0028, 0x110C, 0x116E, 0x0029, 0x0028, 0x110B, 0x1169, 0x110C, 0x1165, 0x11AB,
    0x0029, 0x0028, 0x110B, 0x1169, 0x1112, 0x116E, 0x0029, 0xFFFF};
static unsigned short unicode_unacc_data164[] = {
    0x0028, 0x4E00, 0x0029, 0x0028, 0x4E8C, 0x0029, 0x0028, 0x4E09, 0x0029, 0x0028, 0x56DB, 0x0029,
    0x0028, 0x4E94, 0x0029, 0x0028, 0x516D, 0x0029, 0x0028, 0x4E03, 0x0029, 0x0028, 0x516B, 0x0029,
    0x0028, 0x4E5D, 0x0029, 0x0028, 0x5341, 0x0029, 0x0028, 0x6708, 0x0029, 0x0028, 0x706B, 0x0029,
    0x0028, 0x6C34, 0x0029, 0x0028, 0x6728, 0x0029, 0x0028, 0x91D1, 0x0029, 0x0028, 0x571F, 0x0029,
    0x0028, 0x65E5, 0x0029, 0x0028, 0x682A, 0x0029, 0x0028, 0x6709, 0x0029, 0x0028, 0x793E, 0x0029,
    0x0028, 0x540D, 0x0029, 0x0028, 0x7279, 0x0029, 0x0028, 0x8CA1, 0x0029, 0x0028, 0x795D, 0x0029,
    0x0028, 0x52B4, 0x0029, 0x0028, 0x4EE3, 0x0029, 0x0028, 0x547C, 0x0029, 0x0028, 0x5B66, 0x0029,
    0x0028, 0x76E3, 0x0029, 0x0028, 0x4F01, 0x0029, 0x0028, 0x8CC7, 0x0029, 0x0028, 0x5354, 0x0029};
static unsigned short unicode_unacc_data165[] = {
    0x0028, 0x796D, 0x0029, 0x0028, 0x4F11, 0x0029, 0x0028, 0x81EA, 0x0029, 0x0028, 0x81F3, 0x0029,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0x0050, 0x0054, 0x0045, 0x0032, 0x0031, 0x0032, 0x0032, 0x0032, 0x0033, 0x0032, 0x0034, 0x0032,
    0x0035, 0x0032, 0x0036, 0x0032, 0x0037, 0x0032, 0x0038, 0x0032, 0x0039, 0x0033, 0x0030, 0x0033,
    0x0031, 0x0033, 0x0032, 0x0033, 0x0033, 0x0033, 0x0034, 0x0033, 0x0035};
static unsigned short unicode_unacc_data166[] = {
    0x1100, 0x1102, 0x1103, 0x1105, 0x1106, 0x1107, 0x1109, 0x110B, 0x110C, 0x110E, 0x110F,
    0x1110, 0x1111, 0x1112, 0x1100, 0x1161, 0x1102, 0x1161, 0x1103, 0x1161, 0x1105, 0x1161,
    0x1106, 0x1161, 0x1107, 0x1161, 0x1109, 0x1161, 0x110B, 0x1161, 0x110C, 0x1161, 0x110E,
    0x1161, 0x110F, 0x1161, 0x1110, 0x1161, 0x1111, 0x1161, 0x1112, 0x1161, 0x110E, 0x1161,
    0x11B7, 0x1100, 0x1169, 0x110C, 0x116E, 0x110B, 0x1174, 0x110B, 0x116E, 0xFFFF};
static unsigned short unicode_unacc_data167[] = {
    0x4E00, 0x4E8C, 0x4E09, 0x56DB, 0x4E94, 0x516D, 0x4E03, 0x516B, 0x4E5D, 0x5341, 0x6708,
    0x706B, 0x6C34, 0x6728, 0x91D1, 0x571F, 0x65E5, 0x682A, 0x6709, 0x793E, 0x540D, 0x7279,
    0x8CA1, 0x795D, 0x52B4, 0x79D8, 0x7537, 0x5973, 0x9069, 0x512A, 0x5370, 0x6CE8};
static unsigned short unicode_unacc_data168[] = {
    0x9805, 0x4F11, 0x5199, 0x6B63, 0x4E0A, 0x4E2D, 0x4E0B, 0x5DE6, 0x53F3, 0x533B, 0x5B97, 0x5B66,
    0x76E3, 0x4F01, 0x8CC7, 0x5354, 0x591C, 0x0033, 0x0036, 0x0033, 0x0037, 0x0033, 0x0038, 0x0033,
    0x0039, 0x0034, 0x0030, 0x0034, 0x0031, 0x0034, 0x0032, 0x0034, 0x0033, 0x0034, 0x0034, 0x0034,
    0x0035, 0x0034, 0x0036, 0x0034, 0x0037, 0x0034, 0x0038, 0x0034, 0x0039, 0x0035, 0x0030};
static unsigned short unicode_unacc_data169[] = {
    0x0031, 0x6708, 0x0032, 0x6708, 0x0033, 0x6708, 0x0034, 0x6708, 0x0035, 0x6708, 0x0036,
    0x6708, 0x0037, 0x6708, 0x0038, 0x6708, 0x0039, 0x6708, 0x0031, 0x0030, 0x6708, 0x0031,
    0x0031, 0x6708, 0x0031, 0x0032, 0x6708, 0x0048, 0x0067, 0x0065, 0x0072, 0x0067, 0x0065,
    0x0056, 0x004C, 0x0054, 0x0044, 0x30A2, 0x30A4, 0x30A6, 0x30A8, 0x30AA, 0x30AB, 0x30AD,
    0x30AF, 0x30B1, 0x30B3, 0x30B5, 0x30B7, 0x30B9, 0x30BB, 0x30BD, 0x30BF};
static unsigned short unicode_unacc_data170[] = {
    0x30C1, 0x30C4, 0x30C6, 0x30C8, 0x30CA, 0x30CB, 0x30CC, 0x30CD, 0x30CE, 0x30CF, 0x30D2,
    0x30D5, 0x30D8, 0x30DB, 0x30DE, 0x30DF, 0x30E0, 0x30E1, 0x30E2, 0x30E4, 0x30E6, 0x30E8,
    0x30E9, 0x30EA, 0x30EB, 0x30EC, 0x30ED, 0x30EF, 0x30F0, 0x30F1, 0x30F2, 0xFFFF};
static unsigned short unicode_unacc_data171[] = {
    0x30A2, 0x30FC, 0x30C8, 0x30CF, 0x30A2, 0x30EB, 0x30D5, 0x30A1, 0x30A2, 0x30F3, 0x30A2, 0x30D8,
    0x30A2, 0x30FC, 0x30EB, 0x30A4, 0x30CB, 0x30F3, 0x30AF, 0x30A4, 0x30F3, 0x30C1, 0x30A6, 0x30A9,
    0x30F3, 0x30A8, 0x30B9, 0x30AF, 0x30FC, 0x30C8, 0x30A8, 0x30FC, 0x30AB, 0x30FC, 0x30AA, 0x30F3,
    0x30B9, 0x30AA, 0x30FC, 0x30E0, 0x30AB, 0x30A4, 0x30EA, 0x30AB, 0x30E9, 0x30C3, 0x30C8, 0x30AB,
    0x30ED, 0x30EA, 0x30FC, 0x30ED, 0x30F3, 0x30AB, 0x30F3, 0x30DE, 0x30AB, 0x30AD, 0x30AB, 0x30CB,
    0x30FC, 0x30AD, 0x30AD, 0x30E5, 0x30EA, 0x30FC, 0x30EB, 0x30FC, 0x30AD, 0x30BF, 0x30AD, 0x30ED,
    0x30AD, 0x30ED, 0x30E9, 0x30E0, 0x30AF, 0x30AD, 0x30ED, 0x30E1, 0x30FC, 0x30C8, 0x30EB, 0x30AD,
    0x30ED, 0x30EF, 0x30C3, 0x30C8, 0x30E9, 0x30E0, 0x30AF, 0x30E9, 0x30E0, 0x30C8, 0x30F3, 0x30AF,
    0x30AF, 0x30EB, 0x30A4, 0x30ED, 0x30BB, 0x30AF, 0x30ED, 0x30FC, 0x30CD, 0x30B1, 0x30FC, 0x30B9,
    0x30B3, 0x30EB, 0x30CA, 0x30B3, 0x30FC, 0x30DB, 0x30B5, 0x30A4, 0x30AF, 0x30EB};
static unsigned short unicode_unacc_data172[] = {
    0x30B5, 0x30F3, 0x30C1, 0x30FC, 0x30E0, 0x30B7, 0x30EA, 0x30F3, 0x30AF, 0x30BB, 0x30F3, 0x30C1,
    0x30BB, 0x30F3, 0x30C8, 0x30FC, 0x30B9, 0x30BF, 0x30B7, 0x30C6, 0x30EB, 0x30C8, 0x30C8, 0x30F3,
    0x30CA, 0x30CE, 0x30CE, 0x30C3, 0x30C8, 0x30CF, 0x30A4, 0x30C4, 0x30FC, 0x30BB, 0x30F3, 0x30C8,
    0x30CF, 0x30FC, 0x30C4, 0x30CF, 0x30FC, 0x30EC, 0x30EB, 0x30CF, 0x30A2, 0x30B9, 0x30C8, 0x30EB,
    0x30D2, 0x30AF, 0x30EB, 0x30D2, 0x30B3, 0x30D2, 0x30EB, 0x30D2, 0x30D5, 0x30A1, 0x30E9, 0x30C3,
    0x30C8, 0x30D5, 0x30A3, 0x30FC, 0x30C8, 0x30C3, 0x30B7, 0x30A7, 0x30EB, 0x30D5, 0x30D5, 0x30E9,
    0x30F3, 0x30D8, 0x30AF, 0x30BF, 0x30FC, 0x30EB, 0x30BD, 0x30D8, 0x30CB, 0x30D2, 0x30D8, 0x30D8,
    0x30EB, 0x30C4, 0x30F3, 0x30B9, 0x30D8, 0x30FC, 0x30D8, 0x30B7, 0x30FC, 0x30BF, 0x30D8, 0x30A4,
    0x30F3, 0x30C8, 0x30DB, 0x30EB, 0x30C8, 0x30DB, 0x30DB, 0x30F3};
static unsigned short unicode_unacc_data173[] = {
    0x30F3, 0x30DB, 0x30C8, 0x30DB, 0x30FC, 0x30EB, 0x30DB, 0x30FC, 0x30F3, 0x30DE, 0x30A4, 0x30AF,
    0x30ED, 0x30DE, 0x30A4, 0x30EB, 0x30DE, 0x30C3, 0x30CF, 0x30DE, 0x30EB, 0x30AF, 0x30DE, 0x30F3,
    0x30B7, 0x30E7, 0x30F3, 0x30DF, 0x30AF, 0x30ED, 0x30F3, 0x30DF, 0x30EA, 0x30DF, 0x30EA, 0x30FC,
    0x30EB, 0x30CF, 0x30E1, 0x30AB, 0x30E1, 0x30C8, 0x30F3, 0x30AB, 0x30E1, 0x30FC, 0x30C8, 0x30EB,
    0x30E4, 0x30FC, 0x30C8, 0x30E4, 0x30FC, 0x30EB, 0x30E6, 0x30A2, 0x30F3, 0x30EA, 0x30C3, 0x30C8,
    0x30EB, 0x30EA, 0x30E9, 0x30EB, 0x30FC, 0x30D2, 0x30EB, 0x30FC, 0x30EB, 0x30D5, 0x30EC, 0x30E0,
    0x30EC, 0x30F3, 0x30C8, 0x30F3, 0x30B1, 0x30EF, 0x30C3, 0x30C8, 0x0030, 0x70B9, 0x0031, 0x70B9,
    0x0032, 0x70B9, 0x0033, 0x70B9, 0x0034, 0x70B9, 0x0035, 0x70B9, 0x0036, 0x70B9, 0x0037, 0x70B9};
static unsigned short unicode_unacc_data174[] = {
    0x0038, 0x70B9, 0x0039, 0x70B9, 0x0031, 0x0030, 0x70B9, 0x0031, 0x0031, 0x70B9, 0x0031,
    0x0032, 0x70B9, 0x0031, 0x0033, 0x70B9, 0x0031, 0x0034, 0x70B9, 0x0031, 0x0035, 0x70B9,
    0x0031, 0x0036, 0x70B9, 0x0031, 0x0037, 0x70B9, 0x0031, 0x0038, 0x70B9, 0x0031, 0x0039,
    0x70B9, 0x0032, 0x0030, 0x70B9, 0x0032, 0x0031, 0x70B9, 0x0032, 0x0032, 0x70B9, 0x0032,
    0x0033, 0x70B9, 0x0032, 0x0034, 0x70B9, 0x0068, 0x0050, 0x0061, 0x0064, 0x0061, 0x0041,
    0x0055, 0x0062, 0x0061, 0x0072, 0x006F, 0x0056, 0x0070, 0x0063, 0x0064, 0x006D, 0x0064,
    0x006D, 0x0032, 0x0064, 0x006D, 0x0033, 0x0049, 0x0055, 0x5E73, 0x6210, 0x662D, 0x548C,
    0x5927, 0x6B63, 0x660E, 0x6CBB, 0x682A, 0x5F0F, 0x4F1A, 0x793E};
static unsigned short unicode_unacc_data175[] = {
    0x0070, 0x0041, 0x006E, 0x0041, 0x03BC, 0x0041, 0x006D, 0x0041, 0x006B, 0x0041, 0x004B, 0x0042,
    0x004D, 0x0042, 0x0047, 0x0042, 0x0063, 0x0061, 0x006C, 0x006B, 0x0063, 0x0061, 0x006C, 0x0070,
    0x0046, 0x006E, 0x0046, 0x03BC, 0x0046, 0x03BC, 0x0067, 0x006D, 0x0067, 0x006B, 0x0067, 0x0048,
    0x007A, 0x006B, 0x0048, 0x007A, 0x004D, 0x0048, 0x007A, 0x0047, 0x0048, 0x007A, 0x0054, 0x0048,
    0x007A, 0x03BC, 0x006C, 0x006D, 0x006C, 0x0064, 0x006C, 0x006B, 0x006C, 0x0066, 0x006D, 0x006E,
    0x006D, 0x03BC, 0x006D, 0x006D, 0x006D, 0x0063, 0x006D, 0x006B, 0x006D, 0x006D, 0x006D, 0x0032};
static unsigned short unicode_unacc_data176[] = {
    0x0063, 0x006D, 0x0032, 0x006D, 0x0032, 0x006B, 0x006D, 0x0032, 0x006D, 0x006D, 0x0033, 0x0063,
    0x006D, 0x0033, 0x006D, 0x0033, 0x006B, 0x006D, 0x0033, 0x006D, 0x2215, 0x0073, 0x006D, 0x2215,
    0x0073, 0x0032, 0x0050, 0x0061, 0x006B, 0x0050, 0x0061, 0x004D, 0x0050, 0x0061, 0x0047, 0x0050,
    0x0061, 0x0072, 0x0061, 0x0064, 0x0072, 0x0061, 0x0064, 0x2215, 0x0073, 0x0072, 0x0061, 0x0064,
    0x2215, 0x0073, 0x0032, 0x0070, 0x0073, 0x006E, 0x0073, 0x03BC, 0x0073, 0x006D, 0x0073, 0x0070,
    0x0056, 0x006E, 0x0056, 0x03BC, 0x0056, 0x006D, 0x0056, 0x006B, 0x0056, 0x004D, 0x0056, 0x0070,
    0x0057, 0x006E, 0x0057, 0x03BC, 0x0057, 0x006D, 0x0057, 0x006B, 0x0057, 0x004D, 0x0057};
static unsigned short unicode_unacc_data177[] = {
    0x006B, 0x03A9, 0x004D, 0x03A9, 0x0061, 0x002E, 0x006D, 0x002E, 0x0042, 0x0071, 0x0063,
    0x0063, 0x0063, 0x0064, 0x0043, 0x2215, 0x006B, 0x0067, 0x0043, 0x006F, 0x002E, 0x0064,
    0x0042, 0x0047, 0x0079, 0x0068, 0x0061, 0x0048, 0x0050, 0x0069, 0x006E, 0x004B, 0x004B,
    0x004B, 0x004D, 0x006B, 0x0074, 0x006C, 0x006D, 0x006C, 0x006E, 0x006C, 0x006F, 0x0067,
    0x006C, 0x0078, 0x006D, 0x0062, 0x006D, 0x0069, 0x006C, 0x006D, 0x006F, 0x006C, 0x0050,
    0x0048, 0x0070, 0x002E, 0x006D, 0x002E, 0x0050, 0x0050, 0x004D, 0x0050, 0x0052, 0x0073,
    0x0072, 0x0053, 0x0076, 0x0057, 0x0062, 0x0056, 0x2215, 0x006D, 0x0041, 0x2215, 0x006D};
static unsigned short unicode_unacc_data178[] = {
    0x0031, 0x65E5, 0x0032, 0x65E5, 0x0033, 0x65E5, 0x0034, 0x65E5, 0x0035, 0x65E5, 0x0036,
    0x65E5, 0x0037, 0x65E5, 0x0038, 0x65E5, 0x0039, 0x65E5, 0x0031, 0x0030, 0x65E5, 0x0031,
    0x0031, 0x65E5, 0x0031, 0x0032, 0x65E5, 0x0031, 0x0033, 0x65E5, 0x0031, 0x0034, 0x65E5,
    0x0031, 0x0035, 0x65E5, 0x0031, 0x0036, 0x65E5, 0x0031, 0x0037, 0x65E5, 0x0031, 0x0038,
    0x65E5, 0x0031, 0x0039, 0x65E5, 0x0032, 0x0030, 0x65E5, 0x0032, 0x0031, 0x65E5, 0x0032,
    0x0032, 0x65E5, 0x0032, 0x0033, 0x65E5, 0x0032, 0x0034, 0x65E5, 0x0032, 0x0035, 0x65E5,
    0x0032, 0x0036, 0x65E5, 0x0032, 0x0037, 0x65E5, 0x0032, 0x0038, 0x65E5, 0x0032, 0x0039,
    0x65E5, 0x0033, 0x0030, 0x65E5, 0x0033, 0x0031, 0x65E5, 0x0067, 0x0061, 0x006C};
static unsigned short unicode_unacc_data179[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x042B, 0x044B, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data180[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0422,
    0x0442, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data181[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xA72C, 0xA72D, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xA738, 0xA739, 0xFFFF, 0xFFFF, 0xFFFF, 0x2184};
static unsigned short unicode_unacc_data182[] = {
    0x004B, 0x006B, 0x004B, 0x006B, 0x004B, 0x006B, 0xFFFF, 0xFFFF, 0x004C, 0x006C, 0x004F,
    0x006F, 0x004F, 0x006F, 0xFFFF, 0xFFFF, 0x0050, 0x0070, 0x0050, 0x0070, 0x0050, 0x0070,
    0x0051, 0x0071, 0x0051, 0x0071, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0056, 0x0076};
static unsigned short unicode_unacc_data183[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x00DE, 0x00FE, 0x00DE, 0x00FE, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xA76F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data184[] = {
    0x8C48, 0x66F4, 0x8ECA, 0x8CC8, 0x6ED1, 0x4E32, 0x53E5, 0x9F9C, 0x9F9C, 0x5951, 0x91D1,
    0x5587, 0x5948, 0x61F6, 0x7669, 0x7F85, 0x863F, 0x87BA, 0x88F8, 0x908F, 0x6A02, 0x6D1B,
    0x70D9, 0x73DE, 0x843D, 0x916A, 0x99F1, 0x4E82, 0x5375, 0x6B04, 0x721B, 0x862D};
static unsigned short unicode_unacc_data185[] = {
    0x9E1E, 0x5D50, 0x6FEB, 0x85CD, 0x8964, 0x62C9, 0x81D8, 0x881F, 0x5ECA, 0x6717, 0x6D6A,
    0x72FC, 0x90CE, 0x4F86, 0x51B7, 0x52DE, 0x64C4, 0x6AD3, 0x7210, 0x76E7, 0x8001, 0x8606,
    0x865C, 0x8DEF, 0x9732, 0x9B6F, 0x9DFA, 0x788C, 0x797F, 0x7DA0, 0x83C9, 0x9304};
static unsigned short unicode_unacc_data186[] = {
    0x9E7F, 0x8AD6, 0x58DF, 0x5F04, 0x7C60, 0x807E, 0x7262, 0x78CA, 0x8CC2, 0x96F7, 0x58D8,
    0x5C62, 0x6A13, 0x6DDA, 0x6F0F, 0x7D2F, 0x7E37, 0x964B, 0x52D2, 0x808B, 0x51DC, 0x51CC,
    0x7A1C, 0x7DBE, 0x83F1, 0x9675, 0x8B80, 0x62CF, 0x6A02, 0x8AFE, 0x4E39, 0x5BE7};
static unsigned short unicode_unacc_data187[] = {
    0x6012, 0x7387, 0x7570, 0x5317, 0x78FB, 0x4FBF, 0x5FA9, 0x4E0D, 0x6CCC, 0x6578, 0x7D22,
    0x53C3, 0x585E, 0x7701, 0x8449, 0x8AAA, 0x6BBA, 0x8FB0, 0x6C88, 0x62FE, 0x82E5, 0x63A0,
    0x7565, 0x4EAE, 0x5169, 0x51C9, 0x6881, 0x7CE7, 0x826F, 0x8AD2, 0x91CF, 0x52F5};
static unsigned short unicode_unacc_data188[] = {
    0x5442, 0x5973, 0x5EEC, 0x65C5, 0x6FFE, 0x792A, 0x95AD, 0x9A6A, 0x9E97, 0x9ECE, 0x529B,
    0x66C6, 0x6B77, 0x8F62, 0x5E74, 0x6190, 0x6200, 0x649A, 0x6F23, 0x7149, 0x7489, 0x79CA,
    0x7DF4, 0x806F, 0x8F26, 0x84EE, 0x9023, 0x934A, 0x5217, 0x52A3, 0x54BD, 0x70C8};
static unsigned short unicode_unacc_data189[] = {
    0x88C2, 0x8AAA, 0x5EC9, 0x5FF5, 0x637B, 0x6BAE, 0x7C3E, 0x7375, 0x4EE4, 0x56F9, 0x5BE7,
    0x5DBA, 0x601C, 0x73B2, 0x7469, 0x7F9A, 0x8046, 0x9234, 0x96F6, 0x9748, 0x9818, 0x4F8B,
    0x79AE, 0x91B4, 0x96B8, 0x60E1, 0x4E86, 0x50DA, 0x5BEE, 0x5C3F, 0x6599, 0x6A02};
static unsigned short unicode_unacc_data190[] = {
    0x71CE, 0x7642, 0x84FC, 0x907C, 0x9F8D, 0x6688, 0x962E, 0x5289, 0x677B, 0x67F3, 0x6D41,
    0x6E9C, 0x7409, 0x7559, 0x786B, 0x7D10, 0x985E, 0x516D, 0x622E, 0x9678, 0x502B, 0x5D19,
    0x6DEA, 0x8F2A, 0x5F8B, 0x6144, 0x6817, 0x7387, 0x9686, 0x5229, 0x540F, 0x5C65};
static unsigned short unicode_unacc_data191[] = {
    0x6613, 0x674E, 0x68A8, 0x6CE5, 0x7406, 0x75E2, 0x7F79, 0x88CF, 0x88E1, 0x91CC, 0x96E2,
    0x533F, 0x6EBA, 0x541D, 0x71D0, 0x7498, 0x85FA, 0x96A3, 0x9C57, 0x9E9F, 0x6797, 0x6DCB,
    0x81E8, 0x7ACB, 0x7B20, 0x7C92, 0x72C0, 0x7099, 0x8B58, 0x4EC0, 0x8336, 0x523A};
static unsigned short unicode_unacc_data192[] = {
    0x5207, 0x5EA6, 0x62D3, 0x7CD6, 0x5B85, 0x6D1E, 0x66B4, 0x8F3B, 0x884C, 0x964D, 0x898B,
    0x5ED3, 0x5140, 0x55C0, 0xFFFF, 0xFFFF, 0x585A, 0xFFFF, 0x6674, 0xFFFF, 0xFFFF, 0x51DE,
    0x732A, 0x76CA, 0x793C, 0x795E, 0x7965, 0x798F, 0x9756, 0x7CBE, 0x7FBD, 0xFFFF};
static unsigned short unicode_unacc_data193[] = {
    0x8612, 0xFFFF, 0x8AF8, 0xFFFF, 0xFFFF, 0x9038, 0x90FD, 0xFFFF, 0xFFFF, 0xFFFF, 0x98EF,
    0x98FC, 0x9928, 0x9DB4, 0xFFFF, 0xFFFF, 0x4FAE, 0x50E7, 0x514D, 0x52C9, 0x52E4, 0x5351,
    0x559D, 0x5606, 0x5668, 0x5840, 0x58A8, 0x5C64, 0x5C6E, 0x6094, 0x6168, 0x618E};
static unsigned short unicode_unacc_data194[] = {
    0x61F2, 0x654F, 0x65E2, 0x6691, 0x6885, 0x6D77, 0x6E1A, 0x6F22, 0x716E, 0x722B, 0x7422,
    0x7891, 0x793E, 0x7949, 0x7948, 0x7950, 0x7956, 0x795D, 0x798D, 0x798E, 0x7A40, 0x7A81,
    0x7BC0, 0x7DF4, 0x7E09, 0x7E41, 0x7F72, 0x8005, 0x81ED, 0x8279, 0x8279, 0x8457};
static unsigned short unicode_unacc_data195[] = {
    0x8910, 0x8996, 0x8B01, 0x8B39, 0x8CD3, 0x8D08, 0x8FB6, 0x9038, 0x96E3, 0x97FF, 0x983B,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x4E26, 0x51B5, 0x5168, 0x4F80, 0x5145, 0x5180,
    0x52C7, 0x52FA, 0x559D, 0x5555, 0x5599, 0x55E2, 0x585A, 0x58B3, 0x5944, 0x5954};
static unsigned short unicode_unacc_data196[] = {
    0x5A62, 0x5B28, 0x5ED2, 0x5ED9, 0x5F69, 0x5FAD, 0x60D8, 0x614E, 0x6108, 0x618E, 0x6160,
    0x61F2, 0x6234, 0x63C4, 0x641C, 0x6452, 0x6556, 0x6674, 0x6717, 0x671B, 0x6756, 0x6B79,
    0x6BBA, 0x6D41, 0x6EDB, 0x6ECB, 0x6F22, 0x701E, 0x716E, 0x77A7, 0x7235, 0x72AF};
static unsigned short unicode_unacc_data197[] = {
    0x732A, 0x7471, 0x7506, 0x753B, 0x761D, 0x761F, 0x76CA, 0x76DB, 0x76F4, 0x774A, 0x7740,
    0x78CC, 0x7AB1, 0x7BC0, 0x7C7B, 0x7D5B, 0x7DF4, 0x7F3E, 0x8005, 0x8352, 0x83EF, 0x8779,
    0x8941, 0x8986, 0x8996, 0x8ABF, 0x8AF8, 0x8ACB, 0x8B01, 0x8AFE, 0x8AED, 0x8B39};
static unsigned short unicode_unacc_data198[] = {
    0x8B8A, 0x8D08, 0x8F38, 0x9072, 0x9199, 0x9276, 0x967C, 0x96E3, 0x9756, 0x97DB, 0x97FF,
    0x980B, 0x983B, 0x9B12, 0x9F9C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x4018, 0x4039, 0xFFFF,
    0xFFFF, 0xFFFF, 0x9F43, 0x9F8E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data199[] = {
    0x0066, 0x0066, 0x0066, 0x0069, 0x0066, 0x006C, 0x0066, 0x0066, 0x0069, 0x0066, 0x0066, 0x006C,
    0x0074, 0x0073, 0x0073, 0x0074, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0574, 0x0576, 0x0574, 0x0565, 0x0574, 0x056B, 0x057E, 0x0576,
    0x0574, 0x056D, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x05D9, 0xFFFF, 0x05F2};
static unsigned short unicode_unacc_data200[] = {
    0x05E2, 0x05D0, 0x05D3, 0x05D4, 0x05DB, 0x05DC, 0x05DD, 0x05E8, 0x05EA, 0x002B, 0x05E9,
    0x05E9, 0x05E9, 0x05E9, 0x05D0, 0x05D0, 0x05D0, 0x05D1, 0x05D2, 0x05D3, 0x05D4, 0x05D5,
    0x05D6, 0xFFFF, 0x05D8, 0x05D9, 0x05DA, 0x05DB, 0x05DC, 0xFFFF, 0x05DE, 0xFFFF};
static unsigned short unicode_unacc_data201[] = {
    0x05E0, 0x05E1, 0xFFFF, 0x05E3, 0x05E4, 0xFFFF, 0x05E6, 0x05E7, 0x05E8, 0x05E9, 0x05EA,
    0x05D5, 0x05D1, 0x05DB, 0x05E4, 0x05D0, 0x05DC, 0x0671, 0x0671, 0x067B, 0x067B, 0x067B,
    0x067B, 0x067E, 0x067E, 0x067E, 0x067E, 0x0680, 0x0680, 0x0680, 0x0680, 0x067A, 0x067A};
static unsigned short unicode_unacc_data202[] = {
    0x067A, 0x067A, 0x067F, 0x067F, 0x067F, 0x067F, 0x0679, 0x0679, 0x0679, 0x0679, 0x06A4,
    0x06A4, 0x06A4, 0x06A4, 0x06A6, 0x06A6, 0x06A6, 0x06A6, 0x0684, 0x0684, 0x0684, 0x0684,
    0x0683, 0x0683, 0x0683, 0x0683, 0x0686, 0x0686, 0x0686, 0x0686, 0x0687, 0x0687};
static unsigned short unicode_unacc_data203[] = {
    0x0687, 0x0687, 0x068D, 0x068D, 0x068C, 0x068C, 0x068E, 0x068E, 0x0688, 0x0688, 0x0698,
    0x0698, 0x0691, 0x0691, 0x06A9, 0x06A9, 0x06A9, 0x06A9, 0x06AF, 0x06AF, 0x06AF, 0x06AF,
    0x06B3, 0x06B3, 0x06B3, 0x06B3, 0x06B1, 0x06B1, 0x06B1, 0x06B1, 0x06BA, 0x06BA};
static unsigned short unicode_unacc_data204[] = {
    0x06BB, 0x06BB, 0x06BB, 0x06BB, 0x06D5, 0x06D5, 0x06C1, 0x06C1, 0x06C1, 0x06C1, 0x06BE,
    0x06BE, 0x06BE, 0x06BE, 0x06D2, 0x06D2, 0x06D2, 0x06D2, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data205[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x06AD, 0x06AD, 0x06AD,
    0x06AD, 0x06C7, 0x06C7, 0x06C6, 0x06C6, 0x06C8, 0x06C8, 0x06C7, 0x0674, 0x06CB, 0x06CB};
static unsigned short unicode_unacc_data206[] = {
    0x06C5, 0x06C5, 0x06C9, 0x06C9, 0x06D0, 0x06D0, 0x06D0, 0x06D0, 0x0649, 0x0649,
    0x0627, 0x064A, 0x0627, 0x064A, 0x06D5, 0x064A, 0x06D5, 0x064A, 0x0648, 0x064A,
    0x0648, 0x064A, 0x06C7, 0x064A, 0x06C7, 0x064A, 0x06C6, 0x064A, 0x06C6, 0x064A,
    0x06C8, 0x064A, 0x06C8, 0x064A, 0x06D0, 0x064A, 0x06D0, 0x064A, 0x06D0, 0x064A,
    0x0649, 0x064A, 0x0649, 0x064A, 0x0649, 0x064A, 0x06CC, 0x06CC, 0x06CC, 0x06CC};
static unsigned short unicode_unacc_data207[] = {
    0x062C, 0x064A, 0x062D, 0x064A, 0x0645, 0x064A, 0x0649, 0x064A, 0x064A, 0x064A, 0x0628,
    0x062C, 0x0628, 0x062D, 0x0628, 0x062E, 0x0628, 0x0645, 0x0628, 0x0649, 0x0628, 0x064A,
    0x062A, 0x062C, 0x062A, 0x062D, 0x062A, 0x062E, 0x062A, 0x0645, 0x062A, 0x0649, 0x062A,
    0x064A, 0x062B, 0x062C, 0x062B, 0x0645, 0x062B, 0x0649, 0x062B, 0x064A, 0x062C, 0x062D,
    0x062C, 0x0645, 0x062D, 0x062C, 0x062D, 0x0645, 0x062E, 0x062C, 0x062E, 0x062D, 0x062E,
    0x0645, 0x0633, 0x062C, 0x0633, 0x062D, 0x0633, 0x062E, 0x0633, 0x0645};
static unsigned short unicode_unacc_data208[] = {
    0x0635, 0x062D, 0x0635, 0x0645, 0x0636, 0x062C, 0x0636, 0x062D, 0x0636, 0x062E, 0x0636,
    0x0645, 0x0637, 0x062D, 0x0637, 0x0645, 0x0638, 0x0645, 0x0639, 0x062C, 0x0639, 0x0645,
    0x063A, 0x062C, 0x063A, 0x0645, 0x0641, 0x062C, 0x0641, 0x062D, 0x0641, 0x062E, 0x0641,
    0x0645, 0x0641, 0x0649, 0x0641, 0x064A, 0x0642, 0x062D, 0x0642, 0x0645, 0x0642, 0x0649,
    0x0642, 0x064A, 0x0643, 0x0627, 0x0643, 0x062C, 0x0643, 0x062D, 0x0643, 0x062E, 0x0643,
    0x0644, 0x0643, 0x0645, 0x0643, 0x0649, 0x0643, 0x064A, 0x0644, 0x062C};
static unsigned short unicode_unacc_data209[] = {
    0x0644, 0x062D, 0x0644, 0x062E, 0x0644, 0x0645, 0x0644, 0x0649, 0x0644, 0x064A, 0x0645, 0x062C,
    0x0645, 0x062D, 0x0645, 0x062E, 0x0645, 0x0645, 0x0645, 0x0649, 0x0645, 0x064A, 0x0646, 0x062C,
    0x0646, 0x062D, 0x0646, 0x062E, 0x0646, 0x0645, 0x0646, 0x0649, 0x0646, 0x064A, 0x0647, 0x062C,
    0x0647, 0x0645, 0x0647, 0x0649, 0x0647, 0x064A, 0x064A, 0x062C, 0x064A, 0x062D, 0x064A, 0x062E,
    0x064A, 0x0645, 0x064A, 0x0649, 0x064A, 0x064A, 0x0630, 0x0631, 0x0649, 0x0020, 0x0020};
static unsigned short unicode_unacc_data210[] = {
    0x0020, 0x0020, 0x0020, 0x0020, 0x0631, 0x064A, 0x0632, 0x064A, 0x0645, 0x064A, 0x0646, 0x064A,
    0x0649, 0x064A, 0x064A, 0x064A, 0x0628, 0x0631, 0x0628, 0x0632, 0x0628, 0x0645, 0x0628, 0x0646,
    0x0628, 0x0649, 0x0628, 0x064A, 0x062A, 0x0631, 0x062A, 0x0632, 0x062A, 0x0645, 0x062A, 0x0646,
    0x062A, 0x0649, 0x062A, 0x064A, 0x062B, 0x0631, 0x062B, 0x0632, 0x062B, 0x0645, 0x062B, 0x0646,
    0x062B, 0x0649, 0x062B, 0x064A, 0x0641, 0x0649, 0x0641, 0x064A, 0x0642, 0x0649, 0x0642, 0x064A};
static unsigned short unicode_unacc_data211[] = {
    0x0643, 0x0627, 0x0643, 0x0644, 0x0643, 0x0645, 0x0643, 0x0649, 0x0643, 0x064A, 0x0644,
    0x0645, 0x0644, 0x0649, 0x0644, 0x064A, 0x0645, 0x0627, 0x0645, 0x0645, 0x0646, 0x0631,
    0x0646, 0x0632, 0x0646, 0x0645, 0x0646, 0x0646, 0x0646, 0x0649, 0x0646, 0x064A, 0x0649,
    0x064A, 0x0631, 0x064A, 0x0632, 0x064A, 0x0645, 0x064A, 0x0646, 0x064A, 0x0649, 0x064A,
    0x064A, 0x062C, 0x064A, 0x062D, 0x064A, 0x062E, 0x064A, 0x0645, 0x064A, 0x0647, 0x064A,
    0x0628, 0x062C, 0x0628, 0x062D, 0x0628, 0x062E, 0x0628, 0x0645};
static unsigned short unicode_unacc_data212[] = {
    0x0628, 0x0647, 0x062A, 0x062C, 0x062A, 0x062D, 0x062A, 0x062E, 0x062A, 0x0645, 0x062A,
    0x0647, 0x062B, 0x0645, 0x062C, 0x062D, 0x062C, 0x0645, 0x062D, 0x062C, 0x062D, 0x0645,
    0x062E, 0x062C, 0x062E, 0x0645, 0x0633, 0x062C, 0x0633, 0x062D, 0x0633, 0x062E, 0x0633,
    0x0645, 0x0635, 0x062D, 0x0635, 0x062E, 0x0635, 0x0645, 0x0636, 0x062C, 0x0636, 0x062D,
    0x0636, 0x062E, 0x0636, 0x0645, 0x0637, 0x062D, 0x0638, 0x0645, 0x0639, 0x062C, 0x0639,
    0x0645, 0x063A, 0x062C, 0x063A, 0x0645, 0x0641, 0x062C, 0x0641, 0x062D};
static unsigned short unicode_unacc_data213[] = {
    0x0641, 0x062E, 0x0641, 0x0645, 0x0642, 0x062D, 0x0642, 0x0645, 0x0643, 0x062C, 0x0643,
    0x062D, 0x0643, 0x062E, 0x0643, 0x0644, 0x0643, 0x0645, 0x0644, 0x062C, 0x0644, 0x062D,
    0x0644, 0x062E, 0x0644, 0x0645, 0x0644, 0x0647, 0x0645, 0x062C, 0x0645, 0x062D, 0x0645,
    0x062E, 0x0645, 0x0645, 0x0646, 0x062C, 0x0646, 0x062D, 0x0646, 0x062E, 0x0646, 0x0645,
    0x0646, 0x0647, 0x0647, 0x062C, 0x0647, 0x0645, 0x0647, 0x064A, 0x062C, 0x064A, 0x062D,
    0x064A, 0x062E, 0x064A, 0x0645, 0x064A, 0x0647, 0x0645, 0x064A};
static unsigned short unicode_unacc_data214[] = {
    0x0647, 0x064A, 0x0628, 0x0645, 0x0628, 0x0647, 0x062A, 0x0645, 0x062A, 0x0647, 0x062B,
    0x0645, 0x062B, 0x0647, 0x0633, 0x0645, 0x0633, 0x0647, 0x0634, 0x0645, 0x0634, 0x0647,
    0x0643, 0x0644, 0x0643, 0x0645, 0x0644, 0x0645, 0x0646, 0x0645, 0x0646, 0x0647, 0x064A,
    0x0645, 0x064A, 0x0647, 0x0640, 0x0640, 0x0640, 0x0637, 0x0649, 0x0637, 0x064A, 0x0639,
    0x0649, 0x0639, 0x064A, 0x063A, 0x0649, 0x063A, 0x064A, 0x0633, 0x0649, 0x0633, 0x064A,
    0x0634, 0x0649, 0x0634, 0x064A, 0x062D, 0x0649};
static unsigned short unicode_unacc_data215[] = {
    0x062D, 0x064A, 0x062C, 0x0649, 0x062C, 0x064A, 0x062E, 0x0649, 0x062E, 0x064A, 0x0635,
    0x0649, 0x0635, 0x064A, 0x0636, 0x0649, 0x0636, 0x064A, 0x0634, 0x062C, 0x0634, 0x062D,
    0x0634, 0x062E, 0x0634, 0x0645, 0x0634, 0x0631, 0x0633, 0x0631, 0x0635, 0x0631, 0x0636,
    0x0631, 0x0637, 0x0649, 0x0637, 0x064A, 0x0639, 0x0649, 0x0639, 0x064A, 0x063A, 0x0649,
    0x063A, 0x064A, 0x0633, 0x0649, 0x0633, 0x064A, 0x0634, 0x0649, 0x0634, 0x064A, 0x062D,
    0x0649, 0x062D, 0x064A, 0x062C, 0x0649, 0x062C, 0x064A, 0x062E, 0x0649};
static unsigned short unicode_unacc_data216[] = {
    0x062E, 0x064A, 0x0635, 0x0649, 0x0635, 0x064A, 0x0636, 0x0649, 0x0636, 0x064A, 0x0634, 0x062C,
    0x0634, 0x062D, 0x0634, 0x062E, 0x0634, 0x0645, 0x0634, 0x0631, 0x0633, 0x0631, 0x0635, 0x0631,
    0x0636, 0x0631, 0x0634, 0x062C, 0x0634, 0x062D, 0x0634, 0x062E, 0x0634, 0x0645, 0x0633, 0x0647,
    0x0634, 0x0647, 0x0637, 0x0645, 0x0633, 0x062C, 0x0633, 0x062D, 0x0633, 0x062E, 0x0634, 0x062C,
    0x0634, 0x062D, 0x0634, 0x062E, 0x0637, 0x0645, 0x0638, 0x0645, 0x0627, 0x0627, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data217[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x062A, 0x062C, 0x0645, 0x062A, 0x062D, 0x062C,
    0x062A, 0x062D, 0x062C, 0x062A, 0x062D, 0x0645, 0x062A, 0x062E, 0x0645, 0x062A, 0x0645,
    0x062C, 0x062A, 0x0645, 0x062D, 0x062A, 0x0645, 0x062E, 0x062C, 0x0645, 0x062D, 0x062C,
    0x0645, 0x062D, 0x062D, 0x0645, 0x064A, 0x062D, 0x0645, 0x0649, 0x0633, 0x062D, 0x062C,
    0x0633, 0x062C, 0x062D, 0x0633, 0x062C, 0x0649, 0x0633, 0x0645, 0x062D};
static unsigned short unicode_unacc_data218[] = {
    0x0633, 0x0645, 0x062D, 0x0633, 0x0645, 0x062C, 0x0633, 0x0645, 0x0645, 0x0633, 0x0645, 0x0645,
    0x0635, 0x062D, 0x062D, 0x0635, 0x062D, 0x062D, 0x0635, 0x0645, 0x0645, 0x0634, 0x062D, 0x0645,
    0x0634, 0x062D, 0x0645, 0x0634, 0x062C, 0x064A, 0x0634, 0x0645, 0x062E, 0x0634, 0x0645, 0x062E,
    0x0634, 0x0645, 0x0645, 0x0634, 0x0645, 0x0645, 0x0636, 0x062D, 0x0649, 0x0636, 0x062E, 0x0645,
    0x0636, 0x062E, 0x0645, 0x0637, 0x0645, 0x062D, 0x0637, 0x0645, 0x062D, 0x0637, 0x0645, 0x0645,
    0x0637, 0x0645, 0x064A, 0x0639, 0x062C, 0x0645, 0x0639, 0x0645, 0x0645, 0x0639, 0x0645, 0x0645,
    0x0639, 0x0645, 0x0649, 0x063A, 0x0645, 0x0645, 0x063A, 0x0645, 0x064A, 0x063A, 0x0645, 0x0649,
    0x0641, 0x062E, 0x0645, 0x0641, 0x062E, 0x0645, 0x0642, 0x0645, 0x062D, 0x0642, 0x0645, 0x0645};
static unsigned short unicode_unacc_data219[] = {
    0x0644, 0x062D, 0x0645, 0x0644, 0x062D, 0x064A, 0x0644, 0x062D, 0x0649, 0x0644, 0x062C, 0x062C,
    0x0644, 0x062C, 0x062C, 0x0644, 0x062E, 0x0645, 0x0644, 0x062E, 0x0645, 0x0644, 0x0645, 0x062D,
    0x0644, 0x0645, 0x062D, 0x0645, 0x062D, 0x062C, 0x0645, 0x062D, 0x0645, 0x0645, 0x062D, 0x064A,
    0x0645, 0x062C, 0x062D, 0x0645, 0x062C, 0x0645, 0x0645, 0x062E, 0x062C, 0x0645, 0x062E, 0x0645,
    0xFFFF, 0xFFFF, 0x0645, 0x062C, 0x062E, 0x0647, 0x0645, 0x062C, 0x0647, 0x0645, 0x0645, 0x0646,
    0x062D, 0x0645, 0x0646, 0x062D, 0x0649, 0x0646, 0x062C, 0x0645, 0x0646, 0x062C, 0x0645, 0x0646,
    0x062C, 0x0649, 0x0646, 0x0645, 0x064A, 0x0646, 0x0645, 0x0649, 0x064A, 0x0645, 0x0645, 0x064A,
    0x0645, 0x0645, 0x0628, 0x062E, 0x064A, 0x062A, 0x062C, 0x064A};
static unsigned short unicode_unacc_data220[] = {
    0x062A, 0x062C, 0x0649, 0x062A, 0x062E, 0x064A, 0x062A, 0x062E, 0x0649, 0x062A, 0x0645, 0x064A,
    0x062A, 0x0645, 0x0649, 0x062C, 0x0645, 0x064A, 0x062C, 0x062D, 0x0649, 0x062C, 0x0645, 0x0649,
    0x0633, 0x062E, 0x0649, 0x0635, 0x062D, 0x064A, 0x0634, 0x062D, 0x064A, 0x0636, 0x062D, 0x064A,
    0x0644, 0x062C, 0x064A, 0x0644, 0x0645, 0x064A, 0x064A, 0x062D, 0x064A, 0x064A, 0x062C, 0x064A,
    0x064A, 0x0645, 0x064A, 0x0645, 0x0645, 0x064A, 0x0642, 0x0645, 0x064A, 0x0646, 0x062D, 0x064A,
    0x0642, 0x0645, 0x062D, 0x0644, 0x062D, 0x0645, 0x0639, 0x0645, 0x064A, 0x0643, 0x0645, 0x064A,
    0x0646, 0x062C, 0x062D, 0x0645, 0x062E, 0x064A, 0x0644, 0x062C, 0x0645, 0x0643, 0x0645, 0x0645,
    0x0644, 0x062C, 0x0645, 0x0646, 0x062C, 0x062D, 0x062C, 0x062D, 0x064A, 0x062D, 0x062C, 0x064A};
static unsigned short unicode_unacc_data221[] = {
    0x0645, 0x062C, 0x064A, 0x0641, 0x0645, 0x064A, 0x0628, 0x062D, 0x064A, 0x0643, 0x0645, 0x0645,
    0x0639, 0x062C, 0x0645, 0x0635, 0x0645, 0x0645, 0x0633, 0x062E, 0x064A, 0x0646, 0x062C, 0x064A,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data222[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0635, 0x0644, 0x06D2, 0x0642, 0x0644, 0x06D2,
    0x0627, 0x0644, 0x0644, 0x0647, 0x0627, 0x0643, 0x0628, 0x0631, 0x0645, 0x062D, 0x0645,
    0x062F, 0x0635, 0x0644, 0x0639, 0x0645, 0x0631, 0x0633, 0x0648, 0x0644, 0x0639, 0x0644,
    0x064A, 0x0647, 0x0648, 0x0633, 0x0644, 0x0645, 0x0635, 0x0644, 0x0649, 0x0635, 0x0644,
    0x0649, 0x0020, 0x0627, 0x0644, 0x0644, 0x0647, 0x0020, 0x0639, 0x0644, 0x064A, 0x0647,
    0x0020, 0x0648, 0x0633, 0x0644, 0x0645, 0x062C, 0x0644, 0x0020, 0x062C, 0x0644, 0x0627,
    0x0644, 0x0647, 0x0631, 0x06CC, 0x0627, 0x0644, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data223[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x002C, 0x3001, 0x3002, 0x003A, 0x003B, 0x0021, 0x003F, 0x3016,
    0x3017, 0x002E, 0x002E, 0x002E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data224[] = {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x002E, 0x002E, 0x2014, 0x2013, 0x005F, 0x005F,
    0x0028, 0x0029, 0x007B, 0x007D, 0x3014, 0x3015, 0x3010, 0x3011, 0x300A, 0x300B, 0x3008};
static unsigned short unicode_unacc_data225[] = {
    0x3009, 0x300C, 0x300D, 0x300E, 0x300F, 0xFFFF, 0xFFFF, 0x005B, 0x005D, 0x0020, 0x0020,
    0x0020, 0x0020, 0x005F, 0x005F, 0x005F, 0x002C, 0x3001, 0x002E, 0xFFFF, 0x003B, 0x003A,
    0x003F, 0x0021, 0x2014, 0x0028, 0x0029, 0x007B, 0x007D, 0x3014, 0x3015, 0x0023};
static unsigned short unicode_unacc_data226[] = {
    0x0026, 0x002A, 0x002B, 0x002D, 0x003C, 0x003E, 0x003D, 0xFFFF, 0x005C, 0x0024, 0x0025,
    0x0040, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0020, 0x0640, 0x0020, 0xFFFF, 0x0020, 0xFFFF,
    0x0020, 0x0640, 0x0020, 0x0640, 0x0020, 0x0640, 0x0020, 0x0640, 0x0020, 0x0640};
static unsigned short unicode_unacc_data227[] = {
    0x0621, 0x0627, 0x0627, 0x0627, 0x0627, 0x0648, 0x0648, 0x0627, 0x0627, 0x064A, 0x064A,
    0x064A, 0x064A, 0x0627, 0x0627, 0x0628, 0x0628, 0x0628, 0x0628, 0x0629, 0x0629, 0x062A,
    0x062A, 0x062A, 0x062A, 0x062B, 0x062B, 0x062B, 0x062B, 0x062C, 0x062C, 0x062C};
static unsigned short unicode_unacc_data228[] = {
    0x062C, 0x062D, 0x062D, 0x062D, 0x062D, 0x062E, 0x062E, 0x062E, 0x062E, 0x062F, 0x062F,
    0x0630, 0x0630, 0x0631, 0x0631, 0x0632, 0x0632, 0x0633, 0x0633, 0x0633, 0x0633, 0x0634,
    0x0634, 0x0634, 0x0634, 0x0635, 0x0635, 0x0635, 0x0635, 0x0636, 0x0636, 0x0636};
static unsigned short unicode_unacc_data229[] = {
    0x0636, 0x0637, 0x0637, 0x0637, 0x0637, 0x0638, 0x0638, 0x0638, 0x0638, 0x0639, 0x0639,
    0x0639, 0x0639, 0x063A, 0x063A, 0x063A, 0x063A, 0x0641, 0x0641, 0x0641, 0x0641, 0x0642,
    0x0642, 0x0642, 0x0642, 0x0643, 0x0643, 0x0643, 0x0643, 0x0644, 0x0644, 0x0644};
static unsigned short unicode_unacc_data230[] = {
    0x0644, 0x0645, 0x0645, 0x0645, 0x0645, 0x0646, 0x0646, 0x0646, 0x0646, 0x0647,
    0x0647, 0x0647, 0x0647, 0x0648, 0x0648, 0x0649, 0x0649, 0x064A, 0x064A, 0x064A,
    0x064A, 0x0644, 0x0627, 0x0644, 0x0627, 0x0644, 0x0627, 0x0644, 0x0627, 0x0644,
    0x0627, 0x0644, 0x0627, 0x0644, 0x0627, 0x0644, 0x0627, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data231[] = {
    0xFFFF, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027, 0x0028, 0x0029, 0x002A,
    0x002B, 0x002C, 0x002D, 0x002E, 0x002F, 0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035,
    0x0036, 0x0037, 0x0038, 0x0039, 0x003A, 0x003B, 0x003C, 0x003D, 0x003E, 0x003F};
static unsigned short unicode_unacc_data232[] = {
    0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 0x0048, 0x0049, 0x004A,
    0x004B, 0x004C, 0x004D, 0x004E, 0x004F, 0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055,
    0x0056, 0x0057, 0x0058, 0x0059, 0x005A, 0x005B, 0x005C, 0x005D, 0x005E, 0x005F};
static unsigned short unicode_unacc_data233[] = {
    0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 0x0068, 0x0069, 0x006A,
    0x006B, 0x006C, 0x006D, 0x006E, 0x006F, 0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075,
    0x0076, 0x0077, 0x0078, 0x0079, 0x007A, 0x007B, 0x007C, 0x007D, 0x007E, 0x2985};
static unsigned short unicode_unacc_data234[] = {
    0x2986, 0x3002, 0x300C, 0x300D, 0x3001, 0x30FB, 0x30F2, 0x30A1, 0x30A3, 0x30A5, 0x30A7,
    0x30A9, 0x30E3, 0x30E5, 0x30E7, 0x30C3, 0x30FC, 0x30A2, 0x30A4, 0x30A6, 0x30A8, 0x30AA,
    0x30AB, 0x30AD, 0x30AF, 0x30B1, 0x30B3, 0x30B5, 0x30B7, 0x30B9, 0x30BB, 0x30BD};
static unsigned short unicode_unacc_data235[] = {
    0x30BF, 0x30C1, 0x30C4, 0x30C6, 0x30C8, 0x30CA, 0x30CB, 0x30CC, 0x30CD, 0x30CE, 0x30CF,
    0x30D2, 0x30D5, 0x30D8, 0x30DB, 0x30DE, 0x30DF, 0x30E0, 0x30E1, 0x30E2, 0x30E4, 0x30E6,
    0x30E8, 0x30E9, 0x30EA, 0x30EB, 0x30EC, 0x30ED, 0x30EF, 0x30F3, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data236[] = {
    0x1160, 0x1100, 0x1101, 0x11AA, 0x1102, 0x11AC, 0x11AD, 0x1103, 0x1104, 0x1105, 0x11B0,
    0x11B1, 0x11B2, 0x11B3, 0x11B4, 0x11B5, 0x111A, 0x1106, 0x1107, 0x1108, 0x1121, 0x1109,
    0x110A, 0x110B, 0x110C, 0x110D, 0x110E, 0x110F, 0x1110, 0x1111, 0x1112, 0xFFFF};
static unsigned short unicode_unacc_data237[] = {
    0xFFFF, 0xFFFF, 0x1161, 0x1162, 0x1163, 0x1164, 0x1165, 0x1166, 0xFFFF, 0xFFFF, 0x1167,
    0x1168, 0x1169, 0x116A, 0x116B, 0x116C, 0xFFFF, 0xFFFF, 0x116D, 0x116E, 0x116F, 0x1170,
    0x1171, 0x1172, 0xFFFF, 0xFFFF, 0x1173, 0x1174, 0x1175, 0xFFFF, 0xFFFF, 0xFFFF};
static unsigned short unicode_unacc_data238[] = {
    0x00A2, 0x00A3, 0x00AC, 0x0020, 0x00A6, 0x00A5, 0x20A9, 0xFFFF, 0x2502, 0x2190, 0x2191,
    0x2192, 0x2193, 0x25A0, 0x25CB, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF};

static unsigned short* unicode_unacc_data_table[UNICODE_UNACC_BLOCK_COUNT] = {
    unicode_unacc_data0,   unicode_unacc_data1,   unicode_unacc_data2,   unicode_unacc_data3,
    unicode_unacc_data4,   unicode_unacc_data5,   unicode_unacc_data6,   unicode_unacc_data7,
    unicode_unacc_data8,   unicode_unacc_data9,   unicode_unacc_data10,  unicode_unacc_data11,
    unicode_unacc_data12,  unicode_unacc_data13,  unicode_unacc_data14,  unicode_unacc_data15,
    unicode_unacc_data16,  unicode_unacc_data17,  unicode_unacc_data18,  unicode_unacc_data19,
    unicode_unacc_data20,  unicode_unacc_data21,  unicode_unacc_data22,  unicode_unacc_data23,
    unicode_unacc_data24,  unicode_unacc_data25,  unicode_unacc_data26,  unicode_unacc_data27,
    unicode_unacc_data28,  unicode_unacc_data29,  unicode_unacc_data30,  unicode_unacc_data31,
    unicode_unacc_data32,  unicode_unacc_data33,  unicode_unacc_data34,  unicode_unacc_data35,
    unicode_unacc_data36,  unicode_unacc_data37,  unicode_unacc_data38,  unicode_unacc_data39,
    unicode_unacc_data40,  unicode_unacc_data41,  unicode_unacc_data42,  unicode_unacc_data43,
    unicode_unacc_data44,  unicode_unacc_data45,  unicode_unacc_data46,  unicode_unacc_data47,
    unicode_unacc_data48,  unicode_unacc_data49,  unicode_unacc_data50,  unicode_unacc_data51,
    unicode_unacc_data52,  unicode_unacc_data53,  unicode_unacc_data54,  unicode_unacc_data55,
    unicode_unacc_data56,  unicode_unacc_data57,  unicode_unacc_data58,  unicode_unacc_data59,
    unicode_unacc_data60,  unicode_unacc_data61,  unicode_unacc_data62,  unicode_unacc_data63,
    unicode_unacc_data64,  unicode_unacc_data65,  unicode_unacc_data66,  unicode_unacc_data67,
    unicode_unacc_data68,  unicode_unacc_data69,  unicode_unacc_data70,  unicode_unacc_data71,
    unicode_unacc_data72,  unicode_unacc_data73,  unicode_unacc_data74,  unicode_unacc_data75,
    unicode_unacc_data76,  unicode_unacc_data77,  unicode_unacc_data78,  unicode_unacc_data79,
    unicode_unacc_data80,  unicode_unacc_data81,  unicode_unacc_data82,  unicode_unacc_data83,
    unicode_unacc_data84,  unicode_unacc_data85,  unicode_unacc_data86,  unicode_unacc_data87,
    unicode_unacc_data88,  unicode_unacc_data89,  unicode_unacc_data90,  unicode_unacc_data91,
    unicode_unacc_data92,  unicode_unacc_data93,  unicode_unacc_data94,  unicode_unacc_data95,
    unicode_unacc_data96,  unicode_unacc_data97,  unicode_unacc_data98,  unicode_unacc_data99,
    unicode_unacc_data100, unicode_unacc_data101, unicode_unacc_data102, unicode_unacc_data103,
    unicode_unacc_data104, unicode_unacc_data105, unicode_unacc_data106, unicode_unacc_data107,
    unicode_unacc_data108, unicode_unacc_data109, unicode_unacc_data110, unicode_unacc_data111,
    unicode_unacc_data112, unicode_unacc_data113, unicode_unacc_data114, unicode_unacc_data115,
    unicode_unacc_data116, unicode_unacc_data117, unicode_unacc_data118, unicode_unacc_data119,
    unicode_unacc_data120, unicode_unacc_data121, unicode_unacc_data122, unicode_unacc_data123,
    unicode_unacc_data124, unicode_unacc_data125, unicode_unacc_data126, unicode_unacc_data127,
    unicode_unacc_data128, unicode_unacc_data129, unicode_unacc_data130, unicode_unacc_data131,
    unicode_unacc_data132, unicode_unacc_data133, unicode_unacc_data134, unicode_unacc_data135,
    unicode_unacc_data136, unicode_unacc_data137, unicode_unacc_data138, unicode_unacc_data139,
    unicode_unacc_data140, unicode_unacc_data141, unicode_unacc_data142, unicode_unacc_data143,
    unicode_unacc_data144, unicode_unacc_data145, unicode_unacc_data146, unicode_unacc_data147,
    unicode_unacc_data148, unicode_unacc_data149, unicode_unacc_data150, unicode_unacc_data151,
    unicode_unacc_data152, unicode_unacc_data153, unicode_unacc_data154, unicode_unacc_data155,
    unicode_unacc_data156, unicode_unacc_data157, unicode_unacc_data158, unicode_unacc_data159,
    unicode_unacc_data160, unicode_unacc_data161, unicode_unacc_data162, unicode_unacc_data163,
    unicode_unacc_data164, unicode_unacc_data165, unicode_unacc_data166, unicode_unacc_data167,
    unicode_unacc_data168, unicode_unacc_data169, unicode_unacc_data170, unicode_unacc_data171,
    unicode_unacc_data172, unicode_unacc_data173, unicode_unacc_data174, unicode_unacc_data175,
    unicode_unacc_data176, unicode_unacc_data177, unicode_unacc_data178, unicode_unacc_data179,
    unicode_unacc_data180, unicode_unacc_data181, unicode_unacc_data182, unicode_unacc_data183,
    unicode_unacc_data184, unicode_unacc_data185, unicode_unacc_data186, unicode_unacc_data187,
    unicode_unacc_data188, unicode_unacc_data189, unicode_unacc_data190, unicode_unacc_data191,
    unicode_unacc_data192, unicode_unacc_data193, unicode_unacc_data194, unicode_unacc_data195,
    unicode_unacc_data196, unicode_unacc_data197, unicode_unacc_data198, unicode_unacc_data199,
    unicode_unacc_data200, unicode_unacc_data201, unicode_unacc_data202, unicode_unacc_data203,
    unicode_unacc_data204, unicode_unacc_data205, unicode_unacc_data206, unicode_unacc_data207,
    unicode_unacc_data208, unicode_unacc_data209, unicode_unacc_data210, unicode_unacc_data211,
    unicode_unacc_data212, unicode_unacc_data213, unicode_unacc_data214, unicode_unacc_data215,
    unicode_unacc_data216, unicode_unacc_data217, unicode_unacc_data218, unicode_unacc_data219,
    unicode_unacc_data220, unicode_unacc_data221, unicode_unacc_data222, unicode_unacc_data223,
    unicode_unacc_data224, unicode_unacc_data225, unicode_unacc_data226, unicode_unacc_data227,
    unicode_unacc_data228, unicode_unacc_data229, unicode_unacc_data230, unicode_unacc_data231,
    unicode_unacc_data232, unicode_unacc_data233, unicode_unacc_data234, unicode_unacc_data235,
    unicode_unacc_data236, unicode_unacc_data237, unicode_unacc_data238};
/* Generated by builder. Do not modify. End unicode_unacc_tables */

#define unicode_unacc(c, p, l)                                                              \
    {                                                                                       \
        unsigned short index = unicode_unacc_indexes[(c) >> UNICODE_UNACC_BLOCK_SHIFT];     \
        unsigned char position = (c)&UNICODE_UNACC_BLOCK_MASK;                              \
        (p) = &(unicode_unacc_data_table[index][unicode_unacc_positions[index][position]]); \
        (l) = unicode_unacc_positions[index][position + 1] -                                \
              unicode_unacc_positions[index][position];                                     \
        if ((l) == 1 && *(p) == 0xFFFF) {                                                   \
            (p) = 0;                                                                        \
            (l) = 0;                                                                        \
        }                                                                                   \
    }
SQLITE_EXPORT u16 sqlite3_unicode_unacc(u16 c, u16** p, int* l) {
    if (c < 0x80) {
        if (l) {
            *l = 1;
            *p = &c;
        }
        return c;
    } else {
        unsigned short index = unicode_unacc_indexes[(c) >> UNICODE_UNACC_BLOCK_SHIFT];
        unsigned char position = (c)&UNICODE_UNACC_BLOCK_MASK;
        unsigned short length =
            unicode_unacc_positions[index][position + 1] - unicode_unacc_positions[index][position];
        unsigned short* pointer =
            &(unicode_unacc_data_table[index][unicode_unacc_positions[index][position]]);

        if (l) {
            *l = length;
            *p = pointer;
        }
        return ((length == 1) && (*pointer == 0xFFFF)) ? c : *pointer;
    }
}
#endif
/*************************************************************************************************
 *************************************************************************************************
 *************************************************************************************************/

/*
** Check to see if this machine uses EBCDIC.  (Yes, believe it or
** not, there are still machines out there that use EBCDIC.)
*/
#if 'A' == '\301'
#define SQLITE_EBCDIC 1
#else
#define SQLITE_ASCII 1
#endif

/*
** Assuming zIn points to the first byte of a UTF-8 character,
** advance zIn to point to the first byte of the next UTF-8 character.
*/
#define SQLITE_SKIP_UTF8(zIn)               \
    {                                       \
        if ((*(zIn++)) >= 0xc0) {           \
            while ((*zIn & 0xc0) == 0x80) { \
                zIn++;                      \
            }                               \
        }                                   \
    }

/*
** pZ is a UTF-8 encoded unicode string. If nByte is less than zero,
** return the number of unicode characters in pZ up to (but not including)
** the first 0x00 byte. If nByte is not less than zero, return the
** number of unicode characters in the first nByte of pZ (or up to
** the first 0x00, whichever comes first).
*/
SQLITE_PRIVATE int sqlite3Utf8CharLen(const char* zIn, int nByte) {
    int r = 0;
    const u8* z = (const u8*)zIn;
    const u8* zTerm;
    if (nByte >= 0) {
        zTerm = &z[nByte];
    } else {
        zTerm = (const u8*)(-1);
    }
    assert(z <= zTerm);
    while (*z != 0 && z < zTerm) {
        SQLITE_SKIP_UTF8(z);
        r++;
    }
    return r;
}

/*
** This lookup table is used to help decode the first byte of
** a multi-byte UTF8 character.
*/
static const unsigned char sqlite3Utf8Trans1[] = {
    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
    0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,
    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x00, 0x01, 0x02, 0x03, 0x00, 0x01, 0x00, 0x00,
};

/*
** Translate a single UTF-8 character.  Return the unicode value.
**
** During translation, assume that the byte that zTerm points
** is a 0x00.
**
** Write a pointer to the next unread byte back into *pzNext.
**
** Notes On Invalid UTF-8:
**
**  *  This routine never allows a 7-bit character (0x00 through 0x7f) to
**     be encoded as a multi-byte character.  Any multi-byte character that
**     attempts to encode a value between 0x00 and 0x7f is rendered as 0xfffd.
**
**  *  This routine never allows a UTF16 surrogate value to be encoded.
**     If a multi-byte character attempts to encode a value between
**     0xd800 and 0xe000 then it is rendered as 0xfffd.
**
**  *  Bytes in the range of 0x80 through 0xbf which occur as the first
**     byte of a character are interpreted as single-byte characters
**     and rendered as themselves even though they are technically
**     invalid characters.
**
**  *  This routine accepts an infinite number of different UTF8 encodings
**     for unicode values 0x80 and greater.  It do not change over-length
**     encodings to 0xfffd as some systems recommend.
*/
#define READ_UTF8(zIn, zTerm, c)                                                    \
    c = *(zIn++);                                                                   \
    if (c >= 0xc0) {                                                                \
        c = sqlite3Utf8Trans1[c - 0xc0];                                            \
        while (zIn != zTerm && (*zIn & 0xc0) == 0x80) {                             \
            c = (c << 6) + (0x3f & *(zIn++));                                       \
        }                                                                           \
        if (c < 0x80 || (c & 0xFFFFF800) == 0xD800 || (c & 0xFFFFFFFE) == 0xFFFE) { \
            c = 0xFFFD;                                                             \
        }                                                                           \
    }
SQLITE_PRIVATE int sqlite3Utf8Read(
    const unsigned char* z,      /* First byte of UTF-8 character */
    const unsigned char* zTerm,  /* Pretend this byte is 0x00 */
    const unsigned char** pzNext /* Write first byte past UTF-8 char here */
) {
    int c;
    READ_UTF8(z, zTerm, c);
    *pzNext = z;
    return c;
}

/* An array to map all upper-case characters into their corresponding
** lower-case character.
**
** SQLite only considers US-ASCII (or EBCDIC) characters.  We do not
** handle case conversions for the UTF character set since the tables
** involved are nearly as big or bigger than SQLite itself.
*/
SQLITE_PRIVATE const unsigned char sqlite3UpperToLower[] = {
#ifdef SQLITE_ASCII
    0,
    1,
    2,
    3,
    4,
    5,
    6,
    7,
    8,
    9,
    10,
    11,
    12,
    13,
    14,
    15,
    16,
    17,
    18,
    19,
    20,
    21,
    22,
    23,
    24,
    25,
    26,
    27,
    28,
    29,
    30,
    31,
    32,
    33,
    34,
    35,
    36,
    37,
    38,
    39,
    40,
    41,
    42,
    43,
    44,
    45,
    46,
    47,
    48,
    49,
    50,
    51,
    52,
    53,
    54,
    55,
    56,
    57,
    58,
    59,
    60,
    61,
    62,
    63,
    64,
    97,
    98,
    99,
    100,
    101,
    102,
    103,
    104,
    105,
    106,
    107,
    108,
    109,
    110,
    111,
    112,
    113,
    114,
    115,
    116,
    117,
    118,
    119,
    120,
    121,
    122,
    91,
    92,
    93,
    94,
    95,
    96,
    97,
    98,
    99,
    100,
    101,
    102,
    103,
    104,
    105,
    106,
    107,
    108,
    109,
    110,
    111,
    112,
    113,
    114,
    115,
    116,
    117,
    118,
    119,
    120,
    121,
    122,
    123,
    124,
    125,
    126,
    127,
    128,
    129,
    130,
    131,
    132,
    133,
    134,
    135,
    136,
    137,
    138,
    139,
    140,
    141,
    142,
    143,
    144,
    145,
    146,
    147,
    148,
    149,
    150,
    151,
    152,
    153,
    154,
    155,
    156,
    157,
    158,
    159,
    160,
    161,
    162,
    163,
    164,
    165,
    166,
    167,
    168,
    169,
    170,
    171,
    172,
    173,
    174,
    175,
    176,
    177,
    178,
    179,
    180,
    181,
    182,
    183,
    184,
    185,
    186,
    187,
    188,
    189,
    190,
    191,
    192,
    193,
    194,
    195,
    196,
    197,
    198,
    199,
    200,
    201,
    202,
    203,
    204,
    205,
    206,
    207,
    208,
    209,
    210,
    211,
    212,
    213,
    214,
    215,
    216,
    217,
    218,
    219,
    220,
    221,
    222,
    223,
    224,
    225,
    226,
    227,
    228,
    229,
    230,
    231,
    232,
    233,
    234,
    235,
    236,
    237,
    238,
    239,
    240,
    241,
    242,
    243,
    244,
    245,
    246,
    247,
    248,
    249,
    250,
    251,
    252,
    253,
    254,
    255
#endif
#ifdef SQLITE_EBCDIC
    0,
    1,
    2,
    3,
    4,
    5,
    6,
    7,
    8,
    9,
    10,
    11,
    12,
    13,
    14,
    15, /* 0x */
    16,
    17,
    18,
    19,
    20,
    21,
    22,
    23,
    24,
    25,
    26,
    27,
    28,
    29,
    30,
    31, /* 1x */
    32,
    33,
    34,
    35,
    36,
    37,
    38,
    39,
    40,
    41,
    42,
    43,
    44,
    45,
    46,
    47, /* 2x */
    48,
    49,
    50,
    51,
    52,
    53,
    54,
    55,
    56,
    57,
    58,
    59,
    60,
    61,
    62,
    63, /* 3x */
    64,
    65,
    66,
    67,
    68,
    69,
    70,
    71,
    72,
    73,
    74,
    75,
    76,
    77,
    78,
    79, /* 4x */
    80,
    81,
    82,
    83,
    84,
    85,
    86,
    87,
    88,
    89,
    90,
    91,
    92,
    93,
    94,
    95, /* 5x */
    96,
    97,
    66,
    67,
    68,
    69,
    70,
    71,
    72,
    73,
    106,
    107,
    108,
    109,
    110,
    111, /* 6x */
    112,
    81,
    82,
    83,
    84,
    85,
    86,
    87,
    88,
    89,
    122,
    123,
    124,
    125,
    126,
    127, /* 7x */
    128,
    129,
    130,
    131,
    132,
    133,
    134,
    135,
    136,
    137,
    138,
    139,
    140,
    141,
    142,
    143, /* 8x */
    144,
    145,
    146,
    147,
    148,
    149,
    150,
    151,
    152,
    153,
    154,
    155,
    156,
    157,
    156,
    159, /* 9x */
    160,
    161,
    162,
    163,
    164,
    165,
    166,
    167,
    168,
    169,
    170,
    171,
    140,
    141,
    142,
    175, /* Ax */
    176,
    177,
    178,
    179,
    180,
    181,
    182,
    183,
    184,
    185,
    186,
    187,
    188,
    189,
    190,
    191, /* Bx */
    192,
    129,
    130,
    131,
    132,
    133,
    134,
    135,
    136,
    137,
    202,
    203,
    204,
    205,
    206,
    207, /* Cx */
    208,
    145,
    146,
    147,
    148,
    149,
    150,
    151,
    152,
    153,
    218,
    219,
    220,
    221,
    222,
    223, /* Dx */
    224,
    225,
    162,
    163,
    164,
    165,
    166,
    167,
    168,
    169,
    232,
    203,
    204,
    205,
    206,
    207, /* Ex */
    239,
    240,
    241,
    242,
    243,
    244,
    245,
    246,
    247,
    248,
    249,
    219,
    220,
    221,
    222,
    255, /* Fx */
#endif
};

/*
** For LIKE and GLOB matching on EBCDIC machines, assume that every
** character is exactly one byte in size.  Also, all characters are
** able to participate in upper-case-to-lower-case mappings in EBCDIC
** whereas only characters less than 0x80 do in ASCII.
*/
/*
** <sqlite3_unicode>
** The buit-in function has been extended to accomodate UTF-8 and UTF-16
** unicode strings containing characters over the 0x80 character limit as
** per the ASCII encoding imposed by SQlite.
**
** The functions below will use the sqlite3_unicode_fold() when
** SQLITE3_UNICODE_FOLD is defined and additonally sqlite_unicode_unacc()
** when SQLITE3_UNICODE_UNACC_AUTOMATIC is defined to normilize
** UTF-8 and UTF-16 encoded strings.
*/
#if defined(SQLITE_EBCDIC)
#define sqlite3Utf8Read(A, B, C) (*(A++))
#define GlogUpperToLower(A) A = sqlite3UpperToLower[A]
#else
#if defined(SQLITE3_UNICODE_UNACC) && defined(SQLITE3_UNICODE_UNACC_AUTOMATIC) && \
    defined(SQLITE3_UNICODE_FOLD)
#define GlogUpperToLower(A) A = sqlite3_unicode_fold(sqlite3_unicode_unacc(A, 0, 0))
#elif defined(SQLITE3_UNICODE_FOLD)
#define GlogUpperToLower(A) A = sqlite3_unicode_fold(A)
#else
#define GlogUpperToLower(A)         \
    if (A < 0x80) {                 \
        A = sqlite3UpperToLower[A]; \
    }
#endif
#endif

/*
** Maximum length (in bytes) of the pattern in a LIKE or GLOB
** operator.
*/
#ifndef SQLITE_MAX_LIKE_PATTERN_LENGTH
#define SQLITE_MAX_LIKE_PATTERN_LENGTH 50000
#endif

/*
** A structure defining how to do GLOB-style comparisons.
*/
struct compareInfo {
    u8 matchAll;
    u8 matchOne;
    u8 matchSet;
    u8 noCase;
};

static const struct compareInfo globInfo = {'*', '?', '[', 0};
/* The correct SQL-92 behavior is for the LIKE operator to ignore
** case.  Thus  'a' LIKE 'A' would be true. */
static const struct compareInfo likeInfoNorm = {'%', '_', 0, 1};
/* If SQLITE_CASE_SENSITIVE_LIKE is defined, then the LIKE operator
** is case sensitive causing 'a' LIKE 'A' to be false */
static const struct compareInfo likeInfoAlt = {'%', '_', 0, 0};

/*
** Compare two UTF-8 strings for equality where the first string can
** potentially be a "glob" expression.  Return true (1) if they
** are the same and false (0) if they are different.
**
** Globbing rules:
**
**      '*'       Matches any sequence of zero or more characters.
**
**      '?'       Matches exactly one character.
**
**     [...]      Matches one character from the enclosed list of
**                characters.
**
**     [^...]     Matches one character not in the enclosed list.
**
** With the [...] and [^...] matching, a ']' character can be included
** in the list by making it the first character after '[' or '^'.  A
** range of characters can be specified using '-'.  Example:
** "[a-z]" matches any single lower-case letter.  To match a '-', make
** it the last character in the list.
**
** This routine is usually quick, but can be N**2 in the worst case.
**
** Hints: to match '*' or '?', put them in "[]".  Like this:
**
**         abc[*]xyz        Matches "abc*xyz" only
*/
static int patternCompare(
    const u8* zPattern,              /* The glob pattern */
    const u8* zString,               /* The string to compare against the glob */
    const struct compareInfo* pInfo, /* Information about how to do the compare */
    const int esc                    /* The escape character */
) {
    int c, c2;
    int invert;
    int seen;
    u8 matchOne = pInfo->matchOne;
    u8 matchAll = pInfo->matchAll;
    u8 matchSet = pInfo->matchSet;
    u8 noCase = pInfo->noCase;
    int prevEscape = 0; /* True if the previous character was 'escape' */

    while ((c = sqlite3Utf8Read(zPattern, 0, &zPattern)) != 0) {
        if (!prevEscape && c == matchAll) {
            while ((c = sqlite3Utf8Read(zPattern, 0, &zPattern)) == matchAll || c == matchOne) {
                if (c == matchOne && sqlite3Utf8Read(zString, 0, &zString) == 0) {
                    return 0;
                }
            }
            if (c == 0) {
                return 1;
            } else if (c == esc) {
                c = sqlite3Utf8Read(zPattern, 0, &zPattern);
                if (c == 0) {
                    return 0;
                }
            } else if (c == matchSet) {
                assert(esc == 0);        /* This is GLOB, not LIKE */
                assert(matchSet < 0x80); /* '[' is a single-byte character */
                while (*zString && patternCompare(&zPattern[-1], zString, pInfo, esc) == 0) {
                    SQLITE_SKIP_UTF8(zString);
                }
                return *zString != 0;
            }
            while ((c2 = sqlite3Utf8Read(zString, 0, &zString)) != 0) {
                if (noCase) {
                    GlogUpperToLower(c2);
                    GlogUpperToLower(c);
                    while (c2 != 0 && c2 != c) {
                        c2 = sqlite3Utf8Read(zString, 0, &zString);
                        GlogUpperToLower(c2);
                    }
                } else {
                    while (c2 != 0 && c2 != c) {
                        c2 = sqlite3Utf8Read(zString, 0, &zString);
                    }
                }
                if (c2 == 0)
                    return 0;
                if (patternCompare(zPattern, zString, pInfo, esc))
                    return 1;
            }
            return 0;
        } else if (!prevEscape && c == matchOne) {
            if (sqlite3Utf8Read(zString, 0, &zString) == 0) {
                return 0;
            }
        } else if (c == matchSet) {
            int prior_c = 0;
            assert(esc == 0); /* This only occurs for GLOB, not LIKE */
            seen = 0;
            invert = 0;
            c = sqlite3Utf8Read(zString, 0, &zString);
            if (c == 0)
                return 0;
            c2 = sqlite3Utf8Read(zPattern, 0, &zPattern);
            if (c2 == '^') {
                invert = 1;
                c2 = sqlite3Utf8Read(zPattern, 0, &zPattern);
            }
            if (c2 == ']') {
                if (c == ']')
                    seen = 1;
                c2 = sqlite3Utf8Read(zPattern, 0, &zPattern);
            }
            while (c2 && c2 != ']') {
                if (c2 == '-' && zPattern[0] != ']' && zPattern[0] != 0 && prior_c > 0) {
                    c2 = sqlite3Utf8Read(zPattern, 0, &zPattern);
                    if (c >= prior_c && c <= c2)
                        seen = 1;
                    prior_c = 0;
                } else {
                    if (c == c2) {
                        seen = 1;
                    }
                    prior_c = c2;
                }
                c2 = sqlite3Utf8Read(zPattern, 0, &zPattern);
            }
            if (c2 == 0 || (seen ^ invert) == 0) {
                return 0;
            }
        } else if (esc == c && !prevEscape) {
            prevEscape = 1;
        } else {
            c2 = sqlite3Utf8Read(zString, 0, &zString);
            if (noCase) {
                GlogUpperToLower(c);
                GlogUpperToLower(c2);
            }
            if (c != c2) {
                return 0;
            }
            prevEscape = 0;
        }
    }
    return *zString == 0;
}

/*
** Count the number of times that the LIKE operator (or GLOB which is
** just a variation of LIKE) gets called.  This is used for testing
** only.
*/
#ifdef SQLITE_TEST
SQLITE_API int sqlite3_like_count = 0;
#endif

/*
** Implementation of the like() SQL function.  This function implements
** the build-in LIKE operator.  The first argument to the function is the
** pattern and the second argument is the string.  So, the SQL statements:
**
**       A LIKE B
**
** is implemented as like(B,A).
**
** This same function (with a different compareInfo structure) computes
** the GLOB operator.
*/
static void likeFunc(sqlite3_context* context, int argc, sqlite3_value** argv) {
    const unsigned char *zA, *zB;
    int escape = 0;
#if 0
  sqlite3 *db = sqlite3_context_db_handle(context);*/
#endif
    zB = sqlite3_value_text(argv[0]);
    zA = sqlite3_value_text(argv[1]);

    /* Limit the length of the LIKE or GLOB pattern to avoid problems
     ** of deep recursion and N*N behavior in patternCompare().
     */
#if 0
  if( sqlite3_value_bytes(argv[0]) >
        db->aLimit[SQLITE_LIMIT_LIKE_PATTERN_LENGTH] ){
#endif
#if 1
    if (sqlite3_value_bytes(argv[0]) > SQLITE_MAX_LIKE_PATTERN_LENGTH) {
#endif
        sqlite3_result_error(context, "LIKE or GLOB pattern too complex", -1);
        return;
    }

    assert(zB == sqlite3_value_text(argv[0])); /* Encoding did not change */

    if (argc == 3) {
        /* The escape character string must consist of a single UTF-8 character.
         ** Otherwise, return an error.
         */
        const unsigned char* zEsc = sqlite3_value_text(argv[2]);
        if (zEsc == 0)
            return;
        if (sqlite3Utf8CharLen((char*)zEsc, -1) != 1) {
            sqlite3_result_error(context, "ESCAPE expression must be a single character", -1);
            return;
        }
        escape = sqlite3Utf8Read(zEsc, 0, &zEsc);
    }
    if (zA && zB) {
        struct compareInfo* pInfo = sqlite3_user_data(context);
#ifdef SQLITE_TEST
        sqlite3_like_count++;
#endif

        sqlite3_result_int(context, patternCompare(zB, zA, pInfo, escape));
    }
}

/*
** Allocate nByte bytes of space using sqlite3_malloc(). If the
** allocation fails, call sqlite3_result_error_nomem() to notify
** the database handle that malloc() has failed.
*/
static void* contextMalloc(sqlite3_context* context, i64 nByte) {
    char* z;
#if 0
  if( nByte>sqlite3_context_db_handle(context)->aLimit[SQLITE_LIMIT_LENGTH] ){
    sqlite3_result_error_toobig(context);
    z = 0;
  }else{
#endif
    z = sqlite3_malloc((int)nByte);
    if (!z && nByte > 0) {
        sqlite3_result_error_nomem(context);
    }
#if 0
  }
#endif
    return z;
}

/*
** <sqlite3_unicode>
** Reallocate nByte bytes of space using sqlite3_realloc(). If the
** allocation fails, call sqlite3_result_error_nomem() to notify
** the database handle that malloc() has failed.
**
** SQlite has not supplied us with a reallocate function so we build our own.
*/
SQLITE_PRIVATE void* contextRealloc(sqlite3_context* context, void* pPrior, i64 nByte) {
    char* z = sqlite3_realloc(pPrior, (int)nByte);
    if (!z && nByte > 0) {
        sqlite3_result_error_nomem(context);
    }
    return z;
}

#if (defined(SQLITE3_UNICODE_FOLD) || defined(SQLITE3_UNICODE_LOWER) || \
     defined(SQLITE3_UNICODE_UPPER) || defined(SQLITE3_UNICODE_TITLE))
/*
** <sqlite3_unicode>
** Implementation of the FOLD(), UPPER(), LOWER(), TITLE() SQL functions.
** This function case folds each character in the supplied string to its
** single character equivalent.
**
** The conversion to be made depends on the contents of (sqlite3_context *)context
** where a pointer to a specific case conversion function is stored.
*/
SQLITE_PRIVATE void caseFunc(sqlite3_context* context, int argc, sqlite3_value** argv) {
    u16* z1;
    const u16* z2;
    int i, n;
    if (argc < 1 || SQLITE_NULL == sqlite3_value_type(argv[0]))
        return;
    z2 = (u16*)sqlite3_value_text16(argv[0]);
    n = sqlite3_value_bytes16(argv[0]);
    /* Verify that the call to _bytes() does not invalidate the _text() pointer */
    assert(z2 == (u16*)sqlite3_value_text16(argv[0]));
    if (z2) {
        z1 = contextMalloc(context, n + 2);
        if (z1) {
            typedef u16 (*PFN_CASEFUNC)(u16);
            memcpy(z1, z2, n + 2);
            for (i = 0; z1[i]; i++) {
                z1[i] = ((PFN_CASEFUNC)sqlite3_user_data(context))(z1[i]);
            }
            sqlite3_result_text16(context, z1, -1, sqlite3_free);
        }
    }
}
#endif

#ifdef SQLITE3_UNICODE_UNACC
/*
** <sqlite3_unicode>
** Implementation of the UNACCENT() SQL function.
** This function decomposes each character in the supplied string
** to its components and strips any accents present in the string.
**
** This function may result to a longer output string compared
** to the original input string. Memory has been properly reallocated
** to accomodate for the extra memory length required.
*/
SQLITE_PRIVATE void unaccFunc(sqlite3_context* context, int argc, sqlite3_value** argv) {
    u16* z1;
    const u16* z2;
    unsigned short* p;
    int i, o, n, l, k;
    if (argc < 1 || SQLITE_NULL == sqlite3_value_type(argv[0]))
        return;
    z2 = (u16*)sqlite3_value_text16(argv[0]);
    n = sqlite3_value_bytes16(argv[0]);
    /* Verify that the call to _bytes() does not invalidate the _text() pointer */
    assert(z2 == (u16*)sqlite3_value_text16(argv[0]));
    if (z2) {
        z1 = contextMalloc(context, n + 2);
        if (z1) {
            memcpy(z1, z2, n + 2);
            for (i = 0, o = 0; z2[i]; i++, o++) {
                unicode_unacc(z2[i], p, l);
                if (l > 0) {
                    if (l > 1) {
                        n += (l - 1) * sizeof(u16);
                        z1 = contextRealloc(context, z1, n + 2);
                    }
                    for (k = 0; k < l; k++)
                        z1[o + k] = p[k];
                    o += --k;
                } else
                    z1[o] = z2[i];
            }
            z1[o] = 0;
            sqlite3_result_text16(context, z1, -1, sqlite3_free);
        }
    }
}
#endif

#if defined(SQLITE3_UNICODE_COLLATE) && defined(SQLITE3_UNICODE_FOLD)

#ifndef max
#define max(a, b) (((a) > (b)) ? (a) : (b))
#endif

/*
** Some systems have stricmp().  Others have strcasecmp().  Because
** there is no consistency, we will define our own.
*/
/*
** <sqlite3_unicode>
** The buit-in function has been extended to accomodate UTF-8 and UTF-16
** unicode strings containing characters over the 0x80 character limit as
** per the ASCII encoding imposed by SQlite.
**
** The functions below will use the sqlite3_unicode_fold() when
** SQLITE3_UNICODE_FOLD is defined and additonally sqlite_unicode_unacc()
** when SQLITE3_UNICODE_UNACC_AUTOMATIC is defined to normilize
** UTF-8 and UTF-16 encoded strings and then compaire them for equality.
*/
SQLITE_PRIVATE int sqlite3StrNICmp(const unsigned char* zLeft, const unsigned char* zRight, int N) {
    const unsigned char* a = zLeft;
    const unsigned char* b = zRight;
    signed int ua = 0, ub = 0;
    int Z = 0;

    do {
        ua = sqlite3Utf8Read(a, 0, &a);
        ub = sqlite3Utf8Read(b, 0, &b);
        ua = GlogUpperToLower(ua);
        ub = GlogUpperToLower(ub);
        Z = (int)max(a - zLeft, b - zRight);
    } while (N > Z && *a != 0 && ua == ub);
    return N < 0 ? 0 : ua - ub;
}
SQLITE_PRIVATE int sqlite3StrNICmp16(const void* zLeft, const void* zRight, int N) {
    const unsigned short* a = zLeft;
    const unsigned short* b = zRight;
    signed int ua = 0, ub = 0;

    do {
        ua = *a;
        ub = *b;
        ua = GlogUpperToLower(ua);
        ub = GlogUpperToLower(ub);
        a++;
        b++;
    } while (--N > 0 && *a != 0 && ua == ub);
    return N < 0 ? 0 : ua - ub;
}

/*
** Another built-in collating sequence: NOCASE.
**
** This collating sequence is intended to be used for "case independant
** comparison". SQLite's knowledge of upper and lower case equivalents
** extends only to the 26 characters used in the English language.
**
** At the moment there is only a UTF-8 implementation.
*/
/*
** <sqlite3_unicode>
** The built-in collating sequence: NOCASE is extended to accomodate the
** unicode case folding mapping tables to normalize characters to their
** fold equivalents and test them for equality.
**
** Both UTF-8 and UTF-16 implementations are supported.
**
** (void *)encoding takes the following values
**   * SQLITE_UTF8  for UTF-8  encoded string comparison
**   * SQLITE_UFT16 for UTF-16 encoded string comparison
*/
SQLITE_EXPORT int sqlite3_unicode_collate(void* encoding,
                                          int nKey1,
                                          const void* pKey1,
                                          int nKey2,
                                          const void* pKey2) {
    int r = 0;

    if ((void*)SQLITE_UTF8 == encoding)
        r = sqlite3StrNICmp((const unsigned char*)pKey1, (const unsigned char*)pKey2,
                            (nKey1 < nKey2) ? nKey1 : nKey2);
    else if ((void*)SQLITE_UTF16 == encoding)
        r = sqlite3StrNICmp16((const void*)pKey1, (const void*)pKey2,
                              (nKey1 < nKey2) ? nKey1 : nKey2);

    if (0 == r) {
        r = nKey1 - nKey2;
    }
    return r;
}
#endif

/*
** <sqlite3_unicode>
** Implementation of the UNICODE_VERSION(*) function.  The result is the version
** of the unicode library that is running.
*/
SQLITE_PRIVATE void versionFunc(sqlite3_context* context, int argc, sqlite3_value** argv) {
    sqlite3_result_text(context, SQLITE3_UNICODE_VERSION_STRING, -1, SQLITE_STATIC);
}

/*
** <sqlite3_unicode>
** Register the UNICODE extension functions with database db.
*/
SQLITE_EXPORT int sqlite3_unicode_init_impl(sqlite3* db) {
    struct FuncScalar {
        const char* zName; /* Function name */
        int nArg;          /* Number of arguments */
        int enc;           /* Optimal text encoding */
        void* pContext;    /* sqlite3_user_data() context */
        void (*xFunc)(sqlite3_context*, int, sqlite3_value**);
    } scalars[] = {
        {"unicode_version", 0, SQLITE_ANY, 0, versionFunc},

#ifdef SQLITE3_UNICODE_FOLD
        {"like", 2, SQLITE_ANY, (void*)&likeInfoNorm, likeFunc},
        {"nlike", 2, SQLITE_ANY, (void*)&likeInfoNorm, likeFunc},
        {"like", 3, SQLITE_ANY, (void*)&likeInfoNorm, likeFunc},
        {"nlike", 3, SQLITE_ANY, (void*)&likeInfoNorm, likeFunc},

        {"casefold", 1, SQLITE_ANY, (void*)sqlite3_unicode_fold, caseFunc},
#endif
#ifdef SQLITE3_UNICODE_LOWER
        {"lower", 1, SQLITE_ANY, (void*)sqlite3_unicode_lower, caseFunc},
        {"nlower", 1, SQLITE_ANY, (void*)sqlite3_unicode_lower, caseFunc},
#endif
#ifdef SQLITE3_UNICODE_UPPER
        {"upper", 1, SQLITE_ANY, (void*)sqlite3_unicode_upper, caseFunc},
        {"nupper", 1, SQLITE_ANY, (void*)sqlite3_unicode_upper, caseFunc},
#endif
#ifdef SQLITE3_UNICODE_TITLE
        // {"title", 1, SQLITE_ANY, (void*)sqlite3_unicode_title, caseFunc},
        // {"ntitle", 1, SQLITE_ANY, (void*)sqlite3_unicode_title, caseFunc},
#endif
#ifdef SQLITE3_UNICODE_UNACC
        {"unaccent", 1, SQLITE_ANY, 0, unaccFunc},
#endif
    };

    for (int i = 0; i < (sizeof(scalars) / sizeof(struct FuncScalar)); i++) {
        struct FuncScalar* p = &scalars[i];
        sqlite3_create_function(db, p->zName, p->nArg, p->enc, p->pContext, p->xFunc, 0, 0);
    }

#if defined(SQLITE3_UNICODE_COLLATE) && defined(SQLITE3_UNICODE_FOLD)
    /* Also override the default NOCASE UTF-8 case-insensitive collation sequence. */
    sqlite3_create_collation(db, "NOCASE", SQLITE_UTF8, (void*)SQLITE_UTF8,
                             sqlite3_unicode_collate);
    sqlite3_create_collation(db, "NOCASE", SQLITE_UTF16, (void*)SQLITE_UTF16,
                             sqlite3_unicode_collate);
#endif

    return SQLITE_OK;
}

/*
** <sqlite3_unicode>
** The following function is the default entry point of an SQlite extension built as a
** dynamically linked library. On calling sqlite3_load_extension() sqlite3 will call
** this function to initialise unicode functionality.
*/
#ifndef SQLITE_CORE
SQLITE_EXPORT int sqlite3_unicode_init(sqlite3* db,
                                       char** pzErrMsg,
                                       const sqlite3_api_routines* pApi) {
    SQLITE_EXTENSION_INIT2(pApi)
    return sqlite3_unicode_init_impl(db);
}
#endif

#endif  //! defined(SQLITE_CORE) || defined(SQLITE_ENABLE_UNICODE)
