Feature: display all executed Git commands

  Background:
    Given a Git repo with origin
    And the branches
      | NAME    | TYPE    | PARENT | LOCATIONS     |
      | current | feature | main   | local, origin |
      | other   | feature | main   | local, origin |
    And the commits
      | BRANCH  | LOCATION      | MESSAGE        |
      | current | local, origin | current commit |
      | other   | local, origin | other commit   |
    And the current branch is "current"
    And the current branch is "current" and the previous branch is "other"
    When I run "git-town delete --verbose"

  Scenario: result
    Then Git Town runs the commands
      | BRANCH  | TYPE     | COMMAND                                                                                                                                                                                                                                                                                                                                          |
      |         | backend  | git version                                                                                                                                                                                                                                                                                                                                      |
      |         | backend  | git rev-parse --show-toplevel                                                                                                                                                                                                                                                                                                                    |
      |         | backend  | git config -lz --global                                                                                                                                                                                                                                                                                                                          |
      |         | backend  | git config -lz --local                                                                                                                                                                                                                                                                                                                           |
      |         | backend  | git config -lz                                                                                                                                                                                                                                                                                                                                   |
      |         | backend  | git status -z --ignore-submodules                                                                                                                                                                                                                                                                                                                |
      |         | backend  | git rev-parse --verify -q MERGE_HEAD                                                                                                                                                                                                                                                                                                             |
      |         | backend  | git rev-parse --absolute-git-dir                                                                                                                                                                                                                                                                                                                 |
      |         | backend  | git remote                                                                                                                                                                                                                                                                                                                                       |
      |         | backend  | git branch --show-current                                                                                                                                                                                                                                                                                                                        |
      | current | frontend | git fetch --prune --tags                                                                                                                                                                                                                                                                                                                         |
      |         | backend  | git stash list                                                                                                                                                                                                                                                                                                                                   |
      |         | backend  | git for-each-ref "--format=refname:%(refname) branchname:%(refname:lstrip=2) sha:%(objectname) head:%(if)%(HEAD)%(then)Y%(else)N%(end) worktree:%(if)%(worktreepath)%(then)Y%(else)N%(end) symref:%(if)%(symref)%(then)Y%(else)N%(end) upstream:%(upstream:lstrip=2) track:%(upstream:track,nobracket)" --sort=refname refs/heads/ refs/remotes/ |
      |         | backend  | git remote get-url origin                                                                                                                                                                                                                                                                                                                        |
      |         | backend  | git rev-parse --verify --abbrev-ref @{-1}                                                                                                                                                                                                                                                                                                        |
      | current | frontend | git push origin :current                                                                                                                                                                                                                                                                                                                         |
      |         | frontend | git checkout other                                                                                                                                                                                                                                                                                                                               |
      | other   | frontend | git branch -D current                                                                                                                                                                                                                                                                                                                            |
      |         | backend  | git config --unset git-town-branch.current.parent                                                                                                                                                                                                                                                                                                |
      |         | backend  | git rev-parse --verify -q refs/heads/current                                                                                                                                                                                                                                                                                                     |
      |         | backend  | git for-each-ref "--format=refname:%(refname) branchname:%(refname:lstrip=2) sha:%(objectname) head:%(if)%(HEAD)%(then)Y%(else)N%(end) worktree:%(if)%(worktreepath)%(then)Y%(else)N%(end) symref:%(if)%(symref)%(then)Y%(else)N%(end) upstream:%(upstream:lstrip=2) track:%(upstream:track,nobracket)" --sort=refname refs/heads/ refs/remotes/ |
      |         | backend  | git config -lz --global                                                                                                                                                                                                                                                                                                                          |
      |         | backend  | git config -lz --local                                                                                                                                                                                                                                                                                                                           |
      |         | backend  | git stash list                                                                                                                                                                                                                                                                                                                                   |
    And Git Town prints:
      """
      Ran 24 shell commands.
      """
