Feature: display all executed Git commands

  Background:
    Given a Git repo with origin
    And the branches
      | NAME     | TYPE    | PARENT | LOCATIONS     |
      | branch-1 | feature | main   | local, origin |
      | branch-2 | feature | main   | local, origin |
    And the commits
      | BRANCH   | LOCATION      | MESSAGE         |
      | branch-1 | local, origin | branch-1 commit |
    And the current branch is "branch-2"
    And origin deletes the "branch-2" branch
    And Git setting "git-town.sync-feature-strategy" is "rebase"
    When I run "git-town sync --verbose"

  Scenario: result
    Then Git Town runs the commands
      | BRANCH   | TYPE     | COMMAND                                                                                                                                                                                                                                                                                                                                          |
      |          | backend  | git version                                                                                                                                                                                                                                                                                                                                      |
      |          | backend  | git rev-parse --show-toplevel                                                                                                                                                                                                                                                                                                                    |
      |          | backend  | git config -lz --global                                                                                                                                                                                                                                                                                                                          |
      |          | backend  | git config -lz --local                                                                                                                                                                                                                                                                                                                           |
      |          | backend  | git config -lz                                                                                                                                                                                                                                                                                                                                   |
      |          | backend  | git for-each-ref "--format=refname:%(refname) branchname:%(refname:lstrip=2) sha:%(objectname) head:%(if)%(HEAD)%(then)Y%(else)N%(end) worktree:%(if)%(worktreepath)%(then)Y%(else)N%(end) symref:%(if)%(symref)%(then)Y%(else)N%(end) upstream:%(upstream:lstrip=2) track:%(upstream:track,nobracket)" --sort=refname refs/heads/ refs/remotes/ |
      |          | backend  | git status -z --ignore-submodules                                                                                                                                                                                                                                                                                                                |
      |          | backend  | git rev-parse --verify -q MERGE_HEAD                                                                                                                                                                                                                                                                                                             |
      |          | backend  | git rev-parse --absolute-git-dir                                                                                                                                                                                                                                                                                                                 |
      |          | backend  | git remote                                                                                                                                                                                                                                                                                                                                       |
      | branch-2 | frontend | git fetch --prune --tags                                                                                                                                                                                                                                                                                                                         |
      |          | backend  | git stash list                                                                                                                                                                                                                                                                                                                                   |
      |          | backend  | git for-each-ref "--format=refname:%(refname) branchname:%(refname:lstrip=2) sha:%(objectname) head:%(if)%(HEAD)%(then)Y%(else)N%(end) worktree:%(if)%(worktreepath)%(then)Y%(else)N%(end) symref:%(if)%(symref)%(then)Y%(else)N%(end) upstream:%(upstream:lstrip=2) track:%(upstream:track,nobracket)" --sort=refname refs/heads/ refs/remotes/ |
      |          | backend  | git rev-parse --verify --abbrev-ref @{-1}                                                                                                                                                                                                                                                                                                        |
      |          | backend  | git remote get-url origin                                                                                                                                                                                                                                                                                                                        |
      |          | backend  | git log main..branch-2 --format=%s --reverse                                                                                                                                                                                                                                                                                                     |
      | branch-2 | frontend | git checkout main                                                                                                                                                                                                                                                                                                                                |
      | main     | frontend | git branch -D branch-2                                                                                                                                                                                                                                                                                                                           |
      |          | backend  | git config --unset git-town-branch.branch-2.parent                                                                                                                                                                                                                                                                                               |
      |          | backend  | git rev-parse --verify -q refs/heads/branch-2                                                                                                                                                                                                                                                                                                    |
      |          | backend  | git rev-parse --verify -q refs/heads/branch-1                                                                                                                                                                                                                                                                                                    |
      | main     | frontend | git checkout branch-1                                                                                                                                                                                                                                                                                                                            |
      |          | backend  | git for-each-ref "--format=refname:%(refname) branchname:%(refname:lstrip=2) sha:%(objectname) head:%(if)%(HEAD)%(then)Y%(else)N%(end) worktree:%(if)%(worktreepath)%(then)Y%(else)N%(end) symref:%(if)%(symref)%(then)Y%(else)N%(end) upstream:%(upstream:lstrip=2) track:%(upstream:track,nobracket)" --sort=refname refs/heads/ refs/remotes/ |
      |          | backend  | git config -lz --global                                                                                                                                                                                                                                                                                                                          |
      |          | backend  | git config -lz --local                                                                                                                                                                                                                                                                                                                           |
      |          | backend  | git stash list                                                                                                                                                                                                                                                                                                                                   |
    And Git Town prints:
      """
      Ran 26 shell commands.
      """
    And the branches are now
      | REPOSITORY    | BRANCHES       |
      | local, origin | main, branch-1 |
    And this lineage exists now
      | BRANCH   | PARENT |
      | branch-1 | main   |

  Scenario: undo
    When I run "git-town undo --verbose"
    Then Git Town runs the commands
      | BRANCH   | TYPE     | COMMAND                                                                                                                                                                                                                                                                                                                                          |
      |          | backend  | git version                                                                                                                                                                                                                                                                                                                                      |
      |          | backend  | git rev-parse --show-toplevel                                                                                                                                                                                                                                                                                                                    |
      |          | backend  | git config -lz --global                                                                                                                                                                                                                                                                                                                          |
      |          | backend  | git config -lz --local                                                                                                                                                                                                                                                                                                                           |
      |          | backend  | git config -lz                                                                                                                                                                                                                                                                                                                                   |
      |          | backend  | git status -z --ignore-submodules                                                                                                                                                                                                                                                                                                                |
      |          | backend  | git rev-parse --verify -q MERGE_HEAD                                                                                                                                                                                                                                                                                                             |
      |          | backend  | git rev-parse --absolute-git-dir                                                                                                                                                                                                                                                                                                                 |
      |          | backend  | git stash list                                                                                                                                                                                                                                                                                                                                   |
      |          | backend  | git for-each-ref "--format=refname:%(refname) branchname:%(refname:lstrip=2) sha:%(objectname) head:%(if)%(HEAD)%(then)Y%(else)N%(end) worktree:%(if)%(worktreepath)%(then)Y%(else)N%(end) symref:%(if)%(symref)%(then)Y%(else)N%(end) upstream:%(upstream:lstrip=2) track:%(upstream:track,nobracket)" --sort=refname refs/heads/ refs/remotes/ |
      |          | backend  | git remote get-url origin                                                                                                                                                                                                                                                                                                                        |
      |          | backend  | git rev-parse --verify --abbrev-ref @{-1}                                                                                                                                                                                                                                                                                                        |
      |          | backend  | git remote get-url origin                                                                                                                                                                                                                                                                                                                        |
      | branch-1 | frontend | git branch branch-2 {{ sha 'initial commit' }}                                                                                                                                                                                                                                                                                                   |
      |          | backend  | git rev-parse --verify -q refs/heads/branch-2                                                                                                                                                                                                                                                                                                    |
      | branch-1 | frontend | git checkout branch-2                                                                                                                                                                                                                                                                                                                            |
      |          | backend  | git config git-town-branch.branch-2.parent main                                                                                                                                                                                                                                                                                                  |
    And Git Town prints:
      """
      Ran 17 shell commands.
      """
    And the initial branches and lineage exist now
