# High-level CLI for Git

Git Town solves the problem that using the Git CLI correctly is cumbersome and
repetitive, and therefore many developers don't use Git to its full potential.

Git isn't just a version control system; it's a flexible framework for creating
various version control workflows. This flexibility means that most of us end up
using ad-hoc workflows, either in our heads or through custom Bash scripts
tailored to our needs. These manual workflows often lack proper specifications
and don't handle errors and edge cases well.

Git Town is a reusable implementation of Git workflows for common usage
scenarios like contributing to a centralized code repository on platforms like
GitHub, GitLab, Bitbucket, Gitea, or Codeberg. Think of Git Town as your Bash
scripts for Git, but fully engineered with rock-solid support for many use
cases, edge cases, and error conditions.

With Git Town you can keep using Git the way you do now, but with extra commands
to create various branch types, keep them in sync, compress, review, and ship
them efficiently.

<br>
<p align="center">
  <a href="https://youtu.be/4QDgQajqxRw" target="_blank">
    <img src="video.jpg" width="517" height="290" alt="screencast">
  </a>
</p>
<br>

Git Town is compatible with most common branching models like
[GitHub Flow](https://docs.github.com/en/get-started/quickstart/github-flow),
[Git Flow](https://www.atlassian.com/git/tutorials/comparing-workflows/gitflow-workflow),
[GitLab Flow](https://docs.gitlab.com/ee/topics/gitlab_flow.html),
[trunk-based development](https://trunkbaseddevelopment.com) and even committing
straight into the main branch. Git Town has special support for mono-repos and
stacked changes. See also this
[external review](https://www.softpedia.com/get/Programming/Other-Programming-Files/Git-Town.shtml).

## What our users say

<p align="center">

<blockquote class="twitter-tweet">
  <p lang="en" dir="ltr">
    <a href="https://twitter.com/hashtag/Gittown">#Gittown</a> you sexy beast!
    <a href="https://twitter.com/GitTown">@GitTown</a>
  </p>
  &mdash; Elegant Development (<a href="https://twitter.com/elegant_dev/status/935643502754615297">@elegant_dev</a>)
</blockquote>

<blockquote class="twitter-tweet">
  <p lang="en" dir="ltr">
    Amazing <a href="https://twitter.com/GitTown">@GitTown</a> rocks! 🚀
    <a href="https://t.co/S5ouIBx2fe">https://t.co/S5ouIBx2fe</a>
  </p>
  &mdash; Jose Quintana (<a href="https://twitter.com/joseluis_q/status/958632011777957888">@joseluis_q</a>)
</blockquote>

<blockquote class="twitter-tweet">
  <p lang="en" dir="ltr">
    All doable w/ just git, but git-town is a simpler mental-model and way less keystrokes
  </p>
  &mdash; Ryan Nystrom (<a href="https://twitter.com/_ryannystrom/status/1155840573653356544">@_ryannystrom</a>)
</blockquote>

<blockquote class="twitter-tweet">
  <p lang="en" dir="ltr">
    I&#39;ve been using git-town along git-flow for a little while and it&#39;s been really nice
    <a href="https://t.co/E5nwHuXP1C">https://t.co/E5nwHuXP1C</a>
  </p>&mdash;
  dan reeves 🏳️‍🌈 (<a href="https://twitter.com/dnrvs/status/885081044847915010">@dnrvs</a>)
</blockquote>

<blockquote class="twitter-tweet">
  <p lang="en" dir="ltr">
  Wow <a href="https://twitter.com/GitTown">@GitTown</a> looks great, type less git commands for common branch/pr workflows.
  Similar to <a href="https://twitter.com/github">@github</a>’s “hub” but looks more powerful, and it logs the fit commands it runs under the hood.
  <a href="https://t.co/PxGs76TS5I">pic.twitter.com/PxGs76TS5I</a></p>
  &mdash; Gregor (<a href="https://twitter.com/gr2m/status/983913843351957504">@gr2m</a>)
</blockquote>

<blockquote>
  Supercharge your workflow with Git by relying on this surprisingly powerful
  and quite useful plugin that provides you with a series of extra Git commands.
  <br><br>
  <b>
    <a href="https://www.softpedia.com/get/Programming/Other-Programming-Files/Git-Town.shtml">
      Softpedia article about Git Town
    </a>
  </b>
</blockquote>

</p>

<script async src="https://platform.twitter.com/widgets.js" charset="utf-8"></script>
