# Changelog

## [v2.0.0-alpha.8](https://github.com/NPLinker/nplinker/tree/v2.0.0-alpha.8) (2025-01-23)

[Full Changelog](https://github.com/NPLinker/nplinker/compare/v2.0.0-alpha.7...v2.0.0-alpha.8)

**Closed issues:**

- Replace square NPLinker logo by one used for Slack \(with NPLinker text\) [\#288](https://github.com/NPLinker/nplinker/issues/288)

**Merged pull requests:**

- move config template file outside of code folder [\#303](https://github.com/NPLinker/nplinker/pull/303) ([CunliangGeng](https://github.com/CunliangGeng))
- remove unused or deprecated code and data [\#302](https://github.com/NPLinker/nplinker/pull/302) ([CunliangGeng](https://github.com/CunliangGeng))
- update doc for gnps2 [\#301](https://github.com/NPLinker/nplinker/pull/301) ([CunliangGeng](https://github.com/CunliangGeng))
- update DatasetArranger for different version of gnps [\#300](https://github.com/NPLinker/nplinker/pull/300) ([CunliangGeng](https://github.com/CunliangGeng))
- update GNPSSpectrumLoader for gnps2 [\#299](https://github.com/NPLinker/nplinker/pull/299) ([CunliangGeng](https://github.com/CunliangGeng))
- update GNPSMolecularFamilyLoader for gnps2 [\#298](https://github.com/NPLinker/nplinker/pull/298) ([CunliangGeng](https://github.com/CunliangGeng))
- update GNPSFileMappingLoader for gnps2 [\#297](https://github.com/NPLinker/nplinker/pull/297) ([CunliangGeng](https://github.com/CunliangGeng))
- Update GNPSFileMappingLoader to support GNPS2 data [\#296](https://github.com/NPLinker/nplinker/pull/296) ([CunliangGeng](https://github.com/CunliangGeng))
- update GNPSExtractor class to support gnps2 [\#295](https://github.com/NPLinker/nplinker/pull/295) ([CunliangGeng](https://github.com/CunliangGeng))
- update GNPSDownloader class to support gnps2 [\#294](https://github.com/NPLinker/nplinker/pull/294) ([CunliangGeng](https://github.com/CunliangGeng))
- update gnpsformat detection function to support gnps2 [\#293](https://github.com/NPLinker/nplinker/pull/293) ([CunliangGeng](https://github.com/CunliangGeng))
- update GNPSFormat to support gnps2 [\#292](https://github.com/NPLinker/nplinker/pull/292) ([CunliangGeng](https://github.com/CunliangGeng))
- add gnps version as a new setting in config file [\#291](https://github.com/NPLinker/nplinker/pull/291) ([CunliangGeng](https://github.com/CunliangGeng))
- change bigscape version setting from int to str [\#290](https://github.com/NPLinker/nplinker/pull/290) ([CunliangGeng](https://github.com/CunliangGeng))
- remove smiles prediction [\#289](https://github.com/NPLinker/nplinker/pull/289) ([CunliangGeng](https://github.com/CunliangGeng))
- add methods to export results in tabular format [\#280](https://github.com/NPLinker/nplinker/pull/280) ([liannette](https://github.com/liannette))

## [v2.0.0-alpha.7](https://github.com/NPLinker/nplinker/tree/v2.0.0-alpha.7) (2024-11-28)

[Full Changelog](https://github.com/NPLinker/nplinker/compare/v2.0.0-alpha.6...v2.0.0-alpha.7)

**Closed issues:**

- Incorrect precursor m/z when loading MGF file from GNPS [\#282](https://github.com/NPLinker/nplinker/issues/282)
- Use bigscape version in loaders [\#271](https://github.com/NPLinker/nplinker/issues/271)

**Merged pull requests:**

- remove default config file to make all settings explicit [\#287](https://github.com/NPLinker/nplinker/pull/287) ([CunliangGeng](https://github.com/CunliangGeng))
- add support of mibig v4.0 [\#286](https://github.com/NPLinker/nplinker/pull/286) ([CunliangGeng](https://github.com/CunliangGeng))
- fix the resolving of genbank and jgi IDs [\#285](https://github.com/NPLinker/nplinker/pull/285) ([CunliangGeng](https://github.com/CunliangGeng))
- Precursor m/z value fix [\#283](https://github.com/NPLinker/nplinker/pull/283) ([liannette](https://github.com/liannette))

## [v2.0.0-alpha.6](https://github.com/NPLinker/nplinker/tree/v2.0.0-alpha.6) (2024-09-17)

[Full Changelog](https://github.com/NPLinker/nplinker/compare/v2.0.0-alpha.5...v2.0.0-alpha.6)

**Merged pull requests:**

- Allow bigscape run for local mode [\#277](https://github.com/NPLinker/nplinker/pull/277) ([CunliangGeng](https://github.com/CunliangGeng))
- Add table display for link graph [\#276](https://github.com/NPLinker/nplinker/pull/276) ([CunliangGeng](https://github.com/CunliangGeng))
- Handle two quantification table folders of GNPS feature-based workflow  [\#275](https://github.com/NPLinker/nplinker/pull/275) ([CunliangGeng](https://github.com/CunliangGeng))
- Verify the support of WSL [\#274](https://github.com/NPLinker/nplinker/pull/274) ([CunliangGeng](https://github.com/CunliangGeng))

## [v2.0.0-alpha.5](https://github.com/NPLinker/nplinker/tree/v2.0.0-alpha.5) (2024-08-22)

[Full Changelog](https://github.com/NPLinker/nplinker/compare/v2.0.0-alpha.4...v2.0.0-alpha.5)

**Merged pull requests:**

- add names of bigscape classes [\#273](https://github.com/NPLinker/nplinker/pull/273) ([CunliangGeng](https://github.com/CunliangGeng))

## [v2.0.0-alpha.4](https://github.com/NPLinker/nplinker/tree/v2.0.0-alpha.4) (2024-07-29)

[Full Changelog](https://github.com/NPLinker/nplinker/compare/v2.0.0-alpha.3...v2.0.0-alpha.4)

**Implemented enhancements:**

- Select subset of the data [\#265](https://github.com/NPLinker/nplinker/issues/265)

**Closed issues:**

- Fix code scanning alert - Token-Permissions [\#268](https://github.com/NPLinker/nplinker/issues/268)
- support bigscape v2 [\#216](https://github.com/NPLinker/nplinker/issues/216)
- Abstraction of run\_bigscape function [\#115](https://github.com/NPLinker/nplinker/issues/115)

**Merged pull requests:**

- update doc for bigscape [\#270](https://github.com/NPLinker/nplinker/pull/270) ([CunliangGeng](https://github.com/CunliangGeng))
- add filter method to LinkGraph [\#269](https://github.com/NPLinker/nplinker/pull/269) ([CunliangGeng](https://github.com/CunliangGeng))
- Add OSSF Scorecard action and badge  [\#267](https://github.com/NPLinker/nplinker/pull/267) ([CunliangGeng](https://github.com/CunliangGeng))
- improve docstrings [\#266](https://github.com/NPLinker/nplinker/pull/266) ([CunliangGeng](https://github.com/CunliangGeng))
- Run bigscape v2 [\#251](https://github.com/NPLinker/nplinker/pull/251) ([adraismawur](https://github.com/adraismawur))

## [v2.0.0-alpha.3](https://github.com/NPLinker/nplinker/tree/v2.0.0-alpha.3) (2024-07-11)

[Full Changelog](https://github.com/NPLinker/nplinker/compare/v2.0.0-alpha.2...v2.0.0-alpha.3)

**Implemented enhancements:**

- Data size warnings / checks when installing and using nplinker package [\#237](https://github.com/NPLinker/nplinker/issues/237)

**Closed issues:**

- Podp: not all genome IDs are in antismashDB [\#242](https://github.com/NPLinker/nplinker/issues/242)
- refactoring scoring \(tracker issue\) [\#205](https://github.com/NPLinker/nplinker/issues/205)
- ensure that IDs are unique [\#146](https://github.com/NPLinker/nplinker/issues/146)
- refactor `__eq__` and `__hash__` methods [\#136](https://github.com/NPLinker/nplinker/issues/136)
- Missing mibig BGC [\#86](https://github.com/NPLinker/nplinker/issues/86)

**Merged pull requests:**

- fix tabular file header detection [\#264](https://github.com/NPLinker/nplinker/pull/264) ([CunliangGeng](https://github.com/CunliangGeng))
- simplify error check in unit tests [\#263](https://github.com/NPLinker/nplinker/pull/263) ([CunliangGeng](https://github.com/CunliangGeng))
- add warning for failed antismash downloads [\#262](https://github.com/NPLinker/nplinker/pull/262) ([CunliangGeng](https://github.com/CunliangGeng))
- check disk space before downloading [\#261](https://github.com/NPLinker/nplinker/pull/261) ([CunliangGeng](https://github.com/CunliangGeng))

## [v2.0.0-alpha.2](https://github.com/NPLinker/nplinker/tree/v2.0.0-alpha.2) (2024-06-20)

[Full Changelog](https://github.com/NPLinker/nplinker/compare/v2.0.0-alpha.1...v2.0.0-alpha.2)

**Closed issues:**

- improvement on docs [\#232](https://github.com/NPLinker/nplinker/issues/232)
- writing tutorials and docs for preparing data [\#204](https://github.com/NPLinker/nplinker/issues/204)

**Merged pull requests:**

- update docs [\#260](https://github.com/NPLinker/nplinker/pull/260) ([CunliangGeng](https://github.com/CunliangGeng))
- improving type hints and usage of abc [\#259](https://github.com/NPLinker/nplinker/pull/259) ([CunliangGeng](https://github.com/CunliangGeng))
- add pickling [\#258](https://github.com/NPLinker/nplinker/pull/258) ([CunliangGeng](https://github.com/CunliangGeng))
- fix mypy and ruff errors [\#257](https://github.com/NPLinker/nplinker/pull/257) ([CunliangGeng](https://github.com/CunliangGeng))
- refactor NPLinker class [\#256](https://github.com/NPLinker/nplinker/pull/256) ([CunliangGeng](https://github.com/CunliangGeng))
- rename `molfam` to `mf` to uniform the abbreviation for MolecularFamily [\#255](https://github.com/NPLinker/nplinker/pull/255) ([CunliangGeng](https://github.com/CunliangGeng))
- refactor MetcalfScoring methods [\#254](https://github.com/NPLinker/nplinker/pull/254) ([CunliangGeng](https://github.com/CunliangGeng))
- use uniformed attribute name `id`  [\#253](https://github.com/NPLinker/nplinker/pull/253) ([CunliangGeng](https://github.com/CunliangGeng))
- Add LinkGraph to replace ObjectLink and LinkCollection [\#252](https://github.com/NPLinker/nplinker/pull/252) ([CunliangGeng](https://github.com/CunliangGeng))
- merge DataLinks `get_common_strains` to ObjectLink [\#250](https://github.com/NPLinker/nplinker/pull/250) ([CunliangGeng](https://github.com/CunliangGeng))
- merge DataLinks to MetcalfScoring class [\#249](https://github.com/NPLinker/nplinker/pull/249) ([CunliangGeng](https://github.com/CunliangGeng))
- merge LinkFinder to MetcalfScoring class [\#248](https://github.com/NPLinker/nplinker/pull/248) ([CunliangGeng](https://github.com/CunliangGeng))
- add abstract base class for scoring methods [\#247](https://github.com/NPLinker/nplinker/pull/247) ([CunliangGeng](https://github.com/CunliangGeng))
- Specify config file explicitly for initializing NPLinker [\#246](https://github.com/NPLinker/nplinker/pull/246) ([CunliangGeng](https://github.com/CunliangGeng))
- fix empty caplog [\#245](https://github.com/NPLinker/nplinker/pull/245) ([CunliangGeng](https://github.com/CunliangGeng))
- update docs and readme [\#244](https://github.com/NPLinker/nplinker/pull/244) ([CunliangGeng](https://github.com/CunliangGeng))
- refactor logging control [\#243](https://github.com/NPLinker/nplinker/pull/243) ([CunliangGeng](https://github.com/CunliangGeng))
- add default output path [\#241](https://github.com/NPLinker/nplinker/pull/241) ([CunliangGeng](https://github.com/CunliangGeng))
- rename globals.py to defaults.py [\#240](https://github.com/NPLinker/nplinker/pull/240) ([CunliangGeng](https://github.com/CunliangGeng))
- Fix locations of attributes docstrings [\#239](https://github.com/NPLinker/nplinker/pull/239) ([CunliangGeng](https://github.com/CunliangGeng))
- check format and typing only on changed files [\#238](https://github.com/NPLinker/nplinker/pull/238) ([CunliangGeng](https://github.com/CunliangGeng))
- remove static typings from Returns in docstrings [\#236](https://github.com/NPLinker/nplinker/pull/236) ([CunliangGeng](https://github.com/CunliangGeng))
- set ruff to not check docstrings of test files [\#235](https://github.com/NPLinker/nplinker/pull/235) ([CunliangGeng](https://github.com/CunliangGeng))
- Support Bigscape v2 data [\#234](https://github.com/NPLinker/nplinker/pull/234) ([adraismawur](https://github.com/adraismawur))

## [v2.0.0-alpha.1](https://github.com/NPLinker/nplinker/tree/v2.0.0-alpha.1) (2024-03-25)

[Full Changelog](https://github.com/NPLinker/nplinker/compare/v1.3.2...v2.0.0-alpha.1)

**Fixed bugs:**

- Fix failing tests [\#96](https://github.com/NPLinker/nplinker/issues/96)

**Closed issues:**

- Fix dev setup issues [\#222](https://github.com/NPLinker/nplinker/issues/222)
- Running NPLinker tutorial [\#213](https://github.com/NPLinker/nplinker/issues/213)
- Exception: Failed to find \*ANY\* strains, missing strain\_mappings.csv? [\#170](https://github.com/NPLinker/nplinker/issues/170)
- Add schema validation [\#165](https://github.com/NPLinker/nplinker/issues/165)
- Refactor initialisation of project root and data folders \[Track issue\] [\#163](https://github.com/NPLinker/nplinker/issues/163)
- http 404 error from `test_nplinker_local.py` [\#156](https://github.com/NPLinker/nplinker/issues/156)
- implement the function to generate strain mappings file [\#154](https://github.com/NPLinker/nplinker/issues/154)
- implement the function to generate `refseq id ↔ BGC id` mapping file [\#153](https://github.com/NPLinker/nplinker/issues/153)
- change csv to json for strain mappings file [\#152](https://github.com/NPLinker/nplinker/issues/152)
- change csv to json for genome status file [\#151](https://github.com/NPLinker/nplinker/issues/151)
- generate strain mappings file for PODP data [\#150](https://github.com/NPLinker/nplinker/issues/150)
- how is `strain_mappings.csv` generated? [\#148](https://github.com/NPLinker/nplinker/issues/148)
- Strain generation, loading and mapping [\#147](https://github.com/NPLinker/nplinker/issues/147)
- Refactor `DatasetLoader` class  [\#145](https://github.com/NPLinker/nplinker/issues/145)
- Use UUID for singleton molecular family? [\#144](https://github.com/NPLinker/nplinker/issues/144)
- KeyError: 'cluster' Extract MIBIG data [\#140](https://github.com/NPLinker/nplinker/issues/140)
- Use the refactored antismash downloader in `PODPDownloader` class [\#137](https://github.com/NPLinker/nplinker/issues/137)
- remove `_strain_dict_index` from `StrainCollection` class [\#134](https://github.com/NPLinker/nplinker/issues/134)
- Rename `Downloader` class to `PODPDownloader` [\#133](https://github.com/NPLinker/nplinker/issues/133)
- Exception: Failed to find \*ANY\* strains, missing strain\_mappings.csv? [\#130](https://github.com/NPLinker/nplinker/issues/130)
- error when loading local data [\#129](https://github.com/NPLinker/nplinker/issues/129)
- nplinker library download [\#128](https://github.com/NPLinker/nplinker/issues/128)
- Hardware Requirements: [\#124](https://github.com/NPLinker/nplinker/issues/124)
- replace load\_gcfs function [\#122](https://github.com/NPLinker/nplinker/issues/122)
- Refactor `Downloader` class to have a specific PoDP downloader [\#121](https://github.com/NPLinker/nplinker/issues/121)
- PODP mode and local data mode [\#117](https://github.com/NPLinker/nplinker/issues/117)
- Create StrainMappingLoader [\#116](https://github.com/NPLinker/nplinker/issues/116)
- Refactor GCF loading process [\#114](https://github.com/NPLinker/nplinker/issues/114)
- Change `strains` in `StrainCollection` to be a `set` instead of `list` [\#113](https://github.com/NPLinker/nplinker/issues/113)
- Implement comparison operator for `StrainCollection` class [\#110](https://github.com/NPLinker/nplinker/issues/110)
- Include `strains` again in objects loaded from Metabolomics [\#109](https://github.com/NPLinker/nplinker/issues/109)
- check if this function is still needed or forward to the proper implementation [\#108](https://github.com/NPLinker/nplinker/issues/108)
- Implement GNPS loading functionality on `DatasetLoader` layer [\#107](https://github.com/NPLinker/nplinker/issues/107)
- Rename `MibigBGC` to `BGC` in MibigBGCLoader [\#106](https://github.com/NPLinker/nplinker/issues/106)
- Remove strain assignment from BGC loaders? [\#104](https://github.com/NPLinker/nplinker/issues/104)
- Use unique and fixed GCF identifier in scoring [\#103](https://github.com/NPLinker/nplinker/issues/103)
- Move test files to subfolders [\#99](https://github.com/NPLinker/nplinker/issues/99)
- Create `antismash_downloader` module [\#98](https://github.com/NPLinker/nplinker/issues/98)
- Fix instructions for zsh shell [\#95](https://github.com/NPLinker/nplinker/issues/95)
- MiBIG v3.x support [\#94](https://github.com/NPLinker/nplinker/issues/94)
- Implement removing the strain also from self.\_lookup indices. \[Bug\] [\#90](https://github.com/NPLinker/nplinker/issues/90)
- Improve GNPS format detection [\#89](https://github.com/NPLinker/nplinker/issues/89)
- PoDP RefSeq accession is used as antiSMASH accession [\#76](https://github.com/NPLinker/nplinker/issues/76)
- Documentation on readthedocs.io [\#74](https://github.com/NPLinker/nplinker/issues/74)

**Merged pull requests:**

- move dependencies to pyproject.toml file [\#233](https://github.com/NPLinker/nplinker/pull/233) ([CunliangGeng](https://github.com/CunliangGeng))
- Add user tutorials  [\#231](https://github.com/NPLinker/nplinker/pull/231) ([CunliangGeng](https://github.com/CunliangGeng))
- update dev env settings for vscode [\#230](https://github.com/NPLinker/nplinker/pull/230) ([CunliangGeng](https://github.com/CunliangGeng))
- update readme files [\#228](https://github.com/NPLinker/nplinker/pull/228) ([CunliangGeng](https://github.com/CunliangGeng))
- enable github actions for PRs on all branches [\#227](https://github.com/NPLinker/nplinker/pull/227) ([CunliangGeng](https://github.com/CunliangGeng))
- update dependencies [\#226](https://github.com/NPLinker/nplinker/pull/226) ([CunliangGeng](https://github.com/CunliangGeng))
- remove unused mkdocs settings [\#225](https://github.com/NPLinker/nplinker/pull/225) ([CunliangGeng](https://github.com/CunliangGeng))
- Fix github actions for large file storage [\#224](https://github.com/NPLinker/nplinker/pull/224) ([CunliangGeng](https://github.com/CunliangGeng))
- Fix dev setup [\#223](https://github.com/NPLinker/nplinker/pull/223) ([adraismawur](https://github.com/adraismawur))
- Add API documentation [\#221](https://github.com/NPLinker/nplinker/pull/221) ([CunliangGeng](https://github.com/CunliangGeng))
- Restructure codebase [\#220](https://github.com/NPLinker/nplinker/pull/220) ([CunliangGeng](https://github.com/CunliangGeng))
- setup docs with Mkdocs [\#218](https://github.com/NPLinker/nplinker/pull/218) ([CunliangGeng](https://github.com/CunliangGeng))
- fix docstrings [\#217](https://github.com/NPLinker/nplinker/pull/217) ([CunliangGeng](https://github.com/CunliangGeng))
- add class DatasetArranger [\#215](https://github.com/NPLinker/nplinker/pull/215) ([CunliangGeng](https://github.com/CunliangGeng))
- use git large file for large zip files [\#214](https://github.com/NPLinker/nplinker/pull/214) ([CunliangGeng](https://github.com/CunliangGeng))
- Update strain mappings generator [\#212](https://github.com/NPLinker/nplinker/pull/212) ([CunliangGeng](https://github.com/CunliangGeng))
- Update global variables [\#211](https://github.com/NPLinker/nplinker/pull/211) ([CunliangGeng](https://github.com/CunliangGeng))
- Update mibig downloader [\#210](https://github.com/NPLinker/nplinker/pull/210) ([CunliangGeng](https://github.com/CunliangGeng))
- Update config template and validations [\#209](https://github.com/NPLinker/nplinker/pull/209) ([CunliangGeng](https://github.com/CunliangGeng))
- Update utils [\#208](https://github.com/NPLinker/nplinker/pull/208) ([CunliangGeng](https://github.com/CunliangGeng))
- Redesign the template of nplinker config file [\#206](https://github.com/NPLinker/nplinker/pull/206) ([CunliangGeng](https://github.com/CunliangGeng))
- Refactor config loader [\#203](https://github.com/NPLinker/nplinker/pull/203) ([CunliangGeng](https://github.com/CunliangGeng))
- refactor initiation of paths to metabolomics files [\#202](https://github.com/NPLinker/nplinker/pull/202) ([CunliangGeng](https://github.com/CunliangGeng))
- update logics of loading mibig data [\#201](https://github.com/NPLinker/nplinker/pull/201) ([CunliangGeng](https://github.com/CunliangGeng))
- remove filtering of common strains during loading [\#200](https://github.com/NPLinker/nplinker/pull/200) ([CunliangGeng](https://github.com/CunliangGeng))
- remove loading of optional data [\#199](https://github.com/NPLinker/nplinker/pull/199) ([CunliangGeng](https://github.com/CunliangGeng))
- deprecate the method `_load_class_info` [\#198](https://github.com/NPLinker/nplinker/pull/198) ([CunliangGeng](https://github.com/CunliangGeng))
- Update loading of genomics data [\#197](https://github.com/NPLinker/nplinker/pull/197) ([CunliangGeng](https://github.com/CunliangGeng))
- Update logics of loading metabolomics data [\#196](https://github.com/NPLinker/nplinker/pull/196) ([CunliangGeng](https://github.com/CunliangGeng))
- remove unused `mgf.py` and its test file [\#194](https://github.com/NPLinker/nplinker/pull/194) ([CunliangGeng](https://github.com/CunliangGeng))
- refactor `Spectrum` class [\#193](https://github.com/NPLinker/nplinker/pull/193) ([CunliangGeng](https://github.com/CunliangGeng))
- Remove class `SingletonFamily` and MF attribute `id` [\#192](https://github.com/NPLinker/nplinker/pull/192) ([CunliangGeng](https://github.com/CunliangGeng))
- Enable filtering of singleton molecular families [\#191](https://github.com/NPLinker/nplinker/pull/191) ([CunliangGeng](https://github.com/CunliangGeng))
- enable parallel testing using pytest-xdist [\#190](https://github.com/NPLinker/nplinker/pull/190) ([CunliangGeng](https://github.com/CunliangGeng))
- refactor class GCF [\#189](https://github.com/NPLinker/nplinker/pull/189) ([CunliangGeng](https://github.com/CunliangGeng))
- refactor class `MolecularFamily` [\#188](https://github.com/NPLinker/nplinker/pull/188) ([CunliangGeng](https://github.com/CunliangGeng))
- remove deprecated functions of loading metabolomics data [\#187](https://github.com/NPLinker/nplinker/pull/187) ([CunliangGeng](https://github.com/CunliangGeng))
- rename `genomics.py` to `utils.py` [\#186](https://github.com/NPLinker/nplinker/pull/186) ([CunliangGeng](https://github.com/CunliangGeng))
- update the process of loading genomics data [\#185](https://github.com/NPLinker/nplinker/pull/185) ([CunliangGeng](https://github.com/CunliangGeng))
- remove deprecated functions of loading genomics data [\#184](https://github.com/NPLinker/nplinker/pull/184) ([CunliangGeng](https://github.com/CunliangGeng))
- rename `strains.py` to `strain.py` [\#183](https://github.com/NPLinker/nplinker/pull/183) ([CunliangGeng](https://github.com/CunliangGeng))
- return list for `get_bgcs` methods of BGC loaders [\#182](https://github.com/NPLinker/nplinker/pull/182) ([CunliangGeng](https://github.com/CunliangGeng))
- Enable GCF loader to filter singleton GCFs [\#181](https://github.com/NPLinker/nplinker/pull/181) ([CunliangGeng](https://github.com/CunliangGeng))
- refactor filtering of user specified strains [\#178](https://github.com/NPLinker/nplinker/pull/178) ([CunliangGeng](https://github.com/CunliangGeng))
- Update ruff rules to ignore unused imports in `__init__.py` files [\#177](https://github.com/NPLinker/nplinker/pull/177) ([CunliangGeng](https://github.com/CunliangGeng))
- change linter and formatter to ruff [\#176](https://github.com/NPLinker/nplinker/pull/176) ([CunliangGeng](https://github.com/CunliangGeng))
- Add or update `__init__.py` [\#174](https://github.com/NPLinker/nplinker/pull/174) ([CunliangGeng](https://github.com/CunliangGeng))
- Add magic method `__add__` [\#173](https://github.com/NPLinker/nplinker/pull/173) ([CunliangGeng](https://github.com/CunliangGeng))
- Fix download bugs [\#172](https://github.com/NPLinker/nplinker/pull/172) ([CunliangGeng](https://github.com/CunliangGeng))
- allow GCF loader to filter mibig-only GCF objects [\#171](https://github.com/NPLinker/nplinker/pull/171) ([CunliangGeng](https://github.com/CunliangGeng))
- Refactor gnps classes [\#169](https://github.com/NPLinker/nplinker/pull/169) ([CunliangGeng](https://github.com/CunliangGeng))
- Refactor loading genomics [\#168](https://github.com/NPLinker/nplinker/pull/168) ([CunliangGeng](https://github.com/CunliangGeng))
- Add schema validation for json data [\#167](https://github.com/NPLinker/nplinker/pull/167) ([CunliangGeng](https://github.com/CunliangGeng))
-  Create functions to extract/get/generate strain mappings [\#166](https://github.com/NPLinker/nplinker/pull/166) ([CunliangGeng](https://github.com/CunliangGeng))
- preparations for issue 154  [\#164](https://github.com/NPLinker/nplinker/pull/164) ([CunliangGeng](https://github.com/CunliangGeng))
- change class method to static method [\#161](https://github.com/NPLinker/nplinker/pull/161) ([CunliangGeng](https://github.com/CunliangGeng))
- Handle 404 NOT FOUND error for `download_and_extract_antismash_data` [\#160](https://github.com/NPLinker/nplinker/pull/160) ([gcroci2](https://github.com/gcroci2))
- Handle unavailable GNPS service [\#159](https://github.com/NPLinker/nplinker/pull/159) ([CunliangGeng](https://github.com/CunliangGeng))
- Issue152 replace csv with json for strain mappings file [\#158](https://github.com/NPLinker/nplinker/pull/158) ([CunliangGeng](https://github.com/CunliangGeng))
- Issue151 use json for genome status file [\#157](https://github.com/NPLinker/nplinker/pull/157) ([CunliangGeng](https://github.com/CunliangGeng))
- 153 bgc mappings generation [\#155](https://github.com/NPLinker/nplinker/pull/155) ([CunliangGeng](https://github.com/CunliangGeng))
- clean up loader and downloader [\#149](https://github.com/NPLinker/nplinker/pull/149) ([CunliangGeng](https://github.com/CunliangGeng))
- refactor: move non-download functionalities out of `PODPDownloader` - `_run_bigscape` [\#143](https://github.com/NPLinker/nplinker/pull/143) ([gcroci2](https://github.com/gcroci2))
- Use unique string IDs [\#142](https://github.com/NPLinker/nplinker/pull/142) ([CunliangGeng](https://github.com/CunliangGeng))
- fix indentation bug in autodocsting [\#141](https://github.com/NPLinker/nplinker/pull/141) ([CunliangGeng](https://github.com/CunliangGeng))
- Refactor `__eq__` and `__hash__` methods [\#139](https://github.com/NPLinker/nplinker/pull/139) ([CunliangGeng](https://github.com/CunliangGeng))
- refactor: use refactored antismash downloader module in `PODPDownloader` class [\#138](https://github.com/NPLinker/nplinker/pull/138) ([gcroci2](https://github.com/gcroci2))
- Refactor StrainCollection class [\#135](https://github.com/NPLinker/nplinker/pull/135) ([CunliangGeng](https://github.com/CunliangGeng))
- Rename `Downloader` class to `POPDownloader` [\#132](https://github.com/NPLinker/nplinker/pull/132) ([gcroci2](https://github.com/gcroci2))
- Refactor Strain class [\#131](https://github.com/NPLinker/nplinker/pull/131) ([CunliangGeng](https://github.com/CunliangGeng))
- refactor: create antismash downloader module and move there inherent code [\#127](https://github.com/NPLinker/nplinker/pull/127) ([gcroci2](https://github.com/gcroci2))
- Add bgc-genome mapping to BGC loaders [\#126](https://github.com/NPLinker/nplinker/pull/126) ([CunliangGeng](https://github.com/CunliangGeng))
- Change `GCF.strains` back to attribute [\#125](https://github.com/NPLinker/nplinker/pull/125) ([CunliangGeng](https://github.com/CunliangGeng))
- add comments for loading process of strain mapping [\#123](https://github.com/NPLinker/nplinker/pull/123) ([CunliangGeng](https://github.com/CunliangGeng))
- refactor GCF loading process [\#120](https://github.com/NPLinker/nplinker/pull/120) ([CunliangGeng](https://github.com/CunliangGeng))
- Improved test coverage for loader [\#118](https://github.com/NPLinker/nplinker/pull/118) ([hechth](https://github.com/hechth))
- rename MibigBGC to BGC in docstrings [\#112](https://github.com/NPLinker/nplinker/pull/112) ([CunliangGeng](https://github.com/CunliangGeng))
- Implement comparison operator for `StrainCollection` class [\#111](https://github.com/NPLinker/nplinker/pull/111) ([hechth](https://github.com/hechth))
- Fix local test error [\#105](https://github.com/NPLinker/nplinker/pull/105) ([CunliangGeng](https://github.com/CunliangGeng))
- Refactor GCF class [\#102](https://github.com/NPLinker/nplinker/pull/102) ([CunliangGeng](https://github.com/CunliangGeng))
- Refactor BGC data model [\#101](https://github.com/NPLinker/nplinker/pull/101) ([CunliangGeng](https://github.com/CunliangGeng))
- Move test files to subfolders and update pytest's conftest.py [\#100](https://github.com/NPLinker/nplinker/pull/100) ([CunliangGeng](https://github.com/CunliangGeng))
- docs: add quotes in package installation for zsh shell [\#97](https://github.com/NPLinker/nplinker/pull/97) ([gcroci2](https://github.com/gcroci2))
- Refactored GNPS downloading and file extraction code [\#93](https://github.com/NPLinker/nplinker/pull/93) ([hechth](https://github.com/hechth))
- Refactor BGC data loader [\#92](https://github.com/NPLinker/nplinker/pull/92) ([CunliangGeng](https://github.com/CunliangGeng))
- Initial refactoring of Metabolomics data loading [\#91](https://github.com/NPLinker/nplinker/pull/91) ([hechth](https://github.com/hechth))
- static typing [\#88](https://github.com/NPLinker/nplinker/pull/88) ([CunliangGeng](https://github.com/CunliangGeng))
- Refactor mibig related code [\#87](https://github.com/NPLinker/nplinker/pull/87) ([CunliangGeng](https://github.com/CunliangGeng))
- Add download extract utils [\#85](https://github.com/NPLinker/nplinker/pull/85) ([CunliangGeng](https://github.com/CunliangGeng))
- Refactor AA prediction [\#84](https://github.com/NPLinker/nplinker/pull/84) ([CunliangGeng](https://github.com/CunliangGeng))
- Check metcalf and IOKR scoring [\#83](https://github.com/NPLinker/nplinker/pull/83) ([CunliangGeng](https://github.com/CunliangGeng))
- add dev branch to github actions [\#82](https://github.com/NPLinker/nplinker/pull/82) ([CunliangGeng](https://github.com/CunliangGeng))
- add DATA\_DIR for sharing test data dir [\#81](https://github.com/NPLinker/nplinker/pull/81) ([CunliangGeng](https://github.com/CunliangGeng))
- Initial refactoring on scoring methods [\#80](https://github.com/NPLinker/nplinker/pull/80) ([hechth](https://github.com/hechth))
- Implemented some tests for the metabolomics side [\#79](https://github.com/NPLinker/nplinker/pull/79) ([hechth](https://github.com/hechth))
- Refactored `genomics.py` and `metabolomics.py` by moving classes into individual files [\#78](https://github.com/NPLinker/nplinker/pull/78) ([hechth](https://github.com/hechth))
- Refine github actions [\#77](https://github.com/NPLinker/nplinker/pull/77) ([CunliangGeng](https://github.com/CunliangGeng))

## [v1.3.2](https://github.com/NPLinker/nplinker/tree/v1.3.2) (2022-08-12)

[Full Changelog](https://github.com/NPLinker/nplinker/compare/v1.3.1...v1.3.2)

## [v1.3.1](https://github.com/NPLinker/nplinker/tree/v1.3.1) (2022-08-05)

[Full Changelog](https://github.com/NPLinker/nplinker/compare/v1.3.0...v1.3.1)

**Closed issues:**

- Important: Stop committing until restructuring is done  [\#73](https://github.com/NPLinker/nplinker/issues/73)
- Explore tutorials/modules are relevant to develop the dashboard [\#68](https://github.com/NPLinker/nplinker/issues/68)

**Merged pull requests:**

- Refine install script and upgrade python syntax [\#75](https://github.com/NPLinker/nplinker/pull/75) ([CunliangGeng](https://github.com/CunliangGeng))

## [v1.3.0](https://github.com/NPLinker/nplinker/tree/v1.3.0) (2022-07-21)

[Full Changelog](https://github.com/NPLinker/nplinker/compare/v1.2.0...v1.3.0)

**Implemented enhancements:**

- Packaging [\#15](https://github.com/NPLinker/nplinker/issues/15)

**Closed issues:**

- Create independent repo for webapp? [\#72](https://github.com/NPLinker/nplinker/issues/72)
- Restructure repo with python template from eScience Center  [\#71](https://github.com/NPLinker/nplinker/issues/71)
- Update wiki page [\#64](https://github.com/NPLinker/nplinker/issues/64)
- something goes wrong in the step for "MetcalfScoring.setup preprocessing dataset" [\#57](https://github.com/NPLinker/nplinker/issues/57)
- Parsing strains in GNPS FBMN output needs to be more flexible [\#50](https://github.com/NPLinker/nplinker/issues/50)
- Rosetta Score issue [\#39](https://github.com/NPLinker/nplinker/issues/39)
- Loading FBMN-GNPS and Bigscape output data into NPLinker error. [\#35](https://github.com/NPLinker/nplinker/issues/35)
- Remove requirements.txt file [\#6](https://github.com/NPLinker/nplinker/issues/6)
- Matching compound names from GNPS to MiBIG [\#3](https://github.com/NPLinker/nplinker/issues/3)

**Merged pull requests:**

- Bump numpy from 1.21.0 to 1.22.0 [\#70](https://github.com/NPLinker/nplinker/pull/70) ([dependabot[bot]](https://github.com/apps/dependabot))
- NpclassScore expand notebooks [\#69](https://github.com/NPLinker/nplinker/pull/69) ([louwenjjr](https://github.com/louwenjjr))

## [v1.2.0](https://github.com/NPLinker/nplinker/tree/v1.2.0) (2022-06-07)

[Full Changelog](https://github.com/NPLinker/nplinker/compare/v1.1.3...v1.2.0)

**Closed issues:**

- WebApp shows no data in tables [\#63](https://github.com/NPLinker/nplinker/issues/63)
- "Error in server loaded hook UnicodeDecodeError" [\#60](https://github.com/NPLinker/nplinker/issues/60)
- Error in loading from PoDP: MSV000078839 [\#58](https://github.com/NPLinker/nplinker/issues/58)
- Linking molfams [\#54](https://github.com/NPLinker/nplinker/issues/54)

**Merged pull requests:**

- Bump httpx from 0.16.1 to 0.23.0 [\#66](https://github.com/NPLinker/nplinker/pull/66) ([dependabot[bot]](https://github.com/apps/dependabot))
- Expand documentation [\#65](https://github.com/NPLinker/nplinker/pull/65) ([louwenjjr](https://github.com/louwenjjr))
- Bump numpy from 1.20.1 to 1.21.0 [\#62](https://github.com/NPLinker/nplinker/pull/62) ([dependabot[bot]](https://github.com/apps/dependabot))
- NPClassScore scoring [\#61](https://github.com/NPLinker/nplinker/pull/61) ([louwenjjr](https://github.com/louwenjjr))
- Bump pillow from 8.3.2 to 9.0.0 [\#59](https://github.com/NPLinker/nplinker/pull/59) ([dependabot[bot]](https://github.com/apps/dependabot))

## [v1.1.3](https://github.com/NPLinker/nplinker/tree/v1.1.3) (2021-11-26)

[Full Changelog](https://github.com/NPLinker/nplinker/compare/v1.1.2...v1.1.3)

## [v1.1.2](https://github.com/NPLinker/nplinker/tree/v1.1.2) (2021-09-23)

[Full Changelog](https://github.com/NPLinker/nplinker/compare/v1.1.1...v1.1.2)

**Closed issues:**

- Turning MIBiG on in BiG-SCAPE run of NPLinker [\#55](https://github.com/NPLinker/nplinker/issues/55)

## [v1.1.1](https://github.com/NPLinker/nplinker/tree/v1.1.1) (2021-09-13)

[Full Changelog](https://github.com/NPLinker/nplinker/compare/v1.1...v1.1.1)

**Closed issues:**

- Add a changelog and tag Docker images [\#52](https://github.com/NPLinker/nplinker/issues/52)
- GCF/BGC data does appear correctly in results [\#49](https://github.com/NPLinker/nplinker/issues/49)

**Merged pull requests:**

- Bump pillow from 8.2.0 to 8.3.2 [\#53](https://github.com/NPLinker/nplinker/pull/53) ([dependabot[bot]](https://github.com/apps/dependabot))

## [v1.1](https://github.com/NPLinker/nplinker/tree/v1.1) (2021-09-04)

[Full Changelog](https://github.com/NPLinker/nplinker/compare/v1.0...v1.1)

**Implemented enhancements:**

- Error when loading Crüsemann data [\#38](https://github.com/NPLinker/nplinker/issues/38)

**Fixed bugs:**

- large-scale sample run error [\#43](https://github.com/NPLinker/nplinker/issues/43)

**Closed issues:**

- Add Licence [\#48](https://github.com/NPLinker/nplinker/issues/48)
- Allowing other websocket to connect to proxy server? [\#47](https://github.com/NPLinker/nplinker/issues/47)
- KeyError in strains.py [\#46](https://github.com/NPLinker/nplinker/issues/46)
- Internal Server Error with tutorial data [\#45](https://github.com/NPLinker/nplinker/issues/45)
- Error loading tutorial data [\#44](https://github.com/NPLinker/nplinker/issues/44)
- rosetta scoring: check for knownclusterblast .txt files at start of scoring process [\#34](https://github.com/NPLinker/nplinker/issues/34)

**Merged pull requests:**

- Bump pillow from 8.1.1 to 8.2.0 [\#42](https://github.com/NPLinker/nplinker/pull/42) ([dependabot[bot]](https://github.com/apps/dependabot))

## [v1.0](https://github.com/NPLinker/nplinker/tree/v1.0) (2021-03-19)

[Full Changelog](https://github.com/NPLinker/nplinker/compare/last_version_with_plots...v1.0)

**Merged pull requests:**

- Bump pillow from 8.1.0 to 8.1.1 [\#40](https://github.com/NPLinker/nplinker/pull/40) ([dependabot[bot]](https://github.com/apps/dependabot))

## [last_version_with_plots](https://github.com/NPLinker/nplinker/tree/last_version_with_plots) (2021-02-15)

[Full Changelog](https://github.com/NPLinker/nplinker/compare/v.0.1...last_version_with_plots)

**Closed issues:**

- Write log output to file [\#37](https://github.com/NPLinker/nplinker/issues/37)

## [v.0.1](https://github.com/NPLinker/nplinker/tree/v.0.1) (2020-12-11)

[Full Changelog](https://github.com/NPLinker/nplinker/compare/scoring_jun2020...v.0.1)

**Implemented enhancements:**

- Input options [\#14](https://github.com/NPLinker/nplinker/issues/14)
- More general annotations [\#12](https://github.com/NPLinker/nplinker/issues/12)

**Closed issues:**

- metadata [\#2](https://github.com/NPLinker/nplinker/issues/2)
- MiBIG [\#1](https://github.com/NPLinker/nplinker/issues/1)

## [scoring_jun2020](https://github.com/NPLinker/nplinker/tree/scoring_jun2020) (2020-05-29)

[Full Changelog](https://github.com/NPLinker/nplinker/compare/6c299348b417e494167c4bd4869fa79f62383fc9...scoring_jun2020)

**Implemented enhancements:**

- Generate null distributions for the different scoring functions [\#9](https://github.com/NPLinker/nplinker/issues/9)

**Fixed bugs:**

- NP-optimised Metcalf score crashes [\#24](https://github.com/NPLinker/nplinker/issues/24)

**Closed issues:**

- Restrict NPLinker strain object to data set population [\#27](https://github.com/NPLinker/nplinker/issues/27)

**Merged pull requests:**

- Bump bleach from 3.0.2 to 3.1.1 [\#30](https://github.com/NPLinker/nplinker/pull/30) ([dependabot[bot]](https://github.com/apps/dependabot))
- Hack to resolve GenBank accession to RefSeq accession [\#29](https://github.com/NPLinker/nplinker/pull/29) ([grimur](https://github.com/grimur))
- Rosetta [\#28](https://github.com/NPLinker/nplinker/pull/28) ([sdrogers](https://github.com/sdrogers))
- Bump notebook from 5.7.0 to 5.7.8 [\#26](https://github.com/NPLinker/nplinker/pull/26) ([dependabot[bot]](https://github.com/apps/dependabot))
- Merging webapp back into master [\#25](https://github.com/NPLinker/nplinker/pull/25) ([andrewramsay](https://github.com/andrewramsay))
- Additional link expectancy calculations. [\#20](https://github.com/NPLinker/nplinker/pull/20) ([florian-huber](https://github.com/florian-huber))
- get\_links function now takes Spectrum, MolecularFamily, or GCF object… [\#19](https://github.com/NPLinker/nplinker/pull/19) ([florian-huber](https://github.com/florian-huber))
- Added some expectancy/probability calculations [\#18](https://github.com/NPLinker/nplinker/pull/18) ([florian-huber](https://github.com/florian-huber))
- Update of tests for updated matrix multiplication functions [\#17](https://github.com/NPLinker/nplinker/pull/17) ([florian-huber](https://github.com/florian-huber))
- Added functions and clearer code structure [\#16](https://github.com/NPLinker/nplinker/pull/16) ([florian-huber](https://github.com/florian-huber))
- Additional DataLinks and LinkProbabilty classes  [\#8](https://github.com/NPLinker/nplinker/pull/8) ([florian-huber](https://github.com/florian-huber))
- Updating metcalf\_scoring to use a faster numpy-based method. [\#7](https://github.com/NPLinker/nplinker/pull/7) ([andrewramsay](https://github.com/andrewramsay))
- 2to3 changes [\#5](https://github.com/NPLinker/nplinker/pull/5) ([andrewramsay](https://github.com/andrewramsay))
- simple multiprocessing for scoring [\#4](https://github.com/NPLinker/nplinker/pull/4) ([andrewramsay](https://github.com/andrewramsay))



\* *This Changelog was automatically generated by [github_changelog_generator](https://github.com/github-changelog-generator/github-changelog-generator)*
