import pytest
from nplinker.metabolomics.gnps import GNPSAnnotationLoader
from nplinker.metabolomics.gnps import GNPSFormat


@pytest.mark.parametrize(
    "workflow, expected",
    [[GNPSFormat.FBMN, 43], [GNPSFormat.SNETS, 1154], [GNPSFormat.SNETSV2, 18]],
)
def test_annotation_loader_gnps1(workflow, expected, gnps_annotations_files):
    loader = GNPSAnnotationLoader(gnps_annotations_files[workflow])
    assert len(loader.annotations) == expected  # number of spectra

    required_columns = [
        "#Scan#",
        "Compound_Name",
        "Organism",
        "MQScore",
        "SpectrumID",
        "png_url",
        "json_url",
        "svg_url",
        "spectrum_url",
    ]
    for annotations in loader.annotations.values():
        assert isinstance(annotations, dict)
        for name in required_columns:
            assert name in annotations


@pytest.mark.parametrize(
    "workflow, expected",
    [
        [GNPSFormat.GNPS2CN, 122],
        [GNPSFormat.GNPS2FBMN, 54],
    ],
)
def test_annotation_loader_gnps2(workflow, expected, gnps2_annotations_files):
    loader = GNPSAnnotationLoader(gnps2_annotations_files[workflow])
    assert len(loader.annotations) == expected  # number of spectra

    required_columns = [
        "#Scan#",
        "Compound_Name",
        "Organism",
        "MQScore",
        "SpectrumID",
        "png_url",
        "json_url",
        "svg_url",
        "spectrum_url",
    ]
    for annotations in loader.annotations.values():
        assert isinstance(annotations, dict)
        for name in required_columns:
            assert name in annotations
