/* Copyright 2018 Istio Authors. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once

#include "envoy/network/filter.h"

namespace Envoy {
namespace Tcp {
namespace ForwardDownstreamSni {

/**
 * Implementation of the forward_downstream_sni filter that sets the original
 * requested server name from the SNI field in the TLS connection.
 */
class ForwardDownstreamSniFilter : public Network::ReadFilter {
 public:
  // Network::ReadFilter
  Network::FilterStatus onData(Buffer::Instance&, bool) override {
    return Network::FilterStatus::Continue;
  }
  Network::FilterStatus onNewConnection() override;
  void initializeReadFilterCallbacks(
      Network::ReadFilterCallbacks& callbacks) override {
    read_callbacks_ = &callbacks;
  }

 private:
  Network::ReadFilterCallbacks* read_callbacks_{};
};

}  // namespace ForwardDownstreamSni
}  // namespace Tcp
}  // namespace Envoy
