% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BenchmarkResult_operators.R
\name{getBMRFeatSelResults}
\alias{getBMRFeatSelResults}
\title{Extract the feature selection results from a benchmark result.}
\usage{
getBMRFeatSelResults(bmr, task.ids = NULL, learner.ids = NULL,
  as.df = FALSE)
}
\arguments{
\item{bmr}{[\code{\link{BenchmarkResult}}]\cr
Benchmark result.}

\item{task.ids}{[\code{character(1)}]\cr
Restrict result to certain tasks.
Default is all.}

\item{learner.ids}{[\code{character(1)}]\cr
Restrict result to certain learners.
Default is all.}

\item{as.df}{[\code{character(1)}]\cr
Return one data.frame as result - or a list of lists of objects?.
Default is \code{FALSE}.}
}
\value{
[\code{list} | \code{data.frame}]. See above.
}
\description{
Returns a nested list of \code{\link{FeatSelResult}}s. The first level of nesting is by data set, the second by learner, the third for the benchmark resampling iterations. If \code{as.df} is \code{TRUE}, a data frame with \dQuote{task.id}, \dQuote{learner.id}, the resample iteration and the selected features is returned.

Note that if more than one feature is selected and a data frame is requested, there will be multiple rows for the same dataset-learner-iteration; one for each selected feature.
}
\seealso{
Other benchmark: \code{\link{BenchmarkResult}},
  \code{\link{benchmark}},
  \code{\link{convertBMRToRankMatrix}},
  \code{\link{friedmanPostHocTestBMR}},
  \code{\link{friedmanTestBMR}},
  \code{\link{generateCritDifferencesData}},
  \code{\link{getBMRAggrPerformances}},
  \code{\link{getBMRFilteredFeatures}},
  \code{\link{getBMRLearnerIds}},
  \code{\link{getBMRLearnerShortNames}},
  \code{\link{getBMRLearners}},
  \code{\link{getBMRMeasureIds}},
  \code{\link{getBMRMeasures}}, \code{\link{getBMRModels}},
  \code{\link{getBMRPerformances}},
  \code{\link{getBMRPredictions}},
  \code{\link{getBMRTaskIds}},
  \code{\link{getBMRTuneResults}},
  \code{\link{plotBMRBoxplots}},
  \code{\link{plotBMRRanksAsBarChart}},
  \code{\link{plotBMRSummary}},
  \code{\link{plotCritDifferences}}
}

