# I18n

[Chrome Docs](https://developer.chrome.com/docs/extensions/reference/api/i18n) • [Firefox Docs](https://developer.mozilla.org/en-US/docs/Mozilla/Add-ons/WebExtensions/API/i18n)

This page discusses how to setup internationalization using the vanilla `browser.i18n` APIs and mentions some alternatives if you want to use something else.

[[toc]]

## Usage

1. Add `default_locale` to your manifest:
   ```ts
   export default defineConfig({
     manifest: {
       default_locale: 'en',
     },
   });
   ```
2. Create `messages.json` files in the `public/` directory:

   <!-- prettier-ignore -->
   ```html
   📂 {srcDir}/
      📂 public/
         📂 _locales/
            📂 en/
               📄 messages.json
            📂 de/
               📄 messages.json
            📂 ko/
               📄 messages.json
   ```

   ```jsonc
   // public/_locales/en/messages.json
   {
     "helloWorld": {
       "message": "Hello world!",
     },
   }
   ```

3. Get the translation:
   ```ts
   browser.i18n.getMessage('helloWorld');
   ```
4. _Optional_: Add translations for extension name and description:

```json
{
  "extName": {
    "message": "..."
  },
  "extDescription": {
    "message": "..."
  },
  "helloWorld": {
    "message": "Hello world!"
  }
}
```

```ts
export default defineConfig({
  manifest: {
    name: '__MSG_extName__',
    description: '__MSG_extDescription__',
    default_locale: 'en',
  },
});
```

## Alternatives

The vanilla API has very few features, which is why you may want to consider using third-party NPM packages like `i18next`, `react-i18n`, `vue-i18n`, etc.

However, it is recommended you stick with the vanilla API (or a package based on top of the vanilla API, like [`@wxt-dev/i18n`](/i18n)), because:

- They can localize text in your manifest and CSS files
- Translations are loaded synchronously
- Translations are not bundled multiple times, keeping your extension small
- Zero configuration

However, there is one major downside to the vanilla API and any packages built on top of it:

- Language cannot be changed without changing your browser/system language

Here are some examples of how to setup a third party i18n library:

- [vue-i18n](https://github.com/wxt-dev/wxt-examples/tree/main/examples/vue-i18n)
