// Copyright (C) 2019-2025 Provable Inc.
// This file is part of the Leo library.

// The Leo library is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.

// The Leo library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with the Leo library. If not, see <https://www.gnu.org/licenses/>.

use crate::create_messages;
use std::fmt::{Debug, Display};

create_messages!(
    /// CliError enum that represents all the errors for the `leo-lang` crate.
    FlattenError,
    code_mask: 3000i32,
    code_prefix: "FLA",

    // TODO: This error is unused.
    @formatted
    binary_overflow {
        args: (left: impl Display, op: impl Display, right: impl Display, right_type: impl Display),
        msg: format!("The const operation `{left}{} {op} {right}{right_type}` causes an overflow.", 0u32),
        help: None,
    }

    // TODO: This error is unused.
    @formatted
    unary_overflow {
        args: (left: impl Display, op: impl Display),
        msg: format!("The const operation `{left}{} {op}` causes an overflow.", 0u32),
        help: None,
    }

    /// For when a loop uses a negative value.
    @formatted
    loop_has_neg_value {
        args: (value: impl Display),
        msg: format!(
            "The loop has a negative loop bound `{value}`.",
        ),
        help: None,
    }

    /// For when a u128 value cannot be converted into an i128.
    @formatted
    u128_to_i128 {
        args: (value: impl Display),
        msg: format!(
            "The value `{value}` cannot be converted into an i128.",
        ),
        help: None,
    }
);
