# Leo Tests

This directory includes Leo code samples, which are parsed and used as tests by `test-framework`.

## Structure

There are two directories: `tests`, which contains `leo` test files, and `expectations`, which contains
output generated by previous test runs.

The subdirectories of `tests` are categories of tests, such as `compiler`, `parser`, and so on.

## Test Expectations

After an initial run of the tests, test expectations will be autogenerated and placed under the `expectations/` directory.
They will contain the results of execution.

During subsequent test runs, the results of each test are compared to the stored expectations, and if the stored expectations
don't match actual results, an error will be thrown and the test won't pass. Of course, there are two possible scenarios:

1. If the test has failed because the logic was changed intentionally, then expectations need to be deleted. New ones will be
generated instead. A PR should contain changes to expectations as well as to tests or code. You can also regenerate new
expectation files by setting the environment variable `REWRITE_EXPECTATIONS` while running tests.
2. If the test should pass, then expectations should not be changed or removed.

