// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: cometbft/services/block_results/v1/block_results.proto

package v1

import (
	fmt "fmt"
	v1 "github.com/cometbft/cometbft/api/cometbft/abci/v1"
	v11 "github.com/cometbft/cometbft/api/cometbft/types/v1"
	proto "github.com/cosmos/gogoproto/proto"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// GetBlockResults is a request for the BlockResults of a given height.
type GetBlockResultsRequest struct {
	Height int64 `protobuf:"varint,1,opt,name=height,proto3" json:"height,omitempty"`
}

func (m *GetBlockResultsRequest) Reset()         { *m = GetBlockResultsRequest{} }
func (m *GetBlockResultsRequest) String() string { return proto.CompactTextString(m) }
func (*GetBlockResultsRequest) ProtoMessage()    {}
func (*GetBlockResultsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3fd862496bf20f1b, []int{0}
}
func (m *GetBlockResultsRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetBlockResultsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetBlockResultsRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetBlockResultsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetBlockResultsRequest.Merge(m, src)
}
func (m *GetBlockResultsRequest) XXX_Size() int {
	return m.Size()
}
func (m *GetBlockResultsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetBlockResultsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetBlockResultsRequest proto.InternalMessageInfo

func (m *GetBlockResultsRequest) GetHeight() int64 {
	if m != nil {
		return m.Height
	}
	return 0
}

// GetBlockResultsResponse contains the block results for the given height.
type GetBlockResultsResponse struct {
	Height                int64                 `protobuf:"varint,1,opt,name=height,proto3" json:"height,omitempty"`
	TxResults             []*v1.ExecTxResult    `protobuf:"bytes,2,rep,name=tx_results,json=txResults,proto3" json:"tx_results,omitempty"`
	FinalizeBlockEvents   []*v1.Event           `protobuf:"bytes,3,rep,name=finalize_block_events,json=finalizeBlockEvents,proto3" json:"finalize_block_events,omitempty"`
	ValidatorUpdates      []*v1.ValidatorUpdate `protobuf:"bytes,4,rep,name=validator_updates,json=validatorUpdates,proto3" json:"validator_updates,omitempty"`
	ConsensusParamUpdates *v11.ConsensusParams  `protobuf:"bytes,5,opt,name=consensus_param_updates,json=consensusParamUpdates,proto3" json:"consensus_param_updates,omitempty"`
	AppHash               []byte                `protobuf:"bytes,6,opt,name=app_hash,json=appHash,proto3" json:"app_hash,omitempty"`
}

func (m *GetBlockResultsResponse) Reset()         { *m = GetBlockResultsResponse{} }
func (m *GetBlockResultsResponse) String() string { return proto.CompactTextString(m) }
func (*GetBlockResultsResponse) ProtoMessage()    {}
func (*GetBlockResultsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_3fd862496bf20f1b, []int{1}
}
func (m *GetBlockResultsResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetBlockResultsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetBlockResultsResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetBlockResultsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetBlockResultsResponse.Merge(m, src)
}
func (m *GetBlockResultsResponse) XXX_Size() int {
	return m.Size()
}
func (m *GetBlockResultsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetBlockResultsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetBlockResultsResponse proto.InternalMessageInfo

func (m *GetBlockResultsResponse) GetHeight() int64 {
	if m != nil {
		return m.Height
	}
	return 0
}

func (m *GetBlockResultsResponse) GetTxResults() []*v1.ExecTxResult {
	if m != nil {
		return m.TxResults
	}
	return nil
}

func (m *GetBlockResultsResponse) GetFinalizeBlockEvents() []*v1.Event {
	if m != nil {
		return m.FinalizeBlockEvents
	}
	return nil
}

func (m *GetBlockResultsResponse) GetValidatorUpdates() []*v1.ValidatorUpdate {
	if m != nil {
		return m.ValidatorUpdates
	}
	return nil
}

func (m *GetBlockResultsResponse) GetConsensusParamUpdates() *v11.ConsensusParams {
	if m != nil {
		return m.ConsensusParamUpdates
	}
	return nil
}

func (m *GetBlockResultsResponse) GetAppHash() []byte {
	if m != nil {
		return m.AppHash
	}
	return nil
}

func init() {
	proto.RegisterType((*GetBlockResultsRequest)(nil), "cometbft.services.block_results.v1.GetBlockResultsRequest")
	proto.RegisterType((*GetBlockResultsResponse)(nil), "cometbft.services.block_results.v1.GetBlockResultsResponse")
}

func init() {
	proto.RegisterFile("cometbft/services/block_results/v1/block_results.proto", fileDescriptor_3fd862496bf20f1b)
}

var fileDescriptor_3fd862496bf20f1b = []byte{
	// 396 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x84, 0x92, 0x4f, 0xcf, 0x93, 0x40,
	0x10, 0xc6, 0x8b, 0x68, 0xd5, 0x7d, 0x3d, 0x28, 0xe6, 0x6d, 0xb1, 0x31, 0x1b, 0xe4, 0xc4, 0x09,
	0xa4, 0x26, 0xde, 0xbc, 0xb4, 0x31, 0x9a, 0x98, 0x18, 0xb3, 0x51, 0x0f, 0x4d, 0x0c, 0x59, 0xe8,
	0xb6, 0x6c, 0xa4, 0xb0, 0x32, 0xcb, 0xa6, 0x7a, 0xf6, 0x03, 0xf8, 0xb1, 0x3c, 0xf6, 0xe8, 0xd1,
	0xb4, 0x5f, 0xc4, 0xb0, 0xfc, 0x69, 0x48, 0x35, 0xde, 0xe0, 0x79, 0xe6, 0xf9, 0x31, 0xc3, 0x0c,
	0x7a, 0x9e, 0x14, 0x3b, 0x26, 0xe3, 0x8d, 0x0c, 0x80, 0x95, 0x8a, 0x27, 0x0c, 0x82, 0x38, 0x2b,
	0x92, 0xcf, 0x51, 0xc9, 0xa0, 0xca, 0x24, 0x04, 0x2a, 0x1c, 0x0a, 0xbe, 0x28, 0x0b, 0x59, 0x58,
	0x6e, 0x97, 0xf3, 0xbb, 0x9c, 0x3f, 0x2c, 0x53, 0xe1, 0xec, 0x71, 0xcf, 0xa6, 0x71, 0xc2, 0x6b,
	0x92, 0xfc, 0x2a, 0x58, 0x4b, 0x98, 0xe1, 0xde, 0xd5, 0x6a, 0x6d, 0x0b, 0x5a, 0xd2, 0x5d, 0xeb,
	0xbb, 0x4f, 0xd1, 0xe4, 0x15, 0x93, 0x8b, 0x1a, 0x4a, 0x1a, 0x26, 0x61, 0x5f, 0x2a, 0x06, 0xd2,
	0x9a, 0xa0, 0x71, 0xca, 0xf8, 0x36, 0x95, 0xb6, 0xe1, 0x18, 0x9e, 0x49, 0xda, 0x37, 0xf7, 0xbb,
	0x89, 0xa6, 0x17, 0x11, 0x10, 0x45, 0x0e, 0xec, 0x5f, 0x19, 0xeb, 0x05, 0x42, 0x72, 0xdf, 0x35,
	0x6d, 0xdf, 0x70, 0x4c, 0xef, 0x6a, 0x8e, 0xfd, 0x7e, 0xb8, 0xba, 0x71, 0x5f, 0x85, 0xfe, 0xcb,
	0x3d, 0x4b, 0xde, 0xef, 0x1b, 0x28, 0xb9, 0x2b, 0xdb, 0x27, 0xb0, 0xde, 0xa0, 0xeb, 0x0d, 0xcf,
	0x69, 0xc6, 0xbf, 0xb1, 0xa8, 0x99, 0x9f, 0x29, 0x96, 0x4b, 0xb0, 0x4d, 0x4d, 0x9a, 0xfe, 0x85,
	0x54, 0xfb, 0xe4, 0x61, 0x97, 0xd2, 0xcd, 0x6a, 0x0d, 0xac, 0xb7, 0xe8, 0x81, 0xa2, 0x19, 0x5f,
	0x53, 0x59, 0x94, 0x51, 0x25, 0xd6, 0x54, 0x32, 0xb0, 0x6f, 0x6a, 0xd0, 0x93, 0x4b, 0xd0, 0xc7,
	0xae, 0xf4, 0x83, 0xae, 0x24, 0xf7, 0xd5, 0x50, 0x00, 0x6b, 0x85, 0xa6, 0x49, 0x3d, 0x7c, 0x0e,
	0x15, 0x44, 0xfa, 0xdf, 0xf6, 0xd4, 0x5b, 0x8e, 0xe1, 0x5d, 0xcd, 0xdd, 0x33, 0xb5, 0xd9, 0x8c,
	0x0a, 0xfd, 0x65, 0x97, 0x78, 0xa7, 0x97, 0x41, 0xae, 0x93, 0x81, 0xd0, 0xb1, 0x1f, 0xa1, 0x3b,
	0x54, 0x88, 0x28, 0xa5, 0x90, 0xda, 0x63, 0xc7, 0xf0, 0xee, 0x91, 0xdb, 0x54, 0x88, 0xd7, 0x14,
	0xd2, 0xc5, 0xa7, 0x9f, 0x47, 0x6c, 0x1c, 0x8e, 0xd8, 0xf8, 0x7d, 0xc4, 0xc6, 0x8f, 0x13, 0x1e,
	0x1d, 0x4e, 0x78, 0xf4, 0xeb, 0x84, 0x47, 0xab, 0xe5, 0x96, 0xcb, 0xb4, 0x8a, 0xeb, 0xaf, 0x06,
	0xfd, 0xf6, 0xcf, 0x47, 0x22, 0x78, 0xf0, 0xff, 0x6b, 0x8c, 0xc7, 0xfa, 0x3c, 0x9e, 0xfd, 0x09,
	0x00, 0x00, 0xff, 0xff, 0xf5, 0x7a, 0x3e, 0x1d, 0xba, 0x02, 0x00, 0x00,
}

func (m *GetBlockResultsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetBlockResultsRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetBlockResultsRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Height != 0 {
		i = encodeVarintBlockResults(dAtA, i, uint64(m.Height))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *GetBlockResultsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetBlockResultsResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetBlockResultsResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.AppHash) > 0 {
		i -= len(m.AppHash)
		copy(dAtA[i:], m.AppHash)
		i = encodeVarintBlockResults(dAtA, i, uint64(len(m.AppHash)))
		i--
		dAtA[i] = 0x32
	}
	if m.ConsensusParamUpdates != nil {
		{
			size, err := m.ConsensusParamUpdates.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintBlockResults(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if len(m.ValidatorUpdates) > 0 {
		for iNdEx := len(m.ValidatorUpdates) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ValidatorUpdates[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintBlockResults(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.FinalizeBlockEvents) > 0 {
		for iNdEx := len(m.FinalizeBlockEvents) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.FinalizeBlockEvents[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintBlockResults(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.TxResults) > 0 {
		for iNdEx := len(m.TxResults) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.TxResults[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintBlockResults(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Height != 0 {
		i = encodeVarintBlockResults(dAtA, i, uint64(m.Height))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func encodeVarintBlockResults(dAtA []byte, offset int, v uint64) int {
	offset -= sovBlockResults(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *GetBlockResultsRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Height != 0 {
		n += 1 + sovBlockResults(uint64(m.Height))
	}
	return n
}

func (m *GetBlockResultsResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Height != 0 {
		n += 1 + sovBlockResults(uint64(m.Height))
	}
	if len(m.TxResults) > 0 {
		for _, e := range m.TxResults {
			l = e.Size()
			n += 1 + l + sovBlockResults(uint64(l))
		}
	}
	if len(m.FinalizeBlockEvents) > 0 {
		for _, e := range m.FinalizeBlockEvents {
			l = e.Size()
			n += 1 + l + sovBlockResults(uint64(l))
		}
	}
	if len(m.ValidatorUpdates) > 0 {
		for _, e := range m.ValidatorUpdates {
			l = e.Size()
			n += 1 + l + sovBlockResults(uint64(l))
		}
	}
	if m.ConsensusParamUpdates != nil {
		l = m.ConsensusParamUpdates.Size()
		n += 1 + l + sovBlockResults(uint64(l))
	}
	l = len(m.AppHash)
	if l > 0 {
		n += 1 + l + sovBlockResults(uint64(l))
	}
	return n
}

func sovBlockResults(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozBlockResults(x uint64) (n int) {
	return sovBlockResults(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *GetBlockResultsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBlockResults
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetBlockResultsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetBlockResultsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Height", wireType)
			}
			m.Height = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBlockResults
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Height |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipBlockResults(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthBlockResults
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetBlockResultsResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBlockResults
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetBlockResultsResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetBlockResultsResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Height", wireType)
			}
			m.Height = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBlockResults
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Height |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxResults", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBlockResults
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBlockResults
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBlockResults
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TxResults = append(m.TxResults, &v1.ExecTxResult{})
			if err := m.TxResults[len(m.TxResults)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FinalizeBlockEvents", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBlockResults
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBlockResults
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBlockResults
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.FinalizeBlockEvents = append(m.FinalizeBlockEvents, &v1.Event{})
			if err := m.FinalizeBlockEvents[len(m.FinalizeBlockEvents)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ValidatorUpdates", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBlockResults
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBlockResults
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBlockResults
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ValidatorUpdates = append(m.ValidatorUpdates, &v1.ValidatorUpdate{})
			if err := m.ValidatorUpdates[len(m.ValidatorUpdates)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConsensusParamUpdates", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBlockResults
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBlockResults
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBlockResults
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ConsensusParamUpdates == nil {
				m.ConsensusParamUpdates = &v11.ConsensusParams{}
			}
			if err := m.ConsensusParamUpdates.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AppHash", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBlockResults
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthBlockResults
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthBlockResults
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AppHash = append(m.AppHash[:0], dAtA[iNdEx:postIndex]...)
			if m.AppHash == nil {
				m.AppHash = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBlockResults(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthBlockResults
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipBlockResults(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowBlockResults
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowBlockResults
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowBlockResults
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthBlockResults
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupBlockResults
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthBlockResults
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthBlockResults        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowBlockResults          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupBlockResults = fmt.Errorf("proto: unexpected end of group")
)
