  .include "p24Fxxxx.inc"
  .text

.macro SINGLE_BIT_GROUP name
    .global _Assign\name
  _Assign\name:
    sl      w0, #1, w0
    add     w0, w1, w0
    sl      w0, #1, w0
    bra     w0
.endm

.macro SINGLE_BIT reg, bnum
    bclr    \reg, #\bnum
    return
    bset    \reg, #\bnum
    return
.endm

.macro MULTI_BIT_GROUP name, width
    .global _Assign\name
  _Assign\name:
    mov     #((1 << \width) - 1), w2
    and     w1, w2, w1
    mul.uu  w0, #6, w4
    bra     w4
.endm

.macro MULTI_BIT reg, bnum
    sl      w2, #\bnum, w0
    com     w0, w0
    and     \reg
    sl      w1, #\bnum, w0
    ior     \reg
    return
.endm

; UART RX
SINGLE_BIT_GROUP UxRXIE
SINGLE_BIT IEC0 U1RXIE
SINGLE_BIT IEC1 U2RXIE
SINGLE_BIT IEC5 U3RXIE
SINGLE_BIT IEC5 U4RXIE

SINGLE_BIT_GROUP UxRXIF
SINGLE_BIT IFS0 U1RXIF
SINGLE_BIT IFS1 U2RXIF
SINGLE_BIT IFS5 U3RXIF
SINGLE_BIT IFS5 U4RXIF

MULTI_BIT_GROUP UxRXIP 3
MULTI_BIT IPC2  U1RXIP0
MULTI_BIT IPC7  U2RXIP0
MULTI_BIT IPC20 U3RXIP0
MULTI_BIT IPC22 U4RXIP0

; UART TX
SINGLE_BIT_GROUP UxTXIE
SINGLE_BIT IEC0 U1TXIE
SINGLE_BIT IEC1 U2TXIE
SINGLE_BIT IEC5 U3TXIE
SINGLE_BIT IEC5 U4TXIE

SINGLE_BIT_GROUP UxTXIF
SINGLE_BIT IFS0 U1TXIF
SINGLE_BIT IFS1 U2TXIF
SINGLE_BIT IFS5 U3TXIF
SINGLE_BIT IFS5 U4TXIF

MULTI_BIT_GROUP UxTXIP 3
MULTI_BIT IPC3  U1TXIP0
MULTI_BIT IPC7  U2TXIP0
MULTI_BIT IPC20 U3TXIP0
MULTI_BIT IPC22 U4TXIP0

; Input Capture
SINGLE_BIT_GROUP ICxIE
SINGLE_BIT IEC0 IC1IE
SINGLE_BIT IEC0 IC2IE
SINGLE_BIT IEC2 IC3IE
SINGLE_BIT IEC2 IC4IE
SINGLE_BIT IEC2 IC5IE
SINGLE_BIT IEC2 IC6IE
SINGLE_BIT IEC1 IC7IE
SINGLE_BIT IEC1 IC8IE
SINGLE_BIT IEC5 IC9IE

SINGLE_BIT_GROUP ICxIF
SINGLE_BIT IFS0 IC1IF
SINGLE_BIT IFS0 IC2IF
SINGLE_BIT IFS2 IC3IF
SINGLE_BIT IFS2 IC4IF
SINGLE_BIT IFS2 IC5IF
SINGLE_BIT IFS2 IC6IF
SINGLE_BIT IFS1 IC7IF
SINGLE_BIT IFS1 IC8IF
SINGLE_BIT IFS5 IC9IF

MULTI_BIT_GROUP ICxIP 3
MULTI_BIT IPC0  IC1IP0
MULTI_BIT IPC1  IC2IP0
MULTI_BIT IPC9  IC3IP0
MULTI_BIT IPC9  IC4IP0
MULTI_BIT IPC9  IC5IP0
MULTI_BIT IPC10 IC6IP0
MULTI_BIT IPC5  IC7IP0
MULTI_BIT IPC5  IC8IP0
MULTI_BIT IPC23 IC9IP0

; SPI
SINGLE_BIT_GROUP SPIxIE
SINGLE_BIT IEC0 SPI1IE
SINGLE_BIT IEC2 SPI2IE
SINGLE_BIT IEC5 SPI3IE

SINGLE_BIT_GROUP SPIxIF
SINGLE_BIT IFS0 SPI1IF
SINGLE_BIT IFS2 SPI2IF
SINGLE_BIT IFS5 SPI3IF

MULTI_BIT_GROUP SPIxIP 3
MULTI_BIT IPC2  SPI1IP0
MULTI_BIT IPC8  SPI2IP0
MULTI_BIT IPC22  SPI3IP0

; I2C Master
SINGLE_BIT_GROUP MI2CxIE
SINGLE_BIT IEC1 MI2C1IE
SINGLE_BIT IEC3 MI2C2IE
SINGLE_BIT IEC5 MI2C3IE

SINGLE_BIT_GROUP MI2CxIF
SINGLE_BIT IFS1 MI2C1IF
SINGLE_BIT IFS3 MI2C2IF
SINGLE_BIT IFS5 MI2C3IF

MULTI_BIT_GROUP MI2CxIP 3
MULTI_BIT IPC4  MI2C1IP0
MULTI_BIT IPC12 MI2C2IP0
MULTI_BIT IPC21 MI2C3IP0
