/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.zip;

import java.io.File;
import org.zeroturnaround.zip.Java6FileApiPermissionsStrategy;
import org.zeroturnaround.zip.Java7Nio2ApiPermissionsStrategy;
import org.zeroturnaround.zip.ZTFilePermissions;
import org.zeroturnaround.zip.ZTFilePermissionsStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ZTFilePermissionsUtil {
    private static final int OWNER_READ_FLAG = 256;
    private static final int OWNER_WRITE_FLAG = 128;
    private static final int OWNER_EXECUTE_FLAG = 64;
    private static final int GROUP_READ_FLAG = 32;
    private static final int GROUP_WRITE_FLAG = 16;
    private static final int GROUP_EXECUTE_FLAG = 8;
    private static final int OTHERS_READ_FLAG = 4;
    private static final int OTHERS_WRITE_FLAG = 2;
    private static final int OTHERS_EXECUTE_FLAG = 1;
    private static final ZTFilePermissionsStrategy NOP_STRATEGY = new ZTFilePermissionsStrategy(){

        public void setPermissions(File file, ZTFilePermissions permissions) {
        }

        public ZTFilePermissions getPermissions(File file) {
            return null;
        }
    };
    private static final ZTFilePermissionsStrategy DEFAULT_STRATEGY = ZTFilePermissionsUtil.fetchDefaultStrategy();

    private ZTFilePermissionsUtil() {
    }

    static ZTFilePermissionsStrategy getDefaultStategy() {
        return DEFAULT_STRATEGY;
    }

    static int toPosixFileMode(ZTFilePermissions permissions) {
        int mode = 0;
        mode |= ZTFilePermissionsUtil.addFlag(permissions.isOwnerCanExecute(), 64);
        mode |= ZTFilePermissionsUtil.addFlag(permissions.isGroupCanExecute(), 8);
        mode |= ZTFilePermissionsUtil.addFlag(permissions.isOthersCanExecute(), 1);
        mode |= ZTFilePermissionsUtil.addFlag(permissions.isOwnerCanWrite(), 128);
        mode |= ZTFilePermissionsUtil.addFlag(permissions.isGroupCanWrite(), 16);
        mode |= ZTFilePermissionsUtil.addFlag(permissions.isOthersCanWrite(), 2);
        mode |= ZTFilePermissionsUtil.addFlag(permissions.isOwnerCanRead(), 256);
        mode |= ZTFilePermissionsUtil.addFlag(permissions.isGroupCanRead(), 32);
        return mode |= ZTFilePermissionsUtil.addFlag(permissions.isOthersCanRead(), 4);
    }

    private static int addFlag(boolean condition, int flag) {
        return condition ? flag : 0;
    }

    static ZTFilePermissions fromPosixFileMode(int mode) {
        ZTFilePermissions permissions = new ZTFilePermissions();
        permissions.setOwnerCanExecute((mode & 0x40) > 0);
        permissions.setGroupCanExecute((mode & 8) > 0);
        permissions.setOthersCanExecute((mode & 1) > 0);
        permissions.setOwnerCanWrite((mode & 0x80) > 0);
        permissions.setGroupCanWrite((mode & 0x10) > 0);
        permissions.setOthersCanWrite((mode & 2) > 0);
        permissions.setOwnerCanRead((mode & 0x100) > 0);
        permissions.setGroupCanRead((mode & 0x20) > 0);
        permissions.setOthersCanRead((mode & 4) > 0);
        return permissions;
    }

    private static ZTFilePermissionsStrategy fetchDefaultStrategy() {
        ZTFilePermissionsStrategy strategy = ZTFilePermissionsUtil.tryInstantiateStrategy(Java7Nio2ApiPermissionsStrategy.class);
        if (strategy == null) {
            strategy = ZTFilePermissionsUtil.tryInstantiateStrategy(Java6FileApiPermissionsStrategy.class);
        }
        if (strategy == null) {
            strategy = NOP_STRATEGY;
        }
        return strategy;
    }

    private static ZTFilePermissionsStrategy tryInstantiateStrategy(Class<? extends ZTFilePermissionsStrategy> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }
}

