/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.zip;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.zeroturnaround.zip.ZipException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZTZipReflectionUtil {
    public static final String JAVA8_STREAM_API = "java.util.stream.Stream";

    private ZTZipReflectionUtil() {
    }

    static <T> Class<? extends T> getClassForName(String name, Class<T> clazz) {
        try {
            return Class.forName(name).asSubclass(clazz);
        }
        catch (ClassNotFoundException e) {
            throw new ZipException(e);
        }
        catch (ClassCastException e) {
            throw new ZipException(e);
        }
    }

    static Method getDeclaredMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        try {
            return clazz.getDeclaredMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw new ZipException(e);
        }
    }

    static Object invoke(Method method, Object obj, Object ... args2) throws ZipException {
        try {
            return method.invoke(obj, args2);
        }
        catch (IllegalAccessException e) {
            throw new ZipException(e);
        }
        catch (InvocationTargetException e) {
            throw new ZipException(e);
        }
        catch (IllegalArgumentException e) {
            throw new ZipException(e);
        }
    }

    public static boolean isClassAvailable(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return false;
    }
}

