/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import apple.awt.CImage;
import apple.awt.CPopupMenu;
import apple.awt.CToolkit;
import apple.awt.PeerImpl;
import apple.awt.RuntimeOptions;
import apple.awt.Utilities;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.TrayIcon;
import java.awt.color.ColorSpace;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.peer.TrayIconPeer;
import java.io.Serializable;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;

public class CTrayIconPeer
extends PeerImpl<TrayIcon>
implements TrayIconPeer {
    static final int TRAY_ICON_HEIGHT = 22;
    static final int TRAY_ICON_WIDTH = 22;
    long fModelPtr;
    JFrame existingNotification;
    JFrame popupParent = new JFrame();
    PopupMenu popup;
    static final int AUTOFADE_INTERVAL = 650;
    static final int CLICKFADE_INTERVAL = 150;
    static final int FADE_INTERVAL = 60;
    static final int MAX_TEXT_WIDTH = 280;

    private native long createNativeTrayIcon();

    private native void disposeNativeImpl(long var1);

    private native void setNativeImage(long var1, long var3, boolean var5);

    private native void setNativeToolTip(long var1, String var3);

    private native void showNativeMenu(long var1, long var3);

    private native void requestAttention(long var1, boolean var3);

    private native Rectangle getNativeRect(long var1);

    public static CTrayIconPeer create(TrayIcon trayIcon) {
        CTrayIconPeer cTrayIconPeer = new CTrayIconPeer(trayIcon);
        cTrayIconPeer.initPeer();
        return cTrayIconPeer;
    }

    CTrayIconPeer(TrayIcon trayIcon) {
        this.fTarget = trayIcon;
    }

    void initPeer() {
        this.popupParent.addNotify();
        this.fModelPtr = this.createNativeTrayIcon();
        this.updateImage();
    }

    @Override
    protected void disposeImpl() {
        if (this.popupParent != null) {
            this.popupParent.dispose();
        }
        long l = this.fModelPtr;
        this.fModelPtr = 0L;
        this.disposeNativeImpl(l);
        CToolkit.targetDisposedPeer(this.fTarget, this);
    }

    @Override
    public void updateImage() {
        BufferedImage bufferedImage;
        Image image = ((TrayIcon)this.fTarget).getImage();
        if (image == null) {
            return;
        }
        Canvas canvas = new Canvas();
        MediaTracker mediaTracker = new MediaTracker(canvas);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        if (n <= 0 || n2 <= 0) {
            return;
        }
        if (!RuntimeOptions.getCurrentOptions().getColorSystemTrayIconsEnabled()) {
            bufferedImage = new BufferedImage(n, n2, 3);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            graphics2D.drawImage(image, 0, 0, null);
            graphics2D.dispose();
            ColorConvertOp colorConvertOp = new ColorConvertOp(ColorSpace.getInstance(1003), null);
            colorConvertOp.filter(bufferedImage, bufferedImage);
            image = bufferedImage;
        }
        bufferedImage = CImage.getCreator().createImage(image);
        this.setNativeImage(this.fModelPtr, ((CImage)bufferedImage).getNSImage(), ((TrayIcon)this.fTarget).isImageAutoSize());
        ((CImage)bufferedImage).dispose();
    }

    @Override
    public void setToolTip(String string) {
        this.setNativeToolTip(this.fModelPtr, string);
    }

    @Override
    public synchronized void showPopupMenu(int n, int n2) {
        if (this.isDisposed()) {
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                PopupMenu popupMenu = ((TrayIcon)CTrayIconPeer.this.fTarget).getPopupMenu();
                if (CTrayIconPeer.this.popup != popupMenu) {
                    if (CTrayIconPeer.this.popup != null) {
                        CTrayIconPeer.this.popupParent.remove(CTrayIconPeer.this.popup);
                    }
                    if (popupMenu != null) {
                        CTrayIconPeer.this.popupParent.add(popupMenu);
                    }
                    CTrayIconPeer.this.popup = popupMenu;
                }
                if (CTrayIconPeer.this.popup == null) {
                    return;
                }
                CTrayIconPeer.this.popup.addNotify();
                long l = ((CPopupMenu)CTrayIconPeer.this.popup.getPeer()).getNativeMenu();
                CTrayIconPeer.this.showNativeMenu(CTrayIconPeer.this.fModelPtr, l);
            }
        });
    }

    @Override
    public void displayMessage(final String string, final String string2, final String string3) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CTrayIconPeer.this.showSwingMessageWindow(string, string2, string3);
            }
        });
    }

    void showSwingMessageWindow(String string, String string2, String string3) {
        JComponent jComponent;
        Serializable serializable;
        final JFrame jFrame = new JFrame();
        Container container = jFrame.getContentPane();
        container.add(CTrayIconPeer.getIconForMessageType(string3), "West");
        JPanel jPanel = new JPanel(new BorderLayout());
        if (string != null) {
            serializable = container.getFont();
            jComponent = CTrayIconPeer.createTextView(((Font)serializable).deriveFont(1), string);
            jComponent.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 12));
            jPanel.add((Component)jComponent, "North");
        }
        if (string2 != null) {
            serializable = container.getFont();
            jComponent = CTrayIconPeer.createTextView(((Font)serializable).deriveFont(((Font)serializable).getSize2D() - 2.0f), string2);
            jComponent.setBorder(BorderFactory.createEmptyBorder(6, 0, 0, 12));
            jPanel.add((Component)jComponent, "Center");
        }
        container.add((Component)jPanel, "Center");
        serializable = new JButton(new AbstractAction(UIManager.getString("OptionPane.okButtonText")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CTrayIconPeer.this.handleEvent();
                CTrayIconPeer.fadeOut(jFrame, 150);
            }
        });
        ((JComponent)serializable).putClientProperty("JComponent.sizeVariant", "small");
        jFrame.getRootPane().setDefaultButton((JButton)serializable);
        jComponent = new JPanel(new BorderLayout());
        jComponent.add((Component)serializable, "East");
        jComponent.setBorder(BorderFactory.createEmptyBorder(8, 12, 8, 12));
        container.add((Component)jComponent, "South");
        jFrame.setDefaultCloseOperation(2);
        jFrame.getRootPane().putClientProperty("Window.style", "small");
        jFrame.setAlwaysOnTop(true);
        jFrame.setResizable(false);
        jFrame.pack();
        jFrame.setLocation(this.getNativeRect(this.fModelPtr).getLocation());
        if (this.existingNotification != null) {
            CTrayIconPeer.fadeOut(this.existingNotification, 650);
        }
        this.existingNotification = jFrame;
        jFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                if (CTrayIconPeer.this.existingNotification == jFrame) {
                    CTrayIconPeer.this.existingNotification = null;
                }
            }
        });
        this.requestAttention(this.fModelPtr, "ERROR".equals(string3));
        jFrame.setVisible(true);
    }

    void handleEvent() {
        CToolkit.postEvent(new ActionEvent(this.fTarget, 1001, ((TrayIcon)this.fTarget).getActionCommand()));
    }

    static Component getIconForMessageType(String string) {
        Icon icon;
        String string2 = "OptionPane.informationIcon";
        if ("WARNING".equals(string)) {
            string2 = "OptionPane.warningIcon";
        }
        if ("ERROR".equals(string)) {
            string2 = "OptionPane.errorIcon";
        }
        JLabel jLabel = new JLabel((icon = UIManager.getIcon(string2)) == null ? null : new Utilities.ScaleIcon(icon, 0.66667f));
        jLabel.setBorder(BorderFactory.createEmptyBorder(16, 16, 16, 8));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jLabel, "North");
        return jPanel;
    }

    static JComponent createTextView(Font font, String string) {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setFocusable(false);
        jTextArea.setBackground(UIManager.getColor("Panel.background"));
        if (font != null) {
            jTextArea.setFont(font);
        }
        jTextArea.setText(string);
        TextLayout textLayout = new TextLayout(string, jTextArea.getFont(), new FontRenderContext(new AffineTransform(), true, false));
        float f = textLayout.getAdvance();
        if (f > 280.0f) {
            jTextArea.setSize(280, 280);
        }
        return jTextArea;
    }

    static void fadeOut(final JFrame jFrame, final int n) {
        final JRootPane jRootPane = jFrame.getRootPane();
        final long l = System.currentTimeMillis() + (long)n;
        final Timer timer = new Timer(60, null);
        timer.addActionListener(new AbstractAction("fade status window"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                long l2 = l - System.currentTimeMillis();
                if (l2 > 0L) {
                    jRootPane.putClientProperty("Window.alpha", new Float((float)l2 / (float)n));
                    return;
                }
                timer.stop();
                jFrame.setVisible(false);
                jFrame.dispose();
            }
        });
        timer.start();
    }
}

