/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import apple.awt.CGraphicsConfig;
import apple.awt.CGraphicsDevice;
import apple.awt.CImage;
import apple.awt.CToolkit;
import apple.awt.ClientPropertyApplicator;
import apple.awt.ComponentModel;
import apple.awt.ContainerModel;
import apple.awt.RuntimeOptions;
import apple.awt.Utilities;
import com.sun.awt.AWTUtilities;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.peer.ComponentPeer;
import java.awt.peer.DialogPeer;
import java.awt.peer.WindowPeer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.PrivilegedAction;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import sun.awt.AWTAccessor;
import sun.java2d.pipe.Region;

public class CWindow
extends ContainerModel
implements WindowPeer,
DialogPeer {
    public static final String BRUSH_METAL_LOOK = "apple.awt.brushMetalLook";
    public static final String DRAGGABLE_WINDOW_BACKGROUND = "apple.awt.draggableWindowBackground";
    public static final String WINDOW_ALPHA = "Window.alpha";
    public static final String WINDOW_SHADOW = "Window.shadow";
    public static final String WINDOW_STYLE = "Window.style";
    public static final String WINDOW_SHADOW_REVALIDATE_NOW = "apple.awt.windowShadow.revalidateNow";
    public static final String DOCUMENT_MODIFIED = "Window.documentModified";
    public static final String DOCUMENT_FILE = "Window.documentFile";
    public static final String WINDOW_CLOSEABLE = "Window.closeable";
    public static final String WINDOW_MINIMIZABLE = "Window.minimizable";
    public static final String WINDOW_ZOOMABLE = "Window.zoomable";
    public static final String WINDOW_FULLSCREENABLE = "apple.awt.fullscreenable";
    public static final String WINDOW_HIDES_ON_DEACTIVATE = "Window.hidesOnDeactivate";
    public static final String WINDOW_MINIMUM_SIZE = "Window.minimumSize";
    public static final String DOCUMENT_MODAL_SHEET = "apple.awt.documentModalSheet";
    public static final String DELAY_WINDOW_ORDERING = "apple.awt.delayWindowOrdering";
    public static final String WINDOW_FADE_DELEGATE = "apple.awt._windowFadeDelegate";
    public static final String WINDOW_FADE_IN = "apple.awt._windowFadeIn";
    public static final String WINDOW_FADE_OUT = "apple.awt._windowFadeOut";
    public static final String WINDOW_WILL_MOVE_CALLBACK = "apple.awt._windowWillMoveHandler";
    public static final String WINDOW_DID_INSTANTIATE_CALLBACK = "apple.awt._windowDidInstantiateHandler";
    public static final String WINDOW_DRAWING_DID_FINISH_HOOK = "apple.awt._drawingDidFinishHook";
    public static final String WINDOW_SYNC_WINDOW_CONTENTS_WITH_LAYER = "apple.awt._syncWindowContentsWithLayer";
    public static final String WINDOW_FAKE_ACTIVE = "apple.awt._windowFakeActive";
    public static final String WINDOW_SUPPRESS_ACTIVATION = "apple.awt._windowSuppressActivation";
    public static final String WINDOW_EVENT_TRANSPARENT = "apple.awt._windowEventTransparent";
    private static final int kMinWindowWidth = 1;
    private static final int kMinWindowHeight = 1;
    private static final Dimension kMinSize = new Dimension(1, 1);
    static final int kCanFlushIndex = 0;
    static final int kIsDirtyIndex = 1;
    static final int kLastIndex = 2;
    public ComponentModel fClient;
    private Dimension userMinimumSize = new Dimension();
    ByteBuffer fByteParameters;
    IntBuffer fIntParameters;
    private boolean fIsPopup = false;
    private boolean fSuppressActivation = false;
    private boolean fNeedsLayerSynchronization;
    private static boolean fNeedToCheckForLayerSynchronization;
    private JRootPane fRootPane;
    static final int MODELESS = 0;
    static final int DOCUMENT_MODAL = 1;
    static final int APPLICATION_MODAL = 2;
    static final int TOOLKIT_MODAL = 3;
    static final int _RESERVED_FOR_DATA = 1;
    static final int DECORATED = 2;
    static final int RESIZABLE = 4;
    static final int HAS_SHADOW = 8;
    static final int CLOSEABLE = 16;
    static final int MINIMIZABLE = 32;
    static final int ZOOMABLE = 64;
    static final int ALWAYS_ON_TOP = 128;
    static final int MODAL_EXCLUDED = 256;
    static final int POPUP = 512;
    static final int TEXTURED = 1024;
    static final int UNIFIED = 2048;
    static final int UTILITY = 4096;
    static final int HUD = 8192;
    static final int SHEET = 16384;
    static final int DRAGGABLE_BACKGROUND = 32768;
    static final int DRAGGABLE_BACKGROUND_SET = 65536;
    static final int FAKE_ACTIVE = 131072;
    static final int FAKE_ACTIVE_SET = 262144;
    static final int SUPPRESS_ACTIVATION = 524288;
    static final int EVENT_TRANSPARENT_PLUGIN2_WINDOW = 0x100000;
    static final int HIDES_ON_DEACTIVATE = 0x200000;
    static final int SYNC_WINDOW_CONTENTS_WITH_LAYER = 0x400000;
    static final int FULLSCREENABLE = 0x800000;
    static ClientPropertyApplicator<JRootPane, CWindow> CLIENT_PROPERTY_APPLICATOR;
    Runnable windowDidInstantiateCallback;
    Runnable windowWillMoveCallback;
    boolean iconifiedImageSet = false;
    Object fFlushingLock = new Object();
    static final long kMinFlushingPeriod;
    long lastTimeFlush = 0L;
    boolean isFlushingAllowed = true;
    int fFlushCountDepth = 0;
    Runnable drawingDidFinishHook = null;
    private long fCGWindowRef = 0L;
    static boolean warnedRepositionFailure;

    static int SET(int n, int n2, boolean bl) {
        if (bl) {
            return n | n2;
        }
        return n & ~n2;
    }

    int jniModalType() {
        return 0;
    }

    public static CWindow create(Window window) {
        CWindow cWindow = new CWindow((Component)window);
        cWindow.initPeer();
        return cWindow;
    }

    CWindow(Component component) {
        super(component);
        ((CGraphicsDevice)this.fGraphicsConfiguration.getDevice()).addDisplayChangedListener(this);
        this.fClient = this;
    }

    protected native Insets _getInsets(long var1);

    @Override
    protected void initPeer() {
        super.initPeer();
        this.fInsets = this._getInsets(this.fModelPtr);
        if (((Window)this.fTarget).getWarningString() != null) {
            this.repositionSecurityWarning();
        }
        this.updateIconImages();
    }

    @Override
    protected void disposeImpl() {
        CGraphicsDevice cGraphicsDevice = (CGraphicsDevice)this.getGraphicsConfiguration().getDevice();
        cGraphicsDevice.removeDisplayChangedListener(this);
        if (this.fRootPane != null) {
            CLIENT_PROPERTY_APPLICATOR.removeFrom(this.fRootPane);
            this.fRootPane = null;
        }
        this.destroyBuffers();
        super.disposeImpl();
    }

    @Override
    public boolean handlesWheelScrolling() {
        return false;
    }

    @Override
    protected long initPeer(long l) {
        Serializable serializable;
        boolean bl;
        Window window;
        int n = 126;
        if (((Component)this.fTarget).getName() == "###overrideRedirect###") {
            n = CWindow.SET(n, 512, true);
            this.fIsPopup = true;
        }
        long l2 = (window = ((Window)this.fTarget).getOwner()) != null ? ((CWindow)window.getPeer()).fModelPtr : 0L;
        this.initContainer();
        Rectangle rectangle = ((Component)this.fTarget).getBounds();
        CGraphicsDevice cGraphicsDevice = (CGraphicsDevice)this.getGraphicsConfiguration().getDevice();
        boolean bl2 = this.fTarget instanceof Frame;
        boolean bl3 = this.fTarget instanceof Dialog;
        if (bl3) {
            n = CWindow.SET(n, 32, false);
        }
        boolean bl4 = bl2 ? ((Frame)this.fTarget).isUndecorated() : (bl = bl3 ? ((Dialog)this.fTarget).isUndecorated() : true);
        if (bl) {
            n = CWindow.SET(n, 2, false);
        }
        boolean bl5 = bl2 ? ((Frame)this.fTarget).isResizable() : (bl = bl3 ? ((Dialog)this.fTarget).isResizable() : false);
        if (!bl) {
            n = CWindow.SET(n, 4, false);
            n = CWindow.SET(n, 64, false);
        }
        if (((Window)this.fTarget).isAlwaysOnTop()) {
            n = CWindow.SET(n, 128, true);
        }
        if (((Window)this.fTarget).getModalExclusionType() == Dialog.ModalExclusionType.APPLICATION_EXCLUDE) {
            n = CWindow.SET(n, 256, true);
        }
        if (RuntimeOptions.getCurrentOptions().UseBrushMetalLook && !bl3 && (n & 0x200) == 0) {
            n = CWindow.SET(n, 1024, true);
        }
        String string = ((Window)this.fTarget).getWarningString();
        boolean bl6 = false;
        float f = 1.0f;
        if (this.fTarget instanceof RootPaneContainer) {
            CWindow cWindow;
            serializable = ((RootPaneContainer)this.fTarget).getRootPane();
            Object object = null;
            object = ((JComponent)serializable).getClientProperty(BRUSH_METAL_LOOK);
            if (object != null) {
                n = CWindow.SET(n, 1024, Boolean.parseBoolean(object.toString()));
            }
            if (bl3 && ((Dialog)this.fTarget).getModalityType() == Dialog.ModalityType.DOCUMENT_MODAL && (object = ((JComponent)serializable).getClientProperty(DOCUMENT_MODAL_SHEET)) != null) {
                n = CWindow.SET(n, 16384, Boolean.parseBoolean(object.toString()));
            }
            if ((object = ((JComponent)serializable).getClientProperty(DELAY_WINDOW_ORDERING)) != null) {
                bl6 = Boolean.parseBoolean(object.toString());
            }
            if ((object = ((JComponent)serializable).getClientProperty(WINDOW_STYLE)) != null) {
                if ("small".equals(object)) {
                    n = CWindow.SET(n, 4096, true);
                    if (((Window)this.fTarget).isAlwaysOnTop() && ((JComponent)serializable).getClientProperty(WINDOW_HIDES_ON_DEACTIVATE) == null) {
                        n = CWindow.SET(n, 0x200000, true);
                    }
                }
                if ("textured".equals(object)) {
                    n = CWindow.SET(n, 1024, true);
                }
                if ("unified".equals(object)) {
                    n = CWindow.SET(n, 2048, true);
                }
                if ("hud".equals(object)) {
                    n = CWindow.SET(n, 8192, true);
                }
            }
            if ((object = ((JComponent)serializable).getClientProperty(WINDOW_HIDES_ON_DEACTIVATE)) != null) {
                n = CWindow.SET(n, 0x200000, Boolean.parseBoolean(object.toString()));
            }
            if ((object = ((JComponent)serializable).getClientProperty(WINDOW_CLOSEABLE)) != null) {
                n = CWindow.SET(n, 16, Boolean.parseBoolean(object.toString()));
            }
            if ((object = ((JComponent)serializable).getClientProperty(WINDOW_MINIMIZABLE)) != null) {
                n = CWindow.SET(n, 32, Boolean.parseBoolean(object.toString()));
            }
            if ((object = ((JComponent)serializable).getClientProperty(WINDOW_ZOOMABLE)) != null) {
                n = CWindow.SET(n, 64, Boolean.parseBoolean(object.toString()));
            }
            if ((object = ((JComponent)serializable).getClientProperty(WINDOW_FULLSCREENABLE)) != null) {
                n = CWindow.SET(n, 0x800000, Boolean.parseBoolean(object.toString()));
            }
            if ((object = ((JComponent)serializable).getClientProperty(WINDOW_SHADOW)) != null) {
                n = CWindow.SET(n, 8, Boolean.parseBoolean(object.toString()));
            }
            if ((object = ((JComponent)serializable).getClientProperty(WINDOW_MINIMUM_SIZE)) instanceof Dimension) {
                this.userMinimumSize = (Dimension)object;
            }
            if ((object = ((JComponent)serializable).getClientProperty(WINDOW_SUPPRESS_ACTIVATION)) != null) {
                this.fSuppressActivation = Boolean.parseBoolean(object.toString());
                n = CWindow.SET(n, 524288, this.fSuppressActivation);
            }
            if (this.fIsPopup && (cWindow = (CWindow)window.getPeer()) != null && cWindow.fSuppressActivation) {
                this.fSuppressActivation = cWindow.fSuppressActivation;
                n = CWindow.SET(n, 524288, this.fSuppressActivation);
            }
            if ((object = ((JComponent)serializable).getClientProperty(WINDOW_EVENT_TRANSPARENT)) != null) {
                n = CWindow.SET(n, 0x100000, Boolean.parseBoolean(object.toString()));
            }
            if ((object = ((JComponent)serializable).getClientProperty(DRAGGABLE_WINDOW_BACKGROUND)) != null) {
                n = CWindow.SET(n, 32768, Boolean.parseBoolean(object.toString()));
                n = CWindow.SET(n, 65536, true);
            }
            if ((object = ((JComponent)serializable).getClientProperty(WINDOW_SYNC_WINDOW_CONTENTS_WITH_LAYER)) != null) {
                n = CWindow.SET(n, 0x400000, Boolean.parseBoolean(object.toString()));
                fNeedToCheckForLayerSynchronization = true;
                this.fNeedsLayerSynchronization = true;
            }
        }
        serializable = this._calculateMinimumSize();
        long l3 = this.createNativeWindow(l2, rectangle.x, rectangle.y, rectangle.width, rectangle.height, ((Component)this.fTarget).isEnabled(), ((Component)this.fTarget).isVisible(), ((Component)this.fTarget).getFont(), ((Component)this.fTarget).getBackground(), ((Component)this.fTarget).isBackgroundSet(), ((Component)this.fTarget).getForeground(), ((Component)this.fTarget).isForegroundSet(), n, this.getTitle(), bl2 ? ((Frame)this.fTarget).getExtendedState() : 0, cGraphicsDevice.getScreen(), ((Window)this.fTarget).isFocusableWindow(), this.jniModalType(), string, ((Dimension)serializable).width, ((Dimension)serializable).height, this.fByteParameters, bl6, f);
        if (string != null) {
            this.initWarningSize((n & 2) == 0);
        }
        if (this.fTarget instanceof RootPaneContainer) {
            JRootPane jRootPane;
            this.fRootPane = jRootPane = ((RootPaneContainer)this.fTarget).getRootPane();
            if (this.fRootPane != null) {
                this.fRootPane.addPropertyChangeListener("ancestor", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        CLIENT_PROPERTY_APPLICATOR.attachAndApplyClientProperties(jRootPane);
                        jRootPane.removePropertyChangeListener("ancestor", this);
                    }
                });
            }
        }
        return l3;
    }

    protected native long createNativeWindow(long var1, int var3, int var4, int var5, int var6, boolean var7, boolean var8, Font var9, Color var10, boolean var11, Color var12, boolean var13, int var14, String var15, int var16, int var17, boolean var18, int var19, String var20, int var21, int var22, ByteBuffer var23, boolean var24, float var25);

    protected native void _setStyleFlag(long var1, int var3);

    protected void setStyleFlag(int n, boolean bl) {
        int n2 = CWindow.SET(n, 1, bl);
        this._setStyleFlag(this.fModelPtr, n2);
    }

    protected native void _updateWindowButtonState(long var1, int var3);

    void nativeWindowDidInstantiate() {
        if (this.windowDidInstantiateCallback == null) {
            return;
        }
        this.windowDidInstantiateCallback.run();
    }

    void nativeWindowWillMove() {
        if (this.windowWillMoveCallback == null) {
            return;
        }
        EventQueue.invokeLater(this.windowWillMoveCallback);
    }

    private native void _revalidateShadow(long var1);

    private native void _setRepresentedFilename(long var1, String var3);

    private native void _setAlpha(long var1, float var3);

    private native void _setHasShadow(long var1, boolean var3);

    private native void _toggleFullScreenMode(long var1);

    private native void _setDocumentEdited(long var1, boolean var3);

    private native void _setFakeActive(long var1, int var3);

    private native void _setSecurityWarningPositioning(long var1, double var3, double var5, float var7, float var8);

    private native void _setDrawingHookNotifyBit(long var1, boolean var3);

    void setHasShadow(boolean bl) {
        this._setHasShadow(this.getModelPtr(), bl);
    }

    public void toggleFullScreen() {
        this._toggleFullScreenMode(this.getModelPtr());
    }

    private static native void postSynthesizedNativeEvent(long var0, byte[] var2);

    public void postSynthesizedEvent(byte[] byArray) {
        CWindow.postSynthesizedNativeEvent(this.fModelPtr, byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleEvent(AWTEvent aWTEvent) {
        if (this.fIsPopup && aWTEvent.getID() == 102) {
            ((Component)this.fTarget).repaint();
            try {
                this.getCWindowContainer().disableFlushing();
                this.paintArea.add(this.getBounds(), 801);
                this.paintArea.paint(this.fTarget, this.shouldClearRectBeforePaint());
            }
            finally {
                this.finishLazyDrawing();
                this.getCWindowContainer().enableFlushing();
            }
        } else {
            super.handleEvent(aWTEvent);
        }
    }

    protected Color getBackgroundColor() {
        return SystemColor.window;
    }

    protected String getTitle() {
        return null;
    }

    @Override
    void initContainer() {
        super.initContainer();
        if (!((Component)this.fTarget).isForegroundSet()) {
            ((Component)this.fTarget).setForeground(Color.black);
        }
        if (!((Component)this.fTarget).isBackgroundSet()) {
            ((Component)this.fTarget).setBackground(this.getBackgroundColor());
        }
        if (((Component)this.fTarget).getFont() == null) {
            ((Component)this.fTarget).setFont(sDefaultFont);
        }
        this.fByteParameters = ByteBuffer.allocateDirect(8);
        this.fByteParameters.order(ByteOrder.nativeOrder());
        this.fIntParameters = this.fByteParameters.asIntBuffer();
    }

    @Override
    public void toFront() {
        this.toFront(this.fModelPtr, ((Window)this.fTarget).isFocusableWindow());
    }

    private native void toFront(long var1, boolean var3);

    @Override
    public void toBack() {
        this.toBack(this.fModelPtr);
    }

    private native void toBack(long var1);

    public void setAlwaysOnTop(boolean bl) {
        if (bl && ((Window)this.fTarget).isVisible() || !bl) {
            this.setAlwaysOnTop(this.fModelPtr, bl);
        }
    }

    native void setAlwaysOnTop(long var1, boolean var3);

    public boolean requestWindowFocus() {
        return false;
    }

    @Override
    public void updateFocusableWindowState() {
        this._updateFocusableWindowState(this.fModelPtr, ((Window)this.fTarget).isFocusableWindow());
    }

    native void _updateFocusableWindowState(long var1, boolean var3);

    @Override
    public void blockWindows(List<Window> list) {
        for (Window window : list) {
            ComponentPeer componentPeer = window.getPeer();
            if (!(componentPeer instanceof CWindow)) {
                return;
            }
            ((CWindow)componentPeer).setModalBlocked(null, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setModalBlocked(Dialog dialog, boolean bl) {
        Object object = ((Component)this.getTarget()).getTreeLock();
        synchronized (object) {
            this._setModalBlocked(this.fModelPtr, bl);
        }
    }

    native void _setModalBlocked(long var1, boolean var3);

    private Window getModalBlocker(Window window) {
        try {
            if (window == null) {
                return null;
            }
            Window window2 = null;
            Field field = this.getWindowField("modalBlocker");
            while (window instanceof Window) {
                window2 = window;
                window = (Window)field.get(window);
            }
            return window2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private long getPeerModelPtrForModalBlocker() {
        Window window = this.getModalBlocker((Window)this.fTarget);
        if (window == null) {
            return 0L;
        }
        ComponentPeer componentPeer = window.getPeer();
        if (!(componentPeer instanceof CWindow)) {
            return 0L;
        }
        CWindow cWindow = (CWindow)componentPeer;
        return cWindow.fModelPtr;
    }

    private void updateUserMinimumSize(Dimension dimension) {
        this.userMinimumSize = dimension;
        this.updateMinimumSize();
        Component component = (Component)this.getTarget();
        Dimension dimension2 = component.getSize();
        if (dimension2.width < this.userMinimumSize.width) {
            dimension2.width = this.userMinimumSize.width;
        }
        if (dimension2.height < this.userMinimumSize.height) {
            dimension2.height = this.userMinimumSize.height;
        }
        component.setSize(dimension2);
    }

    @Override
    public void updateMinimumSize() {
        Dimension dimension = this._calculateMinimumSize();
        this._updateMinimumSize(this.fModelPtr, dimension.width, dimension.height);
    }

    Dimension _calculateMinimumSize() {
        Dimension dimension;
        if (((Component)this.fTarget).isMinimumSizeSet() && (dimension = ((Component)this.fTarget).getMinimumSize()) != null) {
            return dimension;
        }
        return new Dimension(this.userMinimumSize);
    }

    native void _updateMinimumSize(long var1, int var3, int var4);

    @Override
    public void updateIconImages() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Window window = (Window)CWindow.this.getTarget();
                List<Image> list = window.getIconImages();
                if (list.size() == 0) {
                    if (!CWindow.this.iconifiedImageSet) {
                        return;
                    }
                    CWindow.this.setIconImage(CWindow.this.fModelPtr, 0L);
                    CWindow.this.iconifiedImageSet = false;
                    return;
                }
                Image image = null;
                int n = 0;
                for (Image image2 : list) {
                    int n2;
                    int n3 = image2.getWidth(window);
                    int n4 = n3 * (n2 = image2.getHeight(window));
                    if (n4 <= n) continue;
                    image = image2;
                    n = n4;
                }
                CWindow.this.setIconImage(image);
                CWindow.this.iconifiedImageSet = true;
            }
        });
    }

    private native void setIconImage(long var1, long var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setIconImage(Image image) {
        if (image == null) {
            return;
        }
        CImage cImage = CImage.getCreator().createImage(image);
        if (cImage == null) {
            return;
        }
        CImage cImage2 = cImage;
        synchronized (cImage2) {
            long l = cImage.getNSImage();
            if (l != 0L) {
                this.setIconImage(this.fModelPtr, l);
            }
        }
    }

    public void grab() {
        this._grab(this.fModelPtr);
    }

    public void ungrab() {
        this._ungrab(this.fModelPtr);
    }

    private native void _grab(long var1);

    private native void _ungrab(long var1);

    @Override
    public void setTitle(String string) {
        this._setTitle(this.fModelPtr, string);
    }

    private native void _setTitle(long var1, String var3);

    @Override
    public void setResizable(boolean bl) {
        this._setResizable(this.fModelPtr, bl);
    }

    private native void _setResizable(long var1, boolean var3);

    public void setState(int n) {
        this._setState(this.fModelPtr, n);
    }

    private native void _setState(long var1, int var3);

    public int getState() {
        return this._getState(this.fModelPtr);
    }

    private native int _getState(long var1);

    public void setMaximizedBounds(Rectangle rectangle) {
        if (rectangle == null) {
            this._resetMaxBounds(this.fModelPtr);
        } else {
            this._setMaximizeBounds(this.fModelPtr, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    private native void _resetMaxBounds(long var1);

    private native void _setMaximizeBounds(long var1, int var3, int var4, int var5, int var6);

    public void setBoundsPrivate(int n, int n2, int n3, int n4) {
        this.setBounds(n, n2, n3, n4, 3);
    }

    native void _setVisible(long var1, boolean var3, boolean var4, int var5, boolean var6, int var7, int var8);

    void doSetVisible(Window window, boolean bl) {
        Dimension dimension = this._calculateMinimumSize();
        boolean bl2 = window.getModalExclusionType() == Dialog.ModalExclusionType.APPLICATION_EXCLUDE;
        this._setVisible(this.fModelPtr, bl, window.isFocusableWindow(), this.jniModalType(), bl2, dimension.width, dimension.height);
    }

    @Override
    public void setVisible(boolean bl) {
        final Window window = (Window)this.fTarget;
        final Utilities.WindowFade windowFade = Utilities.WindowFade.getFadeForWindow(window, bl);
        if (windowFade == null) {
            this.doSetVisible(window, bl);
            return;
        }
        final float f = this.getDefaultOpacity();
        if (bl) {
            AWTUtilities.setWindowOpacity((Window)window, (float)0.0f);
            this.doSetVisible(window, bl);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    windowFade.perform(window, f);
                    AWTUtilities.setWindowOpacity((Window)window, (float)f);
                }
            });
        } else {
            windowFade.perform(window, f);
            this.doSetVisible(window, bl);
            AWTUtilities.setWindowOpacity((Window)window, (float)f);
        }
    }

    float getDefaultOpacity() {
        return AWTUtilities.getWindowOpacity((Window)((Window)this.fTarget));
    }

    void dynamicallyLayoutContainer() {
        final Container container = (Container)this.fTarget;
        try {
            CToolkit.invokeLater(new Runnable(){

                @Override
                public void run() {
                    container.invalidate();
                    container.validate();
                }
            }, container);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private native Point _getLocationOnScreen(long var1);

    @Override
    public Point getLocationOnScreen() {
        if (this.fModelPtr == 0L) {
            return null;
        }
        return this._getLocationOnScreen(this.fModelPtr);
    }

    public void requestFocus() {
        CToolkit.notImplemented();
    }

    public boolean isFocusTraversable() {
        CToolkit.notImplemented();
        return false;
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    public Dimension getMinimumSize() {
        return kMinSize;
    }

    @Override
    public CWindow getCWindowContainer() {
        return this;
    }

    private native void resetGraphicsConfiguration(long var1, Component var3);

    @Override
    public void displayChanged() {
        int n = this.getScreenIndex(this.fModelPtr);
        if (n < 0) {
            return;
        }
        CGraphicsDevice cGraphicsDevice = (CGraphicsDevice)this.getGraphicsConfiguration().getDevice();
        CGraphicsDevice cGraphicsDevice2 = (CGraphicsDevice)GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()[n];
        this.fGraphicsConfiguration = (CGraphicsConfig)cGraphicsDevice2.getDefaultConfiguration();
        this.resetGraphicsConfiguration(this.fModelPtr, (Component)this.fTarget);
        if (cGraphicsDevice != cGraphicsDevice2) {
            cGraphicsDevice.removeDisplayChangedListener(this);
            cGraphicsDevice2.addDisplayChangedListener(this);
        }
        super.displayChanged();
    }

    private native int getScreenIndex(long var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFlushingAllowed() {
        Object object = this.fFlushingLock;
        synchronized (object) {
            if (this.isFlushingAllowed) {
                this.fClient.finishLazyDrawing();
            }
            return this.isFlushingAllowed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableFlushing() {
        Object object = this.fFlushingLock;
        synchronized (object) {
            if (this.fFlushCountDepth == 0) {
                this.fIntParameters.put(0, 0);
                this.isFlushingAllowed = false;
            }
            --this.fFlushCountDepth;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableFlushing() {
        Object object = this.fFlushingLock;
        synchronized (object) {
            ++this.fFlushCountDepth;
            if (this.fFlushCountDepth != 0) {
                return;
            }
            long l = System.currentTimeMillis();
            if (l - this.lastTimeFlush >= kMinFlushingPeriod) {
                this.lastTimeFlush = l;
                this.fClient.finishLazyDrawing();
                this.fIntParameters.put(0, 1);
                this.isFlushingAllowed = true;
                this.fGraphicsConfiguration.flush(this, this.fModelPtr);
            } else {
                this.fIntParameters.put(0, 1);
                this.isFlushingAllowed = true;
            }
        }
        this.runDrawingHook();
    }

    void runDrawingHook() {
        if (this.drawingDidFinishHook == null) {
            return;
        }
        this.drawingDidFinishHook.run();
    }

    public void markDirty(boolean bl) {
        this.fIntParameters.put(1, bl ? 1 : 0);
    }

    private static native void _syncLayerContents(long var0, int var2, int var3, int var4, int var5);

    public static void syncLayerContents(Component component, Rectangle rectangle) {
        if (!fNeedToCheckForLayerSynchronization) {
            return;
        }
        if (component == null) {
            return;
        }
        Window window = SwingUtilities.getWindowAncestor(component);
        if (window == null) {
            return;
        }
        CWindow cWindow = (CWindow)window.getPeer();
        if (!cWindow.fNeedsLayerSynchronization) {
            return;
        }
        Rectangle rectangle2 = SwingUtilities.convertRectangle(component, rectangle, window);
        CWindow._syncLayerContents(cWindow.getData(), rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
    }

    @Override
    public long getData() {
        return this.getModelPtr();
    }

    long getWindowID() {
        if (this.fCGWindowRef == 0L && this.fModelPtr != 0L) {
            this.fCGWindowRef = this._getCGWindowRef(this.fModelPtr);
            if (this.fCGWindowRef == -1L) {
                this.fCGWindowRef = 0L;
            }
        }
        return this.fCGWindowRef;
    }

    native long _getCGWindowRef(long var1);

    @Override
    long getModelPtr() {
        return this.fModelPtr;
    }

    @Override
    public void print(Graphics graphics) {
        Shape shape = AWTAccessor.getWindowAccessor().getShape((Window)this.getTarget());
        if (shape != null) {
            graphics.setClip(shape);
        }
        super.print(graphics);
    }

    @Override
    public void setOpacity(float f) {
        if (f < 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("The value of opacity should be in the range [0.0f .. 1.0f].");
        }
        this._setAlpha(this.fModelPtr, f);
    }

    @Override
    public void setOpaque(boolean bl) {
    }

    @Override
    public void applyShape(Region region) {
    }

    @Override
    public void updateWindow() {
    }

    @Override
    public void repositionSecurityWarning() {
        try {
            double d = this.getWindowField("securityWarningPointX").getDouble(this.fTarget);
            double d2 = this.getWindowField("securityWarningPointY").getDouble(this.fTarget);
            float f = this.getWindowField("securityWarningAlignmentX").getFloat(this.fTarget);
            float f2 = this.getWindowField("securityWarningAlignmentY").getFloat(this.fTarget);
            this._setSecurityWarningPositioning(this.fModelPtr, d, d2, f, f2);
        }
        catch (Exception exception) {
            this.reportOnce(exception, "CWindow.repositionSecurityWarning(): failed to set position");
        }
    }

    void initWarningSize(boolean bl) {
        try {
            this.getWindowField("securityWarningWidth").setInt(this.fTarget, 28);
            this.getWindowField("securityWarningHeight").setInt(this.fTarget, 19);
            this.getWindowField("securityWarningPointX").setDouble(this.fTarget, bl ? 5.0 : -16.0);
            this.getWindowField("securityWarningPointY").setDouble(this.fTarget, bl ? -5.0 : 11.0);
            this.getWindowField("securityWarningAlignmentX").setFloat(this.fTarget, 1.0f);
            this.getWindowField("securityWarningAlignmentY").setFloat(this.fTarget, 0.0f);
        }
        catch (Exception exception) {
            this.reportOnce(exception, "CWindow.initWarningSize(): failed to set size");
        }
    }

    void reportOnce(Exception exception, String string) {
        if (warnedRepositionFailure) {
            return;
        }
        warnedRepositionFailure = true;
        System.err.println(string);
        exception.printStackTrace(System.err);
    }

    Field getWindowField(final String string) throws Exception {
        return AccessController.doPrivileged(new PrivilegedAction<Field>(){

            @Override
            public Field run() {
                try {
                    Field field = Window.class.getDeclaredField(string);
                    field.setAccessible(true);
                    return field;
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
        });
    }

    void windowWillEnterFullScreen() {
    }

    void windowDidEnterFullScreen() {
    }

    void windowWillExitFullScreen() {
    }

    void windowDidExitFullScreen() {
    }

    @Override
    public void updateAlwaysOnTopState() {
        Window window = (Window)this.fTarget;
        this.setAlwaysOnTop(window.isAlwaysOnTop());
    }

    static {
        CLIENT_PROPERTY_APPLICATOR = new ClientPropertyApplicator<JRootPane, CWindow>(new ClientPropertyApplicator.Property[]{new ClientPropertyApplicator.Property<CWindow>("windowModified"){

            @Override
            public void applyProperty(CWindow cWindow, Object object) {
                cWindow._setDocumentEdited(cWindow.fModelPtr, object == null ? false : Boolean.parseBoolean(object.toString()));
            }
        }, new ClientPropertyApplicator.Property<CWindow>(DOCUMENT_MODIFIED){

            @Override
            public void applyProperty(CWindow cWindow, Object object) {
                cWindow._setDocumentEdited(cWindow.fModelPtr, object == null ? false : Boolean.parseBoolean(object.toString()));
            }
        }, new ClientPropertyApplicator.Property<CWindow>(BRUSH_METAL_LOOK){

            @Override
            public void applyProperty(CWindow cWindow, Object object) {
                cWindow.setStyleFlag(1024, Boolean.parseBoolean(object.toString()));
            }
        }, new ClientPropertyApplicator.Property<CWindow>(WINDOW_ALPHA){

            @Override
            public void applyProperty(CWindow cWindow, Object object) {
                AWTUtilities.setWindowOpacity((Window)((Window)cWindow.getTarget()), (float)(object == null ? 1.0f : Float.parseFloat(object.toString())));
            }
        }, new ClientPropertyApplicator.Property<CWindow>(WINDOW_SHADOW){

            @Override
            public void applyProperty(CWindow cWindow, Object object) {
                cWindow._setHasShadow(cWindow.fModelPtr, object == null ? true : Boolean.parseBoolean(object.toString()));
            }
        }, new ClientPropertyApplicator.Property<CWindow>(WINDOW_MINIMIZABLE){

            @Override
            public void applyProperty(CWindow cWindow, Object object) {
                cWindow.setStyleFlag(32, Boolean.parseBoolean(object.toString()));
                cWindow._updateWindowButtonState(cWindow.fModelPtr, 32);
            }
        }, new ClientPropertyApplicator.Property<CWindow>(WINDOW_CLOSEABLE){

            @Override
            public void applyProperty(CWindow cWindow, Object object) {
                cWindow.setStyleFlag(16, Boolean.parseBoolean(object.toString()));
                cWindow._updateWindowButtonState(cWindow.fModelPtr, 16);
            }
        }, new ClientPropertyApplicator.Property<CWindow>(WINDOW_ZOOMABLE){

            @Override
            public void applyProperty(CWindow cWindow, Object object) {
                cWindow.setStyleFlag(64, Boolean.parseBoolean(object.toString()));
                cWindow._updateWindowButtonState(cWindow.fModelPtr, 64);
            }
        }, new ClientPropertyApplicator.Property<CWindow>(WINDOW_MINIMUM_SIZE){

            @Override
            public void applyProperty(CWindow cWindow, Object object) {
                if (object instanceof Dimension) {
                    cWindow.updateUserMinimumSize((Dimension)object);
                }
            }
        }, new ClientPropertyApplicator.Property<CWindow>(WINDOW_SHADOW_REVALIDATE_NOW){

            @Override
            public void applyProperty(CWindow cWindow, Object object) {
                cWindow._revalidateShadow(cWindow.fModelPtr);
            }
        }, new ClientPropertyApplicator.Property<CWindow>(DOCUMENT_FILE){

            @Override
            public void applyProperty(CWindow cWindow, Object object) {
                if (object == null) {
                    cWindow._setRepresentedFilename(cWindow.fModelPtr, "");
                    return;
                }
                if (!(object instanceof File)) {
                    return;
                }
                String string = ((File)object).getAbsolutePath();
                cWindow._setRepresentedFilename(cWindow.fModelPtr, string);
            }
        }, new ClientPropertyApplicator.Property<CWindow>(WINDOW_FAKE_ACTIVE){

            @Override
            public void applyProperty(CWindow cWindow, Object object) {
                cWindow._setFakeActive(cWindow.fModelPtr, object == null ? 0 : (Boolean.parseBoolean(object.toString()) ? 1 : -1));
            }
        }, new ClientPropertyApplicator.Property<CWindow>(WINDOW_DID_INSTANTIATE_CALLBACK){

            @Override
            public void applyProperty(CWindow cWindow, Object object) {
                AccessController.checkPermission(new AllPermission());
                cWindow.windowDidInstantiateCallback = (Runnable)object;
            }
        }, new ClientPropertyApplicator.Property<CWindow>(WINDOW_WILL_MOVE_CALLBACK){

            @Override
            public void applyProperty(CWindow cWindow, Object object) {
                AccessController.checkPermission(new AllPermission());
                cWindow.windowWillMoveCallback = (Runnable)object;
            }
        }, new ClientPropertyApplicator.Property<CWindow>(WINDOW_DRAWING_DID_FINISH_HOOK){

            @Override
            public void applyProperty(CWindow cWindow, Object object) {
                AccessController.checkPermission(new AllPermission());
                cWindow.drawingDidFinishHook = (Runnable)object;
                cWindow._setDrawingHookNotifyBit(cWindow.fModelPtr, cWindow.drawingDidFinishHook != null);
            }
        }}){

            @Override
            public CWindow convertJComponentToTarget(JRootPane jRootPane) {
                Component component = SwingUtilities.getRoot(jRootPane);
                if (component == null) {
                    return null;
                }
                return (CWindow)component.getPeer();
            }
        };
        kMinFlushingPeriod = 1000 / RuntimeOptions.getCurrentOptions().LazyFlushingFPS;
    }

    public static interface NativeEventHandler {
        public void handledNativeEvent(byte[] var1);
    }
}

