/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import apple.awt.CComponent;
import apple.awt.CToolkit;
import apple.awt.CWindow;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.InvocationEvent;
import java.awt.event.WindowEvent;
import sun.awt.AWTAccessor;
import sun.awt.AppContext;
import sun.awt.SunToolkit;

public class EventFactoryProxy {
    private static void postComponentResizedEvent(int n, Object object) {
        assert (CToolkit.stdio("EventFactoryProxy.postComponentResizedEvent"));
        try {
            CComponent cComponent = (CComponent)object;
            ComponentEvent componentEvent = new ComponentEvent((Component)cComponent.fTarget, 101);
            CToolkit.postEvent(cComponent, (AWTEvent)componentEvent);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private static void postComponentMovedEvent(int n, Object object) {
        assert (CToolkit.stdio("EventFactoryProxy.postComponentMovedEvent"));
        try {
            CComponent cComponent = (CComponent)object;
            ComponentEvent componentEvent = new ComponentEvent((Component)cComponent.fTarget, 100);
            CToolkit.postEvent(cComponent, (AWTEvent)componentEvent);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private static void updateWindowState(WindowEvent windowEvent) {
        int n = windowEvent.getOldState();
        int n2 = windowEvent.getNewState();
        Component component = windowEvent.getComponent();
        if (n != n2 && component instanceof Frame) {
            AWTAccessor.getFrameAccessor().setExtendedState((Frame)component, n2);
        }
    }

    private static void forwardEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof WindowEvent) {
            EventFactoryProxy.updateWindowState((WindowEvent)aWTEvent);
        }
        CToolkit.postEvent(aWTEvent);
    }

    private static void changeFocus(final boolean bl, Component component) {
        assert (CToolkit.stdio("EventFactoryProxy.changeFocus"));
        AppContext appContext = CToolkit.targetToAppContext(component);
        final KeyboardFocusManager keyboardFocusManager = (KeyboardFocusManager)appContext.get(KeyboardFocusManager.class);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (bl) {
                    keyboardFocusManager.focusNextComponent();
                } else {
                    keyboardFocusManager.focusPreviousComponent();
                }
            }
        };
        InvocationEvent invocationEvent = new InvocationEvent((Object)Toolkit.getDefaultToolkit(), runnable);
        SunToolkit.postEvent(appContext, invocationEvent);
    }

    private static void windowMoved(final CWindow cWindow) {
        assert (CToolkit.stdio("EventFactoryProxy.windowMoved"));
        SunToolkit.executeOnEventHandlerThread((Component)cWindow.fTarget, new Runnable(){

            @Override
            public void run() {
                cWindow.displayChanged();
            }
        });
    }
}

