/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import apple.awt.CImage;
import apple.awt.CToolkit;
import apple.laf.JRSUIConstants;
import apple.laf.JRSUIState;
import apple.laf.JRSUIUtils;
import com.apple.eawt.Application;
import com.apple.eio.FileManager;
import com.apple.laf.AquaIcon;
import com.apple.laf.AquaNativeResources;
import com.apple.laf.AquaPainter;
import com.apple.laf.AquaUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.UIResource;

public class AquaImageFactory {
    private static final int kAlertIconSize = 64;
    protected static final NamedImageSingleton northArrow = new NamedImageSingleton("NSMenuScrollUp");
    protected static final IconUIResourceSingleton northArrowIcon = new IconUIResourceSingleton(northArrow);
    protected static final NamedImageSingleton southArrow = new NamedImageSingleton("NSMenuScrollDown");
    protected static final IconUIResourceSingleton southArrowIcon = new IconUIResourceSingleton(southArrow);
    protected static final NamedImageSingleton westArrow = new NamedImageSingleton("NSMenuSubmenuLeft");
    protected static final IconUIResourceSingleton westArrowIcon = new IconUIResourceSingleton(westArrow);
    protected static final NamedImageSingleton eastArrow = new NamedImageSingleton("NSMenuSubmenu");
    protected static final IconUIResourceSingleton eastArrowIcon = new IconUIResourceSingleton(eastArrow);

    public static IconUIResource getConfirmImageIcon() {
        return new IconUIResource(new AquaIcon.CachingScalingIcon(64, 64){

            @Override
            Image createImage() {
                return AquaImageFactory.getThisApplicationsIcon(64, 64);
            }
        });
    }

    public static IconUIResource getCautionImageIcon() {
        return AquaImageFactory.getAppIconCompositedOn(AquaIcon.SystemIcon.getCautionIcon());
    }

    public static IconUIResource getStopImageIcon() {
        return AquaImageFactory.getAppIconCompositedOn(AquaIcon.SystemIcon.getStopIcon());
    }

    public static IconUIResource getLockImageIcon() {
        if (JRSUIUtils.Images.shouldUseLegacySecurityUIPath()) {
            BufferedImage bufferedImage = AquaUtils.getCImageCreator().createImageFromFile("/System/Library/CoreServices/SecurityAgent.app/Contents/Resources/Security.icns", 64, 64);
            return AquaImageFactory.getAppIconCompositedOn(bufferedImage);
        }
        Image image = Toolkit.getDefaultToolkit().getImage("NSImage://NSSecurity");
        return AquaImageFactory.getAppIconCompositedOn(image);
    }

    static Image getThisApplicationsIcon(int n, int n2) {
        String string = AquaImageFactory.getPathToThisApplication();
        if (string == null) {
            return AquaImageFactory.getGenericJavaIcon();
        }
        if (string.endsWith("/Home/bin")) {
            return AquaImageFactory.getGenericJavaIcon();
        }
        if (string.startsWith("/usr/bin")) {
            return AquaImageFactory.getGenericJavaIcon();
        }
        return AquaUtils.getCImageCreator().createImageOfFile(string, n2, n);
    }

    static Image getGenericJavaIcon() {
        return AccessController.doPrivileged(new PrivilegedAction<Image>(){

            @Override
            public Image run() {
                return Application.getApplication().getDockIconImage();
            }
        });
    }

    static String getPathToThisApplication() {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return FileManager.getPathToApplicationBundle();
            }
        });
    }

    static IconUIResource getAppIconCompositedOn(AquaIcon.SystemIcon systemIcon) {
        systemIcon.setSize(64, 64);
        return AquaImageFactory.getAppIconCompositedOn(systemIcon.createImage());
    }

    static IconUIResource getAppIconCompositedOn(final Image image) {
        return new IconUIResource(new ImageIcon(new CImage.HiDPIScaledImage(64, 64, 2){

            @Override
            protected void drawIntoImage(BufferedImage bufferedImage, float f) {
                final int n = (int)(32.0 * (double)f);
                int n2 = (int)(64.0f * f) - n;
                AquaIcon.CachingScalingIcon cachingScalingIcon = new AquaIcon.CachingScalingIcon(n, n){

                    @Override
                    Image createImage() {
                        return AquaImageFactory.getThisApplicationsIcon(n, n);
                    }
                };
                Graphics graphics = bufferedImage.getGraphics();
                graphics.drawImage(image, 0, 0, (int)(64.0f * f), (int)(64.0f * f), null);
                if (graphics instanceof Graphics2D) {
                    ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                }
                cachingScalingIcon.paintIcon(null, graphics, n2, n2);
                graphics.dispose();
            }
        }));
    }

    public static IconUIResource getTreeFolderIcon() {
        return AquaIcon.SystemIcon.getFolderIconUIResource();
    }

    public static IconUIResource getTreeOpenFolderIcon() {
        return AquaIcon.SystemIcon.getOpenFolderIconUIResource();
    }

    public static IconUIResource getTreeDocumentIcon() {
        return AquaIcon.SystemIcon.getDocumentIconUIResource();
    }

    public static UIResource getTreeExpandedIcon() {
        return AquaIcon.getIconFor(new AquaIcon.JRSUIControlSpec(){

            @Override
            public void initIconPainter(AquaPainter<? extends JRSUIState> aquaPainter) {
                ((JRSUIState)aquaPainter.state).set(JRSUIConstants.Widget.DISCLOSURE_TRIANGLE);
                ((JRSUIState)aquaPainter.state).set(JRSUIConstants.State.ACTIVE);
                ((JRSUIState)aquaPainter.state).set(JRSUIConstants.Direction.DOWN);
                ((JRSUIState)aquaPainter.state).set(JRSUIConstants.AlignmentHorizontal.CENTER);
                ((JRSUIState)aquaPainter.state).set(JRSUIConstants.AlignmentVertical.CENTER);
            }
        }, 20, 20);
    }

    public static UIResource getTreeCollapsedIcon() {
        return AquaIcon.getIconFor(new AquaIcon.JRSUIControlSpec(){

            @Override
            public void initIconPainter(AquaPainter<? extends JRSUIState> aquaPainter) {
                ((JRSUIState)aquaPainter.state).set(JRSUIConstants.Widget.DISCLOSURE_TRIANGLE);
                ((JRSUIState)aquaPainter.state).set(JRSUIConstants.State.ACTIVE);
                ((JRSUIState)aquaPainter.state).set(JRSUIConstants.Direction.RIGHT);
                ((JRSUIState)aquaPainter.state).set(JRSUIConstants.AlignmentHorizontal.CENTER);
                ((JRSUIState)aquaPainter.state).set(JRSUIConstants.AlignmentVertical.CENTER);
            }
        }, 20, 20);
    }

    public static UIResource getTreeRightToLeftCollapsedIcon() {
        return AquaIcon.getIconFor(new AquaIcon.JRSUIControlSpec(){

            @Override
            public void initIconPainter(AquaPainter<? extends JRSUIState> aquaPainter) {
                ((JRSUIState)aquaPainter.state).set(JRSUIConstants.Widget.DISCLOSURE_TRIANGLE);
                ((JRSUIState)aquaPainter.state).set(JRSUIConstants.State.ACTIVE);
                ((JRSUIState)aquaPainter.state).set(JRSUIConstants.Direction.LEFT);
                ((JRSUIState)aquaPainter.state).set(JRSUIConstants.AlignmentHorizontal.CENTER);
                ((JRSUIState)aquaPainter.state).set(JRSUIConstants.AlignmentVertical.CENTER);
            }
        }, 20, 20);
    }

    static Image getArrowImageForDirection(int n) {
        switch (n) {
            case 1: {
                return (Image)northArrow.get();
            }
            case 5: {
                return (Image)southArrow.get();
            }
            case 3: {
                return (Image)eastArrow.get();
            }
            case 7: {
                return (Image)westArrow.get();
            }
        }
        return null;
    }

    static Icon getArrowIconForDirection(int n) {
        switch (n) {
            case 1: {
                return (Icon)northArrowIcon.get();
            }
            case 5: {
                return (Icon)southArrowIcon.get();
            }
            case 3: {
                return (Icon)eastArrowIcon.get();
            }
            case 7: {
                return (Icon)westArrowIcon.get();
            }
        }
        return null;
    }

    public static Icon getMenuArrowIcon() {
        return new InvertableImageIcon(AquaUtils.generateLightenedImage((Image)eastArrow.get(), 25));
    }

    public static Icon getMenuItemCheckIcon() {
        return new InvertableImageIcon(AquaUtils.generateLightenedImage(Toolkit.getDefaultToolkit().getImage("NSImage://NSMenuItemSelection"), 25));
    }

    public static Icon getMenuItemDashIcon() {
        return new InvertableImageIcon(AquaUtils.generateLightenedImage(Toolkit.getDefaultToolkit().getImage("NSImage://NSMenuMixedState"), 25));
    }

    public static Color getWindowBackgroundColorUIResource() {
        return AquaNativeResources.getWindowBackgroundColorUIResource();
    }

    public static Color getTextSelectionBackgroundColorUIResource() {
        return new SystemColorProxy(SystemColor.textHighlight);
    }

    public static Color getTextSelectionForegroundColorUIResource() {
        return new SystemColorProxy(SystemColor.textHighlightText);
    }

    public static Color getSelectionBackgroundColorUIResource() {
        return new SystemColorProxy(SystemColor.controlHighlight);
    }

    public static Color getSelectionForegroundColorUIResource() {
        return new SystemColorProxy(SystemColor.controlLtHighlight);
    }

    public static Color getFocusRingColorUIResource() {
        return new SystemColorProxy(CToolkit.getAppleColor(0));
    }

    public static Color getSelectionInactiveBackgroundColorUIResource() {
        return new SystemColorProxy(CToolkit.getAppleColor(1));
    }

    public static Color getSelectionInactiveForegroundColorUIResource() {
        return new SystemColorProxy(CToolkit.getAppleColor(2));
    }

    private static class SystemColorProxy
    extends Color
    implements UIResource {
        final Color color;

        public SystemColorProxy(Color color) {
            super(color.getRGB());
            this.color = color;
        }

        @Override
        public int getRGB() {
            return this.color.getRGB();
        }
    }

    public static class SlicedImageControl {
        final BufferedImage NW;
        final BufferedImage N;
        final BufferedImage NE;
        final BufferedImage W;
        final BufferedImage C;
        final BufferedImage E;
        final BufferedImage SW;
        final BufferedImage S;
        final BufferedImage SE;
        final int wCut;
        final int eCut;
        final int nCut;
        final int sCut;
        final int totalWidth;
        final int totalHeight;
        final int centerColWidth;
        final int centerRowHeight;

        public SlicedImageControl(Image image, int n, int n2, int n3, int n4, boolean bl) {
            this.wCut = n;
            this.eCut = n2;
            this.nCut = n3;
            this.sCut = n4;
            this.totalWidth = image.getWidth(null);
            this.totalHeight = image.getHeight(null);
            this.centerColWidth = this.totalWidth - n - n2;
            this.centerRowHeight = this.totalHeight - n3 - n4;
            this.NW = SlicedImageControl.createSlice(image, 0, 0, n, n3);
            this.N = SlicedImageControl.createSlice(image, n, 0, this.centerColWidth, n3);
            this.NE = SlicedImageControl.createSlice(image, this.totalWidth - n2, 0, n2, n3);
            this.W = SlicedImageControl.createSlice(image, 0, n3, n, this.centerRowHeight);
            this.C = bl ? SlicedImageControl.createSlice(image, n, n3, this.centerColWidth, this.centerRowHeight) : null;
            this.E = SlicedImageControl.createSlice(image, this.totalWidth - n2, n3, n2, this.centerRowHeight);
            this.SW = SlicedImageControl.createSlice(image, 0, this.totalHeight - n4, n, n4);
            this.S = SlicedImageControl.createSlice(image, n, this.totalHeight - n4, this.centerColWidth, n4);
            this.SE = SlicedImageControl.createSlice(image, this.totalWidth - n2, this.totalHeight - n4, n2, n4);
        }

        static BufferedImage createSlice(Image image, int n, int n2, int n3, int n4) {
            if (n3 == 0 || n4 == 0) {
                return null;
            }
            BufferedImage bufferedImage = new BufferedImage(n3, n4, 3);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.drawImage(image, -n, -n2, null);
            graphics2D.dispose();
            return bufferedImage;
        }

        public void paint(Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.translate(n, n2);
            if (n3 < this.totalWidth || n4 < this.totalHeight) {
                this.paintCompressed(graphics, n3, n4);
            } else {
                this.paintStretchedMiddles(graphics, n3, n4);
            }
            graphics.translate(-n, -n2);
        }

        void paintStretchedMiddles(Graphics graphics, int n, int n2) {
            if (this.NW != null) {
                graphics.drawImage(this.NW, 0, 0, null);
            }
            if (this.N != null) {
                graphics.drawImage(this.N, this.wCut, 0, n - this.eCut - this.wCut, this.nCut, null);
            }
            if (this.NE != null) {
                graphics.drawImage(this.NE, n - this.eCut, 0, null);
            }
            if (this.W != null) {
                graphics.drawImage(this.W, 0, this.nCut, this.wCut, n2 - this.nCut - this.sCut, null);
            }
            if (this.C != null) {
                graphics.drawImage(this.C, this.wCut, this.nCut, n - this.eCut - this.wCut, n2 - this.nCut - this.sCut, null);
            }
            if (this.E != null) {
                graphics.drawImage(this.E, n - this.eCut, this.nCut, this.eCut, n2 - this.nCut - this.sCut, null);
            }
            if (this.SW != null) {
                graphics.drawImage(this.SW, 0, n2 - this.sCut, null);
            }
            if (this.S != null) {
                graphics.drawImage(this.S, this.wCut, n2 - this.sCut, n - this.eCut - this.wCut, this.sCut, null);
            }
            if (this.SE != null) {
                graphics.drawImage(this.SE, n - this.eCut, n2 - this.sCut, null);
            }
        }

        void paintCompressed(Graphics graphics, int n, int n2) {
            double d = n2 > this.totalHeight ? 1.0 : (double)n2 / (double)this.totalHeight;
            double d2 = n > this.totalWidth ? 1.0 : (double)n / (double)this.totalWidth;
            int n3 = (int)((double)this.nCut * d);
            int n4 = (int)((double)this.sCut * d);
            int n5 = n2 - n3 - n4;
            int n6 = (int)((double)this.wCut * d2);
            int n7 = (int)((double)this.eCut * d2);
            int n8 = n - n6 - n7;
            if (this.NW != null) {
                graphics.drawImage(this.NW, 0, 0, n6, n3, null);
            }
            if (this.N != null) {
                graphics.drawImage(this.N, n6, 0, n8, n3, null);
            }
            if (this.NE != null) {
                graphics.drawImage(this.NE, n - n7, 0, n7, n3, null);
            }
            if (this.W != null) {
                graphics.drawImage(this.W, 0, n3, n6, n5, null);
            }
            if (this.C != null) {
                graphics.drawImage(this.C, n6, n3, n8, n5, null);
            }
            if (this.E != null) {
                graphics.drawImage(this.E, n - n7, n3, n7, n5, null);
            }
            if (this.SW != null) {
                graphics.drawImage(this.SW, 0, n2 - n4, n6, n4, null);
            }
            if (this.S != null) {
                graphics.drawImage(this.S, n6, n2 - n4, n8, n4, null);
            }
            if (this.SE != null) {
                graphics.drawImage(this.SE, n - n7, n2 - n4, n7, n4, null);
            }
        }
    }

    static class InvertableImageIcon
    extends ImageIcon
    implements AquaIcon.InvertableIcon,
    UIResource {
        Icon invertedImage;

        public InvertableImageIcon(Image image) {
            super(image);
        }

        @Override
        public Icon getInvertedIcon() {
            if (this.invertedImage != null) {
                return this.invertedImage;
            }
            this.invertedImage = new IconUIResource(new ImageIcon(AquaUtils.generateLightenedImage(this.getImage(), 100)));
            return this.invertedImage;
        }
    }

    static class IconUIResourceSingleton
    extends AquaUtils.LazySingleton<IconUIResource> {
        final NamedImageSingleton holder;

        public IconUIResourceSingleton(NamedImageSingleton namedImageSingleton) {
            this.holder = namedImageSingleton;
        }

        @Override
        protected IconUIResource getInstance() {
            return new IconUIResource(new ImageIcon((Image)this.holder.get()));
        }
    }

    static class NamedImageSingleton
    extends AquaUtils.LazySingleton<Image> {
        final String namedImage;

        NamedImageSingleton(String string) {
            this.namedImage = string;
        }

        @Override
        protected Image getInstance() {
            return Toolkit.getDefaultToolkit().getImage("NSImage://" + this.namedImage);
        }
    }
}

