/*
 * Decompiled with CFR 0.152.
 */
package com.apple.eawt;

import com.apple.eawt.FullScreenListener;
import com.apple.eawt.event.FullScreenEvent;
import java.awt.Window;
import java.util.LinkedList;
import java.util.List;
import javax.swing.RootPaneContainer;
import sun.awt.SunToolkit;

final class FullScreenHandler {
    private static final String CLIENT_PROPERTY = "com.apple.eawt.event.internalFullScreenHandler";
    static final int FULLSCREEN_WILL_ENTER = 1;
    static final int FULLSCREEN_DID_ENTER = 2;
    static final int FULLSCREEN_WILL_EXIT = 3;
    static final int FULLSCREEN_DID_EXIT = 4;
    final List<FullScreenListener> listeners = new LinkedList<FullScreenListener>();

    static void addFullScreenListenerTo(RootPaneContainer window, FullScreenListener listener) {
        Object value = window.getRootPane().getClientProperty(CLIENT_PROPERTY);
        if (value instanceof FullScreenHandler) {
            ((FullScreenHandler)value).addListener(listener);
            return;
        }
        if (value != null) {
            return;
        }
        FullScreenHandler newHandler = new FullScreenHandler();
        newHandler.addListener(listener);
        window.getRootPane().putClientProperty(CLIENT_PROPERTY, newHandler);
    }

    static void removeFullScreenListenerFrom(RootPaneContainer window, FullScreenListener listener) {
        Object value = window.getRootPane().getClientProperty(CLIENT_PROPERTY);
        if (!(value instanceof FullScreenHandler)) {
            return;
        }
        ((FullScreenHandler)value).removeListener(listener);
    }

    static FullScreenHandler getHandlerFor(RootPaneContainer window) {
        Object value = window.getRootPane().getClientProperty(CLIENT_PROPERTY);
        if (value instanceof FullScreenHandler) {
            return (FullScreenHandler)value;
        }
        return null;
    }

    static void handleFullScreenEventFromNative(final Window window, final int type) {
        if (!(window instanceof RootPaneContainer)) {
            return;
        }
        SunToolkit.executeOnEventHandlerThread(window, new Runnable(){

            @Override
            public void run() {
                FullScreenHandler handler = FullScreenHandler.getHandlerFor((RootPaneContainer)((Object)window));
                if (handler != null) {
                    handler.notifyListener(new FullScreenEvent(window), type);
                }
            }
        });
    }

    FullScreenHandler() {
    }

    void addListener(FullScreenListener listener) {
        this.listeners.add(listener);
    }

    void removeListener(FullScreenListener listener) {
        this.listeners.remove(listener);
    }

    void notifyListener(FullScreenEvent e, int op) {
        for (FullScreenListener listener : this.listeners) {
            switch (op) {
                case 1: {
                    listener.windowEnteringFullScreen(e);
                    return;
                }
                case 2: {
                    listener.windowEnteredFullScreen(e);
                    return;
                }
                case 3: {
                    listener.windowExitingFullScreen(e);
                    return;
                }
                case 4: {
                    listener.windowExitedFullScreen(e);
                    return;
                }
            }
        }
    }
}

