/*
 * Decompiled with CFR 0.152.
 */
package com.apple.eawt.event;

import com.apple.eawt.event.GestureListener;
import com.apple.eawt.event.GesturePhaseEvent;
import com.apple.eawt.event.GesturePhaseListener;
import com.apple.eawt.event.MagnificationEvent;
import com.apple.eawt.event.MagnificationListener;
import com.apple.eawt.event.RotationEvent;
import com.apple.eawt.event.RotationListener;
import com.apple.eawt.event.SwipeEvent;
import com.apple.eawt.event.SwipeListener;
import java.awt.Component;
import java.awt.Window;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import sun.awt.SunToolkit;

final class GestureHandler {
    private static final String CLIENT_PROPERTY = "com.apple.eawt.event.internalGestureHandler";
    static final int PHASE = 1;
    static final int ROTATE = 2;
    static final int MAGNIFY = 3;
    static final int SWIPE = 4;
    final List<GesturePhaseListener> phasers = new LinkedList<GesturePhaseListener>();
    final List<RotationListener> rotaters = new LinkedList<RotationListener>();
    final List<MagnificationListener> magnifiers = new LinkedList<MagnificationListener>();
    final List<SwipeListener> swipers = new LinkedList<SwipeListener>();

    static void addGestureListenerTo(JComponent component, GestureListener listener) {
        Object value = component.getClientProperty(CLIENT_PROPERTY);
        if (value instanceof GestureHandler) {
            ((GestureHandler)value).addListener(listener);
            return;
        }
        if (value != null) {
            return;
        }
        GestureHandler newHandler = new GestureHandler();
        newHandler.addListener(listener);
        component.putClientProperty(CLIENT_PROPERTY, newHandler);
    }

    static void removeGestureListenerFrom(JComponent component, GestureListener listener) {
        Object value = component.getClientProperty(CLIENT_PROPERTY);
        if (!(value instanceof GestureHandler)) {
            return;
        }
        ((GestureHandler)value).removeListener(listener);
    }

    static void handleGestureFromNative(final Window window, final int type, final double x, final double y, final double a, final double b) {
        if (window == null) {
            return;
        }
        SunToolkit.executeOnEventHandlerThread(window, new Runnable(){

            @Override
            public void run() {
                Component component = SwingUtilities.getDeepestComponentAt(window, (int)x, (int)y);
                PerComponentNotifier firstNotifier = component instanceof RootPaneContainer ? GestureHandler.getNextNotifierForComponent(((RootPaneContainer)((Object)component)).getRootPane()) : GestureHandler.getNextNotifierForComponent(component);
                if (firstNotifier == null) {
                    return;
                }
                switch (type) {
                    case 1: {
                        firstNotifier.recursivelyHandlePhaseChange(a, new GesturePhaseEvent());
                        return;
                    }
                    case 2: {
                        firstNotifier.recursivelyHandleRotate(new RotationEvent(a));
                        return;
                    }
                    case 3: {
                        firstNotifier.recursivelyHandleMagnify(new MagnificationEvent(a));
                        return;
                    }
                    case 4: {
                        firstNotifier.recursivelyHandleSwipe(a, b, new SwipeEvent());
                        return;
                    }
                }
            }
        });
    }

    GestureHandler() {
    }

    void addListener(GestureListener listener) {
        if (listener instanceof GesturePhaseListener) {
            this.phasers.add((GesturePhaseListener)listener);
        }
        if (listener instanceof RotationListener) {
            this.rotaters.add((RotationListener)listener);
        }
        if (listener instanceof MagnificationListener) {
            this.magnifiers.add((MagnificationListener)listener);
        }
        if (listener instanceof SwipeListener) {
            this.swipers.add((SwipeListener)listener);
        }
    }

    void removeListener(GestureListener listener) {
        this.phasers.remove(listener);
        this.rotaters.remove(listener);
        this.magnifiers.remove(listener);
        this.swipers.remove(listener);
    }

    static GestureHandler getHandlerForComponent(Component c) {
        if (!(c instanceof JComponent)) {
            return null;
        }
        Object value = ((JComponent)c).getClientProperty(CLIENT_PROPERTY);
        if (!(value instanceof GestureHandler)) {
            return null;
        }
        return (GestureHandler)value;
    }

    static PerComponentNotifier getNextNotifierForComponent(Component c) {
        if (c == null) {
            return null;
        }
        GestureHandler handler = GestureHandler.getHandlerForComponent(c);
        if (handler != null) {
            return new PerComponentNotifier(c, handler);
        }
        return GestureHandler.getNextNotifierForComponent(c.getParent());
    }

    static class PerComponentNotifier {
        final Component component;
        final GestureHandler handler;

        public PerComponentNotifier(Component component, GestureHandler handler) {
            this.component = component;
            this.handler = handler;
        }

        void recursivelyHandlePhaseChange(double phase, GesturePhaseEvent e) {
            for (GesturePhaseListener listener : this.handler.phasers) {
                if (phase < 0.0) {
                    listener.gestureBegan(e);
                } else {
                    listener.gestureEnded(e);
                }
                if (!e.isConsumed()) continue;
                return;
            }
            PerComponentNotifier next = GestureHandler.getNextNotifierForComponent(this.component.getParent());
            if (next != null) {
                next.recursivelyHandlePhaseChange(phase, e);
            }
        }

        void recursivelyHandleRotate(RotationEvent e) {
            for (RotationListener listener : this.handler.rotaters) {
                listener.rotate(e);
                if (!e.isConsumed()) continue;
                return;
            }
            PerComponentNotifier next = GestureHandler.getNextNotifierForComponent(this.component.getParent());
            if (next != null) {
                next.recursivelyHandleRotate(e);
            }
        }

        void recursivelyHandleMagnify(MagnificationEvent e) {
            for (MagnificationListener listener : this.handler.magnifiers) {
                listener.magnify(e);
                if (!e.isConsumed()) continue;
                return;
            }
            PerComponentNotifier next = GestureHandler.getNextNotifierForComponent(this.component.getParent());
            if (next != null) {
                next.recursivelyHandleMagnify(e);
            }
        }

        void recursivelyHandleSwipe(double x, double y, SwipeEvent e) {
            for (SwipeListener listener : this.handler.swipers) {
                if (x < 0.0) {
                    listener.swipedLeft(e);
                }
                if (x > 0.0) {
                    listener.swipedRight(e);
                }
                if (y < 0.0) {
                    listener.swipedDown(e);
                }
                if (y > 0.0) {
                    listener.swipedUp(e);
                }
                if (!e.isConsumed()) continue;
                return;
            }
            PerComponentNotifier next = GestureHandler.getNextNotifierForComponent(this.component.getParent());
            if (next != null) {
                next.recursivelyHandleSwipe(x, y, e);
            }
        }
    }
}

