/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import apple.laf.JRSUIConstants;
import apple.laf.JRSUIState;
import apple.laf.JRSUIStateFactory;
import com.apple.laf.AquaButtonBorder;
import com.apple.laf.AquaButtonToggleUI;
import com.apple.laf.AquaPainter;
import com.apple.laf.AquaUtilControlSize;
import com.apple.laf.AquaUtils;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import javax.swing.text.View;

public abstract class AquaButtonLabeledUI
extends AquaButtonToggleUI
implements AquaUtilControlSize.Sizeable {
    private static final RecyclableSizingIcon regularIcon = new RecyclableSizingIcon(18);
    private static final RecyclableSizingIcon smallIcon = new RecyclableSizingIcon(16);
    private static final RecyclableSizingIcon miniIcon = new RecyclableSizingIcon(14);
    protected AquaButtonBorder widgetBorder = this.getPainter();

    @Override
    public void applySizeFor(JComponent c, JRSUIConstants.Size newSize) {
        super.applySizeFor(c, newSize);
        this.widgetBorder = (AquaButtonBorder)this.widgetBorder.deriveBorderForSize(newSize);
    }

    public Icon getDefaultIcon(JComponent c) {
        JRSUIConstants.Size componentSize = AquaUtilControlSize.getUserSizeFrom(c);
        if (componentSize == JRSUIConstants.Size.REGULAR) {
            return (Icon)regularIcon.get();
        }
        if (componentSize == JRSUIConstants.Size.SMALL) {
            return (Icon)smallIcon.get();
        }
        if (componentSize == JRSUIConstants.Size.MINI) {
            return (Icon)miniIcon.get();
        }
        return (Icon)regularIcon.get();
    }

    @Override
    protected void setThemeBorder(AbstractButton b) {
        super.setThemeBorder(b);
        Border border = b.getBorder();
        if (border == null || border instanceof UIResource) {
            b.setBorder(AquaButtonBorder.getBevelButtonBorder());
        }
    }

    protected abstract AquaButtonBorder getPainter();

    @Override
    public synchronized void paint(Graphics g, JComponent c) {
        Border border;
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        Font f = c.getFont();
        g.setFont(f);
        FontMetrics fm = g.getFontMetrics();
        Dimension size = b.getSize();
        Insets i = c.getInsets();
        Rectangle viewRect = new Rectangle(b.getWidth(), b.getHeight());
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        Icon altIcon = b.getIcon();
        boolean isCellEditor = c.getParent() instanceof CellRendererPane;
        if (b.isOpaque() || isCellEditor) {
            g.setColor(b.getBackground());
            g.fillRect(0, 0, size.width, size.height);
        }
        if (((AbstractButton)c).isBorderPainted() && !isCellEditor && (border = c.getBorder()) instanceof AquaButtonBorder) {
            ((AquaButtonBorder)border).paintButton(c, g, viewRect.x, viewRect.y, viewRect.width, viewRect.height);
        }
        viewRect.x = i.left;
        viewRect.y = i.top;
        viewRect.width = b.getWidth() - (i.right + viewRect.x);
        viewRect.height = b.getHeight() - (i.bottom + viewRect.y);
        String text = SwingUtilities.layoutCompoundLabel(c, fm, b.getText(), altIcon != null ? altIcon : this.getDefaultIcon(b), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getText() == null ? 0 : b.getIconTextGap());
        if (altIcon == null) {
            this.widgetBorder.paintButton(c, g, iconRect.x, iconRect.y, iconRect.width, iconRect.height);
        } else {
            if (!model.isEnabled()) {
                altIcon = model.isSelected() ? b.getDisabledSelectedIcon() : b.getDisabledIcon();
            } else if (model.isPressed() && model.isArmed()) {
                altIcon = b.getPressedIcon();
                if (altIcon == null) {
                    altIcon = b.getSelectedIcon();
                }
            } else if (model.isSelected()) {
                if (b.isRolloverEnabled() && model.isRollover()) {
                    altIcon = b.getRolloverSelectedIcon();
                    if (altIcon == null) {
                        altIcon = b.getSelectedIcon();
                    }
                } else {
                    altIcon = b.getSelectedIcon();
                }
            } else if (b.isRolloverEnabled() && model.isRollover()) {
                altIcon = b.getRolloverIcon();
            }
            if (altIcon == null) {
                altIcon = b.getIcon();
            }
            altIcon.paintIcon(c, g, iconRect.x, iconRect.y);
        }
        if (text != null) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                v.paint(g, textRect);
            } else {
                this.paintText(g, b, textRect, text);
            }
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        if (c.getComponentCount() > 0) {
            return null;
        }
        AbstractButton b = (AbstractButton)c;
        String text = b.getText();
        Icon buttonIcon = b.getIcon();
        if (buttonIcon == null) {
            buttonIcon = this.getDefaultIcon(b);
        }
        Font font = b.getFont();
        FontMetrics fm = b.getFontMetrics(font);
        Rectangle prefViewRect = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
        Rectangle prefIconRect = new Rectangle();
        Rectangle prefTextRect = new Rectangle();
        SwingUtilities.layoutCompoundLabel(c, fm, text, buttonIcon, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), prefViewRect, prefIconRect, prefTextRect, text == null ? 0 : b.getIconTextGap());
        int x1 = Math.min(prefIconRect.x, prefTextRect.x);
        int x2 = Math.max(prefIconRect.x + prefIconRect.width, prefTextRect.x + prefTextRect.width);
        int y1 = Math.min(prefIconRect.y, prefTextRect.y);
        int y2 = Math.max(prefIconRect.y + prefIconRect.height, prefTextRect.y + prefTextRect.height);
        int width = x2 - x1;
        int height = y2 - y1;
        Insets prefInsets = b.getInsets();
        return new Dimension(width += prefInsets.left + prefInsets.right, height += prefInsets.top + prefInsets.bottom);
    }

    public static abstract class LabeledButtonBorder
    extends AquaButtonBorder {
        public LabeledButtonBorder(AquaUtilControlSize.SizeDescriptor sizeDescriptor) {
            super(sizeDescriptor);
        }

        public LabeledButtonBorder(LabeledButtonBorder other) {
            super(other);
        }

        @Override
        protected AquaPainter<? extends JRSUIState> createPainter() {
            AquaPainter<JRSUIState.ValueState> painter = AquaPainter.create(JRSUIStateFactory.getLabeledButton());
            ((JRSUIState.ValueState)painter.state).set(JRSUIConstants.AlignmentVertical.CENTER);
            ((JRSUIState.ValueState)painter.state).set(JRSUIConstants.AlignmentHorizontal.CENTER);
            return painter;
        }

        @Override
        protected void doButtonPaint(AbstractButton b, ButtonModel model, Graphics g, int x, int y, int width, int height) {
            ((JRSUIState)this.painter.state).set(AquaUtilControlSize.getUserSizeFrom(b));
            ((JRSUIState.ValueState)this.painter.state).setValue(model.isSelected() ? (LabeledButtonBorder.isIndeterminate(b) ? 2.0 : 1.0) : 0.0);
            super.doButtonPaint(b, model, g, x, y, width, height);
        }

        @Override
        protected JRSUIConstants.State getButtonState(AbstractButton b, ButtonModel model) {
            JRSUIConstants.State state = super.getButtonState(b, model);
            if (state == JRSUIConstants.State.INACTIVE) {
                return JRSUIConstants.State.INACTIVE;
            }
            if (state == JRSUIConstants.State.DISABLED) {
                return JRSUIConstants.State.DISABLED;
            }
            if (model.isArmed() && model.isPressed()) {
                return JRSUIConstants.State.PRESSED;
            }
            if (model.isSelected()) {
                return JRSUIConstants.State.ACTIVE;
            }
            return state;
        }

        static boolean isIndeterminate(AbstractButton b) {
            return "indeterminate".equals(b.getClientProperty("JButton.selectedState"));
        }
    }

    protected static class RecyclableSizingIcon
    extends AquaUtils.RecyclableSingleton<Icon> {
        final int iconSize;

        public RecyclableSizingIcon(int iconSize) {
            this.iconSize = iconSize;
        }

        @Override
        protected Icon getInstance() {
            return new ImageIcon(new BufferedImage(this.iconSize, this.iconSize, 3));
        }
    }
}

