/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import com.apple.laf.AquaHighlighter;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JEditorPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;

public class AquaCaret
extends DefaultCaret
implements UIResource,
PropertyChangeListener {
    private boolean isMultiLineEditor;
    private boolean mFocused = false;
    private boolean fPainting = false;
    private boolean shouldSelectAllOnFocus = true;

    @Override
    public void install(JTextComponent c) {
        super.install(c);
        this.isMultiLineEditor = c instanceof JTextArea || c instanceof JEditorPane;
        c.addPropertyChangeListener(this);
    }

    @Override
    public void deinstall(JTextComponent c) {
        c.removePropertyChangeListener(this);
        super.deinstall(c);
    }

    @Override
    protected Highlighter.HighlightPainter getSelectionPainter() {
        return AquaHighlighter.getInstance();
    }

    @Override
    public void setVisible(boolean e) {
        if (e) {
            e = this.getDot() == this.getMark();
        }
        super.setVisible(e);
    }

    @Override
    protected void fireStateChanged() {
        if (this.mFocused) {
            this.setVisible(this.getComponent().isEditable());
        }
        super.fireStateChanged();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if ("Frame.active".equals(propertyName)) {
            JTextComponent comp = (JTextComponent)evt.getSource();
            if (evt.getNewValue() == Boolean.TRUE) {
                this.setVisible(comp.hasFocus());
            } else {
                this.setVisible(false);
            }
            if (this.getDot() != this.getMark()) {
                comp.getUI().damageRange(comp, this.getDot(), this.getMark());
            }
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        int mark;
        JTextComponent component = this.getComponent();
        if (!component.isEnabled() || !component.isEditable()) {
            super.focusGained(e);
            return;
        }
        this.mFocused = true;
        if (!this.shouldSelectAllOnFocus) {
            this.shouldSelectAllOnFocus = true;
            super.focusGained(e);
            return;
        }
        if (this.isMultiLineEditor) {
            super.focusGained(e);
            return;
        }
        int end = component.getDocument().getLength();
        int dot = this.getDot();
        if (dot == (mark = this.getMark())) {
            if (dot == 0) {
                component.setCaretPosition(end);
                component.moveCaretPosition(0);
            } else if (dot == end) {
                component.setCaretPosition(0);
                component.moveCaretPosition(end);
            }
        }
        super.focusGained(e);
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.mFocused = false;
        this.shouldSelectAllOnFocus = true;
        if (this.isMultiLineEditor) {
            this.setVisible(false);
            this.getComponent().repaint();
        } else {
            super.focusLost(e);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!e.isPopupTrigger()) {
            super.mousePressed(e);
            this.shouldSelectAllOnFocus = false;
        }
    }

    @Override
    protected synchronized void damage(Rectangle r) {
        if (r == null || this.fPainting) {
            return;
        }
        this.x = r.x - 4;
        this.y = r.y;
        this.width = 10;
        this.height = r.height;
        Rectangle caretRect = new Rectangle(this.x, this.y, this.width, this.height);
        Border border = this.getComponent().getBorder();
        if (border != null) {
            Rectangle alloc = this.getComponent().getBounds();
            alloc.y = 0;
            alloc.x = 0;
            Insets borderInsets = border.getBorderInsets(this.getComponent());
            alloc.x += borderInsets.left;
            alloc.y += borderInsets.top;
            alloc.width -= borderInsets.left + borderInsets.right;
            alloc.height -= borderInsets.top + borderInsets.bottom;
            Rectangle2D.intersect(caretRect, alloc, caretRect);
        }
        this.x = caretRect.x;
        this.y = caretRect.y;
        this.width = Math.max(caretRect.width, 1);
        this.height = Math.max(caretRect.height, 1);
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        if (this.isVisible()) {
            this.fPainting = true;
            super.paint(g);
            this.fPainting = false;
        }
    }
}

