/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import com.apple.laf.AquaCaret;
import com.apple.laf.AquaFocusHandler;
import com.apple.laf.AquaHighlighter;
import com.apple.laf.AquaKeyBindings;
import com.apple.laf.AquaUtilControlSize;
import java.awt.GraphicsEnvironment;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTextPaneUI;
import javax.swing.text.Caret;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;

public class AquaTextPaneUI
extends BasicTextPaneUI {
    AquaFocusHandler handler;
    boolean oldDragState = false;

    public static ComponentUI createUI(JComponent c) {
        return new AquaTextPaneUI();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        JTextComponent c = this.getComponent();
        this.handler = new AquaFocusHandler();
        c.addFocusListener(this.handler);
        c.addPropertyChangeListener(this.handler);
        AquaUtilControlSize.addSizePropertyListener(c);
    }

    @Override
    protected void uninstallListeners() {
        JTextComponent c = this.getComponent();
        AquaUtilControlSize.removeSizePropertyListener(c);
        c.removeFocusListener(this.handler);
        c.removePropertyChangeListener(this.handler);
        this.handler = null;
        super.uninstallListeners();
    }

    @Override
    protected void installDefaults() {
        JTextComponent c = this.getComponent();
        if (!GraphicsEnvironment.isHeadless()) {
            this.oldDragState = c.getDragEnabled();
            c.setDragEnabled(true);
        }
        super.installDefaults();
    }

    @Override
    protected void uninstallDefaults() {
        if (!GraphicsEnvironment.isHeadless()) {
            this.getComponent().setDragEnabled(this.oldDragState);
        }
        super.uninstallDefaults();
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        AquaKeyBindings bindings = AquaKeyBindings.instance();
        bindings.setDefaultAction(this.getKeymapName());
        JTextComponent c = this.getComponent();
        bindings.installAquaUpDownActions(c);
    }

    @Override
    protected Caret createCaret() {
        return new AquaCaret();
    }

    @Override
    protected Highlighter createHighlighter() {
        return new AquaHighlighter();
    }
}

