/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import com.apple.laf.AquaImageFactory;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.Kernel;
import java.awt.image.MultiResolutionImage;
import java.awt.image.RGBImageFilter;
import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import javax.swing.GrayFilter;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import jdk.internal.loader.ClassLoaders;
import sun.awt.AppContext;
import sun.awt.image.MultiResolutionCachedImage;
import sun.reflect.misc.ReflectUtil;
import sun.security.action.GetPropertyAction;
import sun.swing.SwingAccessor;
import sun.swing.SwingUtilities2;

final class AquaUtils {
    private static final String ANIMATIONS_PROPERTY = "swing.enableAnimations";
    private static final RecyclableSingleton<Boolean> enableAnimations = new RecyclableSingleton<Boolean>(){

        @Override
        protected Boolean getInstance() {
            String sizeProperty = AccessController.doPrivileged(new GetPropertyAction(AquaUtils.ANIMATIONS_PROPERTY));
            return !"false".equals(sizeProperty);
        }
    };
    private static final int MENU_BLINK_DELAY = 50;
    private static final RecyclableSingleton<Method> getJComponentGetFlagMethod = new RecyclableSingleton<Method>(){

        @Override
        protected Method getInstance() {
            return AccessController.doPrivileged(new PrivilegedAction<Method>(){

                @Override
                public Method run() {
                    try {
                        Method method = JComponent.class.getDeclaredMethod("getFlag", Integer.TYPE);
                        method.setAccessible(true);
                        return method;
                    }
                    catch (Throwable ignored) {
                        return null;
                    }
                }
            });
        }
    };
    private static final int OPAQUE_SET_FLAG = 24;

    private AquaUtils() {
    }

    static boolean isLeftToRight(Component c) {
        return c.getComponentOrientation().isLeftToRight();
    }

    static void enforceComponentOrientation(Component c, ComponentOrientation orientation) {
        c.setComponentOrientation(orientation);
        if (c instanceof Container) {
            for (Component child : ((Container)c).getComponents()) {
                AquaUtils.enforceComponentOrientation(child, orientation);
            }
        }
    }

    static Image generateSelectedDarkImage(Image image) {
        IconImageFilter filter = new IconImageFilter(){

            @Override
            int getGreyFor(int gray) {
                return gray * 75 / 100;
            }
        };
        return AquaUtils.map(image, filter);
    }

    static Image generateDisabledImage(Image image) {
        IconImageFilter filter = new IconImageFilter(){

            @Override
            int getGreyFor(int gray) {
                return 255 - (255 - gray) * 65 / 100;
            }
        };
        return AquaUtils.map(image, filter);
    }

    static Image generateLightenedImage(Image image, int percent) {
        GrayFilter filter = new GrayFilter(true, percent);
        return AquaUtils.map(image, filter);
    }

    static Image generateFilteredImage(Image image, ImageFilter filter) {
        FilteredImageSource prod = new FilteredImageSource(image.getSource(), filter);
        return Toolkit.getDefaultToolkit().createImage(prod);
    }

    private static Image map(Image image, ImageFilter filter) {
        if (image instanceof MultiResolutionImage) {
            return MultiResolutionCachedImage.map((MultiResolutionImage)((Object)image), (Image img) -> AquaUtils.generateFilteredImage(img, filter));
        }
        return AquaUtils.generateFilteredImage(image, filter);
    }

    private static boolean animationsEnabled() {
        return enableAnimations.get();
    }

    static void blinkMenu(Selectable selectable) {
        if (!AquaUtils.animationsEnabled()) {
            return;
        }
        try {
            selectable.paintSelected(false);
            Thread.sleep(50L);
            selectable.paintSelected(true);
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static void paintDropShadowText(Graphics g, JComponent c, Font font, FontMetrics metrics, int x, int y, int offsetX, int offsetY, Color textColor, Color shadowColor, String text) {
        g.setFont(font);
        g.setColor(shadowColor);
        SwingUtilities2.drawString(c, g, text, x + offsetX, y + offsetY + metrics.getAscent());
        g.setColor(textColor);
        SwingUtilities2.drawString(c, g, text, x, y + metrics.getAscent());
    }

    static boolean shouldUseOpaqueButtons() {
        ClassLoader launcherClassLoader = ClassLoaders.appClassLoader();
        return AquaUtils.classExists(launcherClassLoader, "com.installshield.wizard.platform.macosx.MacOSXUtils");
    }

    private static boolean classExists(ClassLoader classLoader, String clazzName) {
        try {
            return Class.forName(clazzName, false, classLoader) != null;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    static boolean hasOpaqueBeenExplicitlySet(JComponent c) {
        return SwingAccessor.getJComponentAccessor().getFlag(c, 24);
    }

    private static boolean isWindowTextured(Component c) {
        if (!(c instanceof JComponent)) {
            return false;
        }
        JRootPane pane = ((JComponent)c).getRootPane();
        if (pane == null) {
            return false;
        }
        Object prop = pane.getClientProperty("apple.awt.brushMetalLook");
        if (prop != null) {
            return Boolean.parseBoolean(prop.toString());
        }
        prop = pane.getClientProperty("Window.style");
        return prop != null && "textured".equals(prop);
    }

    private static Color resetAlpha(Color color) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), 0);
    }

    static void fillRect(Graphics g, Component c) {
        AquaUtils.fillRect(g, c, c.getBackground(), 0, 0, c.getWidth(), c.getHeight());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void fillRect(Graphics g, Component c, Color color, int x, int y, int w, int h) {
        if (!(g instanceof Graphics2D)) {
            return;
        }
        Graphics2D cg = (Graphics2D)g.create();
        try {
            if (color instanceof UIResource && AquaUtils.isWindowTextured(c) && color.equals(SystemColor.window)) {
                cg.setComposite(AlphaComposite.Src);
                cg.setColor(AquaUtils.resetAlpha(color));
            } else {
                cg.setColor(color);
            }
            cg.fillRect(x, y, w, h);
        }
        finally {
            cg.dispose();
        }
    }

    static class SlicedShadowBorder
    extends ShadowBorder {
        private final AquaImageFactory.SlicedImageControl slices;

        SlicedShadowBorder(Painter prePainter, Painter postPainter, int offsetX, int offsetY, float distance, float intensity, int blur, int templateWidth, int templateHeight, int leftCut, int topCut, int rightCut, int bottomCut) {
            super(prePainter, postPainter, offsetX, offsetY, distance, intensity, blur);
            BufferedImage i = new BufferedImage(templateWidth, templateHeight, 3);
            super.paintBorder(null, i.getGraphics(), 0, 0, templateWidth, templateHeight);
            this.slices = new AquaImageFactory.SlicedImageControl(i, leftCut, topCut, rightCut, bottomCut, false);
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            this.slices.paint(g, x, y, width, height);
        }
    }

    static class ShadowBorder
    implements Border {
        private final Painter prePainter;
        private final Painter postPainter;
        private final int offsetX;
        private final int offsetY;
        private final float distance;
        private final int blur;
        private final Insets insets;
        private final ConvolveOp blurOp;

        ShadowBorder(Painter prePainter, Painter postPainter, int offsetX, int offsetY, float distance, float intensity, int blur) {
            this.prePainter = prePainter;
            this.postPainter = postPainter;
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            this.distance = distance;
            this.blur = blur;
            int halfBlur = blur / 2;
            this.insets = new Insets(halfBlur - offsetY, halfBlur - offsetX, halfBlur + offsetY, halfBlur + offsetX);
            float blurry = intensity / (float)(blur * blur);
            float[] blurKernel = new float[blur * blur];
            for (int i = 0; i < blurKernel.length; ++i) {
                blurKernel[i] = blurry;
            }
            this.blurOp = new ConvolveOp(new Kernel(blur, blur, blurKernel));
        }

        @Override
        public final boolean isBorderOpaque() {
            return false;
        }

        @Override
        public final Insets getBorderInsets(Component c) {
            return this.insets;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            BufferedImage img = new BufferedImage(width + this.blur * 2, height + this.blur * 2, 3);
            this.paintToImage(img, x, y, width, height);
            g.drawImage(img, -this.blur, -this.blur, null);
        }

        private void paintToImage(BufferedImage img, int x, int y, int width, int height) {
            Graphics2D imgG = (Graphics2D)img.getGraphics();
            imgG.setComposite(AlphaComposite.Clear);
            imgG.setColor(Color.black);
            imgG.fillRect(0, 0, width + this.blur * 2, height + this.blur * 2);
            int adjX = (int)((float)(x + this.blur + this.offsetX) + (float)this.insets.left * this.distance);
            int adjY = (int)((float)(y + this.blur + this.offsetY) + (float)this.insets.top * this.distance);
            int adjW = (int)((float)width - (float)(this.insets.left + this.insets.right) * this.distance);
            int adjH = (int)((float)height - (float)(this.insets.top + this.insets.bottom) * this.distance);
            imgG.setComposite(AlphaComposite.DstAtop);
            if (this.prePainter != null) {
                this.prePainter.paint(imgG, adjX, adjY, adjW, adjH);
            }
            imgG.dispose();
            imgG = (Graphics2D)img.getGraphics();
            imgG.setComposite(AlphaComposite.DstAtop);
            imgG.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            imgG.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            imgG.drawImage(img, this.blurOp, 0, 0);
            if (this.postPainter != null) {
                this.postPainter.paint(imgG, adjX, adjY, adjW, adjH);
            }
            imgG.dispose();
        }
    }

    static interface Painter {
        public void paint(Graphics var1, int var2, int var3, int var4, int var5);
    }

    static interface JComponentPainter {
        public void paint(JComponent var1, Graphics var2, int var3, int var4, int var5, int var6);
    }

    static interface Selectable {
        public void paintSelected(boolean var1);
    }

    static abstract class LazyKeyedSingleton<K, V> {
        private Map<K, V> refs;

        LazyKeyedSingleton() {
        }

        V get(K key) {
            V cachedValue;
            if (this.refs == null) {
                this.refs = new HashMap();
            }
            if ((cachedValue = this.refs.get(key)) != null) {
                return cachedValue;
            }
            V value = this.getInstance(key);
            this.refs.put(key, value);
            return value;
        }

        protected abstract V getInstance(K var1);
    }

    static class RecyclableSingletonFromDefaultConstructor<T>
    extends RecyclableSingleton<T> {
        private final Class<T> clazz;

        RecyclableSingletonFromDefaultConstructor(Class<T> clazz) {
            this.clazz = clazz;
        }

        @Override
        T getInstance() {
            try {
                ReflectUtil.checkPackageAccess(this.clazz);
                return this.clazz.newInstance();
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                return null;
            }
        }
    }

    static abstract class RecyclableSingleton<T> {
        RecyclableSingleton() {
        }

        final T get() {
            return (T)AppContext.getSoftReferenceValue(this, () -> this.getInstance());
        }

        void reset() {
            AppContext.getAppContext().remove(this);
        }

        abstract T getInstance();
    }

    static abstract class RecyclableObject<T> {
        private SoftReference<T> objectRef;

        RecyclableObject() {
        }

        T get() {
            T referent;
            if (this.objectRef != null && (referent = this.objectRef.get()) != null) {
                return referent;
            }
            referent = this.create();
            this.objectRef = new SoftReference<T>(referent);
            return referent;
        }

        protected abstract T create();
    }

    private static abstract class IconImageFilter
    extends RGBImageFilter {
        IconImageFilter() {
            this.canFilterIndexColorModel = true;
        }

        @Override
        public final int filterRGB(int x, int y, int rgb) {
            int red = rgb >> 16 & 0xFF;
            int green = rgb >> 8 & 0xFF;
            int blue = rgb & 0xFF;
            int gray = this.getGreyFor((int)((0.3 * (double)red + 0.59 * (double)green + 0.11 * (double)blue) / 3.0));
            return rgb & 0xFF000000 | IconImageFilter.grayTransform(red, gray) << 16 | IconImageFilter.grayTransform(green, gray) << 8 | IconImageFilter.grayTransform(blue, gray) << 0;
        }

        private static int grayTransform(int color, int gray) {
            int result = color - gray;
            if (result < 0) {
                result = 0;
            }
            if (result > 255) {
                result = 255;
            }
            return result;
        }

        abstract int getGreyFor(int var1);
    }
}

