/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.peer.FileDialogPeer;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import sun.awt.AWTAccessor;

public class FileDialog
extends Dialog {
    public static final int LOAD = 0;
    public static final int SAVE = 1;
    int mode;
    String dir;
    String file;
    private File[] files;
    private boolean multipleMode = false;
    FilenameFilter filter;
    private static final String base = "filedlg";
    private static int nameCounter = 0;
    private static final long serialVersionUID = 5035145889651310422L;

    private static native void initIDs();

    public FileDialog(Frame parent) {
        this(parent, "", 0);
    }

    public FileDialog(Frame parent, String title) {
        this(parent, title, 0);
    }

    public FileDialog(Frame parent, String title, int mode) {
        super(parent, title, true);
        this.setMode(mode);
        this.setLayout(null);
    }

    public FileDialog(Dialog parent) {
        this(parent, "", 0);
    }

    public FileDialog(Dialog parent, String title) {
        this(parent, title, 0);
    }

    public FileDialog(Dialog parent, String title, int mode) {
        super(parent, title, true);
        this.setMode(mode);
        this.setLayout(null);
    }

    @Override
    public void setTitle(String title) {
        super.setTitle(title);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    String constructComponentName() {
        Class<FileDialog> clazz = FileDialog.class;
        synchronized (FileDialog.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return base + nameCounter++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.parent != null && this.parent.peer == null) {
                this.parent.addNotify();
            }
            if (this.peer == null) {
                this.peer = this.getComponentFactory().createFileDialog(this);
            }
            super.addNotify();
        }
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        switch (mode) {
            case 0: 
            case 1: {
                this.mode = mode;
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal file dialog mode");
            }
        }
    }

    public String getDirectory() {
        return this.dir;
    }

    public void setDirectory(String dir) {
        this.dir = dir != null && dir.equals("") ? null : dir;
        FileDialogPeer peer = (FileDialogPeer)this.peer;
        if (peer != null) {
            peer.setDirectory(this.dir);
        }
    }

    public String getFile() {
        return this.file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File[] getFiles() {
        Object object = this.getObjectLock();
        synchronized (object) {
            if (this.files != null) {
                return (File[])this.files.clone();
            }
            return new File[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFiles(File[] files) {
        Object object = this.getObjectLock();
        synchronized (object) {
            this.files = files;
        }
    }

    public void setFile(String file) {
        this.file = file != null && file.equals("") ? null : file;
        FileDialogPeer peer = (FileDialogPeer)this.peer;
        if (peer != null) {
            peer.setFile(this.file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMultipleMode(boolean enable) {
        Object object = this.getObjectLock();
        synchronized (object) {
            this.multipleMode = enable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMultipleMode() {
        Object object = this.getObjectLock();
        synchronized (object) {
            return this.multipleMode;
        }
    }

    public FilenameFilter getFilenameFilter() {
        return this.filter;
    }

    public synchronized void setFilenameFilter(FilenameFilter filter) {
        this.filter = filter;
        FileDialogPeer peer = (FileDialogPeer)this.peer;
        if (peer != null) {
            peer.setFilenameFilter(filter);
        }
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        if (this.dir != null && this.dir.equals("")) {
            this.dir = null;
        }
        if (this.file != null && this.file.equals("")) {
            this.file = null;
        }
    }

    @Override
    protected String paramString() {
        Object str = super.paramString();
        str = (String)str + ",dir= " + this.dir;
        str = (String)str + ",file= " + this.file;
        return (String)str + (this.mode == 0 ? ",load" : ",save");
    }

    @Override
    boolean postsOldMouseEvents() {
        return false;
    }

    static {
        Toolkit.loadLibraries();
        if (!GraphicsEnvironment.isHeadless()) {
            FileDialog.initIDs();
        }
        AWTAccessor.setFileDialogAccessor(new AWTAccessor.FileDialogAccessor(){

            @Override
            public void setFiles(FileDialog fileDialog, File[] files) {
                fileDialog.setFiles(files);
            }

            @Override
            public void setFile(FileDialog fileDialog, String file) {
                fileDialog.file = "".equals(file) ? null : file;
            }

            @Override
            public void setDirectory(FileDialog fileDialog, String directory) {
                fileDialog.dir = "".equals(directory) ? null : directory;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isMultipleMode(FileDialog fileDialog) {
                Object object = fileDialog.getObjectLock();
                synchronized (object) {
                    return fileDialog.multipleMode;
                }
            }
        });
    }
}

